/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.blocking;

import java.util.Set;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.utils.SetUtils;

public final class BlockingContext {
    public final Individual _blocked;
    public volatile Individual _blocker;
    private volatile Set<Role> _rolesToBlocked = null;

    public BlockingContext(Individual blocked) {
        this._blocked = blocked;
        this._blocker = blocked;
    }

    public boolean moveBlockerUp() {
        this._blocker = this._blocker.getParent();
        this._rolesToBlocked = null;
        return !this._blocker.isRoot();
    }

    public boolean moveBlockerDown(Node child) {
        if (child.isLiteral() || child.isRoot() || child.isPruned() || child.isMerged() || ((Individual)child).isBlocked() || child.equals(this._blocker)) {
            return false;
        }
        this._blocker = (Individual)child;
        this._rolesToBlocked = null;
        return true;
    }

    public boolean isRSuccessor(Role r) {
        return this.getIncomingRoles().contains(r);
    }

    public boolean isInvSuccessor() {
        for (Role role : this.getIncomingRoles()) {
            if (!role.isAnon()) continue;
            return true;
        }
        return false;
    }

    protected Set<Role> getIncomingRoles() {
        if (this._rolesToBlocked == null) {
            this._rolesToBlocked = BlockingContext.getIncomingRoles(this._blocked);
            assert (this._rolesToBlocked != null);
        }
        return this._rolesToBlocked;
    }

    public static Set<Role> getIncomingRoles(Individual ind) {
        Set<Role> rolesToBlocked = null;
        for (Edge e2 : ind.getInEdges()) {
            if (!e2.getFrom().equals(ind.getParent())) continue;
            if (rolesToBlocked == null) {
                rolesToBlocked = e2.getRole().getSuperRoles();
                continue;
            }
            if (rolesToBlocked.contains(e2.getRole())) continue;
            rolesToBlocked = SetUtils.create(rolesToBlocked);
            rolesToBlocked.addAll(e2.getRole().getSuperRoles());
        }
        return rolesToBlocked;
    }

    public String toString() {
        return this._blocked + " blocked by " + this._blocker;
    }
}

