/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.branch;

import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.rbox.Role;
import openllet.core.tableau.branch.IndividualBranch;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.utils.ATermUtils;

public class GuessBranch
extends IndividualBranch {
    private final Role _r;
    private final int _minGuess;
    private final ATermAppl _qualification;

    public GuessBranch(ABox abox, CompletionStrategy strategy, Individual x, Role r, int minGuess, int maxGuess, ATermAppl q, DependencySet ds) {
        super(abox, strategy, x, ds, maxGuess - minGuess + 1);
        this._r = r;
        this._minGuess = minGuess;
        this._qualification = q;
    }

    public GuessBranch(ABox abox, GuessBranch gb) {
        super(abox, gb, gb._minGuess + gb.getTryCount() - gb._minGuess);
        this._r = gb._r;
        this._minGuess = gb._minGuess;
        this._qualification = gb._qualification;
        this._ind = abox.getIndividual(this._ind.getName());
    }

    @Override
    public IndividualBranch copyTo(ABox abox) {
        return new GuessBranch(abox, this);
    }

    @Override
    protected void tryBranch() {
        this._abox.incrementBranch();
        DependencySet ds = this.getTermDepends();
        while (this.getTryNext() < this.getTryCount()) {
            DependencySet clashDepends;
            int n = this._minGuess + this.getTryCount() - this.getTryNext() - 1;
            _logger.fine(() -> "GUES: (" + (this.getTryNext() + 1) + "/" + this.getTryCount() + ") at _branch (" + this.getBranchIndexInABox() + ") to  " + this._ind + " -> " + this._r + " -> anon" + (n == 1 ? "" : this._abox.getAnonCount() + 1 + " - anon") + (this._abox.getAnonCount() + n));
            ds = ds.union(new DependencySet(this.getBranchIndexInABox()), this._abox.doExplanation());
            this._strategy.addType(this._ind, ATermUtils.makeMin((ATerm)this._r.getName(), n, (ATerm)this._qualification), ds);
            this._strategy.addType(this._ind, ATermUtils.makeNormalizedMax(this._r.getName(), n, this._qualification), ds);
            Individual[] y = new Individual[n];
            for (int c1 = 0; c1 < n; ++c1) {
                y[c1] = this._strategy.createFreshIndividual(null, ds);
                this._strategy.addEdge(this._ind, this._r, y[c1], ds);
                y[c1] = y[c1].getSame();
                this._strategy.addType(y[c1], this._qualification, ds);
                y[c1] = y[c1].getSame();
                for (int c2 = 0; c2 < c1; ++c2) {
                    y[c1].setDifferent(y[c2], ds);
                }
            }
            boolean earlyClash = this._abox.isClosed();
            if (earlyClash) {
                _logger.fine(() -> "CLASH: Branch " + this.getBranchIndexInABox() + " " + this._abox.getClash() + "!");
                clashDepends = this._abox.getClash().getDepends();
                if (!clashDepends.contains(this.getBranchIndexInABox())) {
                    return;
                }
            } else {
                return;
            }
            this._strategy.restore(this);
            this._abox.incrementBranch();
            this.setLastClash(clashDepends);
            ++this._tryNext;
        }
        ds = this.getCombinedClash();
        if (!OpenlletOptions.USE_INCREMENTAL_DELETION) {
            ds.remove(this.getBranchIndexInABox());
        }
        this._abox.setClash(Clash.unexplained(this._ind, ds));
    }

    @Override
    public String toString() {
        if (this.getTryNext() < this.getTryCount()) {
            return "Branch " + this.getBranchIndexInABox() + " guess rule on " + this._ind + " for role  " + this._r;
        }
        return "Branch " + this.getBranchIndexInABox() + " guess rule on " + this._ind + " for role  " + this._r + " exhausted merge possibilities";
    }

    @Override
    public void shiftTryNext(int openIndex) {
    }
}

