/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.branch;

import java.util.List;
import java.util.logging.Level;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.rules.RuleAtomAsserter;
import openllet.core.rules.VariableBinding;
import openllet.core.rules.model.AtomIObject;
import openllet.core.rules.model.BinaryAtom;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.model.UnaryAtom;
import openllet.core.tableau.branch.Branch;
import openllet.core.tableau.completion.CompletionStrategy;

public class RuleBranch
extends Branch {
    private final RuleAtomAsserter _ruleAtomAsserter;
    private final VariableBinding _binding;
    private final List<RuleAtom> _atoms;
    private final int _bodyAtomCount;
    private final int[] _order;
    private final DependencySet[] _prevDS;

    public RuleBranch(ABox abox, CompletionStrategy completion, RuleAtomAsserter ruleAtomAsserter, List<RuleAtom> atoms, VariableBinding binding, int bodyAtomCount, DependencySet ds) {
        super(abox, completion, ds, atoms.size());
        this._ruleAtomAsserter = ruleAtomAsserter;
        this._atoms = atoms;
        this._bodyAtomCount = bodyAtomCount;
        this._binding = binding;
        this._prevDS = new DependencySet[atoms.size()];
        this._order = new int[atoms.size()];
        for (int i = 0; i < this._order.length; ++i) {
            this._order[i] = i;
        }
    }

    public RuleBranch(RuleBranch rb, ABox abox) {
        super(abox, rb._atoms.size(), rb);
        this._ruleAtomAsserter = rb._ruleAtomAsserter;
        this._atoms = rb._atoms;
        this._binding = rb._binding;
        this._bodyAtomCount = rb._bodyAtomCount;
        this._prevDS = new DependencySet[rb._prevDS.length];
        System.arraycopy(rb._prevDS, 0, this._prevDS, 0, rb._tryNext);
        this._order = new int[rb._order.length];
        System.arraycopy(rb._order, 0, this._order, 0, rb._order.length);
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    @Deprecated
    public RuleBranch copyTo(ABox abox) {
        return new RuleBranch(this, abox);
    }

    @Override
    public void setLastClash(DependencySet ds) {
        super.setLastClash(ds);
        if (this._tryNext >= 0) {
            this._prevDS[this._tryNext] = ds;
        }
    }

    @Override
    protected void tryBranch() {
        this._abox.incrementBranch();
        while (this._tryNext < this._tryCount) {
            DependencySet clashDepends;
            RuleAtom atom = this._atoms.get(this._tryNext);
            DependencySet ds = null;
            if (this._tryNext == this._tryCount - 1 && !OpenlletOptions.SATURATE_TABLEAU) {
                ds = this.getTermDepends();
                for (int m = 0; m < this._tryNext; ++m) {
                    ds = ds.union(this._prevDS[m], this._abox.doExplanation());
                }
                if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
                    ds.setExplain(this.getTermDepends().getExplain());
                } else {
                    ds.remove(this.getBranchIndexInABox());
                }
            } else {
                ds = OpenlletOptions.USE_INCREMENTAL_DELETION ? this.getTermDepends().union(new DependencySet(this.getBranchIndexInABox()), this._abox.doExplanation()) : new DependencySet(this.getBranchIndexInABox());
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("RULE: Branch (" + this.getBranchIndexInABox() + ") try (" + (this._tryNext + 1) + "/" + this._tryCount + ") " + atom + " " + this._binding + " " + this._atoms + " " + ds);
            }
            this._ruleAtomAsserter.assertAtom(atom, this._binding, ds, this._tryNext < this._bodyAtomCount, this._abox, this._strategy);
            if (this._abox.isClosed()) {
                clashDepends = this._abox.getClash().getDepends();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("CLASH: Branch " + this.getBranchIndexInABox() + " " + Clash.unexplained(null, clashDepends) + "!");
                }
                if (this._tryNext >= this._tryCount - 1 || !clashDepends.contains(this.getBranchIndexInABox())) {
                    this._abox.setClash(Clash.unexplained(null, clashDepends.union(ds, this._abox.doExplanation())));
                    if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
                        this._abox.getKB().getDependencyIndex().addCloseBranchDependency(this, this._abox.getClash().getDepends());
                    }
                    return;
                }
            } else {
                return;
            }
            AtomIObject obj = (AtomIObject)(atom instanceof UnaryAtom ? ((UnaryAtom)atom).getArgument() : ((BinaryAtom)atom).getArgument1());
            Individual ind = this._binding.get(obj);
            this._strategy.restoreLocal(ind, this);
            this._abox.incrementBranch();
            this.setLastClash(clashDepends);
            ++this._tryNext;
        }
        throw new InternalReasonerException("This exception should not be thrown!");
    }

    @Override
    public void shiftTryNext(int openIndex) {
    }
}

