/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.cache;

import java.util.HashSet;
import java.util.Map;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.tableau.cache.CachedEdge;
import openllet.core.tableau.cache.CachedInEdge;
import openllet.core.tableau.cache.CachedNode;
import openllet.core.tableau.cache.CachedOutEdge;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CollectionUtils;

public class CachedConceptNode
implements CachedNode {
    private final ATermAppl _name;
    private final EdgeList _inEdges;
    private final EdgeList _outEdges;
    private final Map<ATermAppl, DependencySet> _types;
    private final boolean _isIndependent;

    public CachedConceptNode(ATermAppl name, Individual nodeParam) {
        this._name = name;
        Individual node = nodeParam;
        this._isIndependent = node.getMergeDependency(true).isIndependent();
        node = node.getSame();
        this._outEdges = CachedConceptNode.copyEdgeList(node, true);
        this._inEdges = CachedConceptNode.copyEdgeList(node, false);
        if (node.getABox().getKB().getExpressivity().hasNominal()) {
            this.collectComplexPropertyValues(node);
        }
        this._types = CollectionUtils.makeIdentityMap(node.getDepends());
        for (Map.Entry<ATermAppl, DependencySet> e2 : this._types.entrySet()) {
            e2.setValue(e2.getValue().cache());
        }
    }

    private void collectComplexPropertyValues(Individual subj) {
        Role role;
        HashSet<Role> collected = new HashSet<Role>();
        for (Edge edge : subj.getOutEdges()) {
            role = edge.getRole();
            if (role.isSimple() || !collected.add(role)) continue;
            collected.add(role);
            this.collectComplexPropertyValues(subj, role);
        }
        for (Edge edge : subj.getInEdges()) {
            role = edge.getRole().getInverse();
            if (role.isSimple() || !collected.add(role)) continue;
            this.collectComplexPropertyValues(subj, role);
        }
    }

    private void collectComplexPropertyValues(Individual subj, Role role) {
        HashSet<ATermAppl> knowns = new HashSet<ATermAppl>();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        subj.getABox().getObjectPropertyValues(subj.getName(), role, knowns, unknowns, false);
        for (ATermAppl val : knowns) {
            this._outEdges.add(new CachedOutEdge(role, val, DependencySet.INDEPENDENT));
        }
        for (ATermAppl val : unknowns) {
            this._outEdges.add(new CachedOutEdge(role, val, DependencySet.DUMMY));
        }
    }

    private static EdgeList copyEdgeList(Individual node, boolean out) {
        EdgeList edgeList = out ? node.getOutEdges() : node.getInEdges();
        EdgeList cachedEdges = new EdgeList(edgeList.size());
        for (Edge edge : edgeList) {
            CachedEdge cachedEdge = out ? new CachedOutEdge(edge) : new CachedInEdge(edge);
            cachedEdges.add(cachedEdge);
            if (!OpenlletOptions.CHECK_NOMINAL_EDGES) continue;
            Node neighbor = edge.getNeighbor(node);
            Map<Node, DependencySet> mergedNodes = neighbor.getAllMerged();
            DependencySet edgeDepends = edge.getDepends();
            for (Map.Entry<Node, DependencySet> entry : mergedNodes.entrySet()) {
                Node mergedNode = entry.getKey();
                if (!mergedNode.isRootNominal() || mergedNode.equals(neighbor)) continue;
                Role r = edge.getRole();
                ATermAppl n = mergedNode.getName();
                DependencySet ds = edgeDepends.union(entry.getValue(), false).cache();
                CachedEdge e2 = out ? new CachedOutEdge(r, n, ds) : new CachedInEdge(r, n, ds);
                cachedEdges.add(e2);
            }
        }
        return cachedEdges;
    }

    @Override
    public boolean isIndependent() {
        return this._isIndependent;
    }

    @Override
    public EdgeList getInEdges() {
        return this._inEdges;
    }

    @Override
    public EdgeList getOutEdges() {
        return this._outEdges;
    }

    @Override
    public Map<ATermAppl, DependencySet> getDepends() {
        return this._types;
    }

    @Override
    public boolean hasRNeighbor(Role role) {
        return this._outEdges.hasEdge(role) || role.isObjectRole() && this._inEdges.hasEdge(role.getInverse());
    }

    @Override
    public boolean isBottom() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean isNamedIndividual() {
        return false;
    }

    @Override
    public boolean isTop() {
        return false;
    }

    @Override
    public ATermAppl getName() {
        return this._name;
    }

    public String toString() {
        return ATermUtils.toString(this._name);
    }
}

