/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABoxImpl;
import openllet.core.boxes.abox.DefaultEdge;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.expressivity.Expressivity;
import openllet.core.tableau.blocking.BlockingFactory;
import openllet.core.tableau.branch.Branch;
import openllet.core.tableau.completion.SROIQStrategy;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.queue.QueueElement;
import openllet.core.tracker.IncrementalChangeTracker;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.Timer;

public class SROIQIncStrategy
extends SROIQStrategy {
    public SROIQIncStrategy(ABoxImpl abox) {
        super(abox);
    }

    @Override
    public Iterator<Individual> getInitializeIterator() {
        return this._abox.getIncrementalChangeTracker().updatedIndividuals();
    }

    public Iterator<Individual> getNewIterator() {
        return this._abox.getIncrementalChangeTracker().newIndividuals();
    }

    public Iterator<Edge> getNewEdgeIterator() {
        return this._abox.getIncrementalChangeTracker().newEdges();
    }

    public Iterator<Node> getUnPrunedIterator() {
        return this._abox.getIncrementalChangeTracker().unprunedNodes();
    }

    public Iterator<Edge> getRemovedEdgeIterator() {
        return this._abox.getIncrementalChangeTracker().deletedEdges();
    }

    public Iterator<Map.Entry<Node, Set<ATermAppl>>> getRemovedTypeIterator() {
        return this._abox.getIncrementalChangeTracker().deletedTypes();
    }

    @Override
    public void initialize(Expressivity expr) {
        Edge e2;
        QueueElement qe;
        Node obj;
        Individual subj;
        Individual n;
        Optional<Timer> timer = this._abox.getKB().getTimers().startTimer("initialize");
        _logger.fine("Initialize Started");
        this._mergeList.clear();
        this._blocking = BlockingFactory.createBlocking(expr);
        this.configureTableauRules(expr);
        for (Branch branch : this._abox.getBranches()) {
            branch.setStrategy(this);
        }
        this._abox.setBranchIndex(0);
        this._mergeList.addAll(this._abox.getToBeMerged());
        if (!this._mergeList.isEmpty()) {
            this.mergeAll();
        }
        Iterator<Individual> newIt = this.getNewIterator();
        while (newIt.hasNext()) {
            n = newIt.next();
            if (n.isMerged()) continue;
            this.applyUniversalRestrictions(n);
            this._unfoldingRule.apply(n);
            this._selfRule.apply(n);
        }
        Iterator<Object> it = this.getInitializeIterator();
        while (it.hasNext()) {
            n = it.next();
            this._nominalRule.apply(n);
            if (n.isMerged()) {
                n = n.getSame();
            }
            this._allValuesRule.apply(n);
        }
        it = this.getNewEdgeIterator();
        while (it.hasNext()) {
            Edge edge = (Edge)it.next();
            subj = edge.getFrom();
            obj = edge.getTo();
            if (subj.isMerged()) {
                subj.getSame();
            }
            if (subj.isPruned()) continue;
            if (obj.isMerged()) {
                obj.getSame();
            }
            if (obj.isPruned()) continue;
            Role pred = edge.getRole();
            DependencySet ds = edge.getDepends();
            this.applyDomainRange(subj, pred, obj, ds);
            if (subj.isPruned() || obj.isPruned()) {
                return;
            }
            this.applyFunctionality(subj, pred, obj);
            if (subj.isPruned() || obj.isPruned()) {
                return;
            }
            if (pred.isObjectRole()) {
                Individual o = (Individual)obj;
                this.checkReflexivitySymmetry(subj, pred, o, ds);
                this.checkReflexivitySymmetry(o, pred.getInverse(), subj, ds);
            }
            if (!this._abox.getKB().getExpressivity().hasCardinality()) continue;
            this.updateQueueAddEdge(subj, pred, obj);
        }
        if (!this._mergeList.isEmpty()) {
            this.mergeAll();
        }
        this._abox.setBranchIndex(this._abox.getBranches().size() + 1);
        Iterator<Edge> i = this.getRemovedEdgeIterator();
        while (i.hasNext()) {
            Edge e3 = i.next();
            subj = e3.getFrom();
            obj = e3.getTo();
            subj = subj.getSame();
            subj._applyNext[2] = 0;
            subj._applyNext[4] = 0;
            qe = new QueueElement(subj);
            this._abox.getCompletionQueue().add(qe, NodeSelector.EXISTENTIAL);
            this._abox.getCompletionQueue().add(qe, NodeSelector.MIN_NUMBER);
            if (!((obj = obj.getSame()) instanceof Individual)) continue;
            Individual objInd = (Individual)obj;
            objInd._applyNext[2] = 0;
            objInd._applyNext[4] = 0;
            qe = new QueueElement(objInd);
            this._abox.getCompletionQueue().add(qe, NodeSelector.EXISTENTIAL);
            this._abox.getCompletionQueue().add(qe, NodeSelector.MIN_NUMBER);
        }
        Iterator<Map.Entry<Node, Set<ATermAppl>>> it2 = this.getRemovedTypeIterator();
        while (it2.hasNext()) {
            Node node = it2.next().getKey();
            if (node.isIndividual()) {
                Individual ind = (Individual)node;
                this.readdConjunctions(ind);
                ind._applyNext[0] = 0;
                ind._applyNext[3] = 0;
                ind._applyNext[1] = 0;
                qe = new QueueElement(ind);
                this._abox.getCompletionQueue().add(qe, NodeSelector.ATOM);
                this._abox.getCompletionQueue().add(qe, NodeSelector.DISJUNCTION);
                this._allValuesRule.apply(ind);
                for (int j = 0; j < ind.getOutEdges().size(); ++j) {
                    e2 = (Edge)ind.getOutEdges().get(j);
                    if (e2.getFrom().isPruned() || e2.getTo().isPruned()) continue;
                    Role pred = e2.getRole();
                    Node obj2 = e2.getTo();
                    DependencySet ds = e2.getDepends();
                    for (ATermAppl domain : pred.getDomains()) {
                        if (!SROIQIncStrategy.requiredAddType(ind, domain)) continue;
                        if (!OpenlletOptions.USE_TRACING) {
                            this.addType(ind, domain, ds.union(DependencySet.EMPTY, this._abox.doExplanation()));
                            continue;
                        }
                        this.addType(ind, domain, ds.union(pred.getExplainDomain(domain), this._abox.doExplanation()));
                    }
                    if (!(obj2 instanceof Individual)) continue;
                    Individual objInd = (Individual)obj2;
                    objInd._applyNext[3] = 0;
                    objInd._applyNext[2] = 0;
                    objInd._applyNext[4] = 0;
                    QueueElement qeObj = new QueueElement(objInd);
                    this._abox.getCompletionQueue().add(qeObj, NodeSelector.EXISTENTIAL);
                    this._abox.getCompletionQueue().add(qeObj, NodeSelector.MIN_NUMBER);
                    this._allValuesRule.apply(ind);
                }
            }
            for (int j = 0; j < node.getInEdges().size(); ++j) {
                Edge e4 = (Edge)node.getInEdges().get(j);
                if (e4.getFrom().isPruned() || e4.getTo().isPruned()) continue;
                Individual subj2 = e4.getFrom();
                Role pred = e4.getRole();
                DependencySet ds = e4.getDepends();
                for (ATermAppl range : pred.getRanges()) {
                    if (!SROIQIncStrategy.requiredAddType(node, range)) continue;
                    if (!OpenlletOptions.USE_TRACING) {
                        this.addType(node, range, ds.union(DependencySet.EMPTY, this._abox.doExplanation()));
                        continue;
                    }
                    this.addType(node, range, ds.union(pred.getExplainRange(range), this._abox.doExplanation()));
                }
                subj2._applyNext[3] = 0;
                subj2._applyNext[2] = 0;
                subj2._applyNext[4] = 0;
                QueueElement qe2 = new QueueElement(subj2);
                this._abox.getCompletionQueue().add(qe2, NodeSelector.EXISTENTIAL);
                this._abox.getCompletionQueue().add(qe2, NodeSelector.MIN_NUMBER);
                this._allValuesRule.apply(subj2);
            }
        }
        i = this.getNewEdgeIterator();
        while (i.hasNext()) {
            this.applyPropertyRestrictions(i.next());
        }
        Iterator<Node> nodeIt = this.getUnPrunedIterator();
        while (nodeIt.hasNext()) {
            int j;
            Node n2 = nodeIt.next();
            if (!n2.isIndividual()) continue;
            Individual ind = (Individual)n2;
            for (j = 0; j < 7; ++j) {
                ind._applyNext[j] = 0;
            }
            this._abox.getCompletionQueue().add(new QueueElement(ind));
            this._allValuesRule.apply(ind);
            for (j = 0; j < ind.getOutEdges().size(); ++j) {
                Node obj3;
                e2 = (Edge)ind.getOutEdges().get(j);
                if (!e2.getFrom().isPruned() && !e2.getTo().isPruned()) {
                    this.applyPropertyRestrictions(e2);
                }
                if (!((obj3 = e2.getTo()) instanceof Individual)) continue;
                Individual objInd = (Individual)obj3;
                objInd._applyNext[3] = 0;
                this._allValuesRule.apply(objInd);
            }
            for (j = 0; j < ind.getInEdges().size(); ++j) {
                e2 = (Edge)ind.getInEdges().get(j);
                if (!e2.getFrom().isPruned() && !e2.getTo().isPruned()) {
                    this.applyPropertyRestrictions(e2);
                }
                Individual subj3 = e2.getFrom();
                subj3._applyNext[3] = 0;
                this._allValuesRule.apply(subj3);
            }
        }
        this._abox.setChanged(true);
        this._abox.setComplete(false);
        this._abox.setInitialized(true);
        timer.ifPresent(t -> t.stop());
        _logger.fine("Initialize Ended");
    }

    private void readdConjunctions(Individual ind) {
        ind.types().filter(conj -> ATermUtils.isAnd(conj) && ind.hasType((ATerm)conj)).forEach(conj -> this.addType(ind, (ATermAppl)conj, ind.getDepends((ATerm)conj)));
    }

    private static boolean requiredAddType(Node node, ATermAppl type) {
        return type != null && (!node.hasType(type) || ATermUtils.isAnd(type));
    }

    @Override
    protected void restoreAllValues() {
        IncrementalChangeTracker tracker = this._abox.getIncrementalChangeTracker();
        Iterator<Map.Entry<Node, Set<ATermAppl>>> it = tracker.deletedTypes();
        while (it.hasNext()) {
            Map.Entry<Node, Set<ATermAppl>> entry = it.next();
            Node node = entry.getKey();
            Set<ATermAppl> types = entry.getValue();
            EdgeList av = this.findAllValues(node, types);
            for (int i = 0; i < av.size(); ++i) {
                Edge e2 = (Edge)av.get(i);
                this._allValuesRule.applyAllValues(e2.getFrom(), e2.getRole(), e2.getTo(), e2.getDepends());
            }
        }
        Iterator<Node> i = tracker.unprunedNodes();
        while (i.hasNext()) {
            Node node = i.next();
            if (node instanceof Individual) {
                int j;
                Individual ind = (Individual)node;
                for (j = 0; j < 7; ++j) {
                    ind._applyNext[j] = 0;
                }
                this._abox.getCompletionQueue().add(new QueueElement(ind));
                this._allValuesRule.apply(ind);
                for (j = 0; j < ind.getOutEdges().size(); ++j) {
                    Edge e3 = (Edge)ind.getOutEdges().get(j);
                    Node obj = e3.getTo();
                    if (!(obj instanceof Individual)) continue;
                    Individual objInd = (Individual)obj;
                    objInd._applyNext[3] = 0;
                    this._allValuesRule.apply(objInd);
                }
            }
            for (int j = 0; j < node.getInEdges().size(); ++j) {
                Edge e4 = (Edge)node.getInEdges().get(j);
                Individual subj = e4.getFrom();
                subj._applyNext[3] = 0;
                this._allValuesRule.apply(subj);
            }
        }
    }

    private EdgeList findAllValues(Node node, Set<ATermAppl> removedTypes) {
        EdgeList edges = new EdgeList();
        for (int i = 0; i < node.getInEdges().size(); ++i) {
            Edge e2 = (Edge)node.getInEdges().get(i);
            edges.addAll(this.findAllValues(node, e2.getFrom(), removedTypes, e2));
        }
        if (node instanceof Individual) {
            Individual ind = (Individual)node;
            for (int i = 0; i < ind.getOutEdges().size(); ++i) {
                Edge e3 = (Edge)ind.getOutEdges().get(i);
                Node to = e3.getTo();
                Role inv = e3.getRole().getInverse();
                if (inv == null || !(to instanceof Individual)) continue;
                edges.addAll(this.findAllValues(ind, (Individual)to, removedTypes, new DefaultEdge(inv, (Individual)to, ind, e3.getDepends())));
            }
        }
        return edges;
    }

    private EdgeList findAllValues(Node node, Individual neighbor, Set<ATermAppl> removedTypes, Edge edge) {
        Object role;
        int i;
        EdgeList edges = new EdgeList();
        boolean applicable = false;
        List<ATermAppl> avTypes = neighbor.getTypes(3);
        ArrayList<ATermAppl> applicableRoles = new ArrayList<ATermAppl>();
        for (i = 0; i < avTypes.size(); ++i) {
            ATermAppl avType = avTypes.get(i);
            role = (ATermAppl)avType.getArgument(0);
            ATermAppl type = (ATermAppl)avType.getArgument(1);
            if (edge != null && !edge.getRole().isSubRoleOf(this._abox.getRole((ATerm)role)) || !this.containsType(type, removedTypes)) continue;
            applicable = true;
            applicableRoles.add(type);
        }
        if (!applicable) {
            return edges;
        }
        if (edge == null) {
            for (i = 0; i < applicableRoles.size(); ++i) {
                ATerm p = (ATerm)applicableRoles.get(i);
                role = this._abox.getRole(p);
                edges.addAll(neighbor.getRNeighborEdges((Role)role, node));
            }
        } else {
            edges.add(edge);
        }
        return edges;
    }

    private boolean containsType(ATermAppl type, Set<ATermAppl> removedTypes) {
        boolean contains = false;
        if (ATermUtils.isAnd(type)) {
            ATermList cs = (ATermList)type.getArgument(0);
            while (!cs.isEmpty()) {
                ATermAppl conj = (ATermAppl)cs.getFirst();
                if (this.containsType(conj, removedTypes)) {
                    contains = true;
                    break;
                }
                cs = cs.getNext();
            }
        } else if (removedTypes.contains(type)) {
            contains = true;
        }
        return contains;
    }
}

