/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.incremental;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.boxes.abox.DefaultEdge;
import openllet.core.boxes.abox.Edge;
import openllet.core.tableau.branch.Branch;
import openllet.core.tableau.completion.incremental.AddBranchDependency;
import openllet.core.tableau.completion.incremental.BranchDependency;
import openllet.core.tableau.completion.incremental.ClashDependency;
import openllet.core.tableau.completion.incremental.CloseBranchDependency;
import openllet.core.tableau.completion.incremental.MergeDependency;
import openllet.core.tableau.completion.incremental.TypeDependency;

public class DependencyEntry {
    private final Set<TypeDependency> _types = new HashSet<TypeDependency>();
    private final Set<MergeDependency> _merges = new HashSet<MergeDependency>();
    private final Set<Edge> _edges = new HashSet<Edge>();
    private final Set<AddBranchDependency> _branchAdds = new HashSet<AddBranchDependency>();
    private final Set<CloseBranchDependency> _branchCloses = new HashSet<CloseBranchDependency>();
    private volatile Optional<ClashDependency> _clash = Optional.empty();

    public DependencyEntry() {
    }

    public DependencyEntry(DependencyEntry that) {
        this._types.addAll(that._types);
        this._merges.addAll(that._merges);
        for (Edge next : that._edges) {
            this._edges.add(new DefaultEdge(next.getRole(), next.getFrom(), next.getTo(), next.getDepends()));
        }
        this._branchAdds.addAll(that._branchAdds);
        this._branchCloses.addAll(that._branchCloses);
        this._clash = that._clash;
    }

    public DependencyEntry copy() {
        return new DependencyEntry(this);
    }

    protected void addTypeDependency(ATermAppl ind, ATermAppl type) {
        this._types.add(new TypeDependency(ind, type));
    }

    protected void addEdgeDependency(Edge edge) {
        this._edges.add(edge);
    }

    protected void addMergeDependency(ATermAppl ind, ATermAppl mergedTo) {
        this._merges.add(new MergeDependency(ind, mergedTo));
    }

    protected BranchDependency addBranchAddDependency(ATermAppl assertion, Branch branch) {
        AddBranchDependency b = new AddBranchDependency(assertion, branch);
        this._branchAdds.add(b);
        return b;
    }

    protected BranchDependency addCloseBranchDependency(ATermAppl assertion, Branch theBranch) {
        CloseBranchDependency b = new CloseBranchDependency(assertion, theBranch.getTryNext(), theBranch);
        if (this._branchCloses.contains(b)) {
            this._branchCloses.remove(b);
        }
        this._branchCloses.add(b);
        return b;
    }

    public void print() {
        System.out.println("  Edge Dependencies:");
        for (Edge e2 : this._edges) {
            System.out.println("    " + e2.toString());
        }
        System.out.println("  Type Dependencies:");
        for (TypeDependency t : this._types) {
            System.out.println("    " + t.toString());
        }
        System.out.println("  Merge Dependencies:");
        for (MergeDependency m : this._merges) {
            System.out.println("    " + m.toString());
        }
    }

    public Set<Edge> getEdges() {
        return this._edges;
    }

    public Set<MergeDependency> getMerges() {
        return this._merges;
    }

    public Set<TypeDependency> getTypes() {
        return this._types;
    }

    public Set<AddBranchDependency> getBranchAdds() {
        return this._branchAdds;
    }

    public Set<CloseBranchDependency> getCloseBranches() {
        return this._branchCloses;
    }

    public Optional<ClashDependency> getClash() {
        return this._clash;
    }

    protected void setClash(ClashDependency clash) {
        this._clash = Optional.ofNullable(clash);
    }
}

