/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.incremental;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.KnowledgeBase;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Edge;
import openllet.core.tableau.branch.Branch;
import openllet.core.tableau.branch.DisjunctionBranch;
import openllet.core.tableau.completion.incremental.AddBranchDependency;
import openllet.core.tableau.completion.incremental.BranchDependency;
import openllet.core.tableau.completion.incremental.ClashDependency;
import openllet.core.tableau.completion.incremental.DependencyEntry;
import openllet.core.utils.SetUtils;
import openllet.shared.tools.Log;

public class DependencyIndex {
    public static final Logger _logger = Log.getLogger(DependencyIndex.class);
    private final Map<ATermAppl, DependencyEntry> _dependencies = new ConcurrentHashMap<ATermAppl, DependencyEntry>();
    private final Map<Branch, Set<BranchDependency>> _branchIndex = new ConcurrentHashMap<Branch, Set<BranchDependency>>();
    private final Set<ClashDependency> _clashIndex = SetUtils.create();
    private final KnowledgeBase _kb;

    public DependencyIndex(KnowledgeBase kb) {
        this._kb = kb;
    }

    public DependencyIndex(KnowledgeBase kb, DependencyIndex oldIndex) {
        this(kb);
        for (ATermAppl next : oldIndex.getDependencies().keySet()) {
            this._dependencies.put(next, new DependencyEntry(oldIndex.getDependencies(next)));
        }
    }

    public DependencyEntry getDependencies(ATermAppl assertion) {
        return this._dependencies.get(assertion);
    }

    protected Map<ATermAppl, DependencyEntry> getDependencies() {
        return this._dependencies;
    }

    public void addTypeDependency(ATermAppl ind, ATermAppl type, DependencySet ds) {
        for (ATermAppl nextAtom : ds.getExplain()) {
            if (!this._kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this._dependencies.containsKey(nextAtom)) {
                this._dependencies.put(nextAtom, new DependencyEntry());
            }
            this._dependencies.get(nextAtom).addTypeDependency(ind, type);
        }
    }

    public void addMergeDependency(ATermAppl ind, ATermAppl mergedTo, DependencySet ds) {
        for (ATermAppl nextAtom : ds.getExplain()) {
            if (!this._kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this._dependencies.containsKey(nextAtom)) {
                this._dependencies.put(nextAtom, new DependencyEntry());
            }
            this._dependencies.get(nextAtom).addMergeDependency(ind, mergedTo);
        }
    }

    public void addEdgeDependency(Edge edge, DependencySet ds) {
        for (ATermAppl nextAtom : ds.getExplain()) {
            if (!this._kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this._dependencies.containsKey(nextAtom)) {
                this._dependencies.put(nextAtom, new DependencyEntry());
            }
            this._dependencies.get(nextAtom).addEdgeDependency(edge);
        }
    }

    public void addBranchAddDependency(Branch branch) {
        for (ATermAppl nextAtom : branch.getTermDepends().getExplain()) {
            if (!this._kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this._dependencies.containsKey(nextAtom)) {
                this._dependencies.put(nextAtom, new DependencyEntry());
            }
            _logger.fine(() -> "DependencyIndex- Adding _branch add dependency for assertion: " + nextAtom + " -  Branch id [" + branch.getBranchIndexInABox() + "]   ,  Branch [" + branch + "]");
            BranchDependency newDep = this._dependencies.get(nextAtom).addBranchAddDependency(nextAtom, branch);
            if (!this._branchIndex.containsKey(branch)) {
                HashSet<BranchDependency> newS = new HashSet<BranchDependency>();
                newS.add(newDep);
                this._branchIndex.put(branch, newS);
                continue;
            }
            this._branchIndex.get(branch).add(newDep);
        }
    }

    public void addCloseBranchDependency(Branch branch, DependencySet ds) {
        for (ATermAppl nextAtom : ds.getExplain()) {
            if (!this._kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this._dependencies.containsKey(nextAtom)) {
                this._dependencies.put(nextAtom, new DependencyEntry());
            }
            ATermAppl label = null;
            if (branch instanceof DisjunctionBranch) {
                label = ((DisjunctionBranch)branch).getDisjunct(branch.getTryNext());
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("DependencyIndex- Adding _branch remove ds dependency for assertion: " + nextAtom + " -  Branch id [" + branch.getBranchIndexInABox() + "]   ,  Branch [" + branch + "]   on label [" + label + "]  ,    _tryNext [" + branch.getTryNext() + "]");
            }
            BranchDependency newDep = this._dependencies.get(nextAtom).addCloseBranchDependency(nextAtom, branch);
            if (!this._branchIndex.containsKey(branch)) {
                HashSet<BranchDependency> newS = new HashSet<BranchDependency>();
                newS.add(newDep);
                this._branchIndex.put(branch, newS);
                continue;
            }
            this._branchIndex.get(branch).add(newDep);
        }
    }

    public void removeDependencies(ATermAppl assertion) {
        this._dependencies.remove(assertion);
    }

    public void removeBranchDependencies(Branch b) {
        Set<BranchDependency> deps = this._branchIndex.get(b);
        if (deps == null) {
            return;
        }
        for (BranchDependency next : deps) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("DependencyIndex: RESTORE causing remove of _branch _index for assertion: " + next.getAssertion() + " _branch dep.: " + next);
            }
            if (!(next instanceof AddBranchDependency)) continue;
            this._dependencies.get(next.getAssertion()).getBranchAdds().remove(next);
        }
    }

    public void setClashDependencies(Clash clash) {
        for (ClashDependency next : this._clashIndex) {
            if (!this._dependencies.containsKey(next.getAssertion())) continue;
            this._dependencies.get(next.getAssertion()).setClash(null);
        }
        this._clashIndex.clear();
        if (clash == null) {
            return;
        }
        for (ATermAppl nextAtom : clash.getDepends().getExplain()) {
            if (!this._kb.getSyntacticAssertions().contains(nextAtom)) continue;
            if (!this._dependencies.containsKey(nextAtom)) {
                this._dependencies.put(nextAtom, new DependencyEntry());
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("  DependencyIndex- Adding clash dependency: Axiom [" + nextAtom + "]   ,  Clash [" + clash + "]");
            }
            ClashDependency newDep = new ClashDependency(nextAtom, clash);
            this._dependencies.get(nextAtom).setClash(newDep);
            this._clashIndex.add(newDep);
        }
    }
}

