/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.queue;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.atom.OpenError;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Literal;
import openllet.core.boxes.abox.Node;
import openllet.core.tableau.completion.queue.CompletionQueue;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.queue.QueueElement;

public final class OptimizedBasicCompletionQueue
extends CompletionQueue {
    private final List<ATermAppl>[] _queue;
    private final Set<ATermAppl>[] _newQueue;
    private final List<ATermAppl>[] _newQueueList;
    private final int[] _current;
    private final int[] _end;
    private final int[] _cutOff;
    private boolean _backtracked = false;

    public OptimizedBasicCompletionQueue(ABox abox) {
        super(abox);
        int nSelectors = NodeSelector.numSelectors();
        this._queue = new ArrayList[nSelectors];
        this._newQueue = new HashSet[nSelectors];
        this._newQueueList = new ArrayList[nSelectors];
        this._current = new int[nSelectors];
        this._cutOff = new int[nSelectors];
        this._end = new int[nSelectors];
        for (int i = 0; i < nSelectors; ++i) {
            this._queue[i] = new ArrayList<ATermAppl>();
            this._newQueue[i] = new HashSet<ATermAppl>();
            this._newQueueList[i] = new ArrayList<ATermAppl>();
            this._current[i] = 0;
            this._cutOff[i] = 0;
            this._end[i] = 0;
        }
    }

    @Override
    protected void findNext(int type) {
        Node node;
        while (!(this._current[type] >= this._cutOff[type] || (node = this._abox.getNode(this._queue[type].get(this._current[type]))) != null && (node = node.getSame()) != null && (node instanceof Literal && this.isAllowLiterals() || node instanceof Individual && !this.isAllowLiterals()) && !node.isPruned())) {
            int n = type;
            this._current[n] = this._current[n] + 1;
        }
    }

    @Override
    public boolean hasNext() {
        this.findNext(this._currentType);
        return this._current[this._currentType] < this._cutOff[this._currentType];
    }

    @Override
    public void restore(int branch) {
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            this._queue[i].addAll(this._newQueueList[i]);
            this._newQueue[i].clear();
            this._newQueueList[i].clear();
            this._end[i] = this._queue[i].size();
            this._current[i] = 0;
            this._cutOff[i] = this._end[i];
        }
        this._backtracked = true;
    }

    @Override
    public Individual next() {
        this.findNext(this._currentType);
        Individual ind = (Individual)this._abox.getNode(this._queue[this._currentType].get(this._current[this._currentType]));
        ind = ind.getSame();
        int n = this._currentType;
        this._current[n] = this._current[n] + 1;
        return ind;
    }

    @Override
    public Node nextLiteral() {
        this.findNext(this._currentType);
        Node node = this._abox.getNode(this._queue[this._currentType].get(this._current[this._currentType]));
        node = node.getSame();
        int n = this._currentType;
        this._current[n] = this._current[n] + 1;
        return node;
    }

    @Override
    public void add(QueueElement x, NodeSelector s) {
        int type = s.ordinal();
        if (!this._newQueue[type].contains(x.getNode())) {
            this._newQueue[type].add(x.getNode());
            this._newQueueList[type].add(x.getNode());
        }
    }

    @Override
    public void add(QueueElement x) {
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            if (this._newQueue[i].contains(x.getNode())) continue;
            this._newQueue[i].add(x.getNode());
            this._newQueueList[i].add(x.getNode());
        }
    }

    @Override
    public void reset(NodeSelector s) {
        this._currentType = s.ordinal();
        this._cutOff[this._currentType] = this._end[this._currentType];
        this._current[this._currentType] = 0;
    }

    @Override
    public void incrementBranch(int branch) {
    }

    @Override
    public OptimizedBasicCompletionQueue copy() {
        OptimizedBasicCompletionQueue copy = new OptimizedBasicCompletionQueue(this._abox);
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            copy._queue[i] = new ArrayList<ATermAppl>(this._queue[i]);
            copy._newQueue[i] = new HashSet<ATermAppl>(this._newQueue[i]);
            copy._newQueueList[i] = new ArrayList<ATermAppl>(this._newQueueList[i]);
            copy._current[i] = this._current[i];
            copy._cutOff[i] = this._cutOff[i];
            copy._end[i] = this._end[i];
        }
        copy._backtracked = this._backtracked;
        copy.setAllowLiterals(this.isAllowLiterals());
        return copy;
    }

    @Override
    public void setABox(ABox ab) {
        this._abox = ab;
    }

    @Override
    public void print(int type) {
        if (type > NodeSelector.numSelectors()) {
            return;
        }
        System.out.println("Queue " + type + ": " + this._queue[type]);
    }

    @Override
    public void print() {
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            System.out.println("Queue " + i + ": " + this._queue[i]);
        }
    }

    @Override
    public void remove() {
        throw new OpenError("Remove is not supported");
    }

    @Override
    public void flushQueue() {
        for (int i = 0; i < NodeSelector.numSelectors(); ++i) {
            if (!this._backtracked && !this._closed) {
                this._queue[i].clear();
            } else if (this._closed && !this._abox.isClosed()) {
                this._closed = false;
            }
            this._queue[i].addAll(this._newQueueList[i]);
            this._newQueue[i].clear();
            this._newQueueList[i].clear();
            this._end[i] = this._queue[i].size();
        }
        this._backtracked = false;
    }

    @Override
    protected void flushQueue(NodeSelector s) {
        int index = s.ordinal();
        if (index == NodeSelector.UNIVERSAL.ordinal() || !this._backtracked) {
            this._queue[index].clear();
        }
        this._queue[index].addAll(this._newQueueList[index]);
        this._newQueue[index].clear();
        this._newQueueList[index].clear();
        this._end[index] = this._queue[index].size();
    }

    @Override
    public void clearQueue(NodeSelector s) {
        int index = s.ordinal();
        this._queue[index].clear();
        this._newQueue[index].clear();
        this._newQueueList[index].clear();
        this._end[index] = this._queue[index].size();
    }
}

