/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.rule;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Literal;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.datatypes.exceptions.DatatypeReasonerException;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.rule.AbstractTableauRule;

public class DataSatisfiabilityRule
extends AbstractTableauRule {
    public DataSatisfiabilityRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.DATATYPE, AbstractTableauRule.BlockingType.NONE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(Individual ind) {
        HashSet<Literal> nodes = new HashSet<Literal>();
        LinkedList<Literal> pending = new LinkedList<Literal>();
        HashMap<Literal, Set<Literal>> ne = new HashMap<Literal, Set<Literal>>();
        DependencySet ds = DependencySet.EMPTY;
        boolean nePresent = false;
        for (Edge edge : ind.getOutEdges()) {
            Role r = edge.getRole();
            if (!r.isDatatypeRole()) continue;
            ds = ds.union(edge.getDepends(), this._strategy.getABox().doExplanation());
            Literal literal = (Literal)edge.getTo();
            pending.add(literal);
            HashSet<Literal> disj = (HashSet<Literal>)ne.get(literal);
            for (Role s : r.getDisjointRoles()) {
                for (Edge f : ind.getOutEdges().getEdges(s)) {
                    Literal k = (Literal)f.getTo();
                    if (disj == null) {
                        disj = new HashSet<Literal>();
                        ne.put(literal, disj);
                        nePresent = true;
                    }
                    disj.add(k);
                }
            }
        }
        while (!pending.isEmpty()) {
            Literal l = (Literal)pending.removeFirst();
            if (!nodes.add(l)) continue;
            Set set = (Set)ne.get(l);
            for (Node node : l.getDifferents()) {
                if (node.isLiteral()) {
                    void var8_13;
                    Literal k = (Literal)node;
                    pending.add(k);
                    if (var8_13 == null) {
                        HashSet hashSet = new HashSet();
                        ne.put(l, hashSet);
                        nePresent = true;
                    }
                    var8_13.add(k);
                    ds = ds.union(l.getDifferenceDependency(node), this._strategy.getABox().doExplanation());
                    continue;
                }
                throw new IllegalStateException();
            }
        }
        if (nePresent) {
            try {
                if (!this._strategy.getABox().getDatatypeReasoner().isSatisfiable(nodes, ne)) {
                    for (Node node : nodes) {
                        for (DependencySet dependencySet : node.getDepends().values()) {
                            ds = ds.union(dependencySet, this._strategy.getABox().doExplanation());
                        }
                    }
                    this._strategy.getABox().setClash(Clash.unexplained(ind, ds));
                }
            }
            catch (InvalidLiteralException e3) {
                String string = "Invalid literal encountered during satisfiability check: " + e3.getMessage();
                if (OpenlletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                    _logger.fine(string);
                    for (Node node : nodes) {
                        for (DependencySet typeDep : node.getDepends().values()) {
                            ds = ds.union(typeDep, this._strategy.getABox().doExplanation());
                        }
                    }
                    this._strategy.getABox().setClash(Clash.invalidLiteral(ind, ds));
                }
                _logger.severe(string);
                throw new InternalReasonerException(string, e3);
            }
            catch (DatatypeReasonerException e4) {
                String string = "Unexpected datatype reasoner exception: " + e4.getMessage();
                _logger.severe(string);
                throw new InternalReasonerException(string, e4);
            }
        }
    }
}

