/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.completion.rule;

import java.util.Iterator;
import java.util.List;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.rule.AllValuesRule;
import openllet.core.utils.ATermUtils;

public class SimpleAllValuesRule
extends AllValuesRule {
    public SimpleAllValuesRule(CompletionStrategy strategy) {
        super(strategy);
    }

    @Override
    public void applyAllValues(Individual x, ATermAppl av, DependencySet ds) {
        ATermAppl p = (ATermAppl)av.getArgument(0);
        ATermAppl c = (ATermAppl)av.getArgument(1);
        Role s = this._strategy.getABox().getRole(p);
        if (null == s) {
            return;
        }
        if (s.isTop() && s.isObjectRole()) {
            this.applyAllValuesTop(av, c, ds);
            return;
        }
        EdgeList edges = x.getRNeighborEdges(s);
        for (int e2 = 0; e2 < edges.size(); ++e2) {
            Edge edgeToY = (Edge)edges.get(e2);
            Node y = edgeToY.getNeighbor(x);
            DependencySet finalDS = ds.union(edgeToY.getDepends(), this._strategy.getABox().doExplanation());
            if (this._strategy.getABox().doExplanation()) {
                Role edgeRole = edgeToY.getRole();
                DependencySet subDS = s.getExplainSubOrInv(edgeRole);
                finalDS = finalDS.union(subDS.getExplain(), true);
            }
            this.applyAllValues(x, s, y, c, finalDS);
            if (!x.isMerged()) continue;
            return;
        }
        if (!s.isSimple()) {
            for (Role r : s.getTransitiveSubRoles()) {
                ATermAppl allRC = ATermUtils.makeAllValues(r.getName(), c);
                edges = x.getRNeighborEdges(r);
                for (int e3 = 0; e3 < edges.size(); ++e3) {
                    Edge edgeToY = (Edge)edges.get(e3);
                    Node y = edgeToY.getNeighbor(x);
                    DependencySet finalDS = ds.union(edgeToY.getDepends(), this._strategy.getABox().doExplanation());
                    if (this._strategy.getABox().doExplanation()) {
                        finalDS = finalDS.union(r.getExplainTransitive().getExplain(), true);
                        finalDS = finalDS.union(s.getExplainSubOrInv(edgeToY.getRole()), true);
                    }
                    this.applyAllValues(x, r, y, allRC, finalDS);
                    if (!x.isMerged()) continue;
                    return;
                }
            }
        }
    }

    @Override
    public void applyAllValues(Individual subj, Role pred, Node obj, DependencySet ds) {
        List<ATermAppl> allValues = subj.getTypes(3);
        int size = allValues.size();
        Iterator<ATermAppl> i = allValues.iterator();
        while (i.hasNext()) {
            ATermAppl av = i.next();
            ATermAppl p = (ATermAppl)av.getArgument(0);
            ATermAppl c = (ATermAppl)av.getArgument(1);
            Role s = this._strategy.getABox().getRole(p);
            if (null == s) continue;
            if (s.isTop() && s.isObjectRole()) {
                this.applyAllValuesTop(av, c, ds);
                continue;
            }
            if (pred.isSubRoleOf(s)) {
                DependencySet finalDS = ds.union(subj.getDepends(av), this._strategy.getABox().doExplanation());
                if (this._strategy.getABox().doExplanation()) {
                    finalDS = finalDS.union(s.getExplainSubOrInv(pred).getExplain(), true);
                }
                this.applyAllValues(subj, s, obj, c, finalDS);
                if (s.isTransitive()) {
                    ATermAppl allRC = ATermUtils.makeAllValues(s.getName(), c);
                    finalDS = ds.union(subj.getDepends(av), this._strategy.getABox().doExplanation());
                    if (this._strategy.getABox().doExplanation()) {
                        finalDS = finalDS.union(s.getExplainTransitive().getExplain(), true);
                    }
                    this.applyAllValues(subj, s, obj, allRC, finalDS);
                }
            }
            if (size == allValues.size()) continue;
            i = allValues.iterator();
            size = allValues.size();
        }
    }
}

