/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.taxonomy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.atom.OpenError;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.IndividualIterator;
import openllet.core.boxes.rbox.Role;
import openllet.core.boxes.tbox.TBox;
import openllet.core.boxes.tbox.impl.Unfolding;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.taxonomy.DefinitionOrder;
import openllet.core.taxonomy.DefinitionOrderFactory;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyBuilder;
import openllet.core.taxonomy.TaxonomyImpl;
import openllet.core.taxonomy.TaxonomyNode;
import openllet.core.taxonomy.TaxonomyUtils;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CollectionUtils;
import openllet.core.utils.SetUtils;
import openllet.core.utils.Timer;
import openllet.core.utils.progress.ProgressMonitor;
import openllet.core.utils.progress.SilentProgressMonitor;
import openllet.shared.tools.Log;

public class CDOptimizedTaxonomyBuilder
implements TaxonomyBuilder {
    protected static Logger _logger = Log.getLogger(TaxonomyImpl.class);
    private static final Set<ConceptFlag> PHASE1_FLAGS = EnumSet.of(ConceptFlag.COMPLETELY_DEFINED, ConceptFlag.PRIMITIVE, ConceptFlag.OTHER);
    private final Map<ATermAppl, Set<ATermAppl>> _toldDisjoints = CollectionUtils.makeIdentityMap();
    private final Map<ATermAppl, ATermList> _unionClasses = CollectionUtils.makeIdentityMap();
    protected final KnowledgeBase _kb;
    private final List<TaxonomyNode<ATermAppl>> _markedNodes = CollectionUtils.makeList();
    private volatile Optional<DefinitionOrder> _definitionOrder = Optional.empty();
    private volatile boolean _useCD = false;
    private volatile boolean _prepared = false;
    private volatile Map<ATermAppl, ConceptFlag> _conceptFlags = CollectionUtils.makeIdentityMap();
    protected volatile ProgressMonitor _monitor = OpenlletOptions.USE_CLASSIFICATION_MONITOR.create();
    protected volatile Collection<ATermAppl> _classes;
    protected volatile Taxonomy<ATermAppl> _toldTaxonomy;
    protected volatile Taxonomy<ATermAppl> _taxonomyImpl;

    public CDOptimizedTaxonomyBuilder(KnowledgeBase kb) {
        this._kb = kb;
        this.init();
    }

    @Override
    public void setProgressMonitor(ProgressMonitor monitor) {
        this._monitor = monitor == null ? new SilentProgressMonitor() : monitor;
    }

    @Override
    public Taxonomy<ATermAppl> getTaxonomy() {
        return this._taxonomyImpl;
    }

    @Override
    public Taxonomy<ATermAppl> getToldTaxonomy() {
        if (!this._prepared) {
            this.reset();
            this.computeToldInformation();
        }
        return this._toldTaxonomy;
    }

    @Override
    public Map<ATermAppl, Set<ATermAppl>> getToldDisjoints() {
        if (!this._prepared) {
            this.reset();
            this.computeToldInformation();
        }
        return this._toldDisjoints;
    }

    @Override
    public synchronized boolean classify() {
        List<ATermAppl> phase2;
        List<ATermAppl> phase1;
        this._classes = this._kb.getClasses();
        int classCount = this._classes.size();
        if (!this._classes.contains(ATermUtils.TOP)) {
            ++classCount;
        }
        if (!this._classes.contains(ATermUtils.BOTTOM)) {
            ++classCount;
        }
        this._monitor.setProgressTitle("Classifying");
        this._monitor.setProgressLength(classCount);
        this._monitor.taskStarted();
        if (this._classes.isEmpty()) {
            this._taxonomyImpl = new TaxonomyImpl<ATermAppl>(null, ATermUtils.TOP, ATermUtils.BOTTOM);
            return true;
        }
        if (_logger.isLoggable(Level.FINE)) {
            this._kb.getTimers().createTimer("classifySub");
            _logger.fine("Classes: " + classCount + " Individuals: " + this._kb.getIndividualsCount());
        }
        if (!this._prepared) {
            this._kb.getTimers().execute("taxBuilder.prepare", t -> this.prepare());
        }
        _logger.fine("Starting classification...");
        if (this._useCD) {
            ArrayList<ATermAppl> phase1List = new ArrayList<ATermAppl>();
            ArrayList<ATermAppl> phase2List = new ArrayList<ATermAppl>();
            for (ATermAppl c : this.getDefinitionOrder()) {
                if (PHASE1_FLAGS.contains((Object)this._conceptFlags.get(c))) {
                    phase1List.add(c);
                    continue;
                }
                phase2List.add(c);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Using CD classification with phase1: " + phase1List.size() + " phase2: " + phase2List.size());
                CDOptimizedTaxonomyBuilder.logList(Level.FINER, "Phase 1", phase1List);
                CDOptimizedTaxonomyBuilder.logList(Level.FINER, "Phase 2", phase2List);
            }
            phase1 = phase1List;
            phase2 = phase2List;
        } else {
            phase1 = Collections.emptyList();
            phase2 = this.getDefinitionOrder().getList();
            _logger.fine("CD classification disabled");
        }
        boolean completed = true;
        completed = completed && this.classify(phase1, false);
        completed = completed && this.classify(phase2, true);
        this._monitor.taskFinished();
        _logger.fine(() -> "Satisfiability Count: " + (this._kb.getABox().getStats()._satisfiabilityCount - (long)(2 * this._kb.getClasses().size())));
        this._definitionOrder = Optional.empty();
        this._taxonomyImpl.assertValid();
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("Tax size : " + this._taxonomyImpl.getNodes().size());
            _logger.finer("Tax depth: " + this._taxonomyImpl.getDepth());
            _logger.finer("Branching: " + (double)this._taxonomyImpl.getTotalBranching() / (double)this._taxonomyImpl.getNodes().size());
            _logger.finer("Leaf size: " + this._taxonomyImpl.getBottomNode().getSupers().size());
        }
        return completed;
    }

    private static void logList(Level level, String header, List<ATermAppl> list) {
        if (!_logger.isLoggable(Level.FINER)) {
            return;
        }
        _logger.log(level, header);
        int i = 0;
        for (ATermAppl c : list) {
            _logger.log(level, i + ") " + c);
            ++i;
        }
    }

    protected boolean classify(List<ATermAppl> phase, boolean requireTopSearch) {
        boolean useThreads = false;
        for (ATermAppl c : phase) {
            _logger.fine(() -> "Classify (" + this._taxonomyImpl.getNodes().size() + ") " + CDOptimizedTaxonomyBuilder.format(c) + "...");
            this.classify(c, requireTopSearch);
            this._monitor.incrementProgress();
            this._kb.getTimers().getTimer("classify").ifPresent(t -> t.check());
            if (!this._monitor.isCanceled()) continue;
            return false;
        }
        return true;
    }

    private void prepare() {
        this.reset();
        this.computeToldInformation();
        this.createDefinitionOrder();
        this.computeConceptFlags();
        this._prepared = true;
    }

    private void init() {
        this._toldDisjoints.clear();
        this._unionClasses.clear();
        this._markedNodes.clear();
        this._taxonomyImpl = new TaxonomyImpl<ATermAppl>(null, ATermUtils.TOP, ATermUtils.BOTTOM);
        this._toldTaxonomy = new TaxonomyImpl<ATermAppl>();
        this._definitionOrder = Optional.empty();
        this._conceptFlags.clear();
    }

    protected void reset() {
        this._kb.prepare();
        this._classes = new ArrayList<ATermAppl>(this._kb.getClasses());
        this._useCD = OpenlletOptions.USE_CD_CLASSIFICATION && !this._kb.getTBox().unfold(ATermUtils.TOP).hasNext() && !this._kb.getExpressivity().hasNominal();
        this.init();
    }

    private void computeToldInformation() {
        Optional<Timer> timer = this._kb.getTimers().startTimer("computeToldInformation");
        this._toldTaxonomy = new TaxonomyImpl<ATermAppl>(this._classes, ATermUtils.TOP, ATermUtils.BOTTOM);
        TBox tbox = this._kb.getTBox();
        tbox.axioms().forEach(axiom -> {
            boolean reverseArgs;
            ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
            boolean equivalent = axiom.getAFun().equals(ATermUtils.EQCLASSFUN);
            Set<ATermAppl> explanation = tbox.getAxiomExplanation((ATermAppl)axiom);
            boolean bl = reverseArgs = !ATermUtils.isPrimitive(c1) && ATermUtils.isPrimitive(c2);
            if (equivalent && reverseArgs) {
                this.addToldRelation(c2, c1, equivalent, explanation);
            } else {
                this.addToldRelation(c1, c2, equivalent, explanation);
            }
        });
        for (ATermAppl c : this._unionClasses.keySet()) {
            ArrayList<ATermAppl> list = new ArrayList<ATermAppl>();
            ATermList disj = this._unionClasses.get(c);
            while (!disj.isEmpty()) {
                list.add((ATermAppl)disj.getFirst());
                disj = disj.getNext();
            }
            List<ATermAppl> lca = this._toldTaxonomy.computeLCA(list);
            for (ATermAppl d : lca) {
                _logger.finer(() -> "Union subsumption " + CDOptimizedTaxonomyBuilder.format(c) + " " + CDOptimizedTaxonomyBuilder.format(d));
                this.addToldSubsumer(c, d);
            }
        }
        this._unionClasses.clear();
        this._toldTaxonomy.assertValid();
        timer.ifPresent(t -> t.stop());
    }

    private synchronized DefinitionOrder createDefinitionOrder() {
        DefinitionOrder df = DefinitionOrderFactory.createDefinitionOrder(this._kb);
        this._definitionOrder = Optional.of(df);
        return df;
    }

    private DefinitionOrder getDefinitionOrder() {
        return this._definitionOrder.orElseGet(this::createDefinitionOrder);
    }

    private void computeConceptFlags() {
        if (!this._useCD) {
            return;
        }
        for (Role role : this._kb.getRBox().getRoles().values()) {
            for (ATermAppl c : role.getDomains()) {
                Object d;
                ATermList list;
                if (ATermUtils.isPrimitive(c)) {
                    this._conceptFlags.put(c, ConceptFlag.OTHER);
                    continue;
                }
                if (ATermUtils.isAnd(c)) {
                    list = (ATermList)c.getArgument(0);
                    while (!list.isEmpty()) {
                        d = (ATermAppl)list.getFirst();
                        if (ATermUtils.isPrimitive((ATermAppl)d)) {
                            this._conceptFlags.put((ATermAppl)d, ConceptFlag.OTHER);
                        }
                        list = list.getNext();
                    }
                    continue;
                }
                if (!ATermUtils.isNot(c) || !ATermUtils.isAnd((ATermAppl)c.getArgument(0))) continue;
                list = (ATermList)((ATermAppl)c.getArgument(0)).getArgument(0);
                while (!list.isEmpty()) {
                    d = (ATermAppl)list.getFirst();
                    if (ATermUtils.isNegatedPrimitive(d)) {
                        this._conceptFlags.put((ATermAppl)d.getArgument(0), ConceptFlag.OTHER);
                    }
                    list = list.getNext();
                }
            }
        }
        TBox tbox = this._kb.getTBox();
        for (ATermAppl c : this.getDefinitionOrder()) {
            Iterator<Unfolding> unfoldingList = this._kb.getTBox().unfold(c);
            if (!tbox.isPrimitive(c) || this.getDefinitionOrder().isCyclic(c) || this._toldTaxonomy.getAllEquivalents(c).size() > 1) {
                this._conceptFlags.put(c, ConceptFlag.NONPRIMITIVE);
                while (unfoldingList.hasNext()) {
                    Unfolding unf = unfoldingList.next();
                    for (ATermAppl d : ATermUtils.findPrimitives(unf.getResult())) {
                        ConceptFlag current = this._conceptFlags.get(d);
                        if (current != null && current != ConceptFlag.COMPLETELY_DEFINED) continue;
                        this._conceptFlags.put(d, ConceptFlag.PRIMITIVE);
                    }
                }
                continue;
            }
            boolean flagged = false;
            for (ATermAppl sup : this._toldTaxonomy.getFlattenedSupers(c, true)) {
                ConceptFlag supFlag = this._conceptFlags.get(sup);
                if (supFlag != ConceptFlag.NONPRIMITIVE && supFlag != ConceptFlag.NONPRIMITIVE_TA) continue;
                this._conceptFlags.put(c, ConceptFlag.NONPRIMITIVE_TA);
                flagged = true;
                break;
            }
            if (flagged || this._conceptFlags.get(c) != null) continue;
            this._conceptFlags.put(c, this.isCDDesc(unfoldingList) ? ConceptFlag.COMPLETELY_DEFINED : ConceptFlag.PRIMITIVE);
        }
        if (_logger.isLoggable(Level.FINE)) {
            int[] nArray = new int[ConceptFlag.values().length];
            Arrays.fill(nArray, 0);
            for (ATermAppl c : this._classes) {
                int n = this._conceptFlags.get(c).ordinal();
                nArray[n] = nArray[n] + 1;
            }
            _logger.fine("Concept flags:");
            for (ConceptFlag flag : ConceptFlag.values()) {
                _logger.fine("\t" + (Object)((Object)flag) + " = " + nArray[flag.ordinal()]);
            }
        }
    }

    private void clearMarks() {
        for (TaxonomyNode<ATermAppl> node : this._markedNodes) {
            if (node == null) continue;
            node.resetMark();
        }
        this._markedNodes.clear();
    }

    private boolean isCDDesc(Iterator<Unfolding> unfoldingList) {
        while (unfoldingList.hasNext()) {
            Unfolding unf = unfoldingList.next();
            if (this.isCDDesc(unf.getResult())) continue;
            return false;
        }
        return true;
    }

    private boolean isCDDesc(ATermAppl desc) {
        ATermAppl negd;
        if (desc == null) {
            return true;
        }
        if (ATermUtils.isPrimitive(desc)) {
            return true;
        }
        if (ATermUtils.isAllValues(desc)) {
            return true;
        }
        if (ATermUtils.isAnd(desc)) {
            ATermList conj;
            boolean allCDConj = true;
            ATermList subConj = conj = (ATermList)desc.getArgument(0);
            while (allCDConj && !subConj.isEmpty()) {
                ATermAppl ci = (ATermAppl)subConj.getFirst();
                allCDConj = this.isCDDesc(ci);
                subConj = subConj.getNext();
            }
            return allCDConj;
        }
        return ATermUtils.isNot(desc) && ATermUtils.isPrimitive(negd = (ATermAppl)desc.getArgument(0));
    }

    private void addToldRelation(ATermAppl c, ATermAppl d, boolean equivalent, Set<ATermAppl> explanation) {
        ATermAppl negation;
        if (!(equivalent || c != ATermUtils.BOTTOM && d != ATermUtils.TOP)) {
            return;
        }
        if (!ATermUtils.isPrimitive(c)) {
            if (c.getAFun().equals(ATermUtils.ORFUN)) {
                ATermList list;
                ATermList disj = list = (ATermList)c.getArgument(0);
                while (!disj.isEmpty()) {
                    ATermAppl e2 = (ATermAppl)disj.getFirst();
                    this.addToldRelation(e2, d, false, explanation);
                    disj = disj.getNext();
                }
            }
        } else if (ATermUtils.isPrimitive(d)) {
            if (ATermUtils.isBnode(d)) {
                return;
            }
            if (!equivalent) {
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.finer("Preclassify (1) " + CDOptimizedTaxonomyBuilder.format(c) + " " + CDOptimizedTaxonomyBuilder.format(d));
                }
                this.addToldSubsumer(c, d, explanation);
            } else {
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.finer("Preclassify (2) " + CDOptimizedTaxonomyBuilder.format(c) + " " + CDOptimizedTaxonomyBuilder.format(d));
                }
                this.addToldEquivalent(c, d);
            }
        } else if (d.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList conj = (ATermList)d.getArgument(0);
            while (!conj.isEmpty()) {
                ATermAppl e3 = (ATermAppl)conj.getFirst();
                this.addToldRelation(c, e3, false, explanation);
                conj = conj.getNext();
            }
        } else if (d.getAFun().equals(ATermUtils.ORFUN)) {
            ATermList list;
            boolean allPrimitive = true;
            ATermList disj = list = (ATermList)d.getArgument(0);
            while (!disj.isEmpty()) {
                ATermAppl e4 = (ATermAppl)disj.getFirst();
                if (ATermUtils.isPrimitive(e4)) {
                    if (equivalent) {
                        if (_logger.isLoggable(Level.FINER)) {
                            _logger.finer("Preclassify (3) " + CDOptimizedTaxonomyBuilder.format(c) + " " + CDOptimizedTaxonomyBuilder.format(e4));
                        }
                        this.addToldSubsumer(e4, c);
                    }
                } else {
                    allPrimitive = false;
                }
                disj = disj.getNext();
            }
            if (allPrimitive) {
                this._unionClasses.put(c, list);
            }
        } else if (d.equals(ATermUtils.BOTTOM)) {
            _logger.finer(() -> "Preclassify (4) " + CDOptimizedTaxonomyBuilder.format(c) + " BOTTOM");
            this.addToldEquivalent(c, ATermUtils.BOTTOM);
        } else if (d.getAFun().equals(ATermUtils.NOTFUN) && ATermUtils.isPrimitive(negation = (ATermAppl)d.getArgument(0))) {
            _logger.finer(() -> "Preclassify (5) " + CDOptimizedTaxonomyBuilder.format(c) + " not " + CDOptimizedTaxonomyBuilder.format(negation));
            this.addToldDisjoint(c, negation);
            this.addToldDisjoint(negation, c);
        }
    }

    private void addToldEquivalent(ATermAppl c, ATermAppl d) {
        if (c.equals(d)) {
            return;
        }
        TaxonomyNode<ATermAppl> cNode = this._toldTaxonomy.getNode(c);
        TaxonomyNode<ATermAppl> dNode = this._toldTaxonomy.getNode(d);
        this._toldTaxonomy.merge(cNode, dNode);
        TaxonomyUtils.clearSuperExplanation(this._toldTaxonomy, c);
    }

    private void addToldSubsumer(ATermAppl c, ATermAppl d) {
        this.addToldSubsumer(c, d, null);
    }

    private void addToldSubsumer(ATermAppl c, ATermAppl d, Set<ATermAppl> explanation) {
        TaxonomyNode<ATermAppl> cNode = this._toldTaxonomy.getNode(c);
        TaxonomyNode<ATermAppl> dNode = this._toldTaxonomy.getNode(d);
        if (cNode == null) {
            throw new InternalReasonerException(c + " is not in the definition _order");
        }
        if (dNode == null) {
            throw new InternalReasonerException(d + " is not in the definition _order");
        }
        if (cNode.equals(dNode)) {
            return;
        }
        if (cNode.equals(this._toldTaxonomy.getTop())) {
            this._toldTaxonomy.merge(cNode, dNode);
            TaxonomyUtils.clearSuperExplanation(this._toldTaxonomy, c);
        } else {
            this._toldTaxonomy.addSuper(c, d);
            this._toldTaxonomy.removeCycles(cNode);
            if (cNode.getEquivalents().size() > 1) {
                TaxonomyUtils.clearSuperExplanation(this._toldTaxonomy, c);
            } else if (explanation != null && !explanation.isEmpty()) {
                TaxonomyUtils.addSuperExplanation(this._toldTaxonomy, c, d, explanation);
            }
        }
    }

    private void addToldDisjoint(ATermAppl c, ATermAppl d) {
        Set<ATermAppl> disjoints = this._toldDisjoints.get(c);
        if (disjoints == null) {
            disjoints = new HashSet<ATermAppl>();
            this._toldDisjoints.put(c, disjoints);
        }
        disjoints.add(d);
    }

    private void markToldSubsumers(ATermAppl c) {
        TaxonomyNode<ATermAppl> node = this._taxonomyImpl.getNode(c);
        if (node != null) {
            boolean newMark = this.mark(node, true, Propogate.UP);
            if (!newMark) {
                return;
            }
        } else if (_logger.isLoggable(Level.FINE) && this._markedNodes.size() > 2) {
            _logger.warning("Told subsumer " + c + " is not classified yet");
        }
        if (this._toldTaxonomy.contains(c)) {
            for (ATermAppl sup : this._toldTaxonomy.getFlattenedSupers(c, true)) {
                this.markToldSubsumers(sup);
            }
        }
    }

    private void markToldSubsumeds(ATermAppl c, boolean b) {
        boolean newMark;
        TaxonomyNode<ATermAppl> node = this._taxonomyImpl.getNode(c);
        if (node != null && !(newMark = this.mark(node, b, Propogate.DOWN))) {
            return;
        }
        if (this._toldTaxonomy.contains(c)) {
            for (ATermAppl sub : this._toldTaxonomy.getFlattenedSubs(c, true)) {
                this.markToldSubsumeds(sub, b);
            }
        }
    }

    private void markToldDisjoints(Collection<ATermAppl> inputc, boolean topSearch) {
        HashSet<ATermAppl> cset = new HashSet<ATermAppl>();
        cset.addAll(inputc);
        for (ATermAppl c : inputc) {
            if (this._taxonomyImpl.contains(c)) {
                cset.addAll(this._taxonomyImpl.getFlattenedSupers(c, false));
            }
            if (!this._toldTaxonomy.contains(c)) continue;
            cset.addAll(this._toldTaxonomy.getFlattenedSupers(c, false));
        }
        HashSet<ATermAppl> disjoints = new HashSet<ATermAppl>();
        for (ATermAppl a : cset) {
            Set<ATermAppl> disj = this._toldDisjoints.get(a);
            if (disj == null) continue;
            disjoints.addAll(disj);
        }
        if (topSearch) {
            for (ATermAppl d : disjoints) {
                TaxonomyNode<ATermAppl> node = this._taxonomyImpl.getNode(d);
                if (node == null) continue;
                this.mark(node, false, Propogate.NONE);
            }
        } else {
            for (ATermAppl d : disjoints) {
                this.markToldSubsumeds(d, false);
            }
        }
    }

    private TaxonomyNode<ATermAppl> checkSatisfiability(ATermAppl c) {
        _logger.finer("Satisfiable ");
        Optional<Timer> timer = this._kb.getTimers().startTimer("classifySat");
        boolean isSatisfiable = this._kb.getABox().isSatisfiable(c, true);
        timer.ifPresent(t -> t.stop());
        if (_logger.isLoggable(Level.FINER) && timer.isPresent()) {
            _logger.finer((isSatisfiable ? "true" : "*****FALSE*****") + " (" + timer.get().getLast() + "ms)");
        }
        if (!isSatisfiable) {
            this._taxonomyImpl.addEquivalentNode(c, this._taxonomyImpl.getBottomNode());
        }
        if (OpenlletOptions.USE_CACHING) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("...negation ");
            }
            Optional<Timer> timer2 = this._kb.getTimers().startTimer("classifySatNot");
            ATermAppl notC = ATermUtils.makeNot(c);
            isSatisfiable = this._kb.getABox().isSatisfiable(notC, true);
            timer2.ifPresent(t -> t.stop());
            if (!isSatisfiable) {
                this._taxonomyImpl.addEquivalentNode(c, this._taxonomyImpl.getTop());
            }
            if (_logger.isLoggable(Level.FINER) && timer2.isPresent()) {
                _logger.finer(isSatisfiable + " (" + timer2.get().getLast() + "ms)");
            }
        }
        return this._taxonomyImpl.getNode(c);
    }

    @Override
    public void classify(ATermAppl c) {
        this.classify(c, true);
    }

    private TaxonomyNode<ATermAppl> classify(ATermAppl c, boolean requireTopSearch) {
        List<ATermAppl> subs;
        boolean skipBottomSearch;
        List<TaxonomyNode<ATermAppl>> superNodes;
        boolean skipTopSearch;
        TaxonomyNode<ATermAppl> node = this._taxonomyImpl.getNode(c);
        if (node != null) {
            return node;
        }
        node = this.checkSatisfiability(c);
        if (node != null) {
            return node;
        }
        this.clearMarks();
        ConceptFlag flag = this._conceptFlags.get(c);
        if (flag == null) {
            flag = ConceptFlag.OTHER;
        }
        boolean bl = skipTopSearch = !requireTopSearch && this._useCD && flag == ConceptFlag.COMPLETELY_DEFINED;
        if (skipTopSearch) {
            superNodes = this.getCDSupers(c);
            skipBottomSearch = true;
        } else {
            superNodes = this.doTopSearch(c);
            skipBottomSearch = this._useCD && (flag == ConceptFlag.PRIMITIVE || flag == ConceptFlag.COMPLETELY_DEFINED);
        }
        ArrayList<ATermAppl> supers = new ArrayList<ATermAppl>();
        for (TaxonomyNode<ATermAppl> taxonomyNode : superNodes) {
            supers.add(taxonomyNode.getName());
        }
        if (skipBottomSearch) {
            subs = Collections.singletonList(ATermUtils.BOTTOM);
        } else {
            if (superNodes.size() == 1) {
                TaxonomyNode<ATermAppl> supNode = superNodes.iterator().next();
                ATermAppl aTermAppl = supNode.getName();
                boolean isEq = this._kb.getTimers().execute("eqCheck", () -> this.subsumes(c, sup));
                if (isEq) {
                    _logger.finer(() -> CDOptimizedTaxonomyBuilder.format(c) + " = " + CDOptimizedTaxonomyBuilder.format(sup));
                    this._taxonomyImpl.addEquivalentNode(c, supNode);
                    return supNode;
                }
            }
            List<TaxonomyNode<ATermAppl>> subNodes = this.doBottomSearch(c, superNodes);
            subs = new ArrayList<ATermAppl>();
            for (TaxonomyNode taxonomyNode : subNodes) {
                subs.add((ATermAppl)taxonomyNode.getName());
            }
        }
        node = this._taxonomyImpl.addNode(Collections.singleton(c), supers, subs, !ATermUtils.isPrimitive(c));
        TaxonomyNode<ATermAppl> toldNode = this._toldTaxonomy.getNode(c);
        if (toldNode != null) {
            TaxonomyNode<ATermAppl> taxonomyNode = this._toldTaxonomy.getNode(c);
            for (ATermAppl aTermAppl : taxonomyNode.getEquivalents()) {
                this._taxonomyImpl.addEquivalentNode(aTermAppl, node);
            }
            for (TaxonomyNode taxonomyNode2 : superNodes) {
                Set<Set<ATermAppl>> exps = TaxonomyUtils.getSuperExplanations(this._toldTaxonomy, c, (ATermAppl)taxonomyNode2.getName());
                if (exps == null) continue;
                for (Set<ATermAppl> exp : exps) {
                    if (exp.isEmpty()) continue;
                    TaxonomyUtils.addSuperExplanation(this._taxonomyImpl, c, (ATermAppl)taxonomyNode2.getName(), exp);
                }
            }
        }
        _logger.finer(() -> "Subsumption Count: " + this._kb.getABox().getStats()._satisfiabilityCount);
        return node;
    }

    private List<TaxonomyNode<ATermAppl>> doBottomSearch(ATermAppl c, List<TaxonomyNode<ATermAppl>> supers) {
        Set<Object> searchFrom;
        if (supers.size() > 1) {
            searchFrom = Collections.newSetFromMap(new ConcurrentHashMap());
            supers.parallelStream().forEach(sup -> CDOptimizedTaxonomyBuilder.collectLeafs(sup, searchFrom));
        } else {
            searchFrom = new HashSet();
            for (TaxonomyNode<ATermAppl> sup2 : supers) {
                CDOptimizedTaxonomyBuilder.collectLeafs(sup2, searchFrom);
            }
        }
        if (searchFrom.isEmpty()) {
            return Collections.singletonList(this._taxonomyImpl.getBottomNode());
        }
        this.clearMarks();
        this.mark(this._taxonomyImpl.getTop(), false, Propogate.NONE);
        this._taxonomyImpl.getBottomNode().setMark(true);
        this.markToldSubsumeds(c, true);
        for (TaxonomyNode<ATermAppl> sup2 : supers) {
            this.mark(sup2, false, Propogate.NONE);
        }
        _logger.finer("Bottom search...");
        ArrayList<TaxonomyNode<ATermAppl>> subs = new ArrayList<TaxonomyNode<ATermAppl>>();
        HashSet<TaxonomyNode<ATermAppl>> visited = new HashSet<TaxonomyNode<ATermAppl>>();
        for (TaxonomyNode taxonomyNode : searchFrom) {
            if (!this.subsumed(taxonomyNode, c)) continue;
            this.search(false, c, taxonomyNode, visited, subs);
        }
        if (subs.isEmpty()) {
            return Collections.singletonList(this._taxonomyImpl.getBottomNode());
        }
        return subs;
    }

    private static void collectLeafs(TaxonomyNode<ATermAppl> node, Collection<TaxonomyNode<ATermAppl>> leafs) {
        if (node.isLeaf()) {
            leafs.add(node);
            return;
        }
        ArrayList<TaxonomyNode<ATermAppl>> nodes = new ArrayList<TaxonomyNode<ATermAppl>>();
        nodes.add(node);
        do {
            TaxonomyNode child = (TaxonomyNode)nodes.remove(nodes.size() - 1);
            for (TaxonomyNode loc : child.getSubs()) {
                (loc.isLeaf() ? leafs : nodes).add(loc);
            }
        } while (!nodes.isEmpty());
    }

    private List<TaxonomyNode<ATermAppl>> doTopSearch(ATermAppl c) {
        this.mark(this._taxonomyImpl.getTop(), true, Propogate.NONE);
        this._taxonomyImpl.getBottomNode().setMark(false);
        this.markToldSubsumers(c);
        this.markToldDisjoints(Collections.singleton(c), true);
        _logger.finer("Top search...");
        ArrayList<TaxonomyNode<ATermAppl>> supers = new ArrayList<TaxonomyNode<ATermAppl>>();
        this.search(true, c, this._taxonomyImpl.getTop(), new HashSet<TaxonomyNode<ATermAppl>>(), supers);
        return supers;
    }

    private List<TaxonomyNode<ATermAppl>> getCDSupers(ATermAppl c) {
        ArrayList<TaxonomyNode<ATermAppl>> supers = new ArrayList<TaxonomyNode<ATermAppl>>();
        TaxonomyNode<ATermAppl> toldTaxNode = this._toldTaxonomy.getNode(c);
        assert (toldTaxNode != null);
        Collection<TaxonomyNode<ATermAppl>> cDefs = toldTaxNode.getSupers();
        int nTS = cDefs.size();
        if (nTS == 1) {
            for (TaxonomyNode<ATermAppl> def : cDefs) {
                if (def == this._toldTaxonomy.getTop()) continue;
                TaxonomyNode<ATermAppl> parent = this._taxonomyImpl.getNode(def.getName());
                if (parent == null) {
                    _logger.warning("Possible tautological definition, assuming " + CDOptimizedTaxonomyBuilder.format(def.getName()) + " is equivalent to " + CDOptimizedTaxonomyBuilder.format(ATermUtils.TOP));
                    _logger.fine(() -> "Told subsumer of " + CDOptimizedTaxonomyBuilder.format(c) + "  is not classified: " + CDOptimizedTaxonomyBuilder.format((ATermAppl)def.getName()));
                } else {
                    supers.add(parent);
                }
                break;
            }
        } else {
            TaxonomyNode<ATermAppl> candidate;
            for (TaxonomyNode<ATermAppl> def : cDefs) {
                if (def == this._toldTaxonomy.getTop()) continue;
                candidate = this._taxonomyImpl.getNode(def.getName());
                if (null == candidate) {
                    _logger.warning("Possible tautological definition, assuming " + CDOptimizedTaxonomyBuilder.format(def.getName()) + " is equivalent to " + CDOptimizedTaxonomyBuilder.format(ATermUtils.TOP));
                    _logger.fine(() -> "Told subsumer of " + CDOptimizedTaxonomyBuilder.format(c) + "  is not classified: " + CDOptimizedTaxonomyBuilder.format((ATermAppl)def.getName()));
                    continue;
                }
                for (TaxonomyNode<ATermAppl> ancestor : candidate.getSupers()) {
                    this.mark(ancestor, true, Propogate.UP);
                }
            }
            for (TaxonomyNode<ATermAppl> def : cDefs) {
                if (def == this._toldTaxonomy.getTop() || (candidate = this._taxonomyImpl.getNode(def.getName())).markIsDefined()) continue;
                supers.add(candidate);
                _logger.finer(() -> "...completely defined by " + ((ATermAppl)candidate.getName()).getName());
            }
        }
        if (supers.isEmpty()) {
            supers.add(this._taxonomyImpl.getTop());
        }
        return supers;
    }

    private Collection<TaxonomyNode<ATermAppl>> search(boolean topSearch, ATermAppl c, TaxonomyNode<ATermAppl> x, Set<TaxonomyNode<ATermAppl>> visited, List<TaxonomyNode<ATermAppl>> result) {
        Optional<Timer> timer = this._kb.getTimers().startTimer("search" + (topSearch ? "Top" : "Bottom"));
        ArrayList<TaxonomyNode<ATermAppl>> posSucc = new ArrayList<TaxonomyNode<ATermAppl>>();
        visited.add(x);
        Collection<TaxonomyNode<ATermAppl>> list = topSearch ? x.getSubs() : x.getSupers();
        for (TaxonomyNode<ATermAppl> next : list) {
            if (topSearch) {
                if (!this.nodeSubsumes(next, c)) continue;
                posSucc.add(next);
                continue;
            }
            if (!this.subsumed(next, c)) continue;
            posSucc.add(next);
        }
        if (posSucc.isEmpty()) {
            result.add(x);
        } else {
            for (TaxonomyNode<ATermAppl> y : posSucc) {
                if (visited.contains(y)) continue;
                this.search(topSearch, c, y, visited, result);
            }
        }
        timer.ifPresent(t -> t.stop());
        return result;
    }

    private boolean subCheckWithCache(TaxonomyNode<ATermAppl> node, ATermAppl c, boolean topDown) {
        Collection<TaxonomyNode<ATermAppl>> ancestors;
        if (node.markIsDefined()) {
            return node.getMark();
        }
        Collection<TaxonomyNode<ATermAppl>> collection = ancestors = topDown ? node.getSupers() : node.getSubs();
        if (ancestors.size() > 1) {
            HashMap visited = new HashMap();
            HashMap<TaxonomyNode<ATermAppl>, TaxonomyNode<ATermAppl>> toBeVisited = new HashMap<TaxonomyNode<ATermAppl>, TaxonomyNode<ATermAppl>>();
            HashMap nextVisit = new HashMap();
            visited.put(node, null);
            for (TaxonomyNode<ATermAppl> taxonomyNode : ancestors) {
                toBeVisited.put(taxonomyNode, node);
            }
            while (!toBeVisited.isEmpty()) {
                for (Map.Entry entry : toBeVisited.entrySet()) {
                    TaxonomyNode reachedFrom;
                    TaxonomyNode relative = (TaxonomyNode)entry.getKey();
                    if (!relative.markIsDefined()) {
                        Collection moreRelatives = topDown ? relative.getSupers() : relative.getSubs();
                        for (TaxonomyNode n : moreRelatives) {
                            if (visited.containsKey(n) || toBeVisited.containsKey(n)) continue;
                            nextVisit.put(n, relative);
                        }
                        continue;
                    }
                    if (relative.getMark()) continue;
                    TaxonomyNode n = reachedFrom = (TaxonomyNode)entry.getValue();
                    while (n != null) {
                        this.mark(n, false, Propogate.NONE);
                        n = (TaxonomyNode)visited.get(n);
                    }
                    return false;
                }
                visited.putAll(toBeVisited);
                toBeVisited.clear();
                HashMap tmp = nextVisit;
                nextVisit = toBeVisited;
                toBeVisited = tmp;
            }
        }
        boolean calcdMark = topDown ? this.subsumes(node.getName(), c) : this.subsumes(c, node.getName());
        this.mark(node, calcdMark, Propogate.NONE);
        return calcdMark;
    }

    private boolean nodeSubsumes(TaxonomyNode<ATermAppl> node, ATermAppl c) {
        return this.subCheckWithCache(node, c, true);
    }

    private boolean subsumed(TaxonomyNode<ATermAppl> node, ATermAppl c) {
        return this.subCheckWithCache(node, c, false);
    }

    private boolean mark(TaxonomyNode<ATermAppl> node, boolean value, Propogate propogate) {
        if (node.getEquivalents().contains(ATermUtils.BOTTOM)) {
            return true;
        }
        if (node.markIsDefined()) {
            if (node.getMark() != value) {
                throw new OpenError("Inconsistent classification result " + node.getName() + " " + node.getMark() + " " + value);
            }
            return false;
        }
        node.setMark(value);
        this._markedNodes.add(node);
        if (propogate != Propogate.NONE) {
            Collection<TaxonomyNode<ATermAppl>> others = propogate == Propogate.UP ? node.getSupers() : node.getSubs();
            for (TaxonomyNode<ATermAppl> n : others) {
                this.mark(n, value, propogate);
            }
        }
        return true;
    }

    private boolean subsumes(ATermAppl sup, ATermAppl sub) {
        return this._kb.getABox().isSubClassOf(sub, sup);
    }

    private static void mark(Set<ATermAppl> set, Map<ATermAppl, Boolean> marked, boolean value) {
        set.forEach(c -> marked.put((ATermAppl)c, value));
    }

    @Override
    public boolean realize() {
        this._monitor.setProgressTitle("Realizing");
        return OpenlletOptions.REALIZE_INDIVIDUAL_AT_A_TIME ? this.realizeByIndividuals() : this.realizeByConcepts();
    }

    private boolean realizeByIndividuals() {
        this._monitor.setProgressLength(this._kb.getIndividuals().size());
        this._monitor.taskStarted();
        IndividualIterator i = this._kb.getABox().getIndIterator();
        int count = 0;
        while (i.hasNext()) {
            Individual x = (Individual)i.next();
            this._monitor.incrementProgress();
            this._kb.getTimers().getTimer("realize").ifPresent(t -> t.check());
            if (this._monitor.isCanceled()) {
                return false;
            }
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer(count + ") Realizing " + CDOptimizedTaxonomyBuilder.format(x.getName()) + " ");
            }
            this.realize(x);
            ++count;
        }
        this._monitor.taskFinished();
        return true;
    }

    @Override
    public void realize(ATermAppl x) {
        this.realize(this._kb.getABox().getIndividual(x));
    }

    private void realize(Individual x) {
        ConcurrentHashMap<ATermAppl, Boolean> marked = new ConcurrentHashMap<ATermAppl, Boolean>();
        ArrayList<ATermAppl> obviousTypes = new ArrayList<ATermAppl>();
        ArrayList<ATermAppl> obviousNonTypes = new ArrayList<ATermAppl>();
        this._kb.getABox().getObviousTypes(x.getName(), obviousTypes, obviousNonTypes);
        for (ATermAppl c : obviousTypes) {
            if (!this._taxonomyImpl.contains(c)) continue;
            CDOptimizedTaxonomyBuilder.mark(this._taxonomyImpl.getAllEquivalents(c), marked, true);
            CDOptimizedTaxonomyBuilder.mark(this._taxonomyImpl.getFlattenedSupers(c, true), marked, true);
        }
        for (ATermAppl c : obviousNonTypes) {
            CDOptimizedTaxonomyBuilder.mark(this._taxonomyImpl.getAllEquivalents(c), marked, false);
            CDOptimizedTaxonomyBuilder.mark(this._taxonomyImpl.getFlattenedSubs(c, true), marked, false);
        }
        this.realize(x.getName(), ATermUtils.TOP, marked);
    }

    private boolean realize(ATermAppl n, ATermAppl c, Map<ATermAppl, Boolean> marked) {
        boolean isType;
        boolean realized = false;
        if (c.equals(ATermUtils.BOTTOM)) {
            return false;
        }
        if (marked.containsKey(c)) {
            isType = marked.get(c);
        } else {
            long time = 0L;
            long count = 0L;
            if (_logger.isLoggable(Level.FINER)) {
                time = System.currentTimeMillis();
                count = this._kb.getABox().getStats()._consistencyCount;
                _logger.finer("Type checking for [" + CDOptimizedTaxonomyBuilder.format(n) + ", " + CDOptimizedTaxonomyBuilder.format(c) + "]...");
            }
            isType = this._kb.getTimers().execute("classifyType", () -> this._kb.isType(n, c));
            marked.put(c, isType);
            if (_logger.isLoggable(Level.FINER)) {
                String sign = this._kb.getABox().getStats()._consistencyCount > count ? "+" : "-";
                time = System.currentTimeMillis() - time;
                _logger.finer("done (" + (isType ? "+" : "-") + ") (" + sign + time + "ms)");
            }
        }
        if (isType) {
            TaxonomyNode<ATermAppl> node = this._taxonomyImpl.getNode(c);
            for (TaxonomyNode<ATermAppl> sub : node.getSubs()) {
                ATermAppl d = sub.getName();
                realized = this.realize(n, d, marked) || realized;
            }
            if (!realized) {
                HashSet<ATermAppl> instances = (HashSet<ATermAppl>)node.getDatum((Object)TaxonomyUtils.TaxonomyKey.INSTANCES_KEY);
                if (instances == null) {
                    instances = new HashSet<ATermAppl>();
                    node.putDatum((Object)TaxonomyUtils.TaxonomyKey.INSTANCES_KEY, instances);
                }
                instances.add(n);
                realized = true;
            }
        }
        return realized;
    }

    private boolean realizeByConcepts() {
        if (null == this._classes) {
            this.classify();
        }
        this._monitor.setProgressLength(this._classes.size() + 2);
        this._monitor.taskStarted();
        this.clearMarks();
        Set<ATermAppl> individuals = this._kb.getIndividuals();
        if (!individuals.isEmpty()) {
            this.realizeByConcept(ATermUtils.TOP, individuals);
        }
        this._kb.getTimers().getTimer("realize").ifPresent(t -> t.check());
        if (this._monitor.isCanceled()) {
            return false;
        }
        this._monitor.taskFinished();
        return true;
    }

    private Set<ATermAppl> realizeByConcept(ATermAppl c, Collection<ATermAppl> individuals) {
        if (c.equals(ATermUtils.BOTTOM)) {
            return Collections.emptySet();
        }
        this._kb.getTimers().getTimer("realize").ifPresent(t -> t.check());
        if (this._monitor.isCanceled()) {
            return null;
        }
        TaxonomyNode<ATermAppl> node = this._taxonomyImpl.getNode(c);
        if (node.markIsDefined() && node.getMark()) {
            return TaxonomyUtils.getAllInstances(this._taxonomyImpl, c);
        }
        this._monitor.incrementProgress();
        this.mark(node, true, Propogate.NONE);
        _logger.fine(() -> "Realizing concept " + c);
        Set<ATermAppl> instances = SetUtils.create(this._kb.retrieve(c, individuals));
        Set<ATermAppl> mostSpecificInstances = SetUtils.create(instances);
        if (!instances.isEmpty()) {
            for (TaxonomyNode<ATermAppl> sub : node.getSubs()) {
                ATermAppl d = sub.getName();
                Set<ATermAppl> subInstances = this.realizeByConcept(d, instances);
                if (subInstances == null) {
                    return null;
                }
                mostSpecificInstances.removeAll(subInstances);
            }
            if (!mostSpecificInstances.isEmpty()) {
                node.putDatum((Object)TaxonomyUtils.TaxonomyKey.INSTANCES_KEY, mostSpecificInstances);
            }
        }
        return instances;
    }

    private static String format(ATermAppl c) {
        return ATermUtils.toString(c);
    }

    private /* synthetic */ void lambda$classify$3(boolean requireTopSearch, ATermAppl c) {
        System.out.println(Thread.currentThread().getName() + " Classify on " + c + " [begin]");
        this.classify(c, requireTopSearch);
        this._monitor.incrementProgress();
        this._kb.getTimers().getTimer("classify").ifPresent(t -> t.check());
        System.out.println(Thread.currentThread().getName() + " Classify on " + c + " [ end ]");
    }

    private static enum ConceptFlag {
        COMPLETELY_DEFINED,
        PRIMITIVE,
        NONPRIMITIVE,
        NONPRIMITIVE_TA,
        OTHER;

    }

    private static enum Propogate {
        UP,
        DOWN,
        NONE;

    }
}

