/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.taxonomy;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import openllet.atom.OpenError;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.taxonomy.TaxonomyNode;
import openllet.core.taxonomy.TaxonomyUtils;
import openllet.core.utils.Bool;
import openllet.shared.tools.Logging;

public interface Taxonomy<T>
extends Logging {
    public TaxonomyNode<T> getBottomNode();

    public void setBottomNode(TaxonomyNode<T> var1);

    public TaxonomyNode<T> getTopNode();

    public void setTopNode(TaxonomyNode<T> var1);

    public short getDepth();

    public void setDepth(short var1);

    public int getTotalBranching();

    public void setTotalBranching(int var1);

    public Map<T, TaxonomyNode<T>> getNodes();

    public void setNodes(Map<T, TaxonomyNode<T>> var1);

    default public void addEquivalentNode(T t, TaxonomyNode<T> node) {
        node.addEquivalent(t);
        this.getNodes().put(t, node);
    }

    default public void addEquivalents(T t, Collection<T> eqs) {
        if (!1.$assertionsDisabled && !this.getNodes().keySet().contains(t)) {
            throw new AssertionError((Object)("Element " + t.toString() + " not in taxonomy"));
        }
        TaxonomyNode<T> node = this.getNodes().get(t);
        for (T eq : eqs) {
            if (!1.$assertionsDisabled && this.getNodes().keySet().contains(eq)) {
                throw new AssertionError((Object)("Element " + eq.toString() + " alread in taxonomy"));
            }
            node.addEquivalent(eq);
            this.getNodes().put(eq, node);
        }
    }

    default public TaxonomyNode<T> addNode(Collection<T> equivalents, Collection<T> sups, Collection<T> subs, boolean hidden) {
        if (!1.$assertionsDisabled && equivalents.isEmpty()) {
            throw new AssertionError((Object)"Taxonomy getNodes() must have at least one element");
        }
        if (!1.$assertionsDisabled && !this.getNodes().keySet().containsAll(sups)) {
            throw new AssertionError((Object)"At least one super element not in taxonomy");
        }
        if (!1.$assertionsDisabled && !this.getNodes().keySet().containsAll(subs)) {
            throw new AssertionError((Object)"At least one sub element not in taxonomy");
        }
        TaxonomyNode node = new TaxonomyNode(equivalents, hidden);
        for (T t : equivalents) {
            this.getNodes().put(t, node);
        }
        short depth = 1;
        if (sups.isEmpty()) {
            if (this.getTopNode().isHidden()) {
                this.getTopNode().addSub(node);
                if (this.getTopNode().getSubs().size() == 2) {
                    this.getTopNode().removeSub(this.getBottomNode());
                }
            } else {
                node.addSupers(Collections.singleton(this.getTopNode()));
            }
            this.setTotalBranching(this.getTotalBranching() + 1);
        } else {
            HashSet supNodes = new HashSet();
            for (T sup : sups) {
                TaxonomyNode<T> supNode = this.getNodes().get(sup);
                if (supNode._depth >= depth) {
                    depth = (short)(supNode._depth + 1);
                }
                supNodes.add(supNode);
            }
            node._depth = depth;
            if (depth > this.getDepth()) {
                this.setDepth(depth);
            }
            node.addSupers(supNodes);
            this.setTotalBranching(this.getTotalBranching() + supNodes.size());
        }
        if (subs.isEmpty()) {
            if (this.getBottomNode().isHidden()) {
                this.getBottomNode().addSupers(Collections.singleton(node));
                this.getBottomNode().getSupers().removeAll(node.getSupers());
            } else {
                node.addSub(this.getBottomNode());
            }
            this.setTotalBranching(this.getTotalBranching() + 1);
        } else {
            HashSet subNodes = new HashSet();
            for (T sub : subs) {
                subNodes.add(this.getNodes().get(sub));
            }
            node.addSubs(subNodes);
            this.setTotalBranching(this.getTotalBranching() + subNodes.size());
        }
        node.removeMultiplePaths();
        return node;
    }

    default public TaxonomyNode<T> addNode(T t, boolean hidden) {
        TaxonomyNode<T> node = new TaxonomyNode<T>(t, hidden);
        this.getTopNode().addSub(node);
        node.addSub(this.getBottomNode());
        this.getNodes().put(t, node);
        return node;
    }

    default public void addSuper(T sub, T sup) {
        TaxonomyNode<T> supNode;
        if (!1.$assertionsDisabled && !this.getNodes().keySet().contains(sub)) {
            throw new AssertionError((Object)("Sub element " + sub.toString() + " not in taxonomy"));
        }
        if (!1.$assertionsDisabled && !this.getNodes().keySet().contains(sup)) {
            throw new AssertionError((Object)("Super element " + sup.toString() + " not in taxonomy"));
        }
        TaxonomyNode<T> subNode = this.getNodes().get(sub);
        if (subNode.equals(supNode = this.getNodes().get(sup))) {
            throw new InternalReasonerException("Equivalent elements cannot have sub/super relationship");
        }
        if (subNode.getSupers().size() == 1 && subNode.getSupers().iterator().next() == this.getTopNode()) {
            this.getTopNode().removeSub(subNode);
        }
        if (supNode.getSubs().size() == 1 && supNode.getSubs().iterator().next() == this.getBottomNode()) {
            supNode.removeSub(this.getBottomNode());
        }
        supNode.addSub(subNode);
    }

    default public void addSupers(T sub, Collection<T> sups) {
        if (!1.$assertionsDisabled && !this.getNodes().keySet().contains(sub)) {
            throw new AssertionError((Object)("Sub element " + sub.toString() + " not in taxonomy"));
        }
        if (!1.$assertionsDisabled && !this.getNodes().keySet().containsAll(sups)) {
            throw new AssertionError((Object)"At least one super element not in taxonomy");
        }
        TaxonomyNode subNode = this.getNodes().get(sub);
        HashSet supNodes = new HashSet();
        for (T t : sups) {
            supNodes.add(this.getNodes().get(t));
        }
        if (subNode.getSupers().size() == 1 && subNode.getSupers().contains(this.getTopNode())) {
            this.getTopNode().removeSub(subNode);
        }
        for (TaxonomyNode taxonomyNode : supNodes) {
            if (taxonomyNode.getSubs().size() != 1 || !taxonomyNode.getSubs().contains(this.getBottomNode())) continue;
            taxonomyNode.removeSub(this.getBottomNode());
        }
        subNode.addSupers(supNodes);
    }

    default public void assertValid() {
        if (!1.$assertionsDisabled && !this.getTopNode().getSupers().isEmpty()) {
            throw new AssertionError((Object)"Top _node in the taxonomy has parents");
        }
        if (!1.$assertionsDisabled && !this.getBottomNode().getSubs().isEmpty()) {
            throw new AssertionError((Object)"Bottom _node in the taxonomy has children");
        }
    }

    default public List<T> computeLCA(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        T t = list.get(0);
        ArrayList<T> ancestors = new ArrayList<T>(this.getFlattenedSupers(t, false));
        for (int i = 1; i < list.size() && ancestors.size() > 0; ++i) {
            t = list.get(i);
            ancestors.retainAll(this.getFlattenedSupers(t, false));
        }
        HashSet toBeRemoved = new HashSet();
        for (Object a : ancestors) {
            if (toBeRemoved.contains(a)) continue;
            Set supers = this.getFlattenedSupers(a, false);
            toBeRemoved.addAll(supers);
        }
        ancestors.removeAll(toBeRemoved);
        return ancestors;
    }

    default public boolean contains(T t) {
        return this.getNodes().containsKey(t);
    }

    public Iterator<Map.Entry<Set<T>, Object>> datumEquivalentsPair(TaxonomyUtils.TaxonomyKey var1);

    public Iterator<Object> depthFirstDatumOnly(T var1, TaxonomyUtils.TaxonomyKey var2);

    default public Set<T> getAllEquivalents(T t) {
        TaxonomyNode<T> node = this.getNodes().get(t);
        if (node == null) {
            return new HashSet();
        }
        return new HashSet<T>(node.getEquivalents());
    }

    default public Set<T> getClasses() {
        return this.getNodes().keySet();
    }

    default public Object getDatum(T t, TaxonomyUtils.TaxonomyKey key) {
        TaxonomyNode<T> node = this.getNodes().get(t);
        return node == null ? null : node.getDatum((Object)key);
    }

    default public Set<T> getEquivalents(T t) {
        Set<T> result = this.getAllEquivalents(t);
        result.remove(t);
        return result;
    }

    public Set<T> getFlattenedSubs(T var1, boolean var2);

    public Set<T> getFlattenedSupers(T var1, boolean var2);

    default public TaxonomyNode<T> getNode(T t) {
        return this.getNodes().get(t);
    }

    default public Set<Set<T>> getSubs(T t) {
        return this.getSubs(t, false);
    }

    public Set<Set<T>> getSubs(T var1, boolean var2);

    default public Set<Set<T>> getSupers(T t) {
        return this.getSupers(t, false);
    }

    public Set<Set<T>> getSupers(T var1, boolean var2);

    public Stream<Set<T>> supers(T var1, boolean var2);

    default public TaxonomyNode<T> getTop() {
        return this.getTopNode();
    }

    default public Bool isEquivalent(T x, T y) {
        TaxonomyNode<T> nodeX = this.getNodes().get(x);
        TaxonomyNode<T> nodeY = this.getNodes().get(y);
        if (nodeX == null || nodeY == null) {
            return Bool.UNKNOWN;
        }
        if (nodeX.equals(nodeY)) {
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    default public Bool isSubNodeOf(T x, T y) {
        TaxonomyNode<T> nodeX = this.getNodes().get(x);
        TaxonomyNode<T> nodeY = this.getNodes().get(y);
        if (nodeX == null || nodeY == null) {
            return Bool.UNKNOWN;
        }
        if (nodeX.equals(nodeY)) {
            return Bool.TRUE;
        }
        if (nodeX.isHidden()) {
            if (nodeY.isHidden()) {
                return Bool.UNKNOWN;
            }
            return this.getFlattenedSupers(x, false).contains(y) ? Bool.TRUE : Bool.FALSE;
        }
        return this.getFlattenedSubs(y, false).contains(x) ? Bool.TRUE : Bool.FALSE;
    }

    public void merge(TaxonomyNode<T> var1, TaxonomyNode<T> var2);

    default public Object putDatum(T t, TaxonomyUtils.TaxonomyKey key, Object value) {
        TaxonomyNode<T> node = this.getNodes().get(t);
        if (node == null) {
            throw new OpenError(t + " is an unknown class!");
        }
        return node.putDatum((Object)key, value);
    }

    default public void remove(T t) {
        if (!1.$assertionsDisabled && !this.getNodes().containsKey(t)) {
            throw new AssertionError((Object)"Element not contained in taxonomy");
        }
        TaxonomyNode<T> node = this.getNodes().remove(t);
        if (node.getEquivalents().size() == 1) {
            Collection<TaxonomyNode<T>> subs = node.getSubs();
            Collection<TaxonomyNode<T>> supers = node.getSupers();
            node.disconnect();
            for (TaxonomyNode<T> sup : supers) {
                sup.addSubs(subs);
            }
        } else {
            node.removeEquivalent(t);
        }
    }

    public void removeCycles(TaxonomyNode<T> var1);

    default public Object removeDatum(T t, TaxonomyUtils.TaxonomyKey key) {
        return this.getNode(t).removeDatum((Object)key);
    }

    default public void resetSupers(T t, Collection<T> supers) {
        if (!1.$assertionsDisabled && !this.getNodes().keySet().contains(t)) {
            throw new AssertionError((Object)("Element " + t.toString() + " not in taxonomy"));
        }
        if (!1.$assertionsDisabled && !this.getNodes().keySet().containsAll(supers)) {
            throw new AssertionError((Object)"Supers not all contained in taxonomy");
        }
        TaxonomyNode<T> node = this.getNodes().get(t);
        ArrayList<TaxonomyNode<T>> initial = new ArrayList<TaxonomyNode<T>>(node.getSupers());
        for (TaxonomyNode taxonomyNode : initial) {
            taxonomyNode.removeSub(node);
        }
        if (supers.isEmpty()) {
            this.getTopNode().addSub(node);
        } else {
            HashSet<TaxonomyNode<T>> added = new HashSet<TaxonomyNode<T>>();
            for (T sup : supers) {
                TaxonomyNode<T> n = this.getNodes().get(sup);
                if (!added.add(n)) continue;
                n.addSub(node);
            }
        }
    }

    default public List<T> topologocialSort(boolean includeEquivalents) {
        return this.topologocialSort(includeEquivalents, null);
    }

    default public List<T> topologocialSort(boolean includeEquivalents, Comparator<? super T> comparator) {
        HashMap degrees = new HashMap();
        AbstractMap nodesPending = comparator == null ? new HashMap() : new TreeMap(comparator);
        HashSet<TaxonomyNode<T>> nodesLeft = new HashSet<TaxonomyNode<T>>();
        ArrayList nodesSorted = new ArrayList();
        this.getLogger().fine("Topological sort...");
        for (TaxonomyNode<T> node : this.getNodes().values()) {
            if (node.isHidden()) continue;
            nodesLeft.add(node);
            int degree = node.getSupers().size();
            if (degree == 0) {
                nodesPending.put(node.getName(), node);
                degrees.put(node, 0);
                continue;
            }
            degrees.put(node, degree);
        }
        int size = nodesLeft.size();
        for (int i = 0; i < size; ++i) {
            if (nodesPending.isEmpty()) {
                throw new InternalReasonerException("Cycle detected in the taxonomy!");
            }
            TaxonomyNode node = (TaxonomyNode)nodesPending.values().iterator().next();
            int deg = (Integer)degrees.get(node);
            if (deg != 0) {
                throw new InternalReasonerException("Cycle detected in the taxonomy " + node + " " + deg + " " + nodesSorted.size() + " " + this.getNodes().size());
            }
            nodesPending.remove(node.getName());
            nodesLeft.remove(node);
            if (includeEquivalents) {
                nodesSorted.addAll(node.getEquivalents());
            } else {
                nodesSorted.add(node.getName());
            }
            for (TaxonomyNode sub : node.getSubs()) {
                int degree = (Integer)degrees.get(sub);
                if (degree == 1) {
                    nodesPending.put(sub.getName(), sub);
                    degrees.put(sub, 0);
                    continue;
                }
                degrees.put(sub, degree - 1);
            }
        }
        if (!nodesLeft.isEmpty()) {
            throw new InternalReasonerException("Failed to sort elements: " + nodesLeft);
        }
        this.getLogger().fine("done");
        return nodesSorted;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

