/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.taxonomy;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.taxonomy.AbstractDefinitionOrder;
import openllet.core.taxonomy.TaxonomyImpl;
import openllet.core.taxonomy.TaxonomyNode;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CollectionUtils;

public class TaxonomyBasedDefinitionOrder
extends AbstractDefinitionOrder {
    private TaxonomyImpl<ATermAppl> _definitionOrderTaxonomy;

    public TaxonomyBasedDefinitionOrder(KnowledgeBase kb, Comparator<ATerm> comparator) {
        super(kb, comparator);
    }

    @Override
    protected void initialize() {
        this._definitionOrderTaxonomy = new TaxonomyImpl<ATermAppl>(this._kb.getClasses(), ATermUtils.TOP, ATermUtils.BOTTOM);
    }

    @Override
    protected void addUses(ATermAppl c, ATermAppl d) {
        if (this._definitionOrderTaxonomy.isEquivalent(c, d).isTrue()) {
            return;
        }
        TaxonomyNode<ATermAppl> cNode = this._definitionOrderTaxonomy.getNode(c);
        TaxonomyNode<ATermAppl> dNode = this._definitionOrderTaxonomy.getNode(d);
        if (cNode == null) {
            throw new InternalReasonerException(c + " is not in the definition _order");
        }
        if (cNode.equals(this._definitionOrderTaxonomy.getTop())) {
            this._definitionOrderTaxonomy.merge(cNode, dNode);
        } else {
            this._definitionOrderTaxonomy.addSuper(c, d);
            this._definitionOrderTaxonomy.removeCycles(cNode);
        }
    }

    @Override
    protected Set<ATermAppl> computeCycles() {
        Set<ATermAppl> cyclicConcepts = CollectionUtils.makeIdentitySet();
        for (TaxonomyNode<ATermAppl> node : this._definitionOrderTaxonomy.getNodes().values()) {
            Set<ATermAppl> names = node.getEquivalents();
            if (names.size() <= 1) continue;
            cyclicConcepts.addAll(names);
        }
        return cyclicConcepts;
    }

    @Override
    protected List<ATermAppl> computeDefinitionOrder() {
        this._definitionOrderTaxonomy.assertValid();
        return this._definitionOrderTaxonomy.topologocialSort(true, this._comparator);
    }
}

