/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.taxonomy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyNode;
import openllet.core.taxonomy.TaxonomyUtils;
import openllet.core.utils.CollectionUtils;
import openllet.shared.tools.Log;

public class TaxonomyImpl<T>
implements Taxonomy<T> {
    public static final Logger _logger = Log.getLogger(TaxonomyImpl.class);
    private static final boolean SUB = true;
    private static final boolean SUPER = false;
    protected volatile TaxonomyNode<T> _bottomNode;
    protected volatile Map<T, TaxonomyNode<T>> _nodes = CollectionUtils.makeMap();
    protected volatile TaxonomyNode<T> _topNode;
    protected volatile short _depth = 0;
    protected volatile int _totalBranching = 0;

    @Override
    public Logger getLogger() {
        return _logger;
    }

    @Override
    public TaxonomyNode<T> getBottomNode() {
        return this._bottomNode;
    }

    @Override
    public void setBottomNode(TaxonomyNode<T> bottomNode) {
        this._bottomNode = bottomNode;
    }

    @Override
    public TaxonomyNode<T> getTopNode() {
        return this._topNode;
    }

    @Override
    public void setTopNode(TaxonomyNode<T> topNode) {
        this._topNode = topNode;
    }

    @Override
    public short getDepth() {
        return this._depth;
    }

    @Override
    public void setDepth(short depth) {
        this._depth = depth;
    }

    @Override
    public int getTotalBranching() {
        return this._totalBranching;
    }

    @Override
    public void setTotalBranching(int totalBranching) {
        this._totalBranching = totalBranching;
    }

    @Override
    public Map<T, TaxonomyNode<T>> getNodes() {
        return this._nodes;
    }

    @Override
    public void setNodes(Map<T, TaxonomyNode<T>> nodes) {
        this._nodes = nodes;
    }

    public TaxonomyImpl() {
        this(null, null, null);
    }

    public TaxonomyImpl(Collection<T> elements, T top, T bottom) {
        if (top == null) {
            this._topNode = new TaxonomyNode<Object>(null, true);
        } else {
            this._topNode = new TaxonomyNode<T>(top, false);
            this._nodes.put(top, this._topNode);
        }
        if (bottom == null) {
            this._bottomNode = new TaxonomyNode<Object>(null, true);
        } else {
            this._bottomNode = new TaxonomyNode<T>(bottom, false);
            this._nodes.put(bottom, this._bottomNode);
        }
        if (elements == null || elements.isEmpty()) {
            this._topNode.addSub(this._bottomNode);
        } else {
            for (T t : elements) {
                this.addNode(t, false);
            }
        }
    }

    @Override
    public Iterator<Map.Entry<Set<T>, Object>> datumEquivalentsPair(TaxonomyUtils.TaxonomyKey key) {
        return new DatumEquivalentsPairIterator(this, (Object)key);
    }

    @Override
    public Iterator<Object> depthFirstDatumOnly(T t, TaxonomyUtils.TaxonomyKey key) {
        return new DepthFirstDatumOnlyIterator<T>(this, t, (Object)key);
    }

    @Override
    public Set<T> getFlattenedSubs(T t, boolean direct) {
        return this.getFlattenedSubSupers(t, direct, true);
    }

    private Set<T> getFlattenedSubSupers(T t, boolean direct, boolean subOrSuper) {
        TaxonomyNode node = this._nodes.get(t);
        HashSet result = new HashSet();
        ArrayList visit = new ArrayList();
        visit.addAll(subOrSuper ? node.getSubs() : node.getSupers());
        for (int i = 0; i < visit.size(); ++i) {
            node = (TaxonomyNode)visit.get(i);
            if (node.isHidden()) continue;
            Set add = node.getEquivalents();
            result.addAll(add);
            if (direct) continue;
            visit.addAll(subOrSuper ? node.getSubs() : node.getSupers());
        }
        return result;
    }

    @Override
    public Set<T> getFlattenedSupers(T t, boolean direct) {
        return this.getFlattenedSubSupers(t, direct, false);
    }

    @Override
    public Set<Set<T>> getSubs(T t, boolean direct) {
        return this.getSubSupers(t, direct, true);
    }

    private Set<Set<T>> getSubSupers(T t, boolean direct, boolean subOrSuper) {
        TaxonomyNode node = this._nodes.get(t);
        if (node == null) {
            return Collections.emptySet();
        }
        HashSet<Set<T>> result = new HashSet<Set<T>>();
        ArrayList visit = new ArrayList();
        visit.addAll(subOrSuper ? node.getSubs() : node.getSupers());
        for (int i = 0; i < visit.size(); ++i) {
            node = (TaxonomyNode)visit.get(i);
            if (node.isHidden()) continue;
            HashSet add = new HashSet(node.getEquivalents());
            if (!add.isEmpty()) {
                result.add(add);
            }
            if (direct) continue;
            visit.addAll(subOrSuper ? node.getSubs() : node.getSupers());
        }
        return result;
    }

    @Override
    public Set<Set<T>> getSupers(T t) {
        return this.getSupers(t, false);
    }

    @Override
    public Set<Set<T>> getSupers(T t, boolean direct) {
        return this.getSubSupers(t, direct, false);
    }

    @Override
    public Stream<Set<T>> supers(T t, boolean direct) {
        return this.getSubSupers(t, direct, false).stream();
    }

    @Override
    public TaxonomyNode<T> getTop() {
        return this._topNode;
    }

    @Override
    public void merge(TaxonomyNode<T> node1, TaxonomyNode<T> node2) {
        ArrayList<TaxonomyNode<T>> mergeList = new ArrayList<TaxonomyNode<T>>(2);
        mergeList.add(node1);
        mergeList.add(node2);
        TaxonomyNode<T> node = this.mergeNodes(mergeList);
        this.removeCycles(node);
    }

    private TaxonomyNode<T> mergeNodes(List<TaxonomyNode<T>> mergeList) {
        assert (mergeList.size() > 1) : "Attempt to merge less than two _nodes";
        _logger.finer(() -> "Merge " + mergeList);
        TaxonomyNode<T> node = null;
        node = mergeList.contains(this._topNode) ? this._topNode : (mergeList.contains(this._bottomNode) ? this._bottomNode : mergeList.get(0));
        HashSet<TaxonomyNode<T>> merged = new HashSet<TaxonomyNode<T>>();
        merged.add(node);
        for (TaxonomyNode<T> other : mergeList) {
            if (merged.contains(other)) continue;
            merged.add(other);
            for (TaxonomyNode<T> sub : other.getSubs()) {
                if (sub == this._bottomNode || mergeList.contains(sub)) continue;
                if (node.getSubs().size() == 1 && node.getSubs().iterator().next() == this._bottomNode) {
                    node.removeSub(this._bottomNode);
                }
                node.addSub(sub);
            }
            for (TaxonomyNode<T> sup : other.getSupers()) {
                if (sup == this._topNode || mergeList.contains(sup)) continue;
                if (node.getSupers().size() == 1 && node.getSupers().iterator().next() == this._topNode) {
                    this._topNode.removeSub(node);
                }
                sup.addSub(node);
            }
            other.disconnect();
            for (TaxonomyNode<T> t : other.getEquivalents()) {
                this.addEquivalentNode(t, node);
            }
        }
        node.clearData();
        if (node != this._topNode && node.getSupers().isEmpty()) {
            this._topNode.addSub(node);
        }
        if (node != this._bottomNode && node.getSubs().isEmpty()) {
            node.addSub(this._bottomNode);
        }
        return node;
    }

    @Override
    public void removeCycles(TaxonomyNode<T> node) {
        if (!this._nodes.get(node.getName()).equals(node)) {
            throw new InternalReasonerException("This _node does not exist in the taxonomy: " + node.getName());
        }
        this.removeCycles(node, new ArrayList<TaxonomyNode<T>>());
    }

    private boolean removeCycles(TaxonomyNode<T> node, List<TaxonomyNode<T>> path) {
        if (path.contains(node)) {
            this.mergeNodes(path);
            return true;
        }
        path.add(node);
        ArrayList<TaxonomyNode<T>> supers = new ArrayList<TaxonomyNode<T>>(node.getSupers());
        int i = 0;
        while (i < supers.size()) {
            TaxonomyNode sup = (TaxonomyNode)supers.get(i);
            this.removeCycles(sup, path);
            if (i >= supers.size() || !((TaxonomyNode)supers.get(i)).equals(sup)) continue;
            ++i;
        }
        path.remove(path.size() - 1);
        return false;
    }

    @Override
    public Object removeDatum(T t, TaxonomyUtils.TaxonomyKey key) {
        return this.getNode(t).removeDatum((Object)key);
    }

    private class SimpleImmutableEntry<K, V>
    implements Map.Entry<K, V> {
        private final K _key;
        private final V _value;

        public SimpleImmutableEntry(K key, V value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    private class DepthFirstDatumOnlyIterator<U>
    implements Iterator<Object> {
        private final Object _key;
        private final List<TaxonomyNode<U>> _pending;
        private final Set<TaxonomyNode<U>> _visited;

        public DepthFirstDatumOnlyIterator(TaxonomyImpl<U> t, U u, Object key) {
            this._key = key;
            this._visited = new HashSet<TaxonomyNode<U>>();
            this._pending = new ArrayList<TaxonomyNode<U>>();
            TaxonomyNode<U> node = t.getNode(u);
            if (node != null) {
                this._pending.add(node);
            }
        }

        @Override
        public boolean hasNext() {
            return !this._pending.isEmpty();
        }

        @Override
        public Object next() {
            if (this._pending.isEmpty()) {
                throw new NoSuchElementException();
            }
            TaxonomyNode<U> current = this._pending.remove(this._pending.size() - 1);
            this._visited.add(current);
            for (TaxonomyNode<U> sub : current.getSubs()) {
                if (this._visited.contains(sub)) continue;
                this._pending.add(sub);
            }
            return current.getDatum(this._key);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class DatumEquivalentsPairIterator<U>
    implements Iterator<Map.Entry<Set<U>, Object>> {
        private final Iterator<TaxonomyNode<U>> _i;
        private final Object _key;

        public DatumEquivalentsPairIterator(TaxonomyImpl<U> t, Object key) {
            this._key = key;
            this._i = t.getNodes().values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._i.hasNext();
        }

        @Override
        public Map.Entry<Set<U>, Object> next() {
            TaxonomyNode<U> current = this._i.next();
            return new SimpleImmutableEntry<Set<U>, Object>(Collections.unmodifiableSet(current.getEquivalents()), current.getDatum(this._key));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

