/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.taxonomy.printer;

import java.io.PrintWriter;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.taxonomy.TaxonomyUtils;
import openllet.core.taxonomy.printer.TreeTaxonomyPrinter;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.QNameProvider;

public class ClassTreePrinter
extends TreeTaxonomyPrinter<ATermAppl> {
    private final QNameProvider _qnames = new QNameProvider();

    @Override
    protected void printNode(Set<ATermAppl> set) {
        super.printNode(set);
        Set<ATermAppl> instances = TaxonomyUtils.getDirectInstances(this._taxonomyImpl, set.iterator().next());
        if (instances.size() > 0) {
            this._out.print(" - (");
            boolean printed = false;
            int anonCount = 0;
            for (ATermAppl x : instances) {
                if (ATermUtils.isBnode(x)) {
                    ++anonCount;
                    continue;
                }
                if (printed) {
                    this._out.print(", ");
                } else {
                    printed = true;
                }
                this.printURI(this._out, x);
            }
            if (anonCount > 0) {
                if (printed) {
                    this._out.print(", ");
                }
                this._out.print(anonCount + " Anonymous Individual");
                if (anonCount > 1) {
                    this._out.print("s");
                }
            }
            this._out.print(")");
        }
    }

    @Override
    protected void printURI(PrintWriter out, ATermAppl c) {
        String str2 = null;
        str2 = c.equals(ATermUtils.TOP) ? "owl:Thing" : (c.equals(ATermUtils.BOTTOM) ? "owl:Nothing" : (ATermUtils.isPrimitive(c) ? this._qnames.shortForm(c.getName()) : c.toString()));
        out.print(str2);
    }
}

