/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.taxonomy.printer;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.printer.TaxonomyPrinter;
import openllet.core.utils.Comparators;

public class TreeTaxonomyPrinter<T>
implements TaxonomyPrinter<T> {
    protected volatile Taxonomy<T> _taxonomyImpl;
    protected volatile PrintWriter _out;

    @Override
    public void print(Taxonomy<T> taxonomy) {
        this.print(taxonomy, new PrintWriter(System.out));
    }

    @Override
    public void print(Taxonomy<T> taxonomy, PrintWriter out) {
        this._taxonomyImpl = taxonomy;
        this._out = out;
        out.println();
        this.printTree();
        out.println();
        out.flush();
    }

    protected void printTree() {
        TreeSet<Object> top = new TreeSet<Object>(Comparators.stringComparator);
        top.add(this._taxonomyImpl.getTop().getName());
        top.addAll(this._taxonomyImpl.getTop().getEquivalents());
        this.printTree(top, " ");
        TreeSet<Object> bottom = new TreeSet<Object>(Comparators.stringComparator);
        bottom.add(this._taxonomyImpl.getBottomNode().getName());
        bottom.addAll(this._taxonomyImpl.getBottomNode().getEquivalents());
        if (bottom.size() > 1) {
            this.printNode(bottom, " ");
        }
    }

    protected void printTree(Set<T> set, String indent) {
        if (set.contains(this._taxonomyImpl.getBottomNode().getName())) {
            return;
        }
        this.printNode(set, indent);
        T c = set.iterator().next();
        Set<Set<T>> subs = this.ss(this._taxonomyImpl.getSubs(c, true));
        for (Set<T> eqs : subs) {
            if (eqs.contains(c)) continue;
            this.printTree(this.s(eqs), indent + "   ");
        }
    }

    protected void printNode(Set<T> set, String indent) {
        this._out.print(indent);
        this.printNode(set);
        this._out.println();
    }

    protected void printNode(Set<T> set) {
        Iterator<T> i = set.iterator();
        T c = i.next();
        this.printURI(this._out, c);
        while (i.hasNext()) {
            this._out.print(" = ");
            this.printURI(this._out, i.next());
        }
    }

    protected void printURI(PrintWriter out, T e2) {
        out.print(e2.toString());
    }

    private Set<Set<T>> ss(Set<Set<T>> subs) {
        TreeSet<Object> sorted = new TreeSet<Object>(Comparators.stringComparator);
        sorted.addAll(subs);
        return sorted;
    }

    private Set<T> s(Set<T> set) {
        TreeSet<Object> sorted = new TreeSet<Object>(Comparators.stringComparator);
        sorted.addAll(set);
        return sorted;
    }
}

