/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tracker;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.boxes.abox.ABoxImpl;
import openllet.core.boxes.abox.DefaultEdge;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.tracker.IncrementalChangeTracker;

public class SimpleIncrementalChangeTracker
implements IncrementalChangeTracker {
    private final HashSet<Edge> _deletedEdges;
    private final HashMap<Node, Set<ATermAppl>> _deletedTypes;
    private final HashSet<Edge> _newEdges;
    private final HashSet<Individual> _newIndividuals;
    private final HashSet<Node> _unprunedNodes;
    private final HashSet<Individual> _updatedIndividuals;

    public SimpleIncrementalChangeTracker() {
        this._deletedEdges = new HashSet();
        this._deletedTypes = new HashMap();
        this._newEdges = new HashSet();
        this._newIndividuals = new HashSet();
        this._unprunedNodes = new HashSet();
        this._updatedIndividuals = new HashSet();
    }

    private SimpleIncrementalChangeTracker(SimpleIncrementalChangeTracker src, ABoxImpl target) {
        Individual ti;
        Node o;
        Individual s;
        this._deletedEdges = new HashSet(src._deletedEdges.size());
        this._newEdges = new HashSet(src._newEdges.size());
        for (Edge edge : src._deletedEdges) {
            s = target.getIndividual(edge.getFrom().getName());
            if (s == null) {
                throw new NullPointerException();
            }
            o = target.getNode(edge.getTo().getName());
            if (o == null) {
                throw new NullPointerException();
            }
            this._newEdges.add(new DefaultEdge(edge.getRole(), s, o, edge.getDepends()));
        }
        this._deletedTypes = new HashMap(src._deletedTypes.size());
        for (Map.Entry entry : src._deletedTypes.entrySet()) {
            Node n = target.getNode(((Node)entry.getKey()).getName());
            if (n == null) {
                throw new NullPointerException();
            }
            this._deletedTypes.put(n, new HashSet((Collection)entry.getValue()));
        }
        for (Edge edge : src._newEdges) {
            s = target.getIndividual(edge.getFrom().getName());
            if (s == null) {
                throw new NullPointerException();
            }
            o = target.getNode(edge.getTo().getName());
            if (o == null) {
                throw new NullPointerException();
            }
            this._newEdges.add(new DefaultEdge(edge.getRole(), s, o, edge.getDepends()));
        }
        this._newIndividuals = new HashSet(src._newIndividuals.size());
        for (Individual individual : src._newIndividuals) {
            ti = target.getIndividual(individual.getName());
            if (ti == null) {
                throw new NullPointerException();
            }
            this._newIndividuals.add(ti);
        }
        this._unprunedNodes = new HashSet(src._unprunedNodes.size());
        for (Node node : src._unprunedNodes) {
            Node tn = target.getNode(node.getName());
            if (tn == null) {
                throw new NullPointerException();
            }
            this._unprunedNodes.add(tn);
        }
        this._updatedIndividuals = new HashSet(src._updatedIndividuals.size());
        for (Individual individual : src._updatedIndividuals) {
            ti = target.getIndividual(individual.getName());
            if (ti == null) {
                throw new NullPointerException();
            }
            this._updatedIndividuals.add(ti);
        }
    }

    @Override
    public boolean addDeletedEdge(Edge e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        return this._deletedEdges.add(e2);
    }

    @Override
    public boolean addDeletedType(Node n, ATermAppl type) {
        if (n == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        Set<ATermAppl> existing = this._deletedTypes.get(n);
        if (existing == null) {
            existing = new HashSet<ATermAppl>();
            this._deletedTypes.put(n, existing);
        }
        return existing.add(type);
    }

    @Override
    public boolean addNewEdge(Edge e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        return this._newEdges.add(e2);
    }

    @Override
    public boolean addNewIndividual(Individual i) {
        if (i == null) {
            throw new NullPointerException();
        }
        return this._newIndividuals.add(i);
    }

    @Override
    public boolean addUnprunedNode(Node n) {
        if (n == null) {
            throw new NullPointerException();
        }
        return this._unprunedNodes.add(n);
    }

    @Override
    public boolean addUpdatedIndividual(Individual i) {
        if (i == null) {
            throw new NullPointerException();
        }
        return this._updatedIndividuals.add(i);
    }

    @Override
    public void clear() {
        this._deletedEdges.clear();
        this._deletedTypes.clear();
        this._newEdges.clear();
        this._newIndividuals.clear();
        this._unprunedNodes.clear();
        this._updatedIndividuals.clear();
    }

    @Override
    public SimpleIncrementalChangeTracker copy(ABoxImpl target) {
        return new SimpleIncrementalChangeTracker(this, target);
    }

    @Override
    public Iterator<Edge> deletedEdges() {
        return Collections.unmodifiableSet(this._deletedEdges).iterator();
    }

    @Override
    public Iterator<Map.Entry<Node, Set<ATermAppl>>> deletedTypes() {
        return Collections.unmodifiableMap(this._deletedTypes).entrySet().iterator();
    }

    @Override
    public Iterator<Edge> newEdges() {
        return Collections.unmodifiableSet(this._newEdges).iterator();
    }

    @Override
    public Iterator<Individual> newIndividuals() {
        return Collections.unmodifiableSet(this._newIndividuals).iterator();
    }

    @Override
    public Iterator<Node> unprunedNodes() {
        return Collections.unmodifiableSet(this._unprunedNodes).iterator();
    }

    @Override
    public Iterator<Individual> updatedIndividuals() {
        return Collections.unmodifiableSet(this._updatedIndividuals).iterator();
    }
}

