/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.util.Iterator;
import java.util.Set;
import openllet.core.utils.Bool;
import openllet.core.utils.SetUtils;
import openllet.core.utils.iterator.PairIterator;

public class CandidateSet<T> {
    private final Set<T> _knowns = SetUtils.create();
    private final Set<T> _unknowns = SetUtils.create();

    public CandidateSet() {
    }

    public CandidateSet(Set<T> knowns) {
        this._knowns.addAll(knowns);
    }

    public CandidateSet(Set<T> knowns, Set<T> unknowns) {
        this._knowns.addAll(knowns);
        this._unknowns.addAll(unknowns);
    }

    public Set<T> getKnowns() {
        return this._knowns;
    }

    public Set<T> getUnknowns() {
        return this._unknowns;
    }

    public void add(T obj, Bool isKnown) {
        if (isKnown.isTrue()) {
            this._knowns.add(obj);
        } else if (isKnown.isUnknown()) {
            this._unknowns.add(obj);
        }
    }

    public void update(T obj, Bool isCandidate) {
        if (!isCandidate.isTrue()) {
            if (isCandidate.isFalse()) {
                this.remove(obj);
            } else if (this._knowns.contains(obj)) {
                this._knowns.remove(obj);
                this._unknowns.add(obj);
            }
        }
    }

    public boolean remove(Object obj) {
        return this._knowns.remove(obj) || this._unknowns.remove(obj);
    }

    public boolean contains(Object obj) {
        return this._knowns.contains(obj) || this._unknowns.contains(obj);
    }

    public int size() {
        return this._knowns.size() + this._unknowns.size();
    }

    public Iterator<T> iterator() {
        return new PairIterator<T>(this._knowns.iterator(), this._unknowns.iterator());
    }

    public String toString() {
        return "Knowns: " + this._knowns.size() + " Unknowns: " + this._unknowns.size();
    }
}

