/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import openllet.core.utils.IdentityHashSet;
import openllet.core.utils.SetUtils;

public class CollectionUtils {
    public static <K, V> Map<K, V> makeIdentityMap() {
        return new IdentityHashMap();
    }

    public static <K, V> Map<K, V> makeIdentityMap(int size) {
        return new IdentityHashMap(size);
    }

    public static <K, V> Map<K, V> makeIdentityMap(Map<? extends K, ? extends V> map) {
        return new IdentityHashMap<K, V>(map);
    }

    public static <T> Set<T> makeIdentitySet() {
        return new IdentityHashSet();
    }

    public static <T> Set<T> makeIdentitySet(int size) {
        return new IdentityHashSet(size);
    }

    public static <T> Set<T> makeIdentitySet(Collection<? extends T> a) {
        return new IdentityHashSet<T>(a);
    }

    public static <T> List<T> makeList() {
        return new ArrayList();
    }

    public static <T> List<T> makeList(int size) {
        return new ArrayList(size);
    }

    public static <T> List<T> makeList(Collection<? extends T> a) {
        return new ArrayList<T>(a);
    }

    public static <K, V> Map<K, V> makeMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> Map<K, V> makeMap(int size) {
        return new ConcurrentHashMap(size);
    }

    public static <K, V> Map<K, V> makeMap(Map<? extends K, ? extends V> map) {
        return new ConcurrentHashMap<K, V>(map);
    }

    @Deprecated
    public static <T> Set<T> makeSet() {
        return SetUtils.create();
    }

    @Deprecated
    public static <T> Set<T> makeSet(int size) {
        return SetUtils.create(size);
    }

    @Deprecated
    public static <T> Set<T> makeSet(Collection<? extends T> a) {
        return SetUtils.create(a);
    }
}

