/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.shared.tools.Log;

public class URIUtils {
    public static final Logger _logger = Log.getLogger(URIUtils.class);

    public static String getQName(String uri) {
        return URIUtils.getFilePart(uri) + ":" + URIUtils.getLocalName(uri);
    }

    public static String getFilePart(String uri) {
        try {
            URI u = URI.create(uri);
            String path = u.getPath();
            int begin = path.lastIndexOf("/");
            int end = path.lastIndexOf(".");
            if (end == -1 || begin > end) {
                end = path.length();
            }
            return path.substring(begin + 1, end);
        }
        catch (Exception e2) {
            _logger.log(Level.FINE, "", e2);
            return "http://invalid/uri/";
        }
    }

    public static String getLocalName(URI uri) {
        return URIUtils.getLocalName(uri.toString());
    }

    public static String getLocalName(String uri) {
        int index = URIUtils.splitPos(uri);
        if (index == -1) {
            return uri;
        }
        return uri.substring(index + 1);
    }

    public static String getNameSpace(URI uri) {
        return URIUtils.getNameSpace(uri.toString());
    }

    public static String getNameSpace(String uri) {
        int index = uri.indexOf("#");
        if (index == -1) {
            return uri;
        }
        return uri.substring(0, index);
    }

    private static int splitPos(String uri) {
        int pos = uri.indexOf("#");
        if (pos == -1) {
            pos = uri.lastIndexOf("/");
        }
        return pos;
    }
}

