/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils.fsm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import openllet.atom.OpenError;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.utils.Pair;
import openllet.core.utils.fsm.State;
import openllet.core.utils.fsm.Transition;

public class TransitionGraph<T> {
    private volatile State<T> _initialState = null;
    private final Set<State<T>> _allStates = new HashSet<State<T>>();
    private volatile Set<State<T>> _finalStates = new HashSet<State<T>>();
    private final Set<T> _alphabet = new HashSet<T>();

    public int size() {
        return this._allStates.size();
    }

    public State<T> newState() {
        State s = new State();
        this._allStates.add(s);
        return s;
    }

    public Set<T> getAlpahabet() {
        return Collections.unmodifiableSet(this._alphabet);
    }

    public Set<State<T>> getAllStates() {
        return Collections.unmodifiableSet(this._allStates);
    }

    public void setInitialState(State<T> s) {
        this._initialState = s;
    }

    public State<T> getInitialState() {
        return this._initialState;
    }

    public void addFinalState(State<T> s) {
        this._finalStates.add(s);
    }

    public Set<State<T>> getFinalStates() {
        return this._finalStates;
    }

    public State<T> getFinalState() {
        int size = this._finalStates.size();
        if (size == 0) {
            throw new OpenError("There are no final states!");
        }
        if (size > 1) {
            throw new OpenError("There is more than one final state!");
        }
        return this._finalStates.iterator().next();
    }

    public void addTransition(State<T> begin, T transition, State<T> end) {
        if (transition == null) {
            throw new NullPointerException();
        }
        begin.addTransition(transition, end);
        this._alphabet.add(transition);
    }

    public void addTransition(State<T> begin, State<T> end) {
        begin.addTransition(end);
    }

    public List<Pair<State<T>, State<T>>> findTransitions(T transition) {
        ArrayList<Pair<State<T>, State<T>>> result = new ArrayList<Pair<State<T>, State<T>>>();
        for (State<T> s1 : this._allStates) {
            State<T> s2 = s1.move(transition);
            if (s2 == null) continue;
            result.add(new Pair<State<T>, State<T>>(s1, s2));
        }
        return result;
    }

    public boolean isInitial(State<T> st) {
        return this._initialState.equals(st);
    }

    public boolean isFinal(State<T> st) {
        return this._finalStates.contains(st);
    }

    public boolean isAnyFinal(Set<State<T>> ss) {
        for (State<T> st : ss) {
            if (!this._finalStates.contains(st)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[Transition Graph\n");
        for (State<T> st : this._allStates) {
            buf.append(st.getName()).append(": ");
            Iterator<Transition<T>> i = st.getTransitions().iterator();
            while (i.hasNext()) {
                buf.append(i.next());
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
            buf.append("\n");
        }
        buf.append("initial state: ");
        buf.append(this._initialState.getName());
        buf.append("\n");
        buf.append("final states: ");
        buf.append(this._finalStates);
        buf.append("\n");
        buf.append("alphabet: ");
        buf.append(this._alphabet);
        buf.append("\n");
        buf.append("]\n");
        return buf.toString();
    }

    public TransitionGraph<T> renumber() {
        HashSet processed = new HashSet();
        LinkedList workList = new LinkedList();
        int val = 0;
        workList.addFirst(this._initialState);
        while (workList.size() > 0) {
            State s = (State)workList.removeFirst();
            s.setName(val++);
            processed.add(s);
            for (Transition e2 : s.getTransitions()) {
                if (!processed.add(e2.getTo())) continue;
                workList.addLast(e2.getTo());
            }
        }
        return this;
    }

    public TransitionGraph<T> insert(TransitionGraph<T> tg, State<T> i, State<T> f) {
        this._alphabet.addAll(tg._alphabet);
        HashMap<State<T>, State<T>> newStates = new HashMap<State<T>, State<T>>();
        newStates.put(tg.getInitialState(), i);
        for (State<T> fs : tg.getFinalStates()) {
            newStates.put(fs, f);
        }
        for (State<T> s1 : tg._allStates) {
            State<T> n1 = (State<T>)newStates.get(s1);
            if (n1 == null) {
                n1 = this.newState();
                newStates.put(s1, n1);
            }
            for (Transition<T> t : s1.getTransitions()) {
                State<T> s2 = t.getTo();
                State<T> n2 = (State<T>)newStates.get(s2);
                if (n2 == null) {
                    n2 = this.newState();
                    newStates.put(s2, n2);
                }
                if (t.isEpsilon()) {
                    n1.addTransition(n2);
                    continue;
                }
                n1.addTransition(t.getName(), n2);
            }
        }
        return this;
    }

    public Set<State<T>> move(Set<State<T>> stateSet, T c) {
        HashSet<State<T>> result = new HashSet<State<T>>();
        for (State<T> st : stateSet) {
            for (Transition<T> e2 : st.getTransitions()) {
                if (!e2.hasName(c)) continue;
                result.add(e2.getTo());
            }
        }
        return result;
    }

    public Set<State<T>> epsilonClosure(State<T> s, Set<State<T>> init) {
        Set<State<T>> result = init;
        result.add(s);
        for (Transition<T> e2 : s.getTransitions()) {
            if (!e2.isEpsilon() || result.contains(e2.getTo())) continue;
            result = this.epsilonClosure(e2.getTo(), result);
        }
        return result;
    }

    public Set<State<T>> epsilonClosure(Set<State<T>> stateSet) {
        Set<State<T>> result = new HashSet<State<T>>();
        for (State<T> s : stateSet) {
            result = this.epsilonClosure(s, result);
        }
        return result;
    }

    public boolean isDeterministic() {
        if (!this._allStates.contains(this._initialState)) {
            throw new InternalReasonerException();
        }
        for (State<T> s : this._allStates) {
            HashSet<T> seenSymbols = new HashSet<T>();
            for (Transition<T> t : s.getTransitions()) {
                T symbol = t.getName();
                if (!t.isEpsilon() && seenSymbols.add(symbol)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isConnected() {
        HashSet visited = new HashSet();
        Stack stack = new Stack();
        stack.push(this._initialState);
        visited.add(this._initialState);
        while (!stack.isEmpty()) {
            State state = (State)stack.pop();
            if (!this._allStates.contains(state)) {
                return false;
            }
            for (Transition t : state.getTransitions()) {
                if (!visited.add(t.getTo())) continue;
                stack.push(t.getTo());
            }
        }
        return visited.size() == this._allStates.size();
    }

    public TransitionGraph<T> determinize() {
        HashMap<Set, State> dStates = new HashMap<Set, State>();
        State s = new State();
        Set ss = this.epsilonClosure(this._initialState, new HashSet<State<T>>());
        this._initialState = s;
        HashSet<State> processList = new HashSet<State>();
        processList.add(s);
        dStates.put(ss, s);
        this._initialState = s;
        boolean moreToProcess = true;
        while (moreToProcess) {
            State u = null;
            Set<State<T>> U = null;
            moreToProcess = false;
            for (Map.Entry entry : dStates.entrySet()) {
                s = (State)entry.getValue();
                ss = (Set)entry.getKey();
                moreToProcess = processList.contains(s);
                if (!moreToProcess) continue;
                break;
            }
            if (!moreToProcess) continue;
            for (Map.Entry a : this._alphabet) {
                U = this.epsilonClosure(this.move(ss, a));
                if (U.size() == 0) continue;
                u = (State)dStates.get(U);
                if (u == null) {
                    u = new State();
                    processList.add(u);
                    dStates.put(U, u);
                } else if (u.equals(s)) {
                    u = s;
                }
                s.addTransition(a, u);
            }
            processList.remove(s);
            dStates.put(ss, s);
        }
        HashSet<State<T>> acceptingStates = new HashSet<State<T>>();
        this._allStates.clear();
        for (Map.Entry entry : dStates.entrySet()) {
            s = (State)entry.getValue();
            ss = (Set)entry.getKey();
            this._allStates.add(s);
            if (!this.isAnyFinal(ss)) continue;
            acceptingStates.add(s);
        }
        this._finalStates.clear();
        this._finalStates = acceptingStates;
        return this;
    }

    public void setPartition(Set<State<T>> stateSet, int num, Map<State<T>, Integer> partitions) {
        for (State<T> s : stateSet) {
            partitions.put(s, num);
        }
    }

    public TransitionGraph<T> minimize() {
        State t;
        ArrayList partitions = new ArrayList(this._allStates.size());
        HashMap<State<T>, Integer> partitionNumbers = new HashMap<State<T>, Integer>();
        HashMap<State, State> partitionRep = new HashMap<State, State>();
        HashSet<State<T>> firstPartition = new HashSet<State<T>>(this._finalStates);
        partitions.add(firstPartition);
        this.setPartition(firstPartition, 0, partitionNumbers);
        if (firstPartition.size() < this._allStates.size()) {
            HashSet<State<T>> secondPartition = new HashSet<State<T>>(this._allStates);
            secondPartition.removeAll(this._finalStates);
            partitions.add(secondPartition);
            this.setPartition(secondPartition, 1, partitionNumbers);
        }
        for (int p = 0; p < partitions.size(); ++p) {
            Iterator i = ((Set)partitions.get(p)).iterator();
            State s = (State)i.next();
            HashSet<State> newPartition = null;
            block1: while (i.hasNext()) {
                t = (State)i.next();
                for (T a : this._alphabet) {
                    if (this.isEquivalentState(s.move(a), t.move(a), partitionNumbers)) continue;
                    if (newPartition == null) {
                        newPartition = new HashSet<State>();
                        partitions.add(newPartition);
                    }
                    i.remove();
                    newPartition.add(t);
                    partitionNumbers.put(t, partitions.size() - 1);
                    continue block1;
                }
            }
            if (newPartition == null) continue;
            p = -1;
        }
        int startPartition = (Integer)partitionNumbers.get(this._initialState);
        for (int p = 0; p < partitions.size(); ++p) {
            Iterator i = ((Set)partitions.get(p)).iterator();
            State s = (State)i.next();
            partitionRep.put(s, s);
            if (p == startPartition) {
                this._initialState = s;
            }
            while (i.hasNext()) {
                t = (State)i.next();
                this._allStates.remove(t);
                this._finalStates.remove(t);
                partitionRep.put(t, s);
            }
        }
        for (State<T> t2 : this._allStates) {
            for (Transition<T> edge : t2.getTransitions()) {
                edge.setTo((State)partitionRep.get(edge.getTo()));
            }
        }
        return this;
    }

    protected boolean isEquivalentState(State<T> s1, State<T> s2, Map<State<T>, Integer> partitionNum) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return partitionNum.get(s1).equals(partitionNum.get(s2));
    }
}

