/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class FilterIterator<T>
implements Iterator<T> {
    private final Iterator<T> _iterator;
    private T _next;

    public FilterIterator(Iterator<T> iterator) {
        this._iterator = iterator;
    }

    private void findNext() {
        if (this._next != null) {
            return;
        }
        while (this._iterator.hasNext()) {
            this._next = this._iterator.next();
            if (this.filter(this._next)) continue;
            return;
        }
        this._next = null;
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this._next != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this._next;
        this._next = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public abstract boolean filter(T var1);
}

