/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MultiIterator<T>
implements Iterator<T> {
    private final List<Iterator<? extends T>> _list = new ArrayList<Iterator<? extends T>>(2);
    private volatile int _index = 0;
    private volatile Iterator<? extends T> _curr;

    public MultiIterator(Iterator<? extends T> first) {
        this._curr = first;
    }

    public MultiIterator(Iterator<? extends T> first, Iterator<? extends T> second) {
        this._curr = first;
        this._list.add(second);
    }

    @Override
    public boolean hasNext() {
        while (!this._curr.hasNext() && this._index < this._list.size()) {
            this._curr = this._list.get(this._index++);
        }
        return this._curr.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("multi iterator");
        }
        return this._curr.next();
    }

    public void append(Iterator<? extends T> other) {
        if (other.hasNext()) {
            if (other instanceof MultiIterator) {
                this._list.addAll(((MultiIterator)other)._list);
            } else {
                this._list.add(other);
            }
        }
    }

    @Override
    public void remove() {
        this._curr.remove();
    }
}

