/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.utils.progress;

import openllet.core.utils.Timer;
import openllet.core.utils.progress.ProgressMonitor;

public abstract class AbstractProgressMonitor
implements ProgressMonitor {
    protected String _progressTitle = "";
    protected String _progressMessage = "";
    protected int _progress = 0;
    protected int _progressLength = 0;
    protected int _progressPercent = -1;
    protected Timer _timer = new Timer();
    protected boolean _cancelled = false;

    public AbstractProgressMonitor() {
    }

    public AbstractProgressMonitor(int length) {
        this.setProgressLength(length);
    }

    @Override
    public int getProgress() {
        return this._progress;
    }

    public int getProgressLength() {
        return this._progressLength;
    }

    public String getProgressMessage() {
        return this._progressMessage;
    }

    @Override
    public int getProgressPercent() {
        return this._progressPercent;
    }

    public String getProgressTitle() {
        return this._progressTitle;
    }

    @Override
    public void incrementProgress() {
        this.setProgress(this._progress + 1);
    }

    @Override
    public boolean isCanceled() {
        return this._cancelled;
    }

    protected void resetProgress() {
        this._progress = 0;
        this._progressPercent = -1;
    }

    @Override
    public void setProgress(int progress) {
        this._progress = progress;
        this.updateProgress();
    }

    @Override
    public void setProgressLength(int progressLength) {
        this._progressLength = progressLength;
        this.resetProgress();
    }

    @Override
    public void setProgressMessage(String progressMessage) {
        this._progressMessage = progressMessage;
    }

    @Override
    public void setProgressTitle(String progressTitle) {
        this._progressTitle = progressTitle;
    }

    @Override
    public void taskFinished() {
        this._timer.stop();
    }

    @Override
    public void taskStarted() {
        this.resetProgress();
        this._timer.start();
    }

    protected abstract void updateProgress();
}

