/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.KnowledgeBase;
import openllet.core.el.RuleBasedELClassifier;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.MultiValueMap;
import openllet.core.utils.SetUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.Builtin;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.Functor;
import org.apache.jena.reasoner.rulesys.GenericRuleReasoner;
import org.apache.jena.reasoner.rulesys.Node_RuleVariable;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.builtins.NotEqual;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.util.iterator.ExtendedIterator;

public class JenaBasedELClassifier
extends RuleBasedELClassifier {
    private static final String PREDICATE_PREFIX = "tag:clarkparsia.com,2008:pellet:el:predicate:";
    private static final Node PRED_SUB = NodeFactory.createURI("tag:clarkparsia.com,2008:pellet:el:predicate:subclassOf");
    private static final Builtin NOT_EQUAL = new NotEqual();
    private final Node TOP;
    private final Node BOTTOM;
    private final NameStore _names;
    private final VariableStore _variables;
    private final Set<Rule> _rules = SetUtils.create();
    private final Graph _facts;

    public JenaBasedELClassifier(KnowledgeBase kb) {
        super(kb);
        this._names = new NameStore();
        this._variables = new VariableStore();
        this._facts = GraphFactory.createDefaultGraph();
        this.TOP = this._names.get(ATermUtils.TOP);
        this.BOTTOM = this._names.get(ATermUtils.BOTTOM);
        this.makeRuleAxioms();
    }

    protected void addClasses(Collection<ATermAppl> classes) {
        for (ATermAppl c : classes) {
            Node n = this._names.get(c);
            this._facts.add(Triple.create(n, PRED_SUB, n));
            this._facts.add(Triple.create(n, PRED_SUB, this.TOP));
        }
    }

    @Override
    protected MultiValueMap<ATermAppl, ATermAppl> run(Collection<ATermAppl> classes) {
        this.addClasses(classes);
        this.addClasses(this._names.getAllAnons());
        GenericRuleReasoner reasoner = new GenericRuleReasoner(new ArrayList<Rule>(this._rules));
        InfGraph inf = reasoner.bind(this._facts);
        inf.prepare();
        MultiValueMap<ATermAppl, ATermAppl> subsumers = this.getSubsumptions(inf);
        for (ATermAppl c : classes) {
            subsumers.add(ATermUtils.BOTTOM, c);
        }
        return subsumers;
    }

    protected MultiValueMap<ATermAppl, ATermAppl> getSubsumptions(Graph graph) {
        MultiValueMap<ATermAppl, ATermAppl> subsumers = new MultiValueMap<ATermAppl, ATermAppl>();
        ExtendedIterator<Triple> it = graph.find(Node.ANY, PRED_SUB, Node.ANY);
        while (it.hasNext()) {
            Triple tri = (Triple)it.next();
            Node sub = tri.getSubject();
            Node sup = tri.getObject();
            if (NameStore.isAnon(sub) || NameStore.isAnon(sup)) continue;
            subsumers.add(this.toATermAppl(sub), this.toATermAppl(sup));
        }
        it.close();
        return subsumers;
    }

    private ATermAppl toATermAppl(Node n) {
        if (this.TOP.hasURI(n.getURI())) {
            return ATermUtils.TOP;
        }
        if (this.BOTTOM.hasURI(n.getURI())) {
            return ATermUtils.BOTTOM;
        }
        return ATermUtils.makeTermAppl(n.getURI());
    }

    @Override
    protected void addSubclassRule(ATermAppl sub, ATermAppl sup) {
        this.addSubclassRule(sub, sup, new FreeVariableStore());
    }

    @Override
    protected void addRoleDomainRule(ATermAppl p, ATermAppl domain) {
        ArrayList<ClauseEntry> body = new ArrayList<ClauseEntry>();
        ArrayList<ClauseEntry> head = new ArrayList<ClauseEntry>();
        FreeVariableStore freeVar = new FreeVariableStore();
        Node var0 = freeVar.next();
        Node var1 = freeVar.next();
        body.add(this.makeSubOfSomeTriple(var0, p, var1));
        this.translateSuper(head, domain, freeVar, var0);
        this._rules.add(new Rule(head, body));
    }

    @Override
    protected void addRoleRangeRule(ATermAppl p, ATermAppl range) {
        ArrayList<ClauseEntry> body = new ArrayList<ClauseEntry>();
        ArrayList<ClauseEntry> head = new ArrayList<ClauseEntry>();
        FreeVariableStore freeVar = new FreeVariableStore();
        Node var0 = freeVar.next();
        Node var1 = freeVar.next();
        body.add(this.makeSubOfSomeTriple(var0, p, var1));
        ATermAppl someOfRange = ATermUtils.makeSomeValues(p, range);
        this.translateSuper(head, someOfRange, freeVar, var0);
        this._rules.add(new Rule(head, body));
    }

    @Override
    protected void addRoleChainRule(ATerm[] chain, ATermAppl sup) {
        if (chain.length < 1) {
            return;
        }
        ArrayList<ClauseEntry> body = new ArrayList<ClauseEntry>();
        FreeVariableStore freeVar = new FreeVariableStore();
        Node[] var = new Node[chain.length + 1];
        var[0] = freeVar.next();
        for (int i = 0; i < chain.length; ++i) {
            var[i + 1] = freeVar.next();
            body.add(this.makeSubOfSomeTriple(var[i], (ATermAppl)chain[i], var[i + 1]));
        }
        TriplePattern head = this.makeSubOfSomeTriple(var[0], sup, var[var.length - 1]);
        this._rules.add(new Rule(Collections.singletonList(head), body));
    }

    @Override
    protected void addRoleHierarchyRule(ATermAppl sub, ATermAppl sup) {
        this.addRoleChainRule(new ATerm[]{sub}, sup);
    }

    private void makeRuleAxioms() {
        this.makeBottomAxiom();
    }

    private void makeBottomAxiom() {
        FreeVariableStore freeVar = new FreeVariableStore();
        Node var0 = freeVar.next();
        Node var1 = freeVar.next();
        Node var2 = freeVar.next();
        ArrayList<ClauseEntry> body = new ArrayList<ClauseEntry>();
        body.add(JenaBasedELClassifier.makeSubOfSomeTriple(var0, var1, var2));
        body.add(JenaBasedELClassifier.makePropertyAssertionFunctor(var1));
        body.add(JenaBasedELClassifier.makeSubclassTriple(var2, this.BOTTOM));
        TriplePattern head = JenaBasedELClassifier.makeSubclassTriple(var0, this.BOTTOM);
        this._rules.add(new Rule(Collections.singletonList(head), body));
    }

    private void addSubclassRule(ATermAppl sub, ATermAppl sup, FreeVariableStore freeVar) {
        ArrayList<ClauseEntry> body = new ArrayList<ClauseEntry>();
        ArrayList<ClauseEntry> head = new ArrayList<ClauseEntry>();
        Node var = freeVar.next();
        this.translateSub(body, sub, freeVar, var);
        this.translateSuper(head, sup, freeVar, var);
        this._rules.add(new Rule(head, body));
    }

    private void translateSub(List<ClauseEntry> outBody, ATermAppl sub, FreeVariableStore freeVar, Node currentVar) {
        AFun fun = sub.getAFun();
        if (ATermUtils.isPrimitive(sub) || ATermUtils.isBottom(sub)) {
            outBody.add(JenaBasedELClassifier.makeSubclassTriple(currentVar, this._names.get(sub)));
        } else if (fun.equals(ATermUtils.ANDFUN)) {
            ATermList list = (ATermList)sub.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conj = (ATermAppl)list.getFirst();
                this.translateSub(outBody, conj, freeVar, currentVar);
                list = list.getNext();
            }
        } else if (fun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl prop = (ATermAppl)sub.getArgument(0);
            ATermAppl q = (ATermAppl)sub.getArgument(1);
            Node nextVar = freeVar.next();
            outBody.add(this.makeSubOfSomeTriple(currentVar, prop, nextVar));
            this.translateSub(outBody, q, freeVar, nextVar);
        } else assert (false);
    }

    private void translateSuper(List<ClauseEntry> outHead, ATermAppl sup, FreeVariableStore freeVar, Node currentVar) {
        AFun fun = sup.getAFun();
        if (ATermUtils.isPrimitive(sup) || ATermUtils.isBottom(sup)) {
            outHead.add(JenaBasedELClassifier.makeSubclassTriple(currentVar, this._names.get(sup)));
        } else if (fun.equals(ATermUtils.ANDFUN)) {
            ATermList list = (ATermList)sup.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conj = (ATermAppl)list.getFirst();
                this.translateSuper(outHead, conj, freeVar, currentVar);
                list = list.getNext();
            }
        } else if (fun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl prop = (ATermAppl)sup.getArgument(0);
            ATermAppl q = (ATermAppl)sup.getArgument(1);
            if (!ATermUtils.isPrimitive(q) && !ATermUtils.isBottom(q)) {
                ATermAppl anon = this._names.getNextAnon();
                this.translateSuperSome(anon, q);
                q = anon;
            }
            outHead.add(this.makeSubOfSomeTriple(currentVar, prop, this._names.get(q)));
        } else assert (false);
    }

    private void translateSuperSome(ATermAppl anon, ATermAppl sup) {
        AFun fun = sup.getAFun();
        if (ATermUtils.isPrimitive(sup) || ATermUtils.isBottom(sup)) {
            this._facts.add(this.makeSubclassFact(anon, sup));
        } else if (fun.equals(ATermUtils.ANDFUN)) {
            ATermList list = (ATermList)sup.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conj = (ATermAppl)list.getFirst();
                this.translateSuperSome(anon, conj);
                list = list.getNext();
            }
        } else if (fun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl prop = (ATermAppl)sup.getArgument(0);
            ATermAppl q = (ATermAppl)sup.getArgument(1);
            if (!ATermUtils.isPrimitive(q) && !ATermUtils.isBottom(q)) {
                ATermAppl nextAnon = this._names.getNextAnon();
                this.translateSuperSome(nextAnon, q);
                q = nextAnon;
            }
            this._facts.add(this.makeSubOfSomeFact(anon, prop, q));
        } else assert (false);
    }

    private Triple makeSubclassFact(ATermAppl t1, ATermAppl t2) {
        return JenaBasedELClassifier.makeSubclassFact(this._names.get(t1), this._names.get(t2));
    }

    private static Triple makeSubclassFact(Node t1, Node t2) {
        return Triple.create(t1, PRED_SUB, t2);
    }

    private Triple makeSubOfSomeFact(ATermAppl t1, ATermAppl t2, ATermAppl t3) {
        return Triple.create(this._names.get(t1), this._names.get(t2), this._names.get(t3));
    }

    private static TriplePattern makeSubclassTriple(Node t1, Node t2) {
        return new TriplePattern(t1, PRED_SUB, t2);
    }

    private TriplePattern makeSubOfSomeTriple(Node t1, ATermAppl p, Node t2) {
        return JenaBasedELClassifier.makeSubOfSomeTriple(t1, this._names.get(p), t2);
    }

    private static TriplePattern makeSubOfSomeTriple(Node t1, Node p, Node t2) {
        return new TriplePattern(t1, p, t2);
    }

    private static Functor makePropertyAssertionFunctor(Node p) {
        Functor f = new Functor("isNotSubClass", new Node[]{p, PRED_SUB});
        f.setImplementor(NOT_EQUAL);
        return f;
    }

    class FreeVariableStore {
        private int _next = 0;

        FreeVariableStore() {
        }

        public Node next() {
            return JenaBasedELClassifier.this._variables.get(this._next++);
        }
    }

    static class VariableStore {
        private static final String PREFIX = "x";
        private final List<Node> _variablesStore = new ArrayList<Node>();

        VariableStore() {
        }

        public Node get(int target) {
            for (int size = this._variablesStore.size(); size <= target; ++size) {
                this._variablesStore.add(new Node_RuleVariable(PREFIX + size, size));
            }
            return this._variablesStore.get(target);
        }
    }

    static class NameStore {
        private static final String ANON = "tag:clarkparsia.com,2008:pellet:el:anon:";
        private static final int FIRST_ANON = 0;
        private final Map<ATermAppl, Node> _constants = new HashMap<ATermAppl, Node>();
        private int _nextAnon = 0;

        NameStore() {
        }

        public Node get(ATermAppl term) {
            Node c = this._constants.get(term);
            if (c == null) {
                c = term == ATermUtils.BOTTOM ? NodeFactory.createURI("_BOTTOM_") : NodeFactory.createURI(term.getName());
                this._constants.put(term, c);
            }
            return c;
        }

        public ATermAppl getNextAnon() {
            return NameStore.makeAnon(this._nextAnon++);
        }

        public Set<ATermAppl> getAllAnons() {
            HashSet<ATermAppl> anons = new HashSet<ATermAppl>();
            for (int i = 0; i < this._nextAnon; ++i) {
                anons.add(NameStore.makeAnon(i));
            }
            return anons;
        }

        public static boolean isAnon(Node c) {
            return c.getURI().startsWith(ANON);
        }

        private static ATermAppl makeAnon(int id) {
            return ATermUtils.makeTermAppl(ANON + id);
        }
    }
}

