/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatypes;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.QNameProvider;
import openllet.jena.PelletReasoner;
import openllet.jena.vocabulary.OWL2;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.OWL;

public class JenaUtils {
    public static final Literal XSD_BOOLEAN_TRUE = ResourceFactory.createTypedLiteral(Boolean.TRUE.toString(), XSDDatatype.XSDboolean);
    public static Predicate<ATermAppl> _isGrapheNode = aTermAppl -> aTermAppl.getArity() == 0 || ATermUtils.isLiteral(aTermAppl) || ATermUtils.isBnode(aTermAppl) || aTermAppl.equals(ATermUtils.TOP) || aTermAppl.equals(ATermUtils.BOTTOM) || aTermAppl.equals(ATermUtils.TOP_DATA_PROPERTY) || aTermAppl.equals(ATermUtils.BOTTOM_DATA_PROPERTY) || aTermAppl.equals(ATermUtils.TOP_OBJECT_PROPERTY) || aTermAppl.equals(ATermUtils.BOTTOM_OBJECT_PROPERTY);

    public static ATermAppl makeLiteral(LiteralLabel jenaLiteral) {
        String lexicalValue = jenaLiteral.getLexicalForm();
        String datatypeURI = jenaLiteral.getDatatypeURI();
        ATermAppl literalValue = null;
        literalValue = datatypeURI != null ? ATermUtils.makeTypedLiteral(lexicalValue, datatypeURI) : (jenaLiteral.language() != null ? ATermUtils.makePlainLiteral(lexicalValue, jenaLiteral.language()) : ATermUtils.makePlainLiteral(lexicalValue));
        return literalValue;
    }

    public static ATermAppl makeATerm(RDFNode node) {
        return JenaUtils.makeATerm(node.asNode());
    }

    public static ATermAppl makeATerm(Node node) {
        if (node.isLiteral()) {
            return JenaUtils.makeLiteral(node.getLiteral());
        }
        if (node.isBlank()) {
            return ATermUtils.makeBnode(node.getBlankNodeLabel());
        }
        if (node.isURI()) {
            if (node.equals(OWL.Thing.asNode())) {
                return ATermUtils.TOP;
            }
            if (node.equals(OWL.Nothing.asNode())) {
                return ATermUtils.BOTTOM;
            }
            if (node.equals(OWL2.topDataProperty.asNode())) {
                return ATermUtils.TOP_DATA_PROPERTY;
            }
            if (node.equals(OWL2.bottomDataProperty.asNode())) {
                return ATermUtils.BOTTOM_DATA_PROPERTY;
            }
            if (node.equals(OWL2.topObjectProperty.asNode())) {
                return ATermUtils.TOP_OBJECT_PROPERTY;
            }
            if (node.equals(OWL2.bottomObjectProperty.asNode())) {
                return ATermUtils.BOTTOM_OBJECT_PROPERTY;
            }
            return ATermUtils.makeTermAppl(node.getURI());
        }
        if (node.isVariable()) {
            return ATermUtils.makeVar(node.getName());
        }
        return null;
    }

    public static Node makeGraphLiteral(ATermAppl literal) {
        Node node;
        String lexicalValue = ((ATermAppl)literal.getArgument(0)).getName();
        ATermAppl lang = (ATermAppl)literal.getArgument(1);
        ATermAppl datatype = (ATermAppl)literal.getArgument(2);
        if (datatype.equals(ATermUtils.PLAIN_LITERAL_DATATYPE)) {
            node = lang.equals(ATermUtils.EMPTY) ? NodeFactory.createLiteral(lexicalValue) : NodeFactory.createLiteral(lexicalValue, lang.getName(), false);
        } else if (datatype.equals(Datatypes.XML_LITERAL)) {
            node = NodeFactory.createLiteral(lexicalValue, "", true);
        } else {
            RDFDatatype type = TypeMapper.getInstance().getTypeByName(datatype.getName());
            node = NodeFactory.createLiteral(lexicalValue, "", type);
        }
        return node;
    }

    public static Node makeGraphResource(ATermAppl term) {
        if (ATermUtils.isBnode(term)) {
            return NodeFactory.createBlankNode(new BlankNodeId(((ATermAppl)term.getArgument(0)).getName()));
        }
        if (term.equals(ATermUtils.TOP)) {
            return OWL.Thing.asNode();
        }
        if (term.equals(ATermUtils.BOTTOM)) {
            return OWL.Nothing.asNode();
        }
        if (term.equals(ATermUtils.TOP_DATA_PROPERTY)) {
            return OWL2.topDataProperty.asNode();
        }
        if (term.equals(ATermUtils.BOTTOM_DATA_PROPERTY)) {
            return OWL2.bottomDataProperty.asNode();
        }
        if (term.equals(ATermUtils.TOP_OBJECT_PROPERTY)) {
            return OWL2.topObjectProperty.asNode();
        }
        if (term.equals(ATermUtils.BOTTOM_OBJECT_PROPERTY)) {
            return OWL2.bottomObjectProperty.asNode();
        }
        if (term.getArity() == 0) {
            return NodeFactory.createURI(term.getName());
        }
        PelletReasoner._logger.warning("Term " + term + " can't be convert into Node");
        return null;
    }

    public static Optional<Node> makeGraphNode(ATermAppl value) {
        return Optional.ofNullable(ATermUtils.isLiteral(value) ? JenaUtils.makeGraphLiteral(value) : JenaUtils.makeGraphResource(value));
    }

    public static Literal makeLiteral(ATermAppl literal, Model model) {
        return (Literal)model.asRDFNode(JenaUtils.makeGraphLiteral(literal));
    }

    public static Optional<Resource> makeResource(ATermAppl term, Model model) {
        return Optional.ofNullable(JenaUtils.makeGraphResource(term)).map(model::asRDFNode).map(Resource.class::cast);
    }

    public static Optional<RDFNode> makeRDFNode(ATermAppl term, Model model) {
        return JenaUtils.makeGraphNode(term).map(model::asRDFNode);
    }

    public static QNameProvider makeQNameProvider(PrefixMapping mapping) {
        QNameProvider qnames = new QNameProvider();
        for (Map.Entry<String, String> entry : mapping.getNsPrefixMap().entrySet()) {
            String prefix = entry.getKey();
            String uri = entry.getValue();
            qnames.setMapping(prefix, uri);
        }
        return qnames;
    }
}

