/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.boxes.rbox.Role;
import openllet.core.utils.iterator.IteratorUtils;
import openllet.jena.JenaUtils;
import openllet.jena.PelletInfGraph;
import openllet.jena.vocabulary.OWL2;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class ModelExtractor {
    public static final Predicate<Triple> FILTER_NONE = t -> false;
    private KnowledgeBase _kb;
    private Predicate<Triple> _filter = FILTER_NONE;
    private EnumSet<StatementType> _selector = StatementType.DEFAULT_STATEMENTS;

    public ModelExtractor() {
    }

    public ModelExtractor(Model model) throws ClassCastException {
        this((PelletInfGraph)model.getGraph());
    }

    public ModelExtractor(PelletInfGraph graph) {
        this(graph.getPreparedKB());
    }

    public ModelExtractor(KnowledgeBase kb) {
        this.setKB(kb);
    }

    private void addTriple(List<Triple> triples, Node s, Node p, Node o) {
        Triple triple = Triple.create(s, p, o);
        if (!this._filter.test(triple)) {
            triples.add(triple);
        }
    }

    public Model extractClassModel() {
        return this.extractClassModel(ModelFactory.createDefaultModel());
    }

    public Model extractClassModel(Model model) {
        boolean allSubs = this._selector.contains((Object)StatementType.ALL_SUBCLASS);
        boolean jenaDirectSubs = this._selector.contains((Object)StatementType.JENA_DIRECT_SUBCLASS);
        boolean subs = allSubs || jenaDirectSubs || this._selector.contains((Object)StatementType.DIRECT_SUBCLASS);
        boolean equivs = this._selector.contains((Object)StatementType.EQUIVALENT_CLASS);
        boolean disjs = this._selector.contains((Object)StatementType.DISJOINT_CLASS);
        boolean comps = this._selector.contains((Object)StatementType.COMPLEMENT_CLASS);
        if (subs || equivs || disjs || comps) {
            this._kb.classify();
        }
        ArrayList<Triple> triples = new ArrayList<Triple>();
        Set<ATermAppl> classes = this._kb.getAllClasses();
        for (ATermAppl c : classes) {
            Set<ATermAppl> comp;
            Node pX;
            Set<Set<ATermAppl>> disj;
            triples.clear();
            Optional<Node> sOpt = JenaUtils.makeGraphNode(c);
            if (!sOpt.isPresent()) continue;
            Node s = sOpt.get();
            this.addTriple(triples, s, RDF.type.asNode(), OWL.Class.asNode());
            Node p = RDFS.subClassOf.asNode();
            if (subs) {
                if (allSubs) {
                    Set<ATermAppl> eqs = this._kb.getAllEquivalentClasses(c);
                    for (ATermAppl eq : eqs) {
                        JenaUtils.makeGraphNode(eq).ifPresent(o -> this.addTriple((List<Triple>)triples, s, p, (Node)o));
                    }
                }
                Set<Set<ATermAppl>> supers = allSubs ? this._kb.getSuperClasses(c, false) : this._kb.getSuperClasses(c, true);
                Iterator<ATermAppl> i = IteratorUtils.flatten(supers.iterator());
                while (i.hasNext()) {
                    JenaUtils.makeGraphNode(i.next()).ifPresent(o -> this.addTriple((List<Triple>)triples, s, p, (Node)o));
                }
                if (jenaDirectSubs) {
                    Node pX2 = ReasonerVocabulary.directSubClassOf.asNode();
                    Set<Set<ATermAppl>> direct = allSubs ? this._kb.getSuperClasses(c, true) : supers;
                    i = IteratorUtils.flatten(direct.iterator());
                    while (i.hasNext()) {
                        JenaUtils.makeGraphNode(i.next()).ifPresent(o -> this.addTriple((List<Triple>)triples, s, pX2, (Node)o));
                    }
                }
            }
            if (equivs) {
                Node pX3 = OWL.equivalentClass.asNode();
                Set<ATermAppl> eqs = this._kb.getAllEquivalentClasses(c);
                for (ATermAppl a : eqs) {
                    JenaUtils.makeGraphNode(a).ifPresent(o -> this.addTriple((List<Triple>)triples, s, pX3, (Node)o));
                }
            }
            if (disjs && !(disj = this._kb.getDisjointClasses(c)).isEmpty()) {
                pX = OWL.disjointWith.asNode();
                Iterator<ATermAppl> i = IteratorUtils.flatten(disj.iterator());
                while (i.hasNext()) {
                    ATermAppl a;
                    a = i.next();
                    if (!classes.contains(a)) continue;
                    JenaUtils.makeGraphNode(a).ifPresent(o -> this.addTriple((List<Triple>)triples, s, pX, (Node)o));
                }
            }
            if (comps && !(comp = this._kb.getComplements(c)).isEmpty()) {
                pX = OWL.complementOf.asNode();
                for (ATermAppl a : comp) {
                    if (!classes.contains(a)) continue;
                    JenaUtils.makeGraphNode(a).ifPresent(o -> this.addTriple((List<Triple>)triples, s, pX, (Node)o));
                }
            }
            for (Triple t : triples) {
                model.getGraph().add(t);
            }
        }
        return model;
    }

    public Model extractIndividualModel() {
        return this.extractIndividualModel(ModelFactory.createDefaultModel());
    }

    public Model extractIndividualModel(Model model) {
        boolean allClasses = this._selector.contains((Object)StatementType.ALL_INSTANCE);
        boolean jenaDirectClasses = this._selector.contains((Object)StatementType.JENA_DIRECT_INSTANCE);
        boolean classes = allClasses || jenaDirectClasses || this._selector.contains((Object)StatementType.DIRECT_INSTANCE);
        boolean sames = this._selector.contains((Object)StatementType.SAME_AS);
        boolean diffs = this._selector.contains((Object)StatementType.DIFFERENT_FROM);
        boolean objValues = this._selector.contains((Object)StatementType.OBJECT_PROPERTY_VALUE);
        boolean dataValues = this._selector.contains((Object)StatementType.DATA_PROPERTY_VALUE);
        if (classes) {
            this._kb.realize();
        }
        ArrayList triples = new ArrayList();
        for (ATermAppl ind : this._kb.getIndividuals()) {
            triples.clear();
            JenaUtils.makeGraphNode(ind).ifPresent(s -> {
                Node pX;
                if (classes) {
                    Set<Set<ATermAppl>> types = this._kb.getTypes(ind, !allClasses);
                    Iterator<ATermAppl> i = IteratorUtils.flatten(types.iterator());
                    Node pX2 = RDF.type.asNode();
                    while (i.hasNext()) {
                        JenaUtils.makeGraphNode(i.next()).ifPresent(o -> this.addTriple(triples, (Node)s, pX2, (Node)o));
                    }
                    if (jenaDirectClasses) {
                        pX2 = ReasonerVocabulary.directRDFType.asNode();
                        Set<Set<ATermAppl>> directTypes = allClasses ? this._kb.getTypes(ind, true) : types;
                        i = IteratorUtils.flatten(directTypes.iterator());
                        while (i.hasNext()) {
                            JenaUtils.makeGraphNode(i.next()).ifPresent(o -> this.addTriple(triples, (Node)s, pX2, (Node)o));
                        }
                    }
                }
                if (sames) {
                    pX = OWL.sameAs.asNode();
                    this.addTriple(triples, (Node)s, pX, (Node)s);
                    for (ATermAppl a : this._kb.getSames(ind)) {
                        JenaUtils.makeGraphNode(a).ifPresent(node -> this.addTriple(triples, (Node)s, pX, (Node)node));
                    }
                }
                if (diffs) {
                    pX = OWL.differentFrom.asNode();
                    for (ATermAppl a : this._kb.getDifferents(ind)) {
                        JenaUtils.makeGraphNode(a).ifPresent(node -> this.addTriple(triples, (Node)s, pX, (Node)node));
                    }
                }
                if (dataValues || objValues) {
                    for (Role role : this._kb.getRBox().getRoles().values()) {
                        List<ATermAppl> values;
                        if (role.isAnon()) continue;
                        ATermAppl name = role.getName();
                        if (role.isDatatypeRole()) {
                            if (!dataValues) continue;
                            values = this._kb.getDataPropertyValues(name, ind);
                        } else {
                            if (!role.isObjectRole() || !objValues) continue;
                            values = this._kb.getObjectPropertyValues(name, ind);
                        }
                        if (values.isEmpty()) continue;
                        JenaUtils.makeGraphNode(name).ifPresent(p -> {
                            for (ATermAppl value : values) {
                                JenaUtils.makeGraphNode(value).ifPresent(node -> this.addTriple(triples, (Node)s, (Node)p, (Node)node));
                            }
                        });
                    }
                }
                for (Triple t : triples) {
                    model.getGraph().add(t);
                }
            });
        }
        return model;
    }

    public Model extractModel() {
        return this.extractModel(ModelFactory.createDefaultModel());
    }

    public Model extractModel(Model model) {
        this.extractClassModel(model);
        this.extractPropertyModel(model);
        this.extractIndividualModel(model);
        return model;
    }

    public Model extractPropertyModel() {
        return this.extractPropertyModel(ModelFactory.createDefaultModel());
    }

    public Model extractPropertyModel(Model model) {
        boolean allSubs = this._selector.contains((Object)StatementType.ALL_SUBPROPERTY);
        boolean jenaDirectSubs = this._selector.contains((Object)StatementType.JENA_DIRECT_SUBPROPERTY);
        boolean subs = allSubs || jenaDirectSubs || this._selector.contains((Object)StatementType.DIRECT_SUBPROPERTY);
        boolean equivs = this._selector.contains((Object)StatementType.EQUIVALENT_PROPERTY);
        boolean invs = this._selector.contains((Object)StatementType.INVERSE_PROPERTY);
        boolean disjs = this._selector.contains((Object)StatementType.DISJOINT_PROPERTY);
        this._kb.prepare();
        ArrayList<Triple> triples = new ArrayList<Triple>();
        for (Role role : this._kb.getRBox().getRoles().values()) {
            Set<Set<ATermAppl>> disjoints;
            Node pX;
            Set<ATermAppl> inverses;
            ATermAppl name;
            Node s;
            triples.clear();
            if (role.isAnon() || null == (s = (Node)JenaUtils.makeGraphNode(name = role.getName()).orElse(null))) continue;
            Node pX2 = RDF.type.asNode();
            if (role.isDatatypeRole()) {
                this.addTriple(triples, s, pX2, OWL.DatatypeProperty.asNode());
            } else {
                if (!role.isObjectRole()) continue;
                this.addTriple(triples, s, pX2, OWL.ObjectProperty.asNode());
            }
            if (role.isFunctional()) {
                this.addTriple(triples, s, pX2, OWL.FunctionalProperty.asNode());
            }
            if (role.isInverseFunctional()) {
                this.addTriple(triples, s, pX2, OWL.InverseFunctionalProperty.asNode());
            }
            if (role.isTransitive()) {
                this.addTriple(triples, s, pX2, OWL.TransitiveProperty.asNode());
            }
            if (role.isSymmetric()) {
                this.addTriple(triples, s, pX2, OWL.SymmetricProperty.asNode());
            }
            if (equivs) {
                Node pX3 = OWL.equivalentProperty.asNode();
                for (ATermAppl aTermAppl : this._kb.getAllEquivalentProperties(name)) {
                    if (!JenaUtils._isGrapheNode.test(aTermAppl)) continue;
                    JenaUtils.makeGraphNode(aTermAppl).ifPresent(node -> {
                        this.addTriple((List<Triple>)triples, s, pX2, (Node)node);
                        if (allSubs) {
                            this.addTriple((List<Triple>)triples, s, RDFS.subPropertyOf.asNode(), (Node)node);
                        }
                    });
                }
            }
            if (invs && !(inverses = this._kb.getInverses(name)).isEmpty()) {
                pX = OWL.inverseOf.asNode();
                for (ATermAppl inverse : inverses) {
                    if (!JenaUtils._isGrapheNode.test(inverse)) continue;
                    JenaUtils.makeGraphNode(inverse).ifPresent(node -> this.addTriple((List<Triple>)triples, s, pX, (Node)node));
                }
            }
            if (disjs && !(disjoints = this._kb.getDisjointProperties(name)).isEmpty()) {
                pX = OWL2.propertyDisjointWith.asNode();
                Iterator<ATermAppl> iterator = IteratorUtils.flatten(disjoints.iterator());
                while (iterator.hasNext()) {
                    JenaUtils.makeGraphNode(iterator.next()).ifPresent(o -> this.addTriple((List<Triple>)triples, s, pX, (Node)o));
                }
            }
            if (subs) {
                Set<Set<ATermAppl>> supers;
                Node pN = RDFS.subPropertyOf.asNode();
                if (allSubs) {
                    Set<ATermAppl> eqs = this._kb.getAllEquivalentProperties(name);
                    for (ATermAppl eq : eqs) {
                        if (!JenaUtils._isGrapheNode.test(eq)) continue;
                        JenaUtils.makeGraphNode(eq).ifPresent(o -> this.addTriple((List<Triple>)triples, s, pN, (Node)o));
                    }
                }
                if (!(supers = this._kb.getSuperProperties(name, !allSubs)).isEmpty()) {
                    Iterator<ATermAppl> iterator = IteratorUtils.flatten(supers.iterator());
                    while (iterator.hasNext()) {
                        JenaUtils.makeGraphNode(iterator.next()).ifPresent(node -> this.addTriple((List<Triple>)triples, s, pN, (Node)node));
                    }
                    if (jenaDirectSubs) {
                        Node pX3 = ReasonerVocabulary.directSubPropertyOf.asNode();
                        Set<Set<ATermAppl>> direct = allSubs ? this._kb.getSuperProperties(name, true) : supers;
                        Iterator<ATermAppl> iterator2 = IteratorUtils.flatten(direct.iterator());
                        while (iterator2.hasNext()) {
                            JenaUtils.makeGraphNode(iterator2.next()).ifPresent(node -> this.addTriple((List<Triple>)triples, s, pX3, (Node)node));
                        }
                    }
                }
            }
            for (Triple t : triples) {
                model.getGraph().add(t);
            }
        }
        return model;
    }

    public EnumSet<StatementType> getSelector() {
        return this._selector;
    }

    public void setSelector(EnumSet<StatementType> selector) {
        this._selector = selector;
    }

    public KnowledgeBase getKB() {
        return this._kb;
    }

    public void setKB(KnowledgeBase kb) {
        this._kb = kb;
    }

    public Predicate<Triple> getFilter() {
        return this._filter;
    }

    public void setFilter(Predicate<Triple> filter) {
        if (filter == null) {
            throw new NullPointerException("Filter cannot be null");
        }
        this._filter = filter;
    }

    public static enum StatementType {
        ALL_INSTANCE,
        ALL_SUBCLASS,
        ALL_SUBPROPERTY,
        COMPLEMENT_CLASS,
        DATA_PROPERTY_VALUE,
        DIFFERENT_FROM,
        DIRECT_INSTANCE,
        DIRECT_SUBCLASS,
        DIRECT_SUBPROPERTY,
        DISJOINT_CLASS,
        DISJOINT_PROPERTY,
        EQUIVALENT_CLASS,
        EQUIVALENT_PROPERTY,
        INVERSE_PROPERTY,
        JENA_DIRECT_INSTANCE,
        JENA_DIRECT_SUBCLASS,
        JENA_DIRECT_SUBPROPERTY,
        OBJECT_PROPERTY_VALUE,
        SAME_AS;

        public static final EnumSet<StatementType> ALL_CLASS_STATEMENTS;
        public static final EnumSet<StatementType> ALL_INDIVIDUAL_STATEMENTS;
        public static final EnumSet<StatementType> ALL_PROPERTY_STATEMENTS;
        public static final EnumSet<StatementType> ALL_STATEMENTS;
        public static final EnumSet<StatementType> ALL_STATEMENTS_INCLUDING_JENA;
        public static final EnumSet<StatementType> PROPERTY_VALUE;
        public static final EnumSet<StatementType> DEFAULT_STATEMENTS;

        static {
            ALL_CLASS_STATEMENTS = EnumSet.of(ALL_SUBCLASS, COMPLEMENT_CLASS, DIRECT_SUBCLASS, DISJOINT_CLASS, EQUIVALENT_CLASS);
            ALL_INDIVIDUAL_STATEMENTS = EnumSet.of(ALL_INSTANCE, new StatementType[]{DATA_PROPERTY_VALUE, DIFFERENT_FROM, DIRECT_INSTANCE, OBJECT_PROPERTY_VALUE, SAME_AS});
            ALL_PROPERTY_STATEMENTS = EnumSet.of(ALL_SUBPROPERTY, DIRECT_SUBPROPERTY, EQUIVALENT_PROPERTY, INVERSE_PROPERTY, DISJOINT_PROPERTY);
            ALL_STATEMENTS = EnumSet.complementOf(EnumSet.of(JENA_DIRECT_INSTANCE, JENA_DIRECT_SUBCLASS, JENA_DIRECT_SUBPROPERTY));
            ALL_STATEMENTS_INCLUDING_JENA = EnumSet.allOf(StatementType.class);
            DEFAULT_STATEMENTS = EnumSet.of(DIRECT_SUBCLASS, new StatementType[]{EQUIVALENT_CLASS, DIRECT_INSTANCE, OBJECT_PROPERTY_VALUE, DATA_PROPERTY_VALUE, DIRECT_SUBPROPERTY, EQUIVALENT_PROPERTY, INVERSE_PROPERTY});
            PROPERTY_VALUE = EnumSet.of(DATA_PROPERTY_VALUE, OBJECT_PROPERTY_VALUE);
        }
    }
}

