/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.output.ATermManchesterSyntaxRenderer;
import openllet.core.output.ATermRenderer;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.QNameProvider;
import openllet.jena.JenaUtils;
import openllet.jena.vocabulary.OWL2;
import openllet.shared.tools.Log;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;

public class NodeFormatter {
    protected static Logger _logger = Log.getLogger(NodeFormatter.class);
    private final QNameProvider _qnames;
    private final StringWriter _sw;
    private final ATermRenderer _renderer;
    private final PrintWriter _formatter;
    private final Model _rawModel;
    private static final Resource NULL = null;

    public NodeFormatter(Model model) {
        if (model == null) {
            throw new NullPointerException("No model given!");
        }
        this._renderer = new ATermManchesterSyntaxRenderer();
        this._sw = new StringWriter();
        this._formatter = new PrintWriter(this._sw);
        this._renderer.setWriter(this._formatter);
        this._qnames = JenaUtils.makeQNameProvider(model);
        if (model instanceof InfModel) {
            InfGraph graph = (InfGraph)model.getGraph();
            this._rawModel = ModelFactory.createModelForGraph(graph.getRawGraph());
        } else {
            this._rawModel = model;
        }
    }

    public QNameProvider getQNames() {
        return this._qnames;
    }

    public String format(RDFNode node) {
        if (node == null) {
            return "<<null>>";
        }
        this._sw.getBuffer().setLength(0);
        ATerm term = this.node2term(node);
        if (term instanceof ATermAppl) {
            this._renderer.visit((ATermAppl)term);
        } else {
            this._sw.write("{");
            this._renderer.visitList((ATermList)term);
            this._sw.write("}");
        }
        return this._sw.toString();
    }

    public ATerm node2term(RDFNode node) {
        ATerm aTerm = null;
        if (node.equals(OWL.Thing)) {
            return ATermUtils.TOP;
        }
        if (node.equals(OWL.Nothing)) {
            return ATermUtils.BOTTOM;
        }
        if (node.equals(OWL2.topDataProperty)) {
            return ATermUtils.TOP_DATA_PROPERTY;
        }
        if (node.equals(OWL2.bottomDataProperty)) {
            return ATermUtils.BOTTOM_DATA_PROPERTY;
        }
        if (node.equals(OWL2.topObjectProperty)) {
            return ATermUtils.TOP_OBJECT_PROPERTY;
        }
        if (node.equals(OWL2.bottomObjectProperty)) {
            return ATermUtils.BOTTOM_OBJECT_PROPERTY;
        }
        if (node instanceof Literal) {
            Literal l = (Literal)node;
            String datatypeURI = l.getDatatypeURI();
            aTerm = datatypeURI != null ? ATermUtils.makeTypedLiteral(l.getString(), datatypeURI) : ATermUtils.makePlainLiteral(l.getString(), l.getLanguage());
        } else if (node instanceof Resource) {
            Resource r = (Resource)node;
            if (this._rawModel.contains(r, OWL.onProperty, NULL)) {
                aTerm = this.createRestriction(r);
            } else if (r.isAnon()) {
                if (this._rawModel.contains(r, RDF.first, NULL)) {
                    aTerm = this.createList(r);
                } else if (this._rawModel.contains(r, OWL.intersectionOf)) {
                    ATermList list = this.createList(this._rawModel.getProperty(r, OWL.intersectionOf).getResource());
                    aTerm = ATermUtils.makeAnd(list);
                } else if (this._rawModel.contains(r, OWL.unionOf)) {
                    ATermList list = this.createList(this._rawModel.getProperty(r, OWL.unionOf).getResource());
                    aTerm = ATermUtils.makeOr(list);
                } else if (this._rawModel.contains(r, OWL.oneOf)) {
                    ATermList list = this.createList(this._rawModel.getProperty(r, OWL.oneOf).getResource());
                    ATermList result = ATermUtils.EMPTY_LIST;
                    ATermList l = list;
                    while (!l.isEmpty()) {
                        ATermAppl c = (ATermAppl)l.getFirst();
                        ATermAppl nominal = ATermUtils.makeValue(c);
                        result = result.insert(nominal);
                        l = l.getNext();
                    }
                    aTerm = ATermUtils.makeOr(result);
                } else if (this._rawModel.contains(r, OWL.complementOf)) {
                    ATerm complement = this.node2term(this._rawModel.getProperty(r, OWL.complementOf).getResource());
                    aTerm = ATermUtils.makeNot(complement);
                } else {
                    aTerm = ATermUtils.makeBnode(r.getId().toString());
                }
            } else {
                aTerm = ATermUtils.makeTermAppl(r.getURI());
            }
        }
        return aTerm;
    }

    private ATermAppl createRestriction(Resource s) {
        ATermAppl aTerm = ATermUtils.BOTTOM;
        Statement stmt = this._rawModel.getProperty(s, OWL.onProperty);
        Resource p = stmt.getResource();
        ATerm pt = this.node2term(p);
        if (s.hasProperty(OWL.hasValue)) {
            stmt = this._rawModel.getProperty(s, OWL.hasValue);
            RDFNode o = stmt.getObject();
            ATerm ot = this.node2term(o);
            aTerm = ATermUtils.makeHasValue(pt, ot);
        } else if (s.hasProperty(OWL.allValuesFrom)) {
            stmt = this._rawModel.getProperty(s, OWL.allValuesFrom);
            Resource o = stmt.getResource();
            ATerm ot = this.node2term(o);
            aTerm = ATermUtils.makeAllValues(pt, ot);
        } else if (s.hasProperty(OWL.someValuesFrom)) {
            stmt = this._rawModel.getProperty(s, OWL.someValuesFrom);
            Resource o = stmt.getResource();
            ATerm ot = this.node2term(o);
            aTerm = ATermUtils.makeSomeValues(pt, ot);
        } else if (s.hasProperty(OWL.minCardinality)) {
            stmt = this._rawModel.getProperty(s, OWL.minCardinality);
            int cardinality = 0;
            try {
                cardinality = stmt.getInt();
            }
            catch (Exception ex) {
                _logger.log(Level.FINER, "", ex);
                cardinality = Integer.parseInt(stmt.getLiteral().getLexicalForm());
            }
            aTerm = ATermUtils.makeDisplayMin(pt, cardinality, ATermUtils.EMPTY);
        } else if (s.hasProperty(OWL.maxCardinality)) {
            stmt = this._rawModel.getProperty(s, OWL.maxCardinality);
            int cardinality = 0;
            try {
                cardinality = stmt.getInt();
            }
            catch (Exception ex) {
                _logger.log(Level.FINER, "", ex);
                cardinality = Integer.parseInt(stmt.getLiteral().getLexicalForm());
            }
            aTerm = ATermUtils.makeDisplayMax(pt, cardinality, ATermUtils.EMPTY);
        } else if (s.hasProperty(OWL.cardinality)) {
            stmt = this._rawModel.getProperty(s, OWL.cardinality);
            int cardinality = 0;
            try {
                cardinality = stmt.getInt();
            }
            catch (Exception ex) {
                _logger.log(Level.FINER, "", ex);
                cardinality = Integer.parseInt(stmt.getLiteral().getLexicalForm());
            }
            aTerm = ATermUtils.makeDisplayCard(pt, cardinality, ATermUtils.EMPTY);
        }
        return aTerm;
    }

    private ATermList createList(Resource r) {
        if (r.equals(RDF.nil)) {
            return ATermUtils.EMPTY_LIST;
        }
        if (!this._rawModel.contains(r, RDF.first)) {
            System.err.println("Invalid list structure: List " + r + " does not have a rdf:first property. Ignoring rest of the list.");
            return ATermUtils.EMPTY_LIST;
        }
        ATerm first = this.node2term(this._rawModel.getProperty(r, RDF.first).getObject());
        Resource rest = this._rawModel.getProperty(r, RDF.rest).getResource();
        return ATermUtils.makeList(first, this.createList(rest));
    }
}

