/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.SetUtils;
import openllet.core.utils.iterator.IteratorUtils;
import openllet.jena.JenaUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.Dyadic;
import org.apache.jena.graph.compose.Polyadic;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.vocabulary.RDF;

public class PelletGraphListener
implements GraphListener {
    private final Set<Graph> _changedGraphs = SetUtils.create();
    private final Graph _rootGraph;
    private final KnowledgeBase _kb;
    private volatile Set<Graph> _leafGraphs = SetUtils.create();
    private boolean _statementDeleted = false;
    private boolean _enabled;

    public PelletGraphListener(Graph rootGraph, KnowledgeBase kb, boolean enabled) {
        this._rootGraph = rootGraph;
        this._kb = kb;
        this._enabled = enabled;
        if (enabled) {
            this.collectLeafGraphs(rootGraph, Collections.emptySet());
        }
    }

    private void addABoxTriple(Triple t) {
        ATermAppl s = JenaUtils.makeATerm(t.getSubject());
        ATermAppl o = JenaUtils.makeATerm(t.getObject());
        if (this._kb.individuals().noneMatch(s::equals)) {
            this._kb.addIndividual(s);
        }
        if (t.getPredicate().equals(RDF.type.asNode())) {
            this._kb.addType(s, o);
        } else {
            if (!t.getObject().isLiteral()) {
                if (this._kb.individuals().noneMatch(o::equals)) {
                    this._kb.addIndividual(o);
                }
            }
            ATermAppl p = JenaUtils.makeATerm(t.getPredicate());
            this._kb.addPropertyValue(p, s, o);
        }
    }

    private boolean canUpdateIncrementally(Graph g) {
        return OpenlletOptions.PROCESS_JENA_UPDATES_INCREMENTALLY && !this._statementDeleted && !this._changedGraphs.contains(g);
    }

    private void collectLeafGraphs(Graph graph, Set<Graph> prevLeaves) {
        if (graph instanceof Polyadic) {
            Polyadic union = (Polyadic)graph;
            if (union.getBaseGraph() != null) {
                this.collectLeafGraphs(union.getBaseGraph(), prevLeaves);
            }
            for (Graph graph2 : union.getSubGraphs()) {
                this.collectLeafGraphs(graph2, prevLeaves);
            }
        } else if (graph instanceof Dyadic) {
            Dyadic dyadic = (Dyadic)graph;
            if (dyadic.getL() instanceof Graph) {
                this.collectLeafGraphs((Graph)dyadic.getL(), prevLeaves);
            }
            if (dyadic.getR() instanceof Graph) {
                this.collectLeafGraphs((Graph)dyadic.getR(), prevLeaves);
            }
        } else if (graph instanceof InfGraph) {
            this.collectLeafGraphs(((InfGraph)graph).getRawGraph(), prevLeaves);
        } else if (this._leafGraphs.add(graph) && !prevLeaves.contains(graph)) {
            this._changedGraphs.add(graph);
            graph.getEventManager().register(this);
        }
    }

    private void deleteABoxTriple(Triple t) {
        ATermAppl s = JenaUtils.makeATerm(t.getSubject());
        ATermAppl o = JenaUtils.makeATerm(t.getObject());
        if (t.getPredicate().equals(RDF.type.asNode())) {
            if (this._kb.isIndividual(s)) {
                this._kb.removeType(s, o);
            }
        } else if (this._kb.isIndividual(s) && (this._kb.isIndividual(o) || ATermUtils.isLiteral(o))) {
            ATermAppl p = JenaUtils.makeATerm(t.getPredicate());
            this._kb.removePropertyValue(p, s, o);
        }
    }

    public void dispose() {
        for (Graph graph : this._leafGraphs) {
            graph.getEventManager().unregister(this);
        }
        this._leafGraphs.clear();
        this._changedGraphs.clear();
        this._statementDeleted = false;
    }

    public synchronized Set<Graph> getChangedGraphs() {
        Set<Graph> prevLeaves = this._leafGraphs;
        this._leafGraphs = SetUtils.create();
        this.collectLeafGraphs(this._rootGraph, prevLeaves);
        for (Graph prevLeaf : prevLeaves) {
            if (this._leafGraphs.contains(prevLeaf)) continue;
            this._statementDeleted = true;
            prevLeaf.getEventManager().unregister(this);
        }
        if (this._statementDeleted) {
            return null;
        }
        return this._changedGraphs;
    }

    public Set<Graph> getLeafGraphs() {
        return this._leafGraphs;
    }

    private boolean isABoxChange(Triple t) {
        Node o = t.getObject();
        Node p = t.getPredicate();
        if (p.equals(RDF.type.asNode())) {
            if (o.isBlank()) {
                return false;
            }
            ATermAppl object = JenaUtils.makeATerm(o);
            if (!this._kb.isClass(object)) {
                return false;
            }
        } else {
            ATermAppl prop = JenaUtils.makeATerm(p);
            if (!this._kb.isProperty(prop)) {
                return false;
            }
        }
        return true;
    }

    public boolean isChanged() {
        if (this._statementDeleted || !this._changedGraphs.isEmpty()) {
            return true;
        }
        this.getChangedGraphs();
        return this._statementDeleted || !this._changedGraphs.isEmpty();
    }

    @Override
    public void notifyAddArray(Graph g, Triple[] triples) {
        this.notifyAddIterator(g, IteratorUtils.iterator(triples));
    }

    @Override
    public void notifyAddGraph(Graph g, Graph added) {
        this.notifyAddIterator(g, added.find(Triple.ANY));
    }

    @Override
    public void notifyAddIterator(Graph g, Iterator<Triple> it) {
        boolean canUpdateIncrementally = this.canUpdateIncrementally(g);
        if (canUpdateIncrementally) {
            while (it.hasNext()) {
                Triple t = it.next();
                if (!this.isABoxChange(t)) {
                    canUpdateIncrementally = false;
                    break;
                }
                this.addABoxTriple(t);
            }
        }
        if (!canUpdateIncrementally) {
            this._changedGraphs.add(g);
        }
    }

    @Override
    public void notifyAddList(Graph g, List<Triple> triples) {
        this.notifyAddIterator(g, triples.iterator());
    }

    @Override
    public void notifyAddTriple(Graph g, Triple t) {
        if (this.canUpdateIncrementally(g) && this.isABoxChange(t)) {
            this.addABoxTriple(t);
        } else {
            this._changedGraphs.add(g);
        }
    }

    @Override
    public void notifyDeleteArray(Graph g, Triple[] triples) {
        this.notifyDeleteIterator(g, IteratorUtils.iterator(triples));
    }

    @Override
    public void notifyDeleteGraph(Graph g, Graph removed) {
        this.notifyDeleteIterator(g, removed.find(Triple.ANY));
    }

    @Override
    public void notifyDeleteIterator(Graph g, Iterator<Triple> it) {
        boolean canUpdateIncrementally = this.canUpdateIncrementally(g);
        if (canUpdateIncrementally) {
            while (it.hasNext()) {
                Triple t = it.next();
                if (!this.isABoxChange(t)) {
                    canUpdateIncrementally = false;
                    break;
                }
                this.deleteABoxTriple(t);
            }
        }
        if (!canUpdateIncrementally) {
            this._statementDeleted = true;
            this._changedGraphs.add(g);
        }
    }

    @Override
    public void notifyDeleteList(Graph g, List<Triple> list) {
        this.notifyDeleteIterator(g, list.iterator());
    }

    @Override
    public void notifyDeleteTriple(Graph g, Triple t) {
        if (this.canUpdateIncrementally(g) && this.isABoxChange(t)) {
            this.deleteABoxTriple(t);
        } else {
            this._changedGraphs.add(g);
        }
        this._statementDeleted = true;
    }

    @Override
    public void notifyEvent(Graph source, Object value) {
        this._statementDeleted = true;
    }

    public void reset() {
        this._changedGraphs.clear();
        this._statementDeleted = false;
    }

    public void setEnabled(boolean enabled) {
        if (this._enabled == enabled) {
            return;
        }
        this._enabled = enabled;
        this._leafGraphs.clear();
        this._changedGraphs.clear();
        this._statementDeleted = false;
        if (enabled) {
            this.collectLeafGraphs(this._rootGraph, Collections.emptySet());
        } else {
            for (Graph graph : this._leafGraphs) {
                graph.getEventManager().unregister(this);
            }
        }
    }
}

