/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena.graph.converter;

import java.util.Optional;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.KnowledgeBase;
import openllet.core.utils.ATermUtils;
import openllet.jena.JenaUtils;
import openllet.jena.graph.converter.ConceptConverter;
import openllet.jena.graph.converter.TripleAdder;
import openllet.jena.vocabulary.OWL2;
import openllet.jena.vocabulary.SWRL;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class AxiomConverter {
    private final KnowledgeBase _kb;
    private final ConceptConverter _converter;
    private final Graph _graph;

    public AxiomConverter(KnowledgeBase kb, Graph g) {
        this._kb = kb;
        this._graph = g;
        this._converter = new ConceptConverter(this._graph);
    }

    public void convert(ATermAppl axiomParam) {
        ATermAppl axiom = axiomParam;
        if (axiom.getAFun().equals(ATermUtils.EQCLASSFUN)) {
            this.convertBinary(axiom, OWL.equivalentClass);
        } else if (axiom.getAFun().equals(ATermUtils.SUBFUN)) {
            this.convertBinary(axiom, RDFS.subClassOf);
        } else if (axiom.getAFun().equals(ATermUtils.DISJOINTFUN)) {
            this.convertBinary(axiom, OWL.disjointWith);
        } else if (axiom.getAFun().equals(ATermUtils.DISJOINTSFUN)) {
            this.convertNary(axiom, OWL2.AllDisjointClasses, OWL2.members);
        } else if (axiom.getAFun().equals(ATermUtils.EQPROPFUN)) {
            this.convertBinary(axiom, OWL.equivalentProperty);
        } else if (axiom.getAFun().equals(ATermUtils.SUBPROPFUN)) {
            if (axiom.getArgument(0) instanceof ATermList) {
                Node s = this._converter.convert(axiom.getArgument(1));
                Node o = this._converter.convert(axiom.getArgument(0));
                TripleAdder.add(this._graph, s, (Resource)OWL2.propertyChainAxiom, o);
            } else {
                this.convertBinary(axiom, RDFS.subPropertyOf);
            }
        } else if (axiom.getAFun().equals(ATermUtils.DISJOINTPROPFUN)) {
            this.convertBinary(axiom, OWL2.propertyDisjointWith);
        } else if (axiom.getAFun().equals(ATermUtils.DISJOINTPROPSFUN)) {
            this.convertNary(axiom, OWL2.AllDisjointProperties, OWL2.members);
        } else if (axiom.getAFun().equals(ATermUtils.DOMAINFUN)) {
            this.convertBinary(axiom, RDFS.domain);
        } else if (axiom.getAFun().equals(ATermUtils.RANGEFUN)) {
            this.convertBinary(axiom, RDFS.range);
        } else if (axiom.getAFun().equals(ATermUtils.INVPROPFUN)) {
            this.convertBinary(axiom, OWL.inverseOf);
        } else if (axiom.getAFun().equals(ATermUtils.TRANSITIVEFUN)) {
            this.convertUnary(axiom, OWL.TransitiveProperty);
        } else if (axiom.getAFun().equals(ATermUtils.FUNCTIONALFUN)) {
            this.convertUnary(axiom, OWL.FunctionalProperty);
        } else if (axiom.getAFun().equals(ATermUtils.INVFUNCTIONALFUN)) {
            this.convertUnary(axiom, OWL.InverseFunctionalProperty);
        } else if (axiom.getAFun().equals(ATermUtils.SYMMETRICFUN)) {
            this.convertUnary(axiom, OWL.SymmetricProperty);
        } else if (axiom.getAFun().equals(ATermUtils.ASYMMETRICFUN)) {
            this.convertUnary(axiom, OWL2.AsymmetricProperty);
        } else if (axiom.getAFun().equals(ATermUtils.REFLEXIVEFUN)) {
            this.convertUnary(axiom, OWL2.ReflexiveProperty);
        } else if (axiom.getAFun().equals(ATermUtils.IRREFLEXIVEFUN)) {
            this.convertUnary(axiom, OWL2.IrreflexiveProperty);
        } else if (axiom.getAFun().equals(ATermUtils.TYPEFUN)) {
            this.convertBinary(axiom, RDF.type);
        } else if (axiom.getAFun().equals(ATermUtils.SAMEASFUN)) {
            this.convertBinary(axiom, OWL.sameAs);
        } else if (axiom.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            this.convertBinary(axiom, OWL.differentFrom);
        } else if (axiom.getAFun().equals(ATermUtils.ALLDIFFERENTFUN)) {
            this.convertNary(axiom, OWL.AllDifferent, OWL2.members);
        } else if (axiom.getAFun().equals(ATermUtils.NOTFUN)) {
            axiom = (ATermAppl)axiom.getArgument(0);
            Node p = this._converter.convert(axiom.getArgument(0));
            Node s = this._converter.convert(axiom.getArgument(1));
            Node o = this._converter.convert(axiom.getArgument(2));
            Node n = NodeFactory.createBlankNode();
            TripleAdder.add(this._graph, n, (Resource)RDF.type, (RDFNode)OWL2.NegativePropertyAssertion);
            TripleAdder.add(this._graph, n, (Resource)RDF.subject, s);
            TripleAdder.add(this._graph, n, (Resource)RDF.predicate, p);
            TripleAdder.add(this._graph, n, (Resource)RDF.object, o);
        } else if (axiom.getAFun().equals(ATermUtils.PROPFUN)) {
            Node p = this._converter.convert(axiom.getArgument(0));
            Node s = this._converter.convert(axiom.getArgument(1));
            Node o = this._converter.convert(axiom.getArgument(2));
            TripleAdder.add(this._graph, s, p, o);
        } else if (axiom.getAFun().equals(ATermUtils.RULEFUN)) {
            Node node = null;
            ATermAppl name = (ATermAppl)axiom.getArgument(0);
            node = name == ATermUtils.EMPTY ? NodeFactory.createBlankNode() : (ATermUtils.isBnode(name) ? NodeFactory.createBlankNode(new BlankNodeId(((ATermAppl)name.getArgument(0)).getName())) : NodeFactory.createURI(name.getName()));
            TripleAdder.add(this._graph, node, (Resource)RDF.type, (RDFNode)SWRL.Imp);
            ATermList head = (ATermList)axiom.getArgument(1);
            if (head.isEmpty()) {
                TripleAdder.add(this._graph, node, (Resource)SWRL.head, (RDFNode)RDF.nil);
            } else {
                Node list = null;
                while (!head.isEmpty()) {
                    Node atomNode = this.convertAtom((ATermAppl)head.getFirst());
                    Node newList = NodeFactory.createBlankNode();
                    TripleAdder.add(this._graph, newList, (Resource)RDF.type, (RDFNode)SWRL.AtomList);
                    TripleAdder.add(this._graph, newList, (Resource)RDF.first, atomNode);
                    if (list != null) {
                        TripleAdder.add(this._graph, list, (Resource)RDF.rest, newList);
                    } else {
                        TripleAdder.add(this._graph, node, (Resource)SWRL.head, newList);
                    }
                    list = newList;
                    head = head.getNext();
                }
                TripleAdder.add(this._graph, list, (Resource)RDF.rest, (RDFNode)RDF.nil);
            }
            ATermList body = (ATermList)axiom.getArgument(2);
            if (body.isEmpty()) {
                TripleAdder.add(this._graph, node, (Resource)SWRL.body, (RDFNode)RDF.nil);
            } else {
                Node list = null;
                while (!body.isEmpty()) {
                    Node atomNode = this.convertAtom((ATermAppl)body.getFirst());
                    Node newList = NodeFactory.createBlankNode();
                    TripleAdder.add(this._graph, newList, (Resource)RDF.type, (RDFNode)SWRL.AtomList);
                    TripleAdder.add(this._graph, newList, (Resource)RDF.first, atomNode);
                    if (list != null) {
                        TripleAdder.add(this._graph, list, (Resource)RDF.rest, newList);
                    } else {
                        TripleAdder.add(this._graph, node, (Resource)SWRL.body, newList);
                    }
                    list = newList;
                    body = body.getNext();
                }
                TripleAdder.add(this._graph, list, (Resource)RDF.rest, (RDFNode)RDF.nil);
            }
        }
    }

    private Node convertAtom(ATermAppl term) {
        Node atom = NodeFactory.createBlankNode();
        if (term.getAFun().equals(ATermUtils.TYPEFUN)) {
            ATermAppl ind = (ATermAppl)term.getArgument(0);
            ATermAppl cls = (ATermAppl)term.getArgument(1);
            this.convertAtomObject(ind).ifPresent(indNode -> {
                Node clsNode = this._converter.convert(cls);
                TripleAdder.add(this._graph, atom, (Resource)RDF.type, (RDFNode)SWRL.ClassAtom);
                TripleAdder.add(this._graph, atom, (Resource)SWRL.classPredicate, clsNode);
                TripleAdder.add(this._graph, atom, (Resource)SWRL.argument1, indNode);
            });
        } else if (term.getAFun().equals(ATermUtils.PROPFUN)) {
            ATermAppl prop = (ATermAppl)term.getArgument(0);
            ATermAppl arg1 = (ATermAppl)term.getArgument(1);
            ATermAppl arg2 = (ATermAppl)term.getArgument(2);
            JenaUtils.makeGraphNode(prop).ifPresent(propNode -> {
                Optional<Node> node1 = this.convertAtomObject(arg1);
                Optional<Node> node2 = this.convertAtomObject(arg2);
                if (node1.isPresent() && node2.isPresent()) {
                    if (this._kb.isObjectProperty(prop)) {
                        TripleAdder.add(this._graph, atom, (Resource)RDF.type, (RDFNode)SWRL.IndividualPropertyAtom);
                    } else if (this._kb.isDatatypeProperty(prop)) {
                        TripleAdder.add(this._graph, atom, (Resource)RDF.type, (RDFNode)SWRL.DatavaluedPropertyAtom);
                    } else {
                        throw new UnsupportedOperationException("Unknown property: " + prop);
                    }
                    TripleAdder.add(this._graph, atom, (Resource)SWRL.propertyPredicate, propNode);
                    TripleAdder.add(this._graph, atom, (Resource)SWRL.argument1, node1.get());
                    TripleAdder.add(this._graph, atom, (Resource)SWRL.argument2, node2.get());
                }
            });
        } else if (term.getAFun().equals(ATermUtils.SAMEASFUN)) {
            ATermAppl arg1 = (ATermAppl)term.getArgument(1);
            ATermAppl arg2 = (ATermAppl)term.getArgument(2);
            Optional<Node> node1 = this.convertAtomObject(arg1);
            Optional<Node> node2 = this.convertAtomObject(arg2);
            if (node1.isPresent() && node2.isPresent()) {
                TripleAdder.add(this._graph, atom, (Resource)RDF.type, (RDFNode)SWRL.SameIndividualAtom);
                TripleAdder.add(this._graph, atom, (Resource)SWRL.argument1, node1.get());
                TripleAdder.add(this._graph, atom, (Resource)SWRL.argument2, node2.get());
            }
        } else if (term.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            ATermAppl arg1 = (ATermAppl)term.getArgument(1);
            ATermAppl arg2 = (ATermAppl)term.getArgument(2);
            Optional<Node> node1 = this.convertAtomObject(arg1);
            Optional<Node> node2 = this.convertAtomObject(arg2);
            if (node1.isPresent() && node2.isPresent()) {
                TripleAdder.add(this._graph, atom, (Resource)RDF.type, (RDFNode)SWRL.DifferentIndividualsAtom);
                TripleAdder.add(this._graph, atom, (Resource)SWRL.argument1, node1.get());
                TripleAdder.add(this._graph, atom, (Resource)SWRL.argument2, node2.get());
            }
        } else if (term.getAFun().equals(ATermUtils.BUILTINFUN)) {
            ATermList args = (ATermList)term.getArgument(0);
            ATermAppl builtin = (ATermAppl)args.getFirst();
            args = args.getNext();
            TripleAdder.add(this._graph, atom, (Resource)RDF.type, (RDFNode)SWRL.BuiltinAtom);
            TripleAdder.add(this._graph, atom, (Resource)SWRL.builtin, NodeFactory.createURI(builtin.toString()));
            if (args.isEmpty()) {
                TripleAdder.add(this._graph, atom, (Resource)SWRL.arguments, (RDFNode)RDF.nil);
            } else {
                Node list = null;
                while (!args.isEmpty()) {
                    Optional<Node> atomNodeOpt = this.convertAtomObject((ATermAppl)args.getFirst());
                    if (atomNodeOpt.isPresent()) {
                        Node atomNode = atomNodeOpt.get();
                        Node newList = NodeFactory.createBlankNode();
                        TripleAdder.add(this._graph, newList, (Resource)RDF.first, atomNode);
                        if (list != null) {
                            TripleAdder.add(this._graph, list, (Resource)RDF.rest, newList);
                        } else {
                            TripleAdder.add(this._graph, atom, (Resource)SWRL.arguments, newList);
                        }
                        list = newList;
                    }
                    args = args.getNext();
                }
                TripleAdder.add(this._graph, list, (Resource)RDF.rest, (RDFNode)RDF.nil);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported atom: " + atom);
        }
        return atom;
    }

    private Optional<Node> convertAtomObject(ATermAppl t) {
        if (ATermUtils.isVar(t)) {
            Optional<Node> node = JenaUtils.makeGraphNode((ATermAppl)t.getArgument(0));
            if (node.isPresent()) {
                TripleAdder.add(this._graph, node.get(), (Resource)RDF.type, (RDFNode)SWRL.Variable);
            }
            return node;
        }
        return JenaUtils.makeGraphNode(t);
    }

    private void convertNary(ATermAppl axiom, Resource type, Property p) {
        Node n = NodeFactory.createBlankNode();
        TripleAdder.add(this._graph, n, (Resource)RDF.type, (RDFNode)type);
        ATermList concepts = (ATermList)axiom.getArgument(0);
        this._converter.visitList(concepts);
        TripleAdder.add(this._graph, n, (Resource)p, this._converter.getResult());
    }

    private void convertBinary(ATermAppl axiom, Property p) {
        Node s = this._converter.convert(axiom.getArgument(0));
        Node o = this._converter.convert(axiom.getArgument(1));
        TripleAdder.add(this._graph, s, (Resource)p, o);
    }

    private void convertUnary(ATermAppl axiom, Resource o) {
        Node s = this._converter.convert(axiom.getArgument(0));
        TripleAdder.add(this._graph, s, RDF.type.asNode(), o.asNode());
    }
}

