/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena.graph.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.boxes.rbox.Role;
import openllet.core.utils.CollectionUtils;
import openllet.core.utils.iterator.FlattenningIterator;
import openllet.core.utils.iterator.IteratorUtils;
import openllet.core.utils.iterator.NestedIterator;
import openllet.jena.JenaUtils;
import openllet.jena.ModelExtractor;
import openllet.jena.PelletInfGraph;
import openllet.jena.graph.loader.GraphLoader;
import openllet.jena.graph.query.BooleanQueryHandler;
import openllet.jena.graph.query.BuiltinTypeQueryHandler;
import openllet.jena.graph.query.ObjectVarHandler;
import openllet.jena.graph.query.SubjectObjectVarHandler;
import openllet.jena.graph.query.SubjectVarHandler;
import openllet.jena.graph.query.TripleQueryHandler;
import openllet.jena.vocabulary.OWL2;
import openllet.shared.tools.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.util.iterator.SingletonIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class GraphQueryHandler {
    public static final Logger _logger = Log.getLogger(GraphQueryHandler.class);
    protected static final Node VAR = Node.ANY;
    protected static final Node CONST = NodeFactory.createURI("CONST");
    private static final Node[] EMPTY = new Node[0];
    private static final Node[] BUILTIN_PREDICATES = new Node[]{RDF.type.asNode(), OWL.sameAs.asNode(), OWL.differentFrom.asNode(), RDFS.subClassOf.asNode(), OWL.equivalentClass.asNode(), OWL.complementOf.asNode(), OWL.disjointWith.asNode(), RDFS.subPropertyOf.asNode(), OWL.equivalentProperty.asNode(), OWL.inverseOf.asNode(), OWL2.propertyDisjointWith.asNode(), RDFS.domain.asNode(), RDFS.range.asNode()};
    private static final Node[] BUILTIN_QUERY_PREDICATES = new Node[]{ReasonerVocabulary.directRDFType.asNode(), ReasonerVocabulary.directSubClassOf.asNode(), ReasonerVocabulary.directSubPropertyOf.asNode()};
    private static final Node[] BUILTIN_TYPES = new Node[]{OWL.Class.asNode(), OWL.AnnotationProperty.asNode(), OWL.ObjectProperty.asNode(), OWL.DatatypeProperty.asNode(), OWL.FunctionalProperty.asNode(), OWL.InverseFunctionalProperty.asNode(), OWL.TransitiveProperty.asNode(), OWL.SymmetricProperty.asNode(), OWL2.AsymmetricProperty.asNode(), OWL2.ReflexiveProperty.asNode(), OWL2.IrreflexiveProperty.asNode()};
    private static final Node[] BUILTIN_QUERY_TYPES = new Node[]{RDFS.Class.asNode(), RDF.Property.asNode()};
    private static final Set<Node> BUILTIN_KEYWORDS = new HashSet<Node>();
    private static final Map<Triple, TripleQueryHandler> QUERY_HANDLERS;

    private static void registerHandler(Node s, Resource p, Node o, TripleQueryHandler handler) {
        GraphQueryHandler.registerHandler(s, p.asNode(), o, handler);
    }

    private static void registerHandler(Node s, Resource p, Resource o, TripleQueryHandler handler) {
        GraphQueryHandler.registerHandler(s, p.asNode(), o.asNode(), handler);
    }

    private static void registerHandler(Node s, Node p, Node o, TripleQueryHandler handler) {
        Triple pattern = Triple.create(s, p, o);
        _logger.fine(() -> "Registering handler for pattern: " + pattern);
        TripleQueryHandler prev = QUERY_HANDLERS.put(pattern, handler);
        if (prev != null) {
            _logger.severe(() -> "Existing handler found for pattern: " + pattern);
        }
    }

    private static void registerQueryHandlers() {
        GraphQueryHandler.registerHandler(VAR, VAR, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return true;
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                ModelExtractor me = new ModelExtractor(kb);
                me.setSelector(ModelExtractor.StatementType.ALL_STATEMENTS);
                Graph graph = me.extractModel().getGraph();
                return graph.find(Triple.ANY);
            }
        });
        GraphQueryHandler.registerHandler(VAR, VAR, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                ATermAppl term = loader.node2term(o);
                return kb.isClass(term) || kb.isProperty(term) || kb.isIndividual(term);
            }

            @Override
            public ExtendedIterator<Triple> find(final KnowledgeBase kb, final PelletInfGraph openllet, final Node s, Node p, final Node o) {
                ExtendedIterator builtinPredicates = NullIterator.instance();
                if (!o.isLiteral() && !openllet.isSkipBuiltinPredicates()) {
                    for (Node pred : BUILTIN_PREDICATES) {
                        builtinPredicates = builtinPredicates.andThen(GraphQueryHandler.findTriple(kb, openllet, s, pred, o));
                    }
                }
                ExtendedIterator<Triple> propertyAssertions = WrappedIterator.create(new NestedIterator<ATermAppl, Triple>(kb.getProperties()){

                    @Override
                    public Iterator<Triple> getInnerIterator(ATermAppl prop) {
                        return JenaUtils.makeGraphNode(prop).map(node -> GraphQueryHandler.findTriple(kb, openllet, s, node, o)).orElseGet(NullIterator::instance);
                    }
                });
                return builtinPredicates.andThen(propertyAssertions);
            }
        });
        GraphQueryHandler.registerHandler(CONST, VAR, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                ATermAppl term = loader.node2term(s);
                return kb.isClass(term) || kb.isProperty(term) || kb.isIndividual(term);
            }

            @Override
            public ExtendedIterator<Triple> find(final KnowledgeBase kb, final PelletInfGraph openllet, final Node s, Node p, final Node o) {
                ExtendedIterator builtinPredicates = NullIterator.instance();
                if (!openllet.isSkipBuiltinPredicates()) {
                    for (Node pred : BUILTIN_PREDICATES) {
                        builtinPredicates = builtinPredicates.andThen(GraphQueryHandler.findTriple(kb, openllet, s, pred, o));
                    }
                }
                ExtendedIterator<Triple> propertyAssertions = WrappedIterator.create(new NestedIterator<ATermAppl, Triple>(kb.getProperties()){

                    @Override
                    public Iterator<Triple> getInnerIterator(ATermAppl prop) {
                        return JenaUtils.makeGraphNode(prop).map(node -> GraphQueryHandler.findTriple(kb, openllet, s, node, o)).orElseGet(NullIterator::instance);
                    }
                });
                return builtinPredicates.andThen(propertyAssertions);
            }
        });
        GraphQueryHandler.registerHandler(CONST, VAR, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                ATermAppl t = loader.node2term(s);
                return kb.isClass(t) || kb.isProperty(t) || kb.isIndividual(t);
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                ExtendedIterator<Triple> result;
                block4: {
                    block3: {
                        result = NullIterator.instance();
                        ATermAppl subj = openllet.getLoader().node2term(s);
                        ATermAppl obj = openllet.getLoader().node2term(o);
                        if (!kb.isIndividual(subj) && !kb.isIndividual(obj)) break block3;
                        if (!kb.isIndividual(subj)) break block4;
                        List<ATermAppl> properties = kb.getProperties(openllet.getLoader().node2term(s), openllet.getLoader().node2term(o));
                        result = this.propertyFiller(s, properties, o);
                        if (!kb.isIndividual(obj)) break block4;
                        if (kb.isSameAs(subj, obj)) {
                            result = result.andThen(new SingletonIterator<Triple>(Triple.create(s, OWL.sameAs.asNode(), o)));
                        }
                        if (!kb.isDifferentFrom(subj, obj)) break block4;
                        result = result.andThen(new SingletonIterator<Triple>(Triple.create(s, OWL.differentFrom.asNode(), o)));
                        break block4;
                    }
                    if (!openllet.isSkipBuiltinPredicates()) {
                        for (Node pred : BUILTIN_PREDICATES) {
                            result = result.andThen(GraphQueryHandler.findTriple(kb, openllet, s, pred, o));
                        }
                    }
                }
                return result;
            }
        });
        GraphQueryHandler.registerHandler(VAR, CONST, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                ATermAppl prop = loader.node2term(p);
                if (!kb.isProperty(prop)) {
                    return false;
                }
                for (ATermAppl ind : kb.getIndividuals()) {
                    if (!kb.hasKnownPropertyValue(ind, prop, null).isTrue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public ExtendedIterator<Triple> find(final KnowledgeBase kb, PelletInfGraph openllet, Node s, final Node p, Node o) {
                final ATermAppl prop = openllet.getLoader().node2term(p);
                return WrappedIterator.create(new NestedIterator<ATermAppl, Triple>(kb.getIndividuals()){

                    @Override
                    public Iterator<Triple> getInnerIterator(ATermAppl subj) {
                        return JenaUtils.makeGraphNode(subj).map(node -> this.objectFiller((Node)node, p, (Collection<ATermAppl>)kb.getPropertyValues(prop, subj))).orElseGet(NullIterator::instance);
                    }
                });
            }
        });
        GraphQueryHandler.registerHandler(VAR, CONST, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                ATermAppl val;
                ATermAppl prop = loader.node2term(p);
                return !kb.getIndividualsWithProperty(prop, val = loader.node2term(o)).isEmpty();
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                ATermAppl prop = openllet.getLoader().node2term(p);
                ATermAppl val = openllet.getLoader().node2term(o);
                return this.subjectFiller(kb.getIndividualsWithProperty(prop, val), p, o);
            }
        });
        GraphQueryHandler.registerHandler(CONST, CONST, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                ATermAppl ind = loader.node2term(s);
                ATermAppl prop = loader.node2term(p);
                return kb.isIndividual(ind) && kb.hasPropertyValue(ind, prop, null);
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                ATermAppl ind = openllet.getLoader().node2term(s);
                ATermAppl prop = openllet.getLoader().node2term(p);
                return this.objectFiller(s, p, kb.getPropertyValues(prop, ind));
            }
        });
        GraphQueryHandler.registerHandler(CONST, CONST, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                ATermAppl subj = loader.node2term(s);
                ATermAppl prop = loader.node2term(p);
                ATermAppl obj = loader.node2term(o);
                return kb.hasPropertyValue(subj, prop, obj);
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return true;
            }

            @Override
            public ExtendedIterator<Triple> find(final KnowledgeBase kb, final PelletInfGraph openllet, final Node subj, final Node pred, Node obj) {
                ExtendedIterator<Triple> builtinTypes = WrappedIterator.create(new NestedIterator<Node, Triple>(Arrays.asList(BUILTIN_TYPES)){

                    @Override
                    public Iterator<Triple> getInnerIterator(Node builtinType) {
                        return GraphQueryHandler.findTriple(kb, openllet, subj, pred, builtinType);
                    }
                });
                ExtendedIterator<Triple> typeAssertions = WrappedIterator.create(new NestedIterator<ATermAppl, Triple>(kb.getAllClasses()){

                    @Override
                    public Iterator<Triple> getInnerIterator(ATermAppl cls) {
                        return this.subjectFiller(kb.getInstances(cls), pred, JenaUtils.makeGraphResource(cls));
                    }
                });
                return builtinTypes.andThen(typeAssertions);
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.hasInstance(loader.node2term(o));
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.subjectFiller(kb.getInstances(openllet.getLoader().node2term(o)), p, o);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                ATermAppl t = loader.node2term(s);
                return kb.isClass(t) || kb.isProperty(t) || kb.isIndividual(t);
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                ATermAppl term = openllet.getLoader().node2term(s);
                if (kb.isIndividual(term)) {
                    return this.objectSetFiller(s, p, kb.getTypes(term));
                }
                ArrayList<Node> types = new ArrayList<Node>();
                if (kb.isClass(term)) {
                    types.add(OWL.Class.asNode());
                } else if (kb.isDatatype(term)) {
                    types.add(RDFS.Datatype.asNode());
                } else if (kb.isObjectProperty(term)) {
                    Role role = kb.getRole(term);
                    types.add(OWL.ObjectProperty.asNode());
                    if (role.isFunctional()) {
                        types.add(OWL.FunctionalProperty.asNode());
                    }
                    if (role.isInverseFunctional()) {
                        types.add(OWL.InverseFunctionalProperty.asNode());
                    }
                    if (role.isTransitive()) {
                        types.add(OWL.TransitiveProperty.asNode());
                    }
                    if (role.isSymmetric()) {
                        types.add(OWL.SymmetricProperty.asNode());
                    }
                    if (role.isAsymmetric()) {
                        types.add(OWL2.AsymmetricProperty.asNode());
                    }
                    if (role.isReflexive()) {
                        types.add(OWL2.ReflexiveProperty.asNode());
                    }
                    if (role.isIrreflexive()) {
                        types.add(OWL2.IrreflexiveProperty.asNode());
                    }
                } else if (kb.isDatatypeProperty(term)) {
                    Role role = kb.getRole(term);
                    types.add(OWL.DatatypeProperty.asNode());
                    if (role.isFunctional()) {
                        types.add(OWL.FunctionalProperty.asNode());
                    }
                    if (role.isInverseFunctional()) {
                        types.add(OWL.InverseFunctionalProperty.asNode());
                    }
                } else if (kb.isAnnotationProperty(term)) {
                    types.add(OWL.AnnotationProperty.asNode());
                }
                return WrappedIterator.create(types.iterator()).mapWith(node -> Triple.create(s, p, node));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isType(loader.node2term(s), loader.node2term(o));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)ReasonerVocabulary.directRDFType, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return IteratorUtils.flatten(kb.getTypes(subj, true).iterator());
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getIndividuals();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return 0 != kb.getIndividualsCount();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)ReasonerVocabulary.directRDFType, CONST, (TripleQueryHandler)new SubjectVarHandler(){

            @Override
            public Set<ATermAppl> getSubjects(KnowledgeBase kb, ATermAppl obj) {
                return kb.getInstances(obj, true);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)ReasonerVocabulary.directRDFType, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return kb.isIndividual(loader.node2term(subj));
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node subj, Node pred, Node obj) {
                return this.objectSetFiller(subj, pred, kb.getTypes(openllet.getLoader().node2term(subj), true));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)ReasonerVocabulary.directRDFType, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.getInstances(loader.node2term(o), true).contains(loader.node2term(s));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.Class, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase kb) {
                return kb.getAllClasses();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, RDFS.Class, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase kb) {
                return kb.getAllClasses();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.Class, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isClass(loader.node2term(s));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, RDFS.Class, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isClass(loader.node2term(s));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, RDF.Property, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isProperty(loader.node2term(s));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, RDF.Property, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase kb) {
                return kb.getProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.ObjectProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isObjectProperty(loader.node2term(s));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.ObjectProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase kb) {
                return kb.getObjectProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.DatatypeProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isDatatypeProperty(loader.node2term(s));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.DatatypeProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase kb) {
                return kb.getDataProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.AnnotationProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isAnnotationProperty(loader.node2term(s));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.AnnotationProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase kb) {
                return kb.getAnnotationProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.TransitiveProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isTransitiveProperty(loader.node2term(s));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.TransitiveProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase kb) {
                return kb.getTransitiveProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.SymmetricProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isSymmetricProperty(loader.node2term(s));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.SymmetricProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase kb) {
                return kb.getSymmetricProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.FunctionalProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isFunctionalProperty(loader.node2term(s));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.FunctionalProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase kb) {
                return kb.getFunctionalProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL.InverseFunctionalProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isInverseFunctionalProperty(loader.node2term(s));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL.InverseFunctionalProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase kb) {
                return kb.getInverseFunctionalProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL2.ReflexiveProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isReflexiveProperty(loader.node2term(s));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL2.ReflexiveProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase kb) {
                return kb.getReflexiveProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL2.IrreflexiveProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isIrreflexiveProperty(loader.node2term(s));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL2.IrreflexiveProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase kb) {
                return kb.getIrreflexiveProperties();
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDF.type, OWL2.AsymmetricProperty, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isAsymmetricProperty(loader.node2term(s));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDF.type, OWL2.AsymmetricProperty, (TripleQueryHandler)new BuiltinTypeQueryHandler(){

            public Set<ATermAppl> getResults(KnowledgeBase kb) {
                return kb.getAsymmetricProperties();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.subClassOf, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return new FlattenningIterator<ATermAppl>((Iterable<Iterable<ATermAppl>>)kb.getSuperClasses(subj, false));
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getAllClasses();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return true;
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.subClassOf, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isClass(loader.node2term(o));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.subjectSetFiller(kb.getSubClasses(openllet.getLoader().node2term(o)), p, o);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.subClassOf, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isClass(loader.node2term(s));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.objectSetFiller(s, p, kb.getSuperClasses(openllet.getLoader().node2term(s)));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.subClassOf, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isSubClassOf(loader.node2term(s), loader.node2term(o));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)ReasonerVocabulary.directSubClassOf, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return new FlattenningIterator<ATermAppl>((Iterable<Iterable<ATermAppl>>)kb.getSuperClasses(subj, true));
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getAllClasses();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return true;
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)ReasonerVocabulary.directSubClassOf, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isClass(loader.node2term(o)) && !o.equals(OWL.Nothing.asNode());
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.subjectSetFiller(kb.getSubClasses(openllet.getLoader().node2term(o), true), p, o);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)ReasonerVocabulary.directSubClassOf, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isClass(loader.node2term(s)) && !o.equals(OWL.Thing.asNode());
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.objectSetFiller(s, p, kb.getSuperClasses(openllet.getLoader().node2term(s), true));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)ReasonerVocabulary.directSubClassOf, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.getSuperClasses(loader.node2term(s), true).contains(kb.getAllEquivalentClasses(loader.node2term(o)));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.equivalentClass, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return kb.getAllEquivalentClasses(subj).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getAllClasses();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return true;
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.equivalentClass, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isClass(loader.node2term(o));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.subjectFiller(kb.getAllEquivalentClasses(openllet.getLoader().node2term(o)), p, o);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.equivalentClass, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isClass(loader.node2term(s));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.objectFiller(s, p, kb.getAllEquivalentClasses(openllet.getLoader().node2term(s)));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.equivalentClass, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isEquivalentClass(loader.node2term(s), loader.node2term(o));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.disjointWith, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return new FlattenningIterator<ATermAppl>((Iterable<Iterable<ATermAppl>>)kb.getDisjointClasses(subj));
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getAllClasses();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return true;
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.disjointWith, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isClass(loader.node2term(o));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.subjectSetFiller(kb.getDisjointClasses(openllet.getLoader().node2term(o)), p, o);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.disjointWith, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isClass(loader.node2term(s));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.objectSetFiller(s, p, kb.getDisjointClasses(openllet.getLoader().node2term(s)));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.disjointWith, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isDisjointClass(loader.node2term(s), loader.node2term(o));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.complementOf, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return kb.getComplements(subj).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getAllClasses();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return true;
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.complementOf, CONST, (TripleQueryHandler)new SubjectVarHandler(){

            @Override
            public Set<ATermAppl> getSubjects(KnowledgeBase kb, ATermAppl c) {
                return kb.getComplements(c);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.complementOf, VAR, (TripleQueryHandler)new ObjectVarHandler(){

            @Override
            public Set<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl c) {
                return kb.getComplements(c);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.complementOf, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isComplement(loader.node2term(s), loader.node2term(o));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.subPropertyOf, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return new FlattenningIterator<ATermAppl>((Iterable<Iterable<ATermAppl>>)kb.getAllSuperProperties(subj));
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getProperties();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return !kb.getProperties().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.subPropertyOf, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isProperty(loader.node2term(o));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.subjectSetFiller(kb.getAllSubProperties(openllet.getLoader().node2term(o)), p, o);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.subPropertyOf, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isProperty(loader.node2term(s));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.objectSetFiller(s, p, kb.getAllSuperProperties(openllet.getLoader().node2term(s)));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.subPropertyOf, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isSubPropertyOf(loader.node2term(s), loader.node2term(o));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)ReasonerVocabulary.directSubPropertyOf, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return new FlattenningIterator<ATermAppl>((Iterable<Iterable<ATermAppl>>)kb.getSuperProperties(subj, true));
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getProperties();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return !kb.getProperties().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)ReasonerVocabulary.directSubPropertyOf, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isProperty(loader.node2term(o));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.subjectSetFiller(kb.getSubProperties(openllet.getLoader().node2term(o), true), p, o);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)ReasonerVocabulary.directSubPropertyOf, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isProperty(loader.node2term(s));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.objectSetFiller(s, p, kb.getSuperProperties(openllet.getLoader().node2term(s), true));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)ReasonerVocabulary.directSubPropertyOf, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.getSuperProperties(loader.node2term(s), true).contains(kb.getAllEquivalentProperties(loader.node2term(o)));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.domain, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return kb.getDomains(subj).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getProperties();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return !kb.getProperties().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.domain, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isProperty(loader.node2term(o));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                ArrayList<ATermAppl> props = new ArrayList<ATermAppl>();
                ATermAppl domain = openllet.getLoader().node2term(o);
                for (ATermAppl prop : kb.getProperties()) {
                    if (!kb.getDomains(prop).contains(domain)) continue;
                    props.add(prop);
                }
                return this.subjectFiller(props, p, o);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.domain, VAR, (TripleQueryHandler)new ObjectVarHandler(){

            @Override
            public Set<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl p) {
                return kb.getDomains(p);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.domain, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.hasDomain(loader.node2term(s), loader.node2term(o));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.range, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return kb.getRanges(subj).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getProperties();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return !kb.getProperties().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)RDFS.range, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isProperty(loader.node2term(o));
            }

            @Override
            public final ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                ArrayList<ATermAppl> props = new ArrayList<ATermAppl>();
                ATermAppl range = openllet.getLoader().node2term(o);
                for (ATermAppl prop : kb.getProperties()) {
                    if (!kb.getRanges(prop).contains(range)) continue;
                    props.add(prop);
                }
                return this.subjectFiller(props, p, o);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.range, VAR, (TripleQueryHandler)new ObjectVarHandler(){

            @Override
            public Set<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl p) {
                return kb.getRanges(p);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)RDFS.range, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.hasRange(loader.node2term(s), loader.node2term(o));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.equivalentProperty, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return kb.getAllEquivalentProperties(subj).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getProperties();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return !kb.getProperties().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.equivalentProperty, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isProperty(loader.node2term(o));
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.subjectFiller(kb.getAllEquivalentProperties(openllet.getLoader().node2term(o)), p, o);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.equivalentProperty, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isProperty(loader.node2term(s));
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.objectFiller(s, p, kb.getAllEquivalentProperties(openllet.getLoader().node2term(s)));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.equivalentProperty, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isEquivalentProperty(loader.node2term(s), loader.node2term(o));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.inverseOf, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return kb.getInverses(subj).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getProperties();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return !kb.getProperties().isEmpty();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.inverseOf, CONST, (TripleQueryHandler)new SubjectVarHandler(){

            @Override
            public Set<ATermAppl> getSubjects(KnowledgeBase kb, ATermAppl p) {
                return kb.getInverses(p);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.inverseOf, VAR, (TripleQueryHandler)new ObjectVarHandler(){

            @Override
            public Set<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl p) {
                return kb.getInverses(p);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.inverseOf, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isInverse(loader.node2term(s), loader.node2term(o));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL2.propertyDisjointWith, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return new FlattenningIterator<ATermAppl>((Iterable<Iterable<ATermAppl>>)kb.getDisjointProperties(subj));
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getProperties();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node subj, Node pred, Node obj) {
                return kb.getExpressivity().hasDisjointRoles();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL2.propertyDisjointWith, CONST, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return !kb.getDisjointProperties(loader.node2term(o)).isEmpty();
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.subjectSetFiller(kb.getDisjointProperties(openllet.getLoader().node2term(o)), p, o);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL2.propertyDisjointWith, VAR, new TripleQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return !kb.getDisjointProperties(loader.node2term(s)).isEmpty();
            }

            @Override
            public ExtendedIterator<Triple> find(KnowledgeBase kb, PelletInfGraph openllet, Node s, Node p, Node o) {
                return this.objectSetFiller(s, p, kb.getDisjointProperties(openllet.getLoader().node2term(s)));
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL2.propertyDisjointWith, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                ATermAppl prop1 = loader.node2term(s);
                ATermAppl prop2 = loader.node2term(o);
                return (kb.isObjectProperty(prop1) && kb.isObjectProperty(prop2) || kb.isDatatypeProperty(prop1) && kb.isDatatypeProperty(prop2)) && kb.isDisjointProperty(prop1, prop2);
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.sameAs, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return kb.getAllSames(subj).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getIndividuals();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return 0 != kb.getIndividualsCount();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.sameAs, CONST, (TripleQueryHandler)new SubjectVarHandler(){

            @Override
            public Set<ATermAppl> getSubjects(KnowledgeBase kb, ATermAppl ind) {
                return kb.getAllSames(ind);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.sameAs, VAR, (TripleQueryHandler)new ObjectVarHandler(){

            @Override
            public Set<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl ind) {
                return kb.getAllSames(ind);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.sameAs, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isSameAs(loader.node2term(s), loader.node2term(o));
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.differentFrom, VAR, (TripleQueryHandler)new SubjectObjectVarHandler(){

            @Override
            public Iterator<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl subj) {
                return kb.getDifferents(subj).iterator();
            }

            @Override
            public Collection<ATermAppl> getSubjects(KnowledgeBase kb) {
                return kb.getIndividuals();
            }

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return 0 != kb.getIndividualsCount();
            }
        });
        GraphQueryHandler.registerHandler(VAR, (Resource)OWL.differentFrom, CONST, (TripleQueryHandler)new SubjectVarHandler(){

            @Override
            public Set<ATermAppl> getSubjects(KnowledgeBase kb, ATermAppl ind) {
                return kb.getDifferents(ind);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.differentFrom, VAR, (TripleQueryHandler)new ObjectVarHandler(){

            @Override
            public Set<ATermAppl> getObjects(KnowledgeBase kb, ATermAppl ind) {
                return kb.getDifferents(ind);
            }
        });
        GraphQueryHandler.registerHandler(CONST, (Resource)OWL.differentFrom, CONST, (TripleQueryHandler)new BooleanQueryHandler(){

            @Override
            public boolean contains(KnowledgeBase kb, GraphLoader loader, Node s, Node p, Node o) {
                return kb.isDifferentFrom(loader.node2term(s), loader.node2term(o));
            }
        });
    }

    public static boolean isBuiltin(Node node) {
        return BUILTIN_KEYWORDS.contains(node);
    }

    public static Node normalize(Node node) {
        return node == VAR || node.isVariable() ? VAR : (GraphQueryHandler.isBuiltin(node) ? node : CONST);
    }

    public static ExtendedIterator<Triple> findTriple(KnowledgeBase kb, PelletInfGraph openllet, Node subj, Node predParam, Node obj) {
        TripleQueryHandler qh;
        Node pred = predParam;
        Node s = GraphQueryHandler.normalize(subj);
        Node p = GraphQueryHandler.normalize(pred);
        Node o = GraphQueryHandler.normalize(obj);
        if (p == VAR && o != VAR && o != CONST) {
            pred = p = RDF.type.asNode();
        }
        if ((qh = QUERY_HANDLERS.get(Triple.create(s, p, o))) == null && _logger.isLoggable(Level.WARNING)) {
            _logger.warning("No query handler found for " + subj + " " + pred + " " + obj);
        }
        return qh == null ? NullIterator.instance() : qh.find(kb, openllet, subj, pred, obj);
    }

    public static boolean containsTriple(KnowledgeBase kb, GraphLoader loader, Node subj, Node predParam, Node obj) {
        TripleQueryHandler qh;
        Node pred = predParam;
        Node s = GraphQueryHandler.normalize(subj);
        Node p = GraphQueryHandler.normalize(pred);
        Node o = GraphQueryHandler.normalize(obj);
        if (p == VAR && o != VAR && o != CONST) {
            pred = p = RDF.type.asNode();
        }
        if ((qh = QUERY_HANDLERS.get(Triple.create(s, p, o))) == null && _logger.isLoggable(Level.WARNING)) {
            _logger.warning("No query handler found for " + subj + " " + pred + " " + obj);
        }
        return qh != null && qh.contains(kb, loader, subj, pred, obj);
    }

    static {
        for (Node node : BUILTIN_PREDICATES) {
            BUILTIN_KEYWORDS.add(node);
        }
        for (Node node : BUILTIN_QUERY_PREDICATES) {
            BUILTIN_KEYWORDS.add(node);
        }
        for (Node node : BUILTIN_TYPES) {
            BUILTIN_KEYWORDS.add(node);
        }
        for (Node node : BUILTIN_QUERY_TYPES) {
            BUILTIN_KEYWORDS.add(node);
        }
        QUERY_HANDLERS = CollectionUtils.makeMap();
        GraphQueryHandler.registerQueryHandlers();
    }
}

