/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena.graph.query;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.utils.iterator.IteratorUtils;
import openllet.jena.JenaUtils;
import openllet.jena.PelletInfGraph;
import openllet.jena.graph.loader.GraphLoader;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public abstract class TripleQueryHandler {
    public abstract boolean contains(KnowledgeBase var1, GraphLoader var2, Node var3, Node var4, Node var5);

    public abstract ExtendedIterator<Triple> find(KnowledgeBase var1, PelletInfGraph var2, Node var3, Node var4, Node var5);

    protected ExtendedIterator<Triple> objectFiller(Node s, Node p, Collection<ATermAppl> objects) {
        return this.objectFiller(s, p, objects.iterator());
    }

    protected ExtendedIterator<Triple> objectFiller(Node s, Node p, Iterator<ATermAppl> objects) {
        return WrappedIterator.create(objects).filterKeep(JenaUtils._isGrapheNode).mapWith(JenaUtils::makeGraphNode).filterKeep(Optional::isPresent).mapWith(node -> Triple.create(s, p, (Node)node.get()));
    }

    protected ExtendedIterator<Triple> objectSetFiller(Node s, Node p, Set<Set<ATermAppl>> objectSets) {
        return this.objectFiller(s, p, IteratorUtils.flatten(objectSets.iterator()));
    }

    protected ExtendedIterator<Triple> propertyFiller(Node s, Collection<ATermAppl> properties, Node o) {
        return this.propertyFiller(s, properties.iterator(), o);
    }

    protected ExtendedIterator<Triple> propertyFiller(Node s, Iterator<ATermAppl> properties, Node o) {
        return WrappedIterator.create(properties).filterKeep(JenaUtils._isGrapheNode).mapWith(JenaUtils::makeGraphNode).filterKeep(Optional::isPresent).mapWith(node -> Triple.create(s, (Node)node.get(), o));
    }

    protected ExtendedIterator<Triple> subjectFiller(Collection<ATermAppl> subjects, Node p, Node o) {
        return this.subjectFiller(subjects.iterator(), p, o);
    }

    protected ExtendedIterator<Triple> subjectFiller(Iterator<ATermAppl> subjects, Node p, Node o) {
        return WrappedIterator.create(subjects).filterKeep(JenaUtils._isGrapheNode).mapWith(JenaUtils::makeGraphNode).filterKeep(Optional::isPresent).mapWith(node -> Triple.create((Node)node.get(), p, o));
    }

    protected ExtendedIterator<Triple> subjectSetFiller(Set<Set<ATermAppl>> subjectSets, Node p, Node o) {
        return this.subjectFiller(IteratorUtils.flatten(subjectSets.iterator()), p, o);
    }
}

