/*
 * Decompiled with CFR 0.152.
 */
package openllet.modularity;

import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.LocalityEvaluator;
import com.clarkparsia.owlapi.modularity.locality.SyntacticLocalityEvaluator;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.expressivity.Expressivity;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyNode;
import openllet.core.utils.MultiValueMap;
import openllet.core.utils.SetUtils;
import openllet.core.utils.Timer;
import openllet.core.utils.Timers;
import openllet.core.utils.progress.ConsoleProgressMonitor;
import openllet.core.utils.progress.ProgressMonitor;
import openllet.modularity.ChangeTypeDetector;
import openllet.modularity.ModuleExtractor;
import openllet.modularity.io.ModuleExtractorPersistence;
import openllet.modularity.io.UncloseableOutputStream;
import openllet.owlapi.OWL;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

public abstract class AbstractModuleExtractor
implements ModuleExtractor {
    public static final Logger _logger = Log.getLogger(AbstractModuleExtractor.class);
    private final Set<OWLAxiom> _additions = SetUtils.create();
    private final Set<OWLClass> _newClasses = SetUtils.create();
    private final Set<OWLAxiom> _axioms = SetUtils.create();
    private final Set<OWLAxiom> _deletions = SetUtils.create();
    protected EnumSet<KnowledgeBase.ChangeType> _changes = EnumSet.noneOf(KnowledgeBase.ChangeType.class);
    protected MultiValueMap<OWLEntity, OWLAxiom> _entityAxioms = new MultiValueMap();
    private LocalityEvaluator _localityEvaluator = null;
    protected MultiValueMap<OWLEntity, OWLEntity> _modules = null;
    private boolean _nonLocalAxioms = false;
    private final Timers _timers = new Timers();
    private static final String MODULE_EXTRACTOR_AXIOMS_FILE_NAME = "ModuleExtractorAxioms";
    private static final String MODULE_EXTRACTOR_MODULES_FILE_NAME = "ModuleExtractorModules";

    public AbstractModuleExtractor() {
        this((LocalityEvaluator)new SyntacticLocalityEvaluator(LocalityClass.BOTTOM_BOTTOM));
    }

    public AbstractModuleExtractor(LocalityEvaluator localityEvaluator) {
        this._localityEvaluator = localityEvaluator;
    }

    @Override
    public void addAxiom(OWLAxiom axiom) {
        this.checkNonLocalAxiom(axiom);
        if (this._axioms.contains(axiom)) {
            return;
        }
        _logger.fine(() -> "Adding " + axiom);
        this._deletions.remove(axiom);
        this._additions.add(axiom);
        this.categorizeAddedAxiom(axiom);
    }

    @Override
    public boolean canUpdate() {
        return this._modules != null && !this._nonLocalAxioms;
    }

    private void checkNonLocalAxiom(OWLAxiom axiom) {
        if (!axiom.isLogicalAxiom()) {
            return;
        }
        if (this.canUpdate() && !this.isLocal(axiom, Collections.emptySet())) {
            _logger.warning("*** Non-local axiom: " + axiom);
            this._nonLocalAxioms = true;
        }
    }

    @Override
    public void deleteAxiom(OWLAxiom axiom) {
        this.checkNonLocalAxiom(axiom);
        if (!this._axioms.contains(axiom)) {
            if (this._additions.remove(axiom)) {
                _logger.fine(() -> "Deleted axiom from add _queue before processing " + axiom);
            }
            return;
        }
        _logger.fine(() -> "Deleting " + axiom);
        this._additions.remove(axiom);
        this._deletions.add(axiom);
        this.categorizeRemovedAxiom(axiom);
    }

    @Override
    public MultiValueMap<OWLEntity, OWLEntity> getModules() {
        return this._modules;
    }

    @Override
    public MultiValueMap<OWLEntity, OWLEntity> extractModules() {
        Optional<Timer> timer = this._timers.startTimer("extractModules");
        this.processAdditions();
        this._additions.clear();
        this._deletions.clear();
        this._changes.clear();
        this._nonLocalAxioms = false;
        this._modules = new MultiValueMap();
        this.extractModuleSignatures(this._entityAxioms.keySet());
        timer.ifPresent(t -> t.stop());
        return this._modules;
    }

    private void extractModuleSignatures(Set<? extends OWLEntity> entities) {
        _logger.fine(() -> "Extracting module for each of " + entities);
        if (entities.isEmpty()) {
            return;
        }
        ConsoleProgressMonitor monitor = new ConsoleProgressMonitor();
        monitor.setProgressTitle("Extracting");
        monitor.setProgressLength(entities.size());
        monitor.taskStarted();
        this.extractModuleSignatures(entities, monitor);
        monitor.taskFinished();
        _logger.finer(() -> "Modules: " + this._modules);
    }

    protected abstract void extractModuleSignatures(Set<? extends OWLEntity> var1, ProgressMonitor var2);

    private Set<OWLEntity> getAffectedRoots(OWLAxiom axiom, Taxonomy<OWLClass> taxonomy, boolean add) {
        HashSet<OWLEntity> roots = new HashSet<OWLEntity>();
        HashSet<TaxonomyNode<OWLClass>> visited = new HashSet<TaxonomyNode<OWLClass>>();
        visited.add(taxonomy.getBottomNode());
        this.getAffectedRoots(axiom, taxonomy.getTop(), roots, add, visited);
        if (!add && roots.isEmpty()) {
            for (OWLClass unsat : taxonomy.getEquivalents(OWL.Nothing)) {
                Set signature = (Set)this._modules.get(unsat);
                if (signature == null || !signature.containsAll(this.getSignature(axiom))) continue;
                roots.add((OWLEntity)unsat);
            }
        }
        return roots;
    }

    private void getAffectedRoots(OWLAxiom axiom, TaxonomyNode<OWLClass> node, Set<OWLEntity> effects, boolean add, Set<TaxonomyNode<OWLClass>> visited) {
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        OWLEntity entity = (OWLEntity)node.getName();
        Set signature = (Set)this._modules.get(entity);
        boolean outdated = false;
        if (signature == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Removed entity " + entity);
            }
        } else {
            outdated = add ? !this.isLocal(axiom, signature) : signature.containsAll(this.getSignature(axiom));
        }
        if (outdated) {
            effects.addAll(node.getEquivalents());
        } else {
            for (TaxonomyNode<OWLClass> next : node.getSubs()) {
                this.getAffectedRoots(axiom, next, effects, add, visited);
            }
        }
    }

    @Override
    public Stream<OWLAxiom> axioms(OWLEntity entity) {
        Set axioms = (Set)this._entityAxioms.get(entity);
        if (axioms == null) {
            return Stream.empty();
        }
        return axioms.stream();
    }

    @Override
    @Deprecated
    public Set<OWLAxiom> getAxioms(OWLEntity entity) {
        Set<OWLAxiom> axioms = (Set<OWLAxiom>)this._entityAxioms.get(entity);
        if (axioms == null) {
            axioms = Collections.emptySet();
        }
        return axioms;
    }

    @Override
    public OWLOntology getModule(OWLEntity entity) {
        return this.getModuleFromSignature((Set)this._modules.get(entity));
    }

    protected Set<OWLAxiom> getModuleAxioms(Set<OWLEntity> signature) {
        HashSet referenced = new HashSet();
        HashSet<OWLEntity> augmentedSig = new HashSet<OWLEntity>(signature);
        augmentedSig.add((OWLEntity)OWL.Thing);
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> candidates = new HashSet<OWLAxiom>();
        for (OWLEntity e2 : signature) {
            candidates.addAll(this.getAxioms(e2));
        }
        for (OWLAxiom axiom : candidates) {
            Set sigAxiom = axiom.signature().collect(Collectors.toSet());
            if (!augmentedSig.containsAll(sigAxiom) || this.isLocal(axiom, signature)) continue;
            axioms.add(axiom);
            referenced.addAll(sigAxiom);
        }
        HashSet<OWLEntity> notReferenced = new HashSet<OWLEntity>(signature);
        notReferenced.removeAll(referenced);
        for (OWLEntity e3 : notReferenced) {
            if (this._entityAxioms.get(e3) == null) continue;
            axioms.add((OWLAxiom)OWL.declaration(e3));
        }
        return axioms;
    }

    @Override
    public OWLOntology getModuleFromSignature(Set<OWLEntity> signature) {
        Set<OWLAxiom> moduleAxioms = this.getModuleAxioms(signature);
        return OWL.Ontology(moduleAxioms);
    }

    @Deprecated
    protected Set<OWLEntity> getSignature(OWLAxiom axiom) {
        return axiom.getSignature();
    }

    protected Stream<OWLEntity> signature(OWLAxiom axiom) {
        return axiom.signature();
    }

    @Override
    public boolean isChanged() {
        return !this._additions.isEmpty() || !this._deletions.isEmpty() || this._nonLocalAxioms;
    }

    protected boolean isLocal(OWLAxiom axiom, Set<OWLEntity> signature) {
        return this._localityEvaluator.isLocal(axiom, signature);
    }

    @Override
    @Deprecated
    public void addAxioms(Iterable<OWLAxiom> axioms) {
        for (OWLAxiom axiom : axioms) {
            this.addAxiom(axiom);
        }
    }

    @Override
    public void addAxioms(Stream<OWLAxiom> axioms) {
        axioms.forEach(this::addAxiom);
    }

    private void processAdditions() {
        for (OWLAxiom axiom : this._additions) {
            this._axioms.add(axiom);
            axiom.signature().forEach(entity -> {
                this._entityAxioms.add((OWLEntity)entity, axiom);
                if (entity instanceof OWLClass) {
                    OWLClass cls = (OWLClass)entity;
                    if (this._modules != null && !this._modules.containsKey(cls)) {
                        this._newClasses.add(cls);
                    }
                }
            });
        }
    }

    private void processDeletions() {
        for (OWLAxiom axiom : this._deletions) {
            this._axioms.remove(axiom);
            axiom.signature().forEach(entity -> {
                this._entityAxioms.remove(entity, axiom);
                if (!this._entityAxioms.containsKey(entity)) {
                    _logger.fine(() -> "Remove " + entity + " which is not mentioned anymore");
                    this._modules.remove(entity);
                }
            });
        }
    }

    private void updateEffectedModules(Set<OWLEntity> effects, Taxonomy<OWLClass> taxonomy, boolean add) {
        HashSet<Object> affectedRoots = new HashSet<Object>();
        HashSet<Object> affected = new HashSet<Object>();
        _logger.fine(() -> "Update modules for " + (add ? "_additions" : "_deletions"));
        affectedRoots.addAll(this._newClasses);
        Set<OWLAxiom> axioms = add ? this._additions : this._deletions;
        for (OWLAxiom oWLAxiom : axioms) {
            affectedRoots.addAll(this.getAffectedRoots(oWLAxiom, taxonomy, add));
        }
        _logger.fine(() -> "Affected roots " + affectedRoots);
        for (OWLEntity oWLEntity : affectedRoots) {
            affected.add(oWLEntity);
            if (!(oWLEntity instanceof OWLClass) || !taxonomy.contains((OWLClass)oWLEntity)) continue;
            affected.addAll(taxonomy.getFlattenedSubs((OWLClass)oWLEntity, false));
        }
        _logger.fine(() -> "Affected entities " + affected);
        for (OWLEntity oWLEntity : affected) {
            this._modules.remove(oWLEntity);
        }
        this.extractModuleSignatures(affected);
        for (OWLEntity oWLEntity : affected) {
            Set module = (Set)this._modules.get(oWLEntity);
            if (module == null) {
                String msg = "No module for " + oWLEntity;
                _logger.log(Level.SEVERE, msg, new RuntimeException(msg));
            }
            effects.addAll(module);
        }
    }

    @Override
    public Set<OWLEntity> applyChanges(Taxonomy<OWLClass> taxonomy) throws UnsupportedOperationException {
        Optional<Timer> timer = this._timers.startTimer("updateModules");
        if (!this.canUpdate()) {
            throw new UnsupportedOperationException("Modules cannot be updated!");
        }
        HashSet<OWLEntity> effects = new HashSet<OWLEntity>();
        this.processAdditions();
        this.updateEffectedModules(effects, taxonomy, true);
        this.updateEffectedModules(effects, taxonomy, false);
        this.processDeletions();
        this._additions.clear();
        this._deletions.clear();
        this._changes.clear();
        this._newClasses.clear();
        timer.ifPresent(t -> t.stop());
        return effects;
    }

    @Override
    public Timers getTimers() {
        return this._timers;
    }

    @Override
    public Stream<OWLAxiom> axioms() {
        return this._axioms.stream();
    }

    @Override
    @Deprecated
    public Set<OWLAxiom> getAxioms() {
        return Collections.unmodifiableSet(this._axioms);
    }

    @Override
    public Set<OWLEntity> getEntities() {
        return Collections.unmodifiableSet(this._entityAxioms.keySet());
    }

    public void resetModules() {
        this.processAdditions();
        this._additions.clear();
        this._deletions.clear();
        this._changes.clear();
        this._nonLocalAxioms = false;
        this._modules = new MultiValueMap();
    }

    @Override
    public boolean isClassificationNeeded(Expressivity expressivity) {
        return this.isTBoxChanged() || this.isRBoxChanged() || expressivity.hasNominal() && !OpenlletOptions.USE_PSEUDO_NOMINALS;
    }

    public boolean isTBoxChanged() {
        return this._changes.contains((Object)KnowledgeBase.ChangeType.TBOX_ADD) || this._changes.contains((Object)KnowledgeBase.ChangeType.TBOX_DEL);
    }

    public boolean isRBoxChanged() {
        return this._changes.contains((Object)KnowledgeBase.ChangeType.RBOX_ADD) || this._changes.contains((Object)KnowledgeBase.ChangeType.RBOX_DEL);
    }

    public boolean isABoxChanged() {
        return this._changes.contains((Object)KnowledgeBase.ChangeType.ABOX_ADD) || this._changes.contains((Object)KnowledgeBase.ChangeType.ABOX_DEL);
    }

    private void categorizeAddedAxiom(OWLAxiom axiom) {
        if (ChangeTypeDetector.isTBoxAxiom(axiom)) {
            this._changes.add(KnowledgeBase.ChangeType.TBOX_ADD);
        } else if (ChangeTypeDetector.isRBoxAxiom(axiom)) {
            this._changes.add(KnowledgeBase.ChangeType.RBOX_ADD);
        } else if (ChangeTypeDetector.isABoxAxiom(axiom)) {
            this._changes.add(KnowledgeBase.ChangeType.ABOX_ADD);
        }
    }

    private void categorizeRemovedAxiom(OWLAxiom axiom) {
        if (ChangeTypeDetector.isTBoxAxiom(axiom)) {
            this._changes.add(KnowledgeBase.ChangeType.TBOX_DEL);
        } else if (ChangeTypeDetector.isRBoxAxiom(axiom)) {
            this._changes.add(KnowledgeBase.ChangeType.RBOX_DEL);
        } else if (ChangeTypeDetector.isABoxAxiom(axiom)) {
            this._changes.add(KnowledgeBase.ChangeType.ABOX_DEL);
        }
    }

    @Override
    public void save(ZipOutputStream outputStream) throws IOException, IllegalStateException {
        if (!this._additions.isEmpty() || !this._deletions.isEmpty()) {
            throw new IllegalStateException("The module extractor contains unapplied changes to the modules, and therefore cannot be saved.");
        }
        ZipEntry axiomsEntry = new ZipEntry(MODULE_EXTRACTOR_AXIOMS_FILE_NAME);
        outputStream.putNextEntry(axiomsEntry);
        ModuleExtractorPersistence.saveAxioms(this._axioms, new UncloseableOutputStream(outputStream));
        ZipEntry modulesEntry = new ZipEntry(MODULE_EXTRACTOR_MODULES_FILE_NAME);
        outputStream.putNextEntry(modulesEntry);
        ModuleExtractorPersistence.saveModules(this._modules, new UncloseableOutputStream(outputStream));
        outputStream.flush();
    }

    @Override
    public void load(ZipInputStream inputStream) throws IOException, IllegalArgumentException {
        this.resetModules();
        ZipEntry zipEntry = inputStream.getNextEntry();
        if (!MODULE_EXTRACTOR_AXIOMS_FILE_NAME.equals(zipEntry.getName())) {
            throw new IllegalArgumentException(String.format("Unexpected entry (%s) in ZipInputStream. Expected %s", zipEntry.getName(), MODULE_EXTRACTOR_AXIOMS_FILE_NAME));
        }
        OWLOntology axiomOntology = ModuleExtractorPersistence.loadAxiomOntology(inputStream);
        this._additions.addAll(axiomOntology.axioms().collect(Collectors.toList()));
        this.processAdditions();
        this._additions.clear();
        zipEntry = inputStream.getNextEntry();
        if (!MODULE_EXTRACTOR_MODULES_FILE_NAME.equals(zipEntry.getName())) {
            throw new IllegalArgumentException(String.format("Unexpected entry (%s) in ZipInputStream. Expected %s", zipEntry.getName(), MODULE_EXTRACTOR_MODULES_FILE_NAME));
        }
        this._modules = ModuleExtractorPersistence.loadModules(inputStream);
    }
}

