/*
 * Decompiled with CFR 0.152.
 */
package openllet.modularity;

import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.LocalityEvaluator;
import com.clarkparsia.owlapi.modularity.locality.SyntacticLocalityEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import openllet.core.utils.DisjointSet;
import openllet.core.utils.SetUtils;
import openllet.core.utils.progress.ProgressMonitor;
import openllet.modularity.AbstractModuleExtractor;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;

public class AxiomBasedModuleExtractor
extends AbstractModuleExtractor {
    public static final Logger _logger = Log.getLogger(AxiomBasedModuleExtractor.class);
    private boolean _optimizeForSharedModules = true;

    public AxiomBasedModuleExtractor() {
    }

    public AxiomBasedModuleExtractor(LocalityClass localityClass) {
        super((LocalityEvaluator)new SyntacticLocalityEvaluator(localityClass));
    }

    public AxiomBasedModuleExtractor(LocalityEvaluator localityEvaluator) {
        super(localityEvaluator);
    }

    private OWLEntity extractModuleSignature(OWLEntity entity, Set<OWLEntity> stackElements, List<OWLEntity> currentCycle, Set<OWLEntity> module) {
        assert (!this._modules.containsKey(entity)) : "po already contained entity";
        assert (currentCycle.isEmpty()) : "non-empty current cycle passed into function";
        HashSet<OWLEntity> myCycle = new HashSet<OWLEntity>();
        if (entity != null) {
            module.add(entity);
            myCycle.add(entity);
            stackElements.add(entity);
            this._modules.put(entity, module);
        }
        int oldSize = -1;
        HashSet<Object> previousModule = new HashSet();
        while (module.size() != oldSize) {
            oldSize = module.size();
            ArrayList newMembers = new ArrayList();
            Set<OWLEntity> addedEntities = SetUtils.difference(module, previousModule);
            previousModule = new HashSet<OWLEntity>(module);
            HashSet testLocal = new HashSet();
            for (OWLEntity e2 : addedEntities) {
                this.axioms(e2).filter(a -> testLocal.add(a) && !this.isLocal((OWLAxiom)a, module)).forEach(a -> this.signature((OWLAxiom)a).filter(module::add).forEach(newMembers::add));
            }
            for (OWLEntity member : newMembers) {
                if (myCycle.contains(member)) continue;
                if (!this._modules.containsKey(member)) {
                    HashSet<OWLEntity> memberMod = new HashSet<OWLEntity>();
                    ArrayList<OWLEntity> memberCycle = new ArrayList<OWLEntity>();
                    OWLEntity root2 = this.extractModuleSignature(member, stackElements, memberCycle, memberMod);
                    module.addAll(memberMod);
                    if (root2.equals(member)) {
                        assert (!stackElements.contains(member)) : "Recursive call did not cleanup stack";
                        continue;
                    }
                    myCycle.addAll(memberCycle);
                    if (myCycle.contains(root2)) {
                        stackElements.addAll(memberCycle);
                        continue;
                    }
                    currentCycle.addAll(myCycle);
                    return root2;
                }
                if (stackElements.contains(member)) {
                    currentCycle.addAll(myCycle);
                    return member;
                }
                module.addAll((Collection)this._modules.get(member));
            }
            for (OWLEntity e3 : myCycle) {
                this._modules.put(e3, module);
            }
        }
        stackElements.removeAll(myCycle);
        return entity;
    }

    private void extractModuleSignature(OWLEntity entity, DisjointSet<OWLEntity> modEqCls, ArrayList<OWLEntity> stack, Set<OWLEntity> stackElements) {
        assert (!stack.contains(entity)) : "stack contained entity already";
        assert (!this._modules.containsKey(entity)) : "po already contained entity";
        HashSet<OWLEntity> module = new HashSet<OWLEntity>();
        if (entity != null) {
            stack.add(entity);
            stackElements.add(entity);
            modEqCls.add(entity);
            module.add(entity);
            this._modules.put(entity, module);
        }
        int oldSize = -1;
        HashSet previousModule = new HashSet();
        while (module.size() != oldSize) {
            oldSize = module.size();
            ArrayList newMembers = new ArrayList();
            Set addedEntities = SetUtils.difference(module, previousModule);
            previousModule = new HashSet(module);
            HashSet testLocal = new HashSet();
            Iterator iterator = addedEntities.iterator();
            while (iterator.hasNext()) {
                OWLEntity e2 = (OWLEntity)iterator.next();
                this.axioms(e2).filter(a -> testLocal.add(a) && !this.isLocal((OWLAxiom)a, (Set<OWLEntity>)module)).forEach(a -> this.signature((OWLAxiom)a).filter(module::add).forEach(newMembers::add));
            }
            for (OWLEntity member : newMembers) {
                if (member.equals(entity)) continue;
                if (!this._modules.containsKey(member)) {
                    this.extractModuleSignature(member, modEqCls, stack, stackElements);
                }
                if (stackElements.contains(member)) {
                    assert (stack.contains(member)) : "node was supposed to be on the stack";
                    boolean foundMember = false;
                    int i = stack.size() - 1;
                    while (!foundMember) {
                        OWLEntity next = stack.get(i);
                        modEqCls.union(member, next);
                        foundMember = next.equals(member);
                        --i;
                    }
                    continue;
                }
                module.addAll((Collection)this._modules.get(member));
            }
        }
        for (OWLEntity other : modEqCls.elements()) {
            if (!modEqCls.isSame(entity, other)) continue;
            ((Set)this._modules.get(other)).addAll(module);
        }
        stack.remove(stack.size() - 1);
        stackElements.remove(entity);
    }

    @Override
    protected void extractModuleSignatures(Set<? extends OWLEntity> entities, ProgressMonitor monitor) {
        HashSet nonLocalModule = new HashSet();
        this.axioms().filter(axiom -> !this.isLocal((OWLAxiom)axiom, Collections.emptySet())).forEach(axiom -> nonLocalModule.addAll(axiom.signature().collect(Collectors.toList())));
        for (OWLEntity oWLEntity : entities) {
            monitor.incrementProgress();
            if (!(oWLEntity instanceof OWLClass)) continue;
            _logger.fine(() -> "Class: " + ent);
            if (this._modules.containsKey(oWLEntity)) continue;
            if (this._optimizeForSharedModules) {
                this.extractModuleSignature(oWLEntity, new HashSet<OWLEntity>(), new ArrayList<OWLEntity>(), new HashSet<OWLEntity>(nonLocalModule));
                continue;
            }
            this.extractModuleSignature(oWLEntity, new DisjointSet<OWLEntity>(), new ArrayList<OWLEntity>(), new HashSet<OWLEntity>(nonLocalModule));
        }
    }

    @Override
    public Set<OWLAxiom> extractModule(Set<? extends OWLEntity> signature) {
        if (this.isChanged()) {
            this.resetModules();
        }
        HashSet<OWLEntity> module = new HashSet<OWLEntity>(signature);
        this.axioms().filter(axiom -> !this.isLocal((OWLAxiom)axiom, Collections.emptySet())).forEach(axiom -> module.addAll(axiom.signature().collect(Collectors.toList())));
        if (!this._entityAxioms.isEmpty()) {
            if (this._optimizeForSharedModules) {
                this.extractModuleSignature(null, new HashSet<OWLEntity>(), new ArrayList<OWLEntity>(), module);
            } else {
                this.extractModuleSignature(null, new DisjointSet<OWLEntity>(), new ArrayList<OWLEntity>(), module);
            }
        }
        return this.getModuleAxioms(module);
    }

    public boolean isOptimizeForSharedModules() {
        return this._optimizeForSharedModules;
    }

    public void setOptimizeForSharedModules(boolean optimizeForSharedModules) {
        this._optimizeForSharedModules = optimizeForSharedModules;
    }
}

