/*
 * Decompiled with CFR 0.152.
 */
package openllet.modularity;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyUtils;
import openllet.modularity.IncrementalClassifier;
import openllet.owlapi.OWL;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.model.AsOWLClass;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;

public class EntailmentChecker
implements OWLAxiomVisitor {
    public static Logger _logger = Log.getLogger(EntailmentChecker.class);
    private final IncrementalClassifier _reasoner;
    private volatile Boolean _isEntailed;

    public EntailmentChecker(IncrementalClassifier reasoner) {
        this._reasoner = reasoner;
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) {
        for (OWLAxiom oWLAxiom : axioms) {
            if (this.isEntailed(oWLAxiom)) continue;
            return false;
        }
        return true;
    }

    public boolean isEntailed(OWLAxiom axiom) {
        this._isEntailed = null;
        axiom.accept((OWLAxiomVisitor)this);
        if (this._isEntailed == null) {
            throw new UnsupportedEntailmentTypeException(axiom);
        }
        return this._isEntailed;
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        OWLClassExpression subClass = axiom.getSubClass();
        OWLClassExpression superClass = axiom.getSuperClass();
        this._isEntailed = !this._reasoner.isClassified() || subClass.isAnonymous() || superClass.isAnonymous() ? Boolean.valueOf(this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom)) : Boolean.valueOf(this._reasoner.getTaxonomy().isSubNodeOf((OWLClass)subClass, (OWLClass)superClass).isTrue());
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        this._isEntailed = true;
        Iterator i = axiom.classExpressions().iterator();
        if (i.hasNext()) {
            OWLClassExpression first = (OWLClassExpression)i.next();
            while (i.hasNext() && this._isEntailed.booleanValue()) {
                OWLClassExpression next = (OWLClassExpression)i.next();
                if (!this._reasoner.isClassified() || first.isAnonymous() || next.isAnonymous()) {
                    this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)OWL.equivalentClasses(first, next));
                    continue;
                }
                this._isEntailed = this._reasoner.getTaxonomy().isEquivalent((OWLClass)first, (OWLClass)next).isTrue();
            }
        }
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        if (this._reasoner.isRealized()) {
            boolean sameTypes = true;
            Taxonomy<OWLClass> taxonomy = this._reasoner.getTaxonomy();
            Iterator i = axiom.individuals().iterator();
            if (i.hasNext()) {
                OWLIndividual first = (OWLIndividual)i.next();
                Set firstTypes = EntailmentChecker.flatten(TaxonomyUtils.getTypes(taxonomy, first, true));
                while (i.hasNext() && sameTypes) {
                    OWLIndividual next = (OWLIndividual)i.next();
                    Set nextTypes = EntailmentChecker.flatten(TaxonomyUtils.getTypes(taxonomy, next, true));
                    sameTypes = firstTypes.equals(nextTypes);
                }
                this._isEntailed = sameTypes ? Boolean.valueOf(this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom)) : Boolean.valueOf(false);
            }
        } else {
            this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
        }
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        OWLClass[] classes;
        this._isEntailed = this._reasoner.isClassified() && !EntailmentChecker.containsAnonymousClasses(axiom.classExpressions()) ? (this.possiblyDisjoint(classes = (OWLClass[])axiom.classExpressions().map(AsOWLClass::asOWLClass).toArray(OWLClass[]::new)) ? Boolean.valueOf(this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom)) : Boolean.valueOf(false)) : Boolean.valueOf(this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom));
    }

    private boolean possiblyDisjoint(OWLClass[] classes) {
        for (int i = 0; i < classes.length - 1; ++i) {
            for (int j = i + 1; j < classes.length; ++j) {
                if (this.possiblyDisjoint(classes[i], classes[j])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean possiblyDisjoint(OWLClass first, OWLClass next) {
        Taxonomy<OWLClass> taxonomy = this._reasoner.getTaxonomy();
        if (taxonomy.getAllEquivalents(first).contains(next)) {
            return false;
        }
        if (taxonomy.getFlattenedSupers(first, false).contains(next)) {
            return false;
        }
        return !taxonomy.getFlattenedSupers(next, false).contains(first);
    }

    private static boolean containsAnonymousClasses(Stream<OWLClassExpression> classExpressions) {
        return classExpressions.filter(IsAnonymous::isAnonymous).findAny().isPresent();
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        this._isEntailed = this._reasoner.isRealized() && !axiom.getClassExpression().isAnonymous() ? Boolean.valueOf(EntailmentChecker.contains(TaxonomyUtils.getTypes(this._reasoner.getTaxonomy(), axiom.getIndividual(), false), axiom.getClassExpression().asOWLClass())) : Boolean.valueOf(this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom));
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLHasKeyAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)axiom);
    }

    public void visit(SWRLRule rule) {
        this._isEntailed = this._reasoner.getReasoner().isEntailed((OWLAxiom)rule);
    }

    private static <T> boolean contains(Set<Set<T>> setOfSets, T element) {
        for (Set<T> set : setOfSets) {
            if (!set.contains(element)) continue;
            return true;
        }
        return false;
    }

    private static <T> Set<T> flatten(Set<Set<T>> setOfSets) {
        HashSet<T> result = new HashSet<T>();
        for (Set<T> set : setOfSets) {
            result.addAll(set);
        }
        return result;
    }
}

