/*
 * Decompiled with CFR 0.152.
 */
package openllet.modularity;

import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import openllet.core.utils.Timer;
import openllet.core.utils.progress.ProgressMonitor;
import openllet.modularity.AbstractModuleExtractor;
import openllet.modularity.GraphBuilder;
import openllet.reachability.EntityNode;
import openllet.reachability.Node;
import openllet.reachability.PairSet;
import openllet.reachability.Reachability;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.model.AsOWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;

public class GraphBasedModuleExtractor
extends AbstractModuleExtractor {
    public static final Logger _logger = Log.getLogger(GraphBasedModuleExtractor.class);

    @Override
    protected void extractModuleSignatures(Set<? extends OWLEntity> entities, ProgressMonitor monitor) {
        Reachability<AsOWLNamedIndividual> graph;
        Optional<Timer> timer = this.getTimers().startTimer("buildGraph");
        GraphBuilder builder = new GraphBuilder();
        this.axioms().forEach(builder::addAxiom);
        Reachability<AsOWLNamedIndividual> engine = graph = new Reachability<AsOWLNamedIndividual>(builder.build());
        timer.ifPresent(t -> t.stop());
        _logger.finer(() -> String.format("Built graph in %d ms", timer.map(t -> t.getLast()).orElse(0L)));
        for (OWLEntity oWLEntity : entities) {
            if (!(oWLEntity instanceof OWLClass)) {
                monitor.incrementProgress();
                continue;
            }
            _logger.fine(() -> "Compute module for " + ent);
            Set module = (Set)this._modules.get(oWLEntity);
            if (module != null) {
                _logger.fine(() -> "Existing module size " + module.size());
                continue;
            }
            EntityNode<AsOWLNamedIndividual> node = engine.getGraph().getNode((AsOWLNamedIndividual)oWLEntity);
            _logger.fine(() -> "Node " + node);
            if (node == null) {
                this._modules.put(oWLEntity, Collections.singleton(oWLEntity));
                continue;
            }
            this.extractModule(engine, node, entities, monitor);
        }
    }

    private Set<OWLEntity> extractModule(Reachability<OWLEntity> engine, EntityNode<OWLEntity> node, Set<? extends OWLEntity> entities, ProgressMonitor monitor) {
        Node output;
        OWLEntity n2;
        _logger.fine(() -> "Extract module for " + node);
        Set<OWLEntity> module = null;
        Iterator<OWLEntity> iterator = node.getEntities().iterator();
        while (iterator.hasNext() && (module = (Set<OWLEntity>)this._modules.get(n2 = iterator.next())) == null) {
        }
        if (module == null && node.getOutputs().size() == 1 && (output = node.getOutputs().iterator().next()).isEntityNode()) {
            Set<OWLEntity> outputModule = this.extractModule(engine, output.asEntityNode(), entities, monitor);
            _logger.fine(() -> "Cached module size " + outputModule.size());
            module = new PairSet<OWLEntity>(outputModule, node.getEntities());
        }
        if (module == null) {
            module = engine.computeReachable(node.getEntities());
        }
        _logger.fine(() -> "Setting the module for " + node.getEntities());
        for (OWLEntity n2 : node.getEntities()) {
            Set<OWLEntity> prevModule = this._modules.put(n2, module);
            if (prevModule != null) {
                if (prevModule.equals(module)) continue;
                _logger.warning(String.format("Possible discrepancy for the module of %s ( Previous %s , Current %s )", n2, prevModule, module));
                continue;
            }
            if (!entities.contains(n2)) continue;
            monitor.incrementProgress();
        }
        return module;
    }

    @Override
    public Set<OWLAxiom> extractModule(Set<? extends OWLEntity> signature) {
        throw new UnsupportedOperationException();
    }
}

