/*
 * Decompiled with CFR 0.152.
 */
package openllet.modularity;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import openllet.core.utils.SetUtils;
import openllet.owlapi.OWL;
import openllet.reachability.EntityNode;
import openllet.reachability.Node;
import openllet.reachability.ReachabilityGraph;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.model.AsOWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class GraphBuilder {
    public static final Logger _logger = Log.getLogger(GraphBuilder.class);
    private final ReachabilityGraph<AsOWLNamedIndividual> _graph = new ReachabilityGraph();
    private final AxiomVisitor _axiomVisitor = new AxiomVisitor();
    private final BottomEvaluator _bottomEvaluator = new BottomEvaluator();
    private final TopEvaluator _topEvaluator = new TopEvaluator();
    private final Node NULL_NODE = this._graph.getNullNode();
    private final Node START_NODE = this._graph.getStartNode();

    public void addAxiom(OWLAxiom axiom) {
        axiom.accept((OWLAxiomVisitor)this._axiomVisitor);
    }

    private void addOutputs(Node node, OWLAxiom axiom) {
        if (node.equals(this.NULL_NODE)) {
            return;
        }
        axiom.signature().map(this._graph::createEntityNode).forEach(node::addOutput);
    }

    private void addOutputs(OWLAxiom axiom) {
        OWLEntity[] entities = (OWLEntity[])axiom.signature().toArray(OWLEntity[]::new);
        int n = entities.length;
        for (int i = 0; i < n - 1; ++i) {
            EntityNode<AsOWLNamedIndividual> n1 = this._graph.createEntityNode((AsOWLNamedIndividual)entities[i]);
            for (int j = i + 1; j < n; ++j) {
                EntityNode<AsOWLNamedIndividual> n2 = this._graph.createEntityNode((AsOWLNamedIndividual)entities[j]);
                n1.addOutput(n2);
                n2.addOutput(n1);
            }
        }
    }

    public ReachabilityGraph<AsOWLNamedIndividual> build() {
        this._graph.simplify();
        return this._graph;
    }

    private class TopEvaluator
    implements OWLClassExpressionVisitor {
        private Node _node;

        public Node evaluate(OWLClassExpression desc) {
            this._node = null;
            desc.accept((OWLClassExpressionVisitor)this);
            if (this._node == null) {
                throw new IllegalStateException("Evaluation returned null");
            }
            return this._node;
        }

        public void visit(OWLClass desc) {
            this._node = desc.equals(OWL.Thing) ? GraphBuilder.this.NULL_NODE : GraphBuilder.this.START_NODE;
        }

        public void visit(OWLDataAllValuesFrom desc) {
            this._node = GraphBuilder.this._graph.createEntityNode(desc.getProperty().asOWLDataProperty());
        }

        public void visit(OWLDataExactCardinality desc) {
            this._node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLDataMaxCardinality desc) {
            this._node = GraphBuilder.this._graph.createEntityNode(desc.getProperty().asOWLDataProperty());
        }

        public void visit(OWLDataMinCardinality desc) {
            this._node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLDataSomeValuesFrom desc) {
            this._node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLDataHasValue desc) {
            this._node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectAllValuesFrom desc) {
            HashSet<Node> inputNodes = new HashSet<Node>();
            inputNodes.add(GraphBuilder.this._graph.createEntityNode(desc.getProperty().getNamedProperty()));
            inputNodes.add(this.evaluate((OWLClassExpression)desc.getFiller()));
            this._node = GraphBuilder.this._graph.createAndNode(inputNodes);
        }

        public void visit(OWLObjectComplementOf desc) {
            this._node = GraphBuilder.this._bottomEvaluator.evaluate(desc.getOperand());
        }

        public void visit(OWLObjectExactCardinality desc) {
            this._node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectIntersectionOf desc) {
            Set<Node> inputNodes = desc.operands().map(this::evaluate).collect(Collectors.toSet());
            this._node = GraphBuilder.this._graph.createOrNode(inputNodes);
        }

        public void visit(OWLObjectMaxCardinality desc) {
            this._node = GraphBuilder.this._graph.createEntityNode(desc.getProperty().getNamedProperty());
        }

        public void visit(OWLObjectMinCardinality desc) {
            this._node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectOneOf desc) {
            this._node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectHasSelf desc) {
            this._node = GraphBuilder.this.NULL_NODE;
        }

        public void visit(OWLObjectSomeValuesFrom desc) {
            this._node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectUnionOf desc) {
            Set<Node> inputNodes = desc.operands().map(this::evaluate).collect(Collectors.toSet());
            if (!inputNodes.isEmpty()) {
                this._node = GraphBuilder.this._graph.createAndNode(inputNodes);
            }
        }

        public void visit(OWLObjectHasValue desc) {
            this._node = GraphBuilder.this.START_NODE;
        }
    }

    private class BottomEvaluator
    implements OWLClassExpressionVisitor {
        private Node _node;

        public Node evaluate(OWLClassExpression desc) {
            this._node = null;
            desc.accept((OWLClassExpressionVisitor)this);
            if (this._node == null) {
                throw new IllegalStateException("Evaluation returned null");
            }
            return this._node;
        }

        public void visit(OWLClass desc) {
            this._node = desc.equals(OWL.Nothing) ? GraphBuilder.this.START_NODE : (desc.equals(OWL.Thing) ? GraphBuilder.this.NULL_NODE : GraphBuilder.this._graph.createEntityNode(desc));
        }

        public void visit(OWLDataAllValuesFrom desc) {
            this._node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLDataExactCardinality desc) {
            this._node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLDataMaxCardinality desc) {
            this._node = desc.getCardinality() == 0 ? GraphBuilder.this._graph.createEntityNode(desc.getProperty().asOWLDataProperty()) : GraphBuilder.this.START_NODE;
        }

        public void visit(OWLDataMinCardinality desc) {
            this._node = GraphBuilder.this._graph.createEntityNode(desc.getProperty().asOWLDataProperty());
        }

        public void visit(OWLDataSomeValuesFrom desc) {
            this._node = GraphBuilder.this._graph.createEntityNode(desc.getProperty().asOWLDataProperty());
        }

        public void visit(OWLDataHasValue desc) {
            this._node = GraphBuilder.this._graph.createEntityNode(desc.getProperty().asOWLDataProperty());
        }

        public void visit(OWLObjectAllValuesFrom desc) {
            this._node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectComplementOf desc) {
            this._node = GraphBuilder.this._topEvaluator.evaluate(desc.getOperand());
        }

        public void visit(OWLObjectExactCardinality desc) {
            this._node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectIntersectionOf desc) {
            Set<Node> inputNodes = desc.operands().map(this::evaluate).collect(Collectors.toSet());
            if (!inputNodes.isEmpty()) {
                this._node = GraphBuilder.this._graph.createAndNode(inputNodes);
            }
        }

        public void visit(OWLObjectMaxCardinality desc) {
            this._node = desc.getCardinality() == 0 ? GraphBuilder.this._graph.createEntityNode(desc.getProperty().getNamedProperty()) : GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectMinCardinality desc) {
            this._node = GraphBuilder.this._graph.createEntityNode(desc.getProperty().getNamedProperty());
        }

        public void visit(OWLObjectOneOf desc) {
            this._node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectHasSelf desc) {
            this._node = GraphBuilder.this._graph.createEntityNode(desc.getProperty().getNamedProperty());
        }

        public void visit(OWLObjectSomeValuesFrom desc) {
            HashSet<Node> inputNodes = new HashSet<Node>();
            inputNodes.add(GraphBuilder.this._graph.createEntityNode(desc.getProperty().getNamedProperty()));
            inputNodes.add(this.evaluate((OWLClassExpression)desc.getFiller()));
            this._node = GraphBuilder.this._graph.createAndNode(inputNodes);
        }

        public void visit(OWLObjectUnionOf desc) {
            Set<Node> inputNodes = desc.operands().map(this::evaluate).collect(Collectors.toSet());
            this._node = GraphBuilder.this._graph.createOrNode(inputNodes);
        }

        public void visit(OWLObjectHasValue desc) {
            this._node = GraphBuilder.this._graph.createEntityNode(desc.getProperty().getNamedProperty());
        }
    }

    private class AxiomVisitor
    implements OWLAxiomVisitor {
        public void visit(OWLClassAssertionAxiom axiom) {
            if (axiom.getIndividual().isAnonymous()) {
                return;
            }
            Node node = GraphBuilder.this._bottomEvaluator.evaluate(axiom.getClassExpression());
            GraphBuilder.this.addOutputs(node, (OWLAxiom)axiom);
            GraphBuilder.this.addOutputs(GraphBuilder.this._graph.createEntityNode(axiom.getIndividual()), (OWLAxiom)axiom);
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            HashSet<Node> nodes = new HashSet<Node>();
            nodes.add(GraphBuilder.this._graph.createEntityNode(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()));
            nodes.add(GraphBuilder.this._topEvaluator.evaluate((OWLClassExpression)axiom.getDomain()));
            GraphBuilder.this.addOutputs(GraphBuilder.this._graph.createAndNode(nodes), (OWLAxiom)axiom);
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            EntityNode<OWLDataProperty> subNode = GraphBuilder.this._graph.createEntityNode(((OWLDataPropertyExpression)axiom.getSubProperty()).asOWLDataProperty());
            EntityNode<OWLDataProperty> supNode = GraphBuilder.this._graph.createEntityNode(((OWLDataPropertyExpression)axiom.getSuperProperty()).asOWLDataProperty());
            subNode.getOutputs().add(supNode);
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            this.processDisjoints((OWLAxiom)axiom, axiom.classExpressions());
        }

        protected void processDisjoints(OWLAxiom axiom, Stream<OWLClassExpression> desc) {
            OWLClassExpression[] descriptions = (OWLClassExpression[])desc.toArray(OWLClassExpression[]::new);
            HashSet<Node> or = new HashSet<Node>();
            for (int i = 0; i < descriptions.length - 1; ++i) {
                for (int j = i; j < descriptions.length; ++j) {
                    Node n1 = GraphBuilder.this._bottomEvaluator.evaluate(descriptions[i]);
                    Node n2 = GraphBuilder.this._bottomEvaluator.evaluate(descriptions[j]);
                    or.add(GraphBuilder.this._graph.createAndNode(SetUtils.create(n1, n2)));
                }
            }
            if (!or.isEmpty()) {
                if (or.size() == 1) {
                    GraphBuilder.this.addOutputs((Node)or.iterator().next(), axiom);
                } else {
                    GraphBuilder.this.addOutputs(GraphBuilder.this._graph.createOrNode(or), axiom);
                }
            }
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            this.processDisjoints((OWLAxiom)axiom, axiom.classExpressions());
            this.processEquivalent((OWLAxiom)axiom, (OWLClassExpression)axiom.getOWLClass(), (OWLClassExpression)OWL.or(axiom.classExpressions()));
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            Iterator eqs = axiom.classExpressions().iterator();
            OWLClassExpression c1 = (OWLClassExpression)eqs.next();
            if (!eqs.hasNext()) {
                return;
            }
            OWLClassExpression c2 = (OWLClassExpression)eqs.next();
            if (eqs.hasNext()) {
                throw new UnsupportedOperationException("OWLEquivalentClassesAxiom with more than 2 elements");
            }
            this.processEquivalent((OWLAxiom)axiom, c1, c2);
        }

        protected void processEquivalent(OWLAxiom axiom, OWLClassExpression c1, OWLClassExpression c2) {
            HashSet<Node> nodes1 = new HashSet<Node>();
            nodes1.add(GraphBuilder.this._topEvaluator.evaluate(c1));
            nodes1.add(GraphBuilder.this._topEvaluator.evaluate(c2));
            HashSet<Node> nodes2 = new HashSet<Node>();
            nodes2.add(GraphBuilder.this._bottomEvaluator.evaluate(c1));
            nodes2.add(GraphBuilder.this._bottomEvaluator.evaluate(c2));
            Node or1 = GraphBuilder.this._graph.createOrNode(nodes1);
            Node or2 = GraphBuilder.this._graph.createOrNode(nodes2);
            Node result = GraphBuilder.this._graph.createAndNode(SetUtils.create(or1, or2));
            GraphBuilder.this.addOutputs(result, axiom);
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            HashSet<Node> nodes = new HashSet<Node>();
            for (OWLObjectPropertyExpression p : axiom.getPropertyChain()) {
                nodes.add(GraphBuilder.this._graph.createEntityNode(p.getNamedProperty()));
            }
            GraphBuilder.this.addOutputs(GraphBuilder.this._graph.createAndNode(nodes), (OWLAxiom)axiom);
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            HashSet<Node> nodes = new HashSet<Node>();
            nodes.add(GraphBuilder.this._graph.createEntityNode(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty()));
            nodes.add(GraphBuilder.this._topEvaluator.evaluate((OWLClassExpression)axiom.getDomain()));
            GraphBuilder.this.addOutputs(GraphBuilder.this._graph.createAndNode(nodes), (OWLAxiom)axiom);
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            HashSet<Node> nodes = new HashSet<Node>();
            nodes.add(GraphBuilder.this._graph.createEntityNode(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty()));
            nodes.add(GraphBuilder.this._topEvaluator.evaluate((OWLClassExpression)axiom.getRange()));
            GraphBuilder.this.addOutputs(GraphBuilder.this._graph.createAndNode(nodes), (OWLAxiom)axiom);
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            EntityNode<OWLObjectProperty> subNode = GraphBuilder.this._graph.createEntityNode(((OWLObjectPropertyExpression)axiom.getSubProperty()).getNamedProperty());
            EntityNode<OWLObjectProperty> supNode = GraphBuilder.this._graph.createEntityNode(((OWLObjectPropertyExpression)axiom.getSuperProperty()).getNamedProperty());
            subNode.addOutput(supNode);
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            HashSet<Node> nodes = new HashSet<Node>();
            nodes.add(GraphBuilder.this._topEvaluator.evaluate(axiom.getSuperClass()));
            nodes.add(GraphBuilder.this._bottomEvaluator.evaluate(axiom.getSubClass()));
            if (!nodes.isEmpty()) {
                GraphBuilder.this.addOutputs(GraphBuilder.this._graph.createAndNode(nodes), (OWLAxiom)axiom);
            }
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        }

        public void visit(SWRLRule axiom) {
        }
    }
}

