/*
 * Decompiled with CFR 0.152.
 */
package openllet.modularity;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import openllet.aterm.ATermAppl;
import openllet.atom.OpenError;
import openllet.core.exceptions.PelletRuntimeException;
import openllet.core.exceptions.TimeoutException;
import openllet.core.exceptions.TimerInterruptedException;
import openllet.core.exceptions.UndefinedEntityException;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyImpl;
import openllet.core.taxonomy.TaxonomyNode;
import openllet.core.taxonomy.TaxonomyUtils;
import openllet.core.taxonomy.printer.ClassTreePrinter;
import openllet.core.taxonomy.printer.TreeTaxonomyPrinter;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.Bool;
import openllet.core.utils.MultiValueMap;
import openllet.core.utils.PartialOrderBuilder;
import openllet.core.utils.PartialOrderComparator;
import openllet.core.utils.PartialOrderRelation;
import openllet.core.utils.Timer;
import openllet.core.utils.Timers;
import openllet.modularity.EntailmentChecker;
import openllet.modularity.ModuleExtractor;
import openllet.modularity.ModuleExtractorFactory;
import openllet.modularity.OntologyDiff;
import openllet.owlapi.OWL;
import openllet.owlapi.OpenlletReasoner;
import openllet.owlapi.OpenlletReasonerFactory;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasAxioms;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.NodeFactory;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.util.Version;

public class IncrementalClassifier
implements OWLReasoner,
OWLOntologyChangeListener {
    public static final String _namedClassesSupportOnly = "This reasoner only supports named classes";
    public static final Logger _logger = Log.getLogger(IncrementalClassifier.class);
    private volatile MultiValueMap<OWLEntity, OWLEntity> _modules = null;
    private final OpenlletReasoner _reasoner;
    private volatile ModuleExtractor _extractor = ModuleExtractorFactory.createModuleExtractor();
    private volatile Taxonomy<OWLClass> _taxonomyImpl = null;
    private volatile boolean _multiThreaded = true;
    public volatile Timers _timers = this._extractor.getTimers();
    private final Random RND = new Random();
    private volatile boolean _realized = false;
    private static final ATermAppl OWL_THING = ATermUtils.makeTermAppl("http://www.w3.org/2002/07/owl#Thing");
    private static final ATermAppl OWL_NOTHING = ATermUtils.makeTermAppl("http://www.w3.org/2002/07/owl#Nothing");

    public IncrementalClassifier(OWLOntology ontology) {
        this(OpenlletReasonerFactory.getInstance().createReasoner(ontology), ModuleExtractorFactory.createModuleExtractor());
    }

    public IncrementalClassifier(OWLOntology ontology, OWLReasonerConfiguration config) {
        this(OpenlletReasonerFactory.getInstance().createReasoner(ontology, config), ModuleExtractorFactory.createModuleExtractor());
    }

    public IncrementalClassifier(OWLOntology ontology, ModuleExtractor moduleExtractor) {
        this(OpenlletReasonerFactory.getInstance().createReasoner(ontology), moduleExtractor);
    }

    public IncrementalClassifier(OWLOntology ontology, OWLReasonerConfiguration config, ModuleExtractor moduleExtractor) {
        this(OpenlletReasonerFactory.getInstance().createReasoner(ontology, config), moduleExtractor);
    }

    public IncrementalClassifier(OpenlletReasoner reasoner) {
        this(reasoner, ModuleExtractorFactory.createModuleExtractor());
    }

    public IncrementalClassifier(OpenlletReasoner reasoner, ModuleExtractor extractor) {
        this._reasoner = reasoner;
        this._extractor = extractor;
        OWLOntology ontology = reasoner.getRootOntology();
        ontology.importsClosure().map(HasAxioms::axioms).forEach(extractor::addAxioms);
        reasoner.getManager().addOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public IncrementalClassifier(PersistedState persistedState) {
        this._extractor = persistedState.getModuleExtractor();
        this._taxonomyImpl = persistedState.getTaxonomy();
        this._realized = persistedState.isRealized();
        this._modules = this._extractor.getModules();
        OWLOntology ontology = OWL.Ontology(this._extractor.axioms());
        this._reasoner = OpenlletReasonerFactory.getInstance().createReasoner(ontology);
        this._reasoner.getManager().addOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public IncrementalClassifier(PersistedState persistedState, OWLOntology ontology) {
        this._reasoner = OpenlletReasonerFactory.getInstance().createReasoner(ontology);
        this._extractor = persistedState.getModuleExtractor();
        this._taxonomyImpl = persistedState.getTaxonomy();
        this._realized = persistedState.isRealized();
        this._modules = this._extractor.getModules();
        OntologyDiff diff = OntologyDiff.diffAxiomsWithOntologies(this._extractor.axioms(), Collections.singleton(ontology));
        if (!diff.areSame()) {
            for (OWLAxiom addition : diff.getAdditions()) {
                this._extractor.addAxiom(addition);
            }
            for (OWLAxiom deletion : diff.getDeletions()) {
                this._extractor.deleteAxiom(deletion);
            }
        }
        this._reasoner.getManager().addOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    @Deprecated
    public Collection<OWLAxiom> getAxioms() {
        return this._extractor.getAxioms();
    }

    public Stream<OWLAxiom> axioms() {
        return this._extractor.axioms();
    }

    public static Taxonomy<OWLClass> buildClassHierarchy(OpenlletReasoner reasoner) {
        TaxonomyImpl<OWLClass> taxonomy = new TaxonomyImpl<OWLClass>(null, OWL.Thing, OWL.Nothing);
        Set things = reasoner.getEquivalentClasses((OWLClassExpression)OWL.Thing).entities().collect(Collectors.toSet());
        things.remove(OWL.Thing);
        if (!things.isEmpty()) {
            taxonomy.addEquivalents(OWL.Thing, things);
        }
        Set nothings = reasoner.getEquivalentClasses((OWLClassExpression)OWL.Nothing).entities().collect(Collectors.toSet());
        nothings.remove(OWL.Nothing);
        if (!nothings.isEmpty()) {
            taxonomy.addEquivalents(OWL.Nothing, nothings);
        }
        for (Node subEq : reasoner.getSubClasses((OWLClassExpression)OWL.Thing, true)) {
            IncrementalClassifier.recursiveBuild(taxonomy, (Node<OWLClass>)subEq, reasoner);
        }
        return taxonomy;
    }

    private static void recursiveBuild(Taxonomy<OWLClass> taxonomy, Node<OWLClass> eqClasses, OpenlletReasoner reasoner) {
        assert (eqClasses.entities().findAny().isPresent()) : "Equivalents empty as passed";
        OWLClass cls = (OWLClass)eqClasses.iterator().next();
        if (taxonomy.contains(cls)) {
            return;
        }
        Set emptySet = Collections.emptySet();
        taxonomy.addNode(eqClasses.entities().collect(Collectors.toList()), emptySet, emptySet, false);
        for (Node subEq : reasoner.getSubClasses((OWLClassExpression)cls, true)) {
            IncrementalClassifier.recursiveBuild(taxonomy, (Node<OWLClass>)subEq, reasoner);
            taxonomy.addSuper((OWLClass)subEq.iterator().next(), cls);
        }
    }

    public void classify() {
        if (this.isClassified()) {
            if (this._extractor.isChanged()) {
                this._extractor.applyChanges(this._taxonomyImpl);
            }
            return;
        }
        if (this._extractor.canUpdate()) {
            this.incrementalClassify();
        } else {
            this.regularClassify();
        }
        this.resetRealization();
    }

    public void dispose() {
        this._reasoner.getManager().removeOntologyChangeListener((OWLOntologyChangeListener)this);
        this._reasoner.dispose();
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression clsC) {
        if (clsC.isAnonymous()) {
            throw new IllegalArgumentException(_namedClassesSupportOnly);
        }
        this.classify();
        return NodeFactory.getOWLClassNode(this._taxonomyImpl.getAllEquivalents((OWLClass)clsC));
    }

    public MultiValueMap<OWLEntity, OWLEntity> getModules() {
        return this._modules;
    }

    public OpenlletReasoner getReasoner() {
        return this._reasoner;
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression clsC, boolean direct) {
        if (clsC.isAnonymous()) {
            throw new UnsupportedOperationException(_namedClassesSupportOnly);
        }
        this.classify();
        HashSet<DefaultNode> values = new HashSet<DefaultNode>();
        for (Set<OWLClass> val : this._taxonomyImpl.getSubs((OWLClass)clsC, direct)) {
            values.add(NodeFactory.getOWLClassNode(val));
        }
        return new OWLClassNodeSet(values);
    }

    private void incClassifyAllModStrategy() {
        Set<OWLEntity> effects = this._extractor.applyChanges(this._taxonomyImpl);
        _logger.fine(() -> "Module entities " + effects);
        OWLOntology owlModule = this._extractor.getModuleFromSignature(effects);
        _logger.fine(() -> "Module axioms " + owlModule.logicalAxioms().map(Object::toString).collect(Collectors.joining(" ")));
        OpenlletReasoner moduleReasoner = OpenlletReasonerFactory.getInstance().createReasoner(owlModule);
        moduleReasoner.getKB().classify();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Classified module:");
            new ClassTreePrinter().print(moduleReasoner.getKB().getTaxonomy(), new PrintWriter(System.err));
        }
        Taxonomy<OWLClass> moduleTaxonomy = IncrementalClassifier.buildClassHierarchy(moduleReasoner);
        HashSet<OWLClass> affectedCls = new HashSet<OWLClass>();
        for (OWLEntity entity : effects) {
            if (!(entity instanceof OWLClass)) continue;
            affectedCls.add((OWLClass)entity);
        }
        this._taxonomyImpl = IncrementalClassifier.updateClassHierarchy(this._taxonomyImpl, moduleTaxonomy, affectedCls);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Updated _taxonomy:");
            new TreeTaxonomyPrinter<OWLClass>().print(this._taxonomyImpl, new PrintWriter(System.err));
        }
        owlModule.getOWLOntologyManager().removeOntology(owlModule);
    }

    private void incrementalClassify() {
        this._timers.execute("incrementalClassify", x -> this.incClassifyAllModStrategy());
    }

    public boolean isClassified() {
        return this._modules != null && (!this._extractor.isChanged() || !this._extractor.isClassificationNeeded(this._reasoner.getKB().getExpressivity()));
    }

    public boolean isRealized() {
        return this.isClassified() && this._realized;
    }

    public boolean isDefined(OWLClass cls) {
        return this._extractor.axioms((OWLEntity)cls).findAny().isPresent();
    }

    public boolean isDefined(OWLDataProperty prop) {
        return this._extractor.axioms((OWLEntity)prop).findAny().isPresent();
    }

    public boolean isDefined(OWLNamedIndividual ind) {
        return this._extractor.axioms((OWLEntity)ind).findAny().isPresent();
    }

    public boolean isDefined(OWLObjectProperty prop) {
        return this._extractor.axioms((OWLEntity)prop).findAny().isPresent();
    }

    public boolean isEquivalentClass(OWLClassExpression clsC, OWLClassExpression clsD) {
        if (clsC.isAnonymous() || clsD.isAnonymous()) {
            throw new UnsupportedOperationException(_namedClassesSupportOnly);
        }
        this.classify();
        return this._taxonomyImpl.isEquivalent((OWLClass)clsC, (OWLClass)clsD) == Bool.TRUE;
    }

    public boolean isSatisfiable(OWLClassExpression description) {
        if (description.isAnonymous() || !this.isClassified()) {
            return this._reasoner.isSatisfiable(description);
        }
        return !this.getUnsatisfiableClasses().contains((OWLObject)((OWLClass)description));
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        OWLOntology ontology = this.getRootOntology();
        if (ontology == null || ontology.getOWLOntologyManager() == null || ontology.getOWLOntologyManager().ontologies() == null) {
            return;
        }
        if (!ontology.getOWLOntologyManager().ontologies().filter(o -> o != null).anyMatch(o -> o.getOntologyID().equals((Object)ontology.getOntologyID()))) {
            return;
        }
        Set ontologies = this.getRootOntology().importsClosure().collect(Collectors.toSet());
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !ontologies.contains(oWLOntologyChange.getOntology())) continue;
            this.resetRealization();
            OWLAxiom axiom = oWLOntologyChange.getAxiom();
            if (oWLOntologyChange instanceof AddAxiom) {
                this._extractor.addAxiom(axiom);
                continue;
            }
            if (oWLOntologyChange instanceof RemoveAxiom) {
                this._extractor.deleteAxiom(axiom);
                continue;
            }
            throw new UnsupportedOperationException("Unrecognized axiom change: " + oWLOntologyChange);
        }
    }

    private void regularClassify() {
        _logger.fine("Regular classification starting");
        Thread classification = new Thread("classification"){

            @Override
            public void run() {
                IncrementalClassifier.this._timers.execute("reasonerClassify", x -> {
                    IncrementalClassifier.this._reasoner.flush();
                    IncrementalClassifier.this._reasoner.getKB().classify();
                });
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Regular taxonomy:");
                    new TreeTaxonomyPrinter<ATermAppl>().print(IncrementalClassifier.this._reasoner.getKB().getTaxonomy(), new PrintWriter(System.err));
                }
                IncrementalClassifier.this._taxonomyImpl = IncrementalClassifier.this._timers.execute("buildClassHierarchy", () -> IncrementalClassifier.buildClassHierarchy(IncrementalClassifier.this._reasoner));
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Copied taxonomy:");
                    new TreeTaxonomyPrinter().print(IncrementalClassifier.this._taxonomyImpl, new PrintWriter(System.err));
                }
            }
        };
        Thread partitioning = new Thread("partitioning"){

            @Override
            public void run() {
                IncrementalClassifier.this._modules = IncrementalClassifier.this._extractor.extractModules();
            }
        };
        try {
            Optional<Timer> timer = this._timers.startTimer("regularClassify");
            if (this._multiThreaded) {
                classification.start();
                partitioning.start();
                classification.join();
                partitioning.join();
            } else {
                classification.run();
                partitioning.run();
            }
            timer.ifPresent(t -> t.stop());
        }
        catch (InterruptedException e2) {
            throw new OpenError(e2);
        }
        _logger.fine(() -> "Regular classification done");
    }

    private static Taxonomy<OWLClass> updateClassHierarchy(Taxonomy<OWLClass> taxonomy, Taxonomy<OWLClass> moduleTaxonomy, Set<OWLClass> affected) {
        HashSet<OWLClass> inTaxonomy = new HashSet<OWLClass>(moduleTaxonomy.getClasses());
        inTaxonomy.remove(OWL.Thing);
        inTaxonomy.remove(OWL.Nothing);
        assert (affected.containsAll(inTaxonomy)) : "Unaffected _nodes in changed _taxonomy";
        HashSet<OWLClass> removed = new HashSet<OWLClass>(affected);
        removed.removeAll(moduleTaxonomy.getClasses());
        List<OWLClass> sorted = taxonomy.topologocialSort(false);
        Set emptySet = Collections.emptySet();
        for (OWLClass cls : sorted) {
            if (removed.contains(cls) || moduleTaxonomy.contains(cls)) continue;
            moduleTaxonomy.addNode(taxonomy.getAllEquivalents(cls), emptySet, emptySet, false);
            Set<OWLClass> supers = taxonomy.getFlattenedSupers(cls, true);
            supers.removeAll(removed);
            moduleTaxonomy.addSupers(cls, supers);
        }
        ArrayList<OWLClass> nothings = new ArrayList<OWLClass>();
        for (OWLClass cls : taxonomy.getEquivalents(OWL.Nothing)) {
            if (removed.contains(cls) || moduleTaxonomy.contains(cls)) continue;
            nothings.add(cls);
        }
        if (!nothings.isEmpty()) {
            moduleTaxonomy.addEquivalents(OWL.Nothing, nothings);
        }
        return moduleTaxonomy;
    }

    public boolean isMultiThreaded() {
        return this._multiThreaded;
    }

    public void setMultiThreaded(boolean multiThreaded) {
        this._multiThreaded = multiThreaded;
    }

    public void flush() {
        this._reasoner.flush();
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)OWL.Nothing);
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        return this.getEquivalentDataProperties(OWL.bottomDataProperty);
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)OWL.bottomObjectProperty);
    }

    public BufferingMode getBufferingMode() {
        return BufferingMode.NON_BUFFERING;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getDataPropertyDomains(pe, direct);
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getDataPropertyValues(ind, pe);
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getDifferentIndividuals(ind);
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce) {
        DisjointClassComparator disjointClassComparator = new DisjointClassComparator(this._taxonomyImpl, ce);
        if (!this._taxonomyImpl.contains(disjointClassComparator.getComplementRepresentation())) {
            this._reasoner.flush();
            PartialOrderBuilder<OWLClass> orderBuilder = new PartialOrderBuilder<OWLClass>(this._taxonomyImpl, disjointClassComparator);
            orderBuilder.add(disjointClassComparator.getComplementRepresentation(), true);
        }
        OWLClassNodeSet result = new OWLClassNodeSet();
        for (Set<OWLClass> equivSet : this._taxonomyImpl.getSubs(disjointClassComparator.getComplementRepresentation(), false)) {
            result.addSameEntities(equivSet);
        }
        return result;
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getDisjointDataProperties(pe);
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getDisjointObjectProperties(pe);
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getEquivalentDataProperties(pe);
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getEquivalentObjectProperties(pe);
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this._reasoner.getFreshEntityPolicy();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this._reasoner.getIndividualNodeSetPolicy();
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSetBySameAs(Collection<OWLNamedIndividual> individuals) {
        HashSet<Node> instances = new HashSet<Node>();
        HashSet seen = new HashSet();
        for (OWLNamedIndividual ind : individuals) {
            if (seen.contains(ind)) continue;
            Node equiv = this._reasoner.getSameIndividuals(ind);
            instances.add(equiv);
            seen.addAll(equiv.entities().collect(Collectors.toList()));
        }
        return new OWLNamedIndividualNodeSet(instances);
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSetByName(Collection<OWLNamedIndividual> individuals) {
        HashSet<OWLNamedIndividualNode> instances = new HashSet<OWLNamedIndividualNode>();
        for (OWLNamedIndividual ind : individuals) {
            for (OWLNamedIndividual equiv : this._reasoner.getSameIndividuals(ind)) {
                instances.add(new OWLNamedIndividualNode(equiv));
            }
        }
        return new OWLNamedIndividualNodeSet(instances);
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSet(Collection<OWLNamedIndividual> individuals) {
        if (IndividualNodeSetPolicy.BY_NAME.equals((Object)this.getIndividualNodeSetPolicy())) {
            return this.getIndividualNodeSetByName(individuals);
        }
        if (IndividualNodeSetPolicy.BY_SAME_AS.equals((Object)this.getIndividualNodeSetPolicy())) {
            return this.getIndividualNodeSetBySameAs(individuals);
        }
        throw new AssertionError((Object)("Unsupported IndividualNodeSetPolicy : " + this.getIndividualNodeSetPolicy()));
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (ce.isAnonymous() && direct) {
            throw new UnsupportedOperationException(_namedClassesSupportOnly);
        }
        this._reasoner.flush();
        if (!this.isRealized() && !direct) {
            return this._reasoner.getInstances(ce, direct);
        }
        this.realize();
        Set<OWLNamedIndividual> individuals = direct ? TaxonomyUtils.getDirectInstances(this._taxonomyImpl, (OWLClass)ce) : TaxonomyUtils.getAllInstances(this._taxonomyImpl, (OWLClass)ce);
        return this.getIndividualNodeSet(individuals);
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getInverseObjectProperties(pe);
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getObjectPropertyDomains(pe, direct);
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getObjectPropertyRanges(pe, direct);
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getObjectPropertyValues(ind, pe);
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        return Collections.emptySet();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        return Collections.emptySet();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return Collections.emptyList();
    }

    public String getReasonerName() {
        return "Openllet (Incremental)";
    }

    public Version getReasonerVersion() {
        return this._reasoner.getReasonerVersion();
    }

    public OWLOntology getRootOntology() {
        return this._reasoner.getRootOntology();
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getSameIndividuals(ind);
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getSubDataProperties(pe, direct);
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getSubObjectProperties(pe, direct);
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (ce.isAnonymous()) {
            throw new UnsupportedOperationException(_namedClassesSupportOnly);
        }
        OWLClass namedClass = (OWLClass)ce;
        this.classify();
        return new OWLClassNodeSet(this._taxonomyImpl.supers(namedClass, direct).map(NodeFactory::getOWLClassNode).collect(Collectors.toSet()));
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getSuperDataProperties(pe, direct);
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.getSuperObjectProperties(pe, direct);
    }

    public long getTimeOut() {
        return this._reasoner.getTimeOut();
    }

    public Node<OWLClass> getTopClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)OWL.Thing);
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        return this.getEquivalentDataProperties(OWL.topDataProperty);
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)OWL.topObjectProperty);
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        this.realize();
        OWLClassNodeSet types = new OWLClassNodeSet();
        for (Set<OWLClass> t : TaxonomyUtils.getTypes(this._taxonomyImpl, ind, direct)) {
            types.addNode((Node)new OWLClassNode(t));
        }
        return types;
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException {
        this.classify();
        return this.getBottomClassNode();
    }

    public void interrupt() {
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        this._reasoner.flush();
        return this._reasoner.isConsistent();
    }

    public boolean isEntailed(OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        try {
            EntailmentChecker entailmentChecker = new EntailmentChecker(this);
            return entailmentChecker.isEntailed(axiom);
        }
        catch (PelletRuntimeException e2) {
            throw IncrementalClassifier.convert(e2);
        }
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        try {
            EntailmentChecker entailmentChecker = new EntailmentChecker(this);
            return entailmentChecker.isEntailed(axioms);
        }
        catch (PelletRuntimeException e2) {
            throw IncrementalClassifier.convert(e2);
        }
    }

    private static PelletRuntimeException convert(PelletRuntimeException e2) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException, FreshEntitiesException {
        if (e2 instanceof TimeoutException) {
            throw new TimeOutException();
        }
        if (e2 instanceof TimerInterruptedException) {
            throw new ReasonerInterruptedException((Throwable)e2);
        }
        if (e2 instanceof openllet.core.exceptions.InconsistentOntologyException) {
            throw new InconsistentOntologyException();
        }
        if (e2 instanceof UndefinedEntityException) {
            Set unknown = Collections.emptySet();
            throw new FreshEntitiesException(unknown);
        }
        return e2;
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return this.getReasoner().isEntailmentCheckingSupported(axiomType);
    }

    public void prepareReasoner() throws ReasonerInterruptedException, TimeOutException {
        this.classify();
    }

    public Taxonomy<OWLClass> getTaxonomy() {
        return this._taxonomyImpl;
    }

    private void resetRealization() {
        if (this._taxonomyImpl != null) {
            for (TaxonomyNode<OWLClass> node : this._taxonomyImpl.getNodes().values()) {
                node.removeDatum((Object)TaxonomyUtils.TaxonomyKey.INSTANCES_KEY);
            }
        }
        this._realized = false;
    }

    private void realize() {
        if (this.isRealized()) {
            return;
        }
        Set<ATermAppl> allIndividuals = this._reasoner.getKB().getIndividuals();
        HashSet<OWLClass> visitedClasses = new HashSet<OWLClass>();
        if (!allIndividuals.isEmpty()) {
            this.realizeByConcept(ATermUtils.TOP, allIndividuals, this._reasoner.getManager().getOWLDataFactory(), visitedClasses);
        }
        this._realized = true;
    }

    private Set<ATermAppl> realizeByConcept(ATermAppl c, Collection<ATermAppl> individuals, OWLDataFactory factory, Set<OWLClass> visitedClasses) {
        OWLClass owlClass;
        if (c.equals(ATermUtils.BOTTOM)) {
            return Collections.emptySet();
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("Realizing concept " + c);
        }
        if (visitedClasses.contains(owlClass = IncrementalClassifier.termToOWLClass(c, factory))) {
            return TaxonomyUtils.getAllInstances(this._taxonomyImpl, owlClass);
        }
        HashSet<ATermAppl> instances = new HashSet<ATermAppl>(this._reasoner.getKB().retrieve(c, individuals));
        HashSet<ATermAppl> mostSpecificInstances = new HashSet<ATermAppl>(instances);
        if (!instances.isEmpty()) {
            TaxonomyNode<OWLClass> node;
            if (null == this._taxonomyImpl) {
                this.classify();
            }
            if ((node = this._taxonomyImpl.getNode(owlClass)) == null) {
                _logger.warning(" no _node for " + c);
                return instances;
            }
            for (TaxonomyNode<OWLClass> sub : node.getSubs()) {
                OWLClass d = sub.getName();
                Set<ATermAppl> subInstances = this.realizeByConcept(IncrementalClassifier.owlClassToTerm(d), instances, factory, visitedClasses);
                if (subInstances == null) {
                    return null;
                }
                mostSpecificInstances.removeAll(subInstances);
            }
            if (!mostSpecificInstances.isEmpty()) {
                node.putDatum((Object)TaxonomyUtils.TaxonomyKey.INSTANCES_KEY, IncrementalClassifier.toOWLNamedIndividuals(mostSpecificInstances, factory));
            }
        }
        return instances;
    }

    private static Set<OWLNamedIndividual> toOWLNamedIndividuals(Set<ATermAppl> terms, OWLDataFactory factory) {
        HashSet<OWLNamedIndividual> result = new HashSet<OWLNamedIndividual>();
        for (ATermAppl ind : terms) {
            OWLNamedIndividual owlInd = IncrementalClassifier.termToOWLNamedIndividual(ind, factory);
            if (owlInd == null) continue;
            result.add(owlInd);
        }
        return result;
    }

    private static OWLClass termToOWLClass(ATermAppl c, OWLDataFactory factory) {
        if (c.equals(ATermUtils.TOP)) {
            return factory.getOWLThing();
        }
        if (c.equals(OWL_THING)) {
            return factory.getOWLThing();
        }
        if (c.equals(OWL_NOTHING)) {
            return factory.getOWLNothing();
        }
        if (!ATermUtils.isBnode(c)) {
            return factory.getOWLClass(IRI.create((String)c.getName()));
        }
        return null;
    }

    private static OWLNamedIndividual termToOWLNamedIndividual(ATermAppl c, OWLDataFactory factory) {
        if (!ATermUtils.isBnode(c)) {
            return factory.getOWLNamedIndividual(IRI.create((String)c.getName()));
        }
        return null;
    }

    private static ATermAppl owlClassToTerm(OWLClass c) {
        if (c.isOWLThing()) {
            return ATermUtils.TOP;
        }
        if (c.isOWLNothing()) {
            return ATermUtils.BOTTOM;
        }
        return ATermUtils.makeTermAppl(c.getIRI().toString());
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return this._reasoner.getPrecomputableInferenceTypes();
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        switch (inferenceType) {
            case CLASS_HIERARCHY: {
                return this.isClassified();
            }
            case CLASS_ASSERTIONS: {
                return this.isRealized();
            }
        }
        return this._reasoner.isPrecomputed(inferenceType);
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        for (InferenceType inferenceType : inferenceTypes) {
            switch (inferenceType) {
                case CLASS_HIERARCHY: {
                    this.classify();
                }
                case CLASS_ASSERTIONS: {
                    this.realize();
                }
            }
            this._reasoner.precomputeInferences(inferenceTypes);
        }
    }

    public class DisjointClassComparator
    implements PartialOrderComparator<OWLClass> {
        private static final String ANONYMOUS_COMPLEMENT_REPRESENTATION_BASE = "http://clarkparsia.com/pellet/complement/";
        private static final String COMPLEMENT_POSTFIX = "-complement";
        private final OWLClassExpression _complementClass;
        private final OWLClass _complementRepresentation;

        public DisjointClassComparator(Taxonomy<OWLClass> taxonomy, OWLClassExpression originalClass) {
            this._complementClass = OWL._factory.getOWLObjectComplementOf(originalClass);
            this._complementRepresentation = this.generateComplementRepresentation(taxonomy, originalClass);
        }

        private OWLClass generateComplementRepresentation(Taxonomy<OWLClass> taxonomy, OWLClassExpression originalClass) {
            OWLClass complementClass = null;
            if (!originalClass.isAnonymous() && originalClass instanceof OWLClass) {
                return OWL._factory.getOWLClass(IRI.create((String)(((OWLClass)originalClass).getIRI() + COMPLEMENT_POSTFIX)));
            }
            while (taxonomy.contains(complementClass = OWL._factory.getOWLClass(IRI.create((String)(ANONYMOUS_COMPLEMENT_REPRESENTATION_BASE + IncrementalClassifier.this.RND.nextLong()))))) {
            }
            return complementClass;
        }

        public OWLClass getComplementRepresentation() {
            return this._complementRepresentation;
        }

        @Override
        public PartialOrderRelation compare(OWLClass a, OWLClass b) {
            OWLClass aExpression = a;
            OWLClass bExpression = b;
            if (a.equals(this._complementRepresentation)) {
                aExpression = this._complementClass;
            }
            if (b.equals(this._complementRepresentation)) {
                bExpression = this._complementClass;
            }
            OWLSubClassOfAxiom aSubClassBAxiom = OWL._factory.getOWLSubClassOfAxiom((OWLClassExpression)aExpression, (OWLClassExpression)bExpression);
            OWLSubClassOfAxiom bSubClassAAxiom = OWL._factory.getOWLSubClassOfAxiom((OWLClassExpression)bExpression, (OWLClassExpression)aExpression);
            boolean aLessB = IncrementalClassifier.this._reasoner.isEntailed((OWLAxiom)aSubClassBAxiom);
            boolean bLessA = IncrementalClassifier.this._reasoner.isEntailed((OWLAxiom)bSubClassAAxiom);
            if (aLessB && bLessA) {
                return PartialOrderRelation.EQUAL;
            }
            if (aLessB) {
                return PartialOrderRelation.LESS;
            }
            if (bLessA) {
                return PartialOrderRelation.GREATER;
            }
            return PartialOrderRelation.INCOMPARABLE;
        }
    }

    public static class PersistedState {
        private final ModuleExtractor _persistedExtractor;
        private final Taxonomy<OWLClass> _persistedTaxonomy;
        private final boolean _persistedRealized;

        public PersistedState(IncrementalClassifier incrementalClassifier) {
            this._persistedExtractor = incrementalClassifier._extractor;
            this._persistedTaxonomy = incrementalClassifier._taxonomyImpl;
            this._persistedRealized = incrementalClassifier._realized;
        }

        public PersistedState(ModuleExtractor extractor, TaxonomyImpl<OWLClass> taxonomy, boolean realized) {
            this._persistedExtractor = extractor;
            this._persistedTaxonomy = taxonomy;
            this._persistedRealized = realized;
        }

        public ModuleExtractor getModuleExtractor() {
            return this._persistedExtractor;
        }

        public Taxonomy<OWLClass> getTaxonomy() {
            return this._persistedTaxonomy;
        }

        public boolean isRealized() {
            return this._persistedRealized;
        }
    }
}

