/*
 * Decompiled with CFR 0.152.
 */
package openllet.modularity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class OntologyDiff {
    private final List<OWLAxiom> additions = new ArrayList<OWLAxiom>();
    private final List<OWLAxiom> deletions = new ArrayList<OWLAxiom>();

    private OntologyDiff() {
    }

    public static OntologyDiff diffOntologies(OWLOntology initialOnt, OWLOntology finalOnt) {
        OntologyDiff result = new OntologyDiff();
        initialOnt.axioms().filter(axiom -> !finalOnt.containsAxiom(axiom)).forEach(result.deletions::add);
        finalOnt.axioms().filter(axiom -> !initialOnt.containsAxiom(axiom)).forEach(result.additions::add);
        return result;
    }

    public static OntologyDiff diffOntologiesWithAxioms(Collection<OWLOntology> initialOntologies, Collection<OWLAxiom> finalAxioms) {
        OntologyDiff result = new OntologyDiff();
        for (OWLOntology ontology : initialOntologies) {
            ontology.axioms().filter(axiom -> !finalAxioms.contains(axiom)).forEach(result.deletions::add);
        }
        for (OWLAxiom axiom2 : finalAxioms) {
            if (OntologyDiff.containsAxiom(axiom2, initialOntologies)) continue;
            result.additions.add(axiom2);
        }
        return result;
    }

    public static OntologyDiff diffAxiomsWithOntologies(Stream<OWLAxiom> initialAxioms, Collection<OWLOntology> finalOntologies) {
        OntologyDiff result = new OntologyDiff();
        List axioms = initialAxioms.collect(Collectors.toList());
        axioms.stream().filter(axiom -> !OntologyDiff.containsAxiom(axiom, finalOntologies)).forEach(result.deletions::add);
        for (OWLOntology ontology : finalOntologies) {
            ontology.axioms().filter(axiom -> !axioms.contains(axiom)).forEach(result.additions::add);
        }
        return result;
    }

    public static OntologyDiff diffAxiomsWithOntologies(Collection<OWLAxiom> initialAxioms, Collection<OWLOntology> finalOntologies) {
        return OntologyDiff.diffAxiomsWithOntologies(initialAxioms.stream(), finalOntologies);
    }

    private static boolean containsAxiom(OWLAxiom axiom, Collection<OWLOntology> ontologies) {
        for (OWLOntology ontology : ontologies) {
            if (!ontology.containsAxiom(axiom)) continue;
            return true;
        }
        return false;
    }

    public static OntologyDiff diffAxioms(Collection<OWLAxiom> initialAxioms, Collection<OWLAxiom> finalAxioms) {
        OntologyDiff result = new OntologyDiff();
        for (OWLAxiom axiom : initialAxioms) {
            if (finalAxioms.contains(axiom)) continue;
            result.deletions.add(axiom);
        }
        for (OWLAxiom axiom : finalAxioms) {
            if (initialAxioms.contains(axiom)) continue;
            result.additions.add(axiom);
        }
        return result;
    }

    public static OntologyDiff diffAxioms(Stream<OWLAxiom> initialAxioms, Collection<OWLAxiom> finalAxioms) {
        return OntologyDiff.diffAxioms(initialAxioms.collect(Collectors.toList()), finalAxioms);
    }

    public boolean areSame() {
        return this.additions.isEmpty() && this.deletions.isEmpty();
    }

    public int getDiffCount() {
        return this.additions.size() + this.deletions.size();
    }

    public Collection<OWLAxiom> getAdditions() {
        return this.additions;
    }

    public Collection<OWLOntologyChange> getChanges(OWLOntology initialOnt) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLAxiom axiom : this.additions) {
            changes.add((OWLOntologyChange)new AddAxiom(initialOnt, axiom));
        }
        for (OWLAxiom axiom : this.deletions) {
            changes.add((OWLOntologyChange)new RemoveAxiom(initialOnt, axiom));
        }
        return changes;
    }

    private static OWLOntology identifyAxiomOntology(OWLAxiom axiom, Collection<OWLOntology> ontologies) {
        for (OWLOntology ontology : ontologies) {
            if (!ontology.containsAxiom(axiom)) continue;
            return ontology;
        }
        return null;
    }

    public Collection<OWLOntologyChange> getChanges(Collection<OWLOntology> ontologies) {
        OWLOntology ontology;
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLAxiom axiom : this.additions) {
            ontology = OntologyDiff.identifyAxiomOntology(axiom, ontologies);
            if (null == ontology) {
                throw new IllegalArgumentException("None of the ontologies contain the added axiom");
            }
            changes.add((OWLOntologyChange)new AddAxiom(ontology, axiom));
        }
        for (OWLAxiom axiom : this.deletions) {
            ontology = null;
            if (ontologies.isEmpty()) {
                throw new IllegalArgumentException("There are no ontologies defined that could have contained the removed axiom");
            }
            ontology = ontologies.iterator().next();
            changes.add((OWLOntologyChange)new RemoveAxiom(ontology, axiom));
        }
        return changes;
    }

    public Collection<OWLAxiom> getDeletions() {
        return this.deletions;
    }
}

