/*
 * Decompiled with CFR 0.152.
 */
package openllet.modularity.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import openllet.core.utils.MultiValueMap;
import openllet.owlapi.OWL;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormat;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class ModuleExtractorPersistence {
    public static final Logger _logger = Log.getLogger(ModuleExtractorPersistence.class);
    private static final String MODULE_BEGIN_KEYWORD = "MODULE";
    private static final String MODULE_END_KEYWORD = "END";
    private static final String CLASS_KEYWORD = "class";
    private static final String DATA_TYPE_KEYWORD = "datatype";
    private static final String INDIVIDUAL_KEYWORD = "individual";
    private static final String DATA_PROPERTY_KEYWORD = "dataproperty";
    private static final String OBJECT_PROPERTY_KEYWORD = "objectproperty";

    public static void saveAxioms(Collection<OWLAxiom> axioms, OutputStream outputStream) throws IOException {
        try {
            OWLOntology ontology = OWL.Ontology(axioms);
            OWL._manager.saveOntology(ontology, (OWLDocumentFormat)new OWLXMLDocumentFormat(), outputStream);
            outputStream.flush();
            OWL._manager.removeOntology(ontology);
        }
        catch (OWLException e2) {
            _logger.log(Level.SEVERE, "A problem occurred during creation or saving the ontology with axioms for the ModuleExtractor", e2);
            throw new IOException("A problem occurred during creation or saving the ontology with axioms for the ModuleExtractor");
        }
    }

    private static String getTypeKeywordForEntity(OWLEntity owlEntity) throws IllegalArgumentException {
        if (owlEntity.isOWLClass()) {
            return CLASS_KEYWORD;
        }
        if (owlEntity.isOWLDatatype()) {
            return DATA_TYPE_KEYWORD;
        }
        if (owlEntity.isOWLNamedIndividual()) {
            return INDIVIDUAL_KEYWORD;
        }
        if (owlEntity.isOWLDataProperty()) {
            return DATA_PROPERTY_KEYWORD;
        }
        if (owlEntity.isOWLObjectProperty()) {
            return OBJECT_PROPERTY_KEYWORD;
        }
        throw new IllegalArgumentException("Unrecognized type of OWLEntity: " + owlEntity.getClass());
    }

    private static String getModuleBegin(OWLEntity module) {
        StringBuffer result = new StringBuffer(MODULE_BEGIN_KEYWORD);
        result.append(" ");
        result.append(ModuleExtractorPersistence.getTypeKeywordForEntity(module));
        result.append(" ");
        result.append((CharSequence)module.getIRI());
        return result.toString();
    }

    private static String getModuleMember(OWLEntity member) {
        return ModuleExtractorPersistence.getTypeKeywordForEntity(member) + " " + member.getIRI();
    }

    private static String getModuleEnd() {
        return MODULE_END_KEYWORD;
    }

    public static void saveModules(MultiValueMap<OWLEntity, OWLEntity> modules, OutputStream outputStream) {
        PrintWriter pw = new PrintWriter(outputStream);
        for (Map.Entry entry : modules.entrySet()) {
            OWLEntity entity = (OWLEntity)entry.getKey();
            Set module = (Set)entry.getValue();
            pw.println(ModuleExtractorPersistence.getModuleBegin(entity));
            for (OWLEntity member : module) {
                pw.println(ModuleExtractorPersistence.getModuleMember(member));
            }
            pw.println(ModuleExtractorPersistence.getModuleEnd());
        }
        pw.flush();
    }

    public static OWLOntology loadAxiomOntology(InputStream inputStream) throws IOException {
        try {
            return OWL._manager.loadOntologyFromOntologyDocument(inputStream);
        }
        catch (OWLOntologyCreationException e2) {
            _logger.log(Level.SEVERE, "Unable to create an ontology", e2);
            throw new IOException("Unable to create an ontology");
        }
    }

    @Deprecated
    public static Collection<OWLAxiom> loadAxioms(InputStream inputStream) throws IOException {
        return ModuleExtractorPersistence.loadAxiomOntology(inputStream).getAxioms();
    }

    public static Stream<OWLAxiom> load_axioms(InputStream inputStream) throws IOException {
        return ModuleExtractorPersistence.loadAxiomOntology(inputStream).axioms();
    }

    private static OWLEntity createEntity(String type, String entityIRI) {
        if (CLASS_KEYWORD.equals(type)) {
            return OWL.Class(entityIRI);
        }
        if (DATA_TYPE_KEYWORD.equals(type)) {
            return OWL.Datatype(entityIRI);
        }
        if (INDIVIDUAL_KEYWORD.equals(type)) {
            return OWL.Individual(entityIRI);
        }
        if (DATA_PROPERTY_KEYWORD.equals(type)) {
            return OWL.DataProperty(entityIRI);
        }
        if (OBJECT_PROPERTY_KEYWORD.equals(type)) {
            return OWL.ObjectProperty(entityIRI);
        }
        throw new IllegalArgumentException("Unrecognized type of OWLEntity in module " + type);
    }

    private static OWLEntity readModuleInformation(String moduleBeginLine) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(moduleBeginLine);
        if (!tokenizer.hasMoreElements()) {
            throw new IOException("Premature _end of line; module MODULE _expected: " + moduleBeginLine);
        }
        tokenizer.nextToken();
        if (!tokenizer.hasMoreElements()) {
            throw new IOException("Premature _end of line; entity type information _expected: " + moduleBeginLine);
        }
        String entityType = tokenizer.nextToken();
        if (!tokenizer.hasMoreElements()) {
            throw new IOException("Premature _end of line; module URI _expected: " + moduleBeginLine);
        }
        String iriString = tokenizer.nextToken();
        if (tokenizer.hasMoreElements()) {
            throw new IOException("Trailing tokens on the line: " + moduleBeginLine);
        }
        return ModuleExtractorPersistence.createEntity(entityType, iriString);
    }

    private static OWLEntity readModuleMember(String memberLine) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(memberLine);
        if (!tokenizer.hasMoreElements()) {
            throw new IOException("Premature _end of line; entity type information _expected: " + memberLine);
        }
        String entityType = tokenizer.nextToken();
        if (!tokenizer.hasMoreElements()) {
            throw new IOException("Premature _end of line; module member URI _expected: " + memberLine);
        }
        String iriString = tokenizer.nextToken();
        if (tokenizer.hasMoreElements()) {
            throw new IOException("Trailing tokens on the line: " + memberLine);
        }
        return ModuleExtractorPersistence.createEntity(entityType, iriString);
    }

    private static boolean readModule(LineNumberReader lnr, MultiValueMap<OWLEntity, OWLEntity> modules) throws IOException {
        String line = null;
        line = lnr.readLine();
        if (line == null) {
            return false;
        }
        if (!line.startsWith(MODULE_BEGIN_KEYWORD)) {
            throw new IOException("Invalid information in the module file (line " + lnr.getLineNumber() + "). " + MODULE_BEGIN_KEYWORD + " _expected.");
        }
        OWLEntity module = ModuleExtractorPersistence.readModuleInformation(line.trim());
        boolean endOfModuleReached = false;
        HashSet<OWLEntity> members = new HashSet<OWLEntity>();
        while ((line = lnr.readLine()) != null) {
            if (line.startsWith(MODULE_END_KEYWORD)) {
                endOfModuleReached = true;
                break;
            }
            members.add(ModuleExtractorPersistence.readModuleMember(line.trim()));
        }
        if (!endOfModuleReached) {
            throw new IOException("Premature _end of file; module information not terminated.");
        }
        modules.put(module, members);
        return true;
    }

    public static MultiValueMap<OWLEntity, OWLEntity> loadModules(InputStream is) throws IOException {
        MultiValueMap<OWLEntity, OWLEntity> modules = new MultiValueMap<OWLEntity, OWLEntity>();
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
        while (ModuleExtractorPersistence.readModule(lnr, modules)) {
        }
        return modules;
    }
}

