/*
 * Decompiled with CFR 0.152.
 */
package openllet.modularity.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyImpl;
import openllet.core.taxonomy.TaxonomyNode;
import openllet.core.taxonomy.TaxonomyUtils;
import openllet.owlapi.OWL;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormat;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.StreamDocumentTarget;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class TaxonomyPersistence {
    public static final Logger _logger = Log.getLogger(TaxonomyPersistence.class);
    private static IRI TAXONOMY_ONTOLOGY_IRI = IRI.create((String)"http://clarkparsia.com/pellet/modularity/taxonomy");

    public static void save(Taxonomy<OWLClass> taxonomy, OutputStream outputStream) throws IOException {
        try {
            OWLOntology ontology = TaxonomyPersistence.createTaxonomyOntology(taxonomy);
            OWL._manager.saveOntology(ontology, (OWLDocumentFormat)new OWLXMLDocumentFormat(), (OWLOntologyDocumentTarget)new StreamDocumentTarget(outputStream));
            outputStream.flush();
            OWL._manager.removeOntology(ontology);
        }
        catch (OWLException e2) {
            _logger.log(Level.SEVERE, "An error occured while creating an ontology for taxonomy", e2);
            throw new IOException("An error occured while creating an ontology for taxonomy");
        }
    }

    private static OWLOntology createTaxonomyOntology(Taxonomy<OWLClass> taxonomy) throws OWLOntologyChangeException {
        OWLOntology ontology = OWL.Ontology(Collections.emptyList(), TAXONOMY_ONTOLOGY_IRI);
        LinkedList<AddAxiom> changes = new LinkedList<AddAxiom>();
        HashSet<OWLClass> processedEquivalentClasses = new HashSet<OWLClass>();
        for (TaxonomyNode<OWLClass> taxonomyNode : taxonomy.getNodes().values()) {
            Collection<OWLNamedIndividual> individuals;
            if (processedEquivalentClasses.contains(taxonomyNode.getName())) continue;
            processedEquivalentClasses.addAll(taxonomyNode.getEquivalents());
            for (OWLClass owlClass : taxonomyNode.getEquivalents()) {
                AddAxiom classAxiom = new AddAxiom(ontology, (OWLAxiom)OWL.declaration((OWLEntity)owlClass));
                changes.add(classAxiom);
                for (TaxonomyNode<OWLClass> superNode : taxonomyNode.getSupers()) {
                    AddAxiom subClassOfAxiom = new AddAxiom(ontology, (OWLAxiom)OWL.subClassOf((OWLClassExpression)owlClass, (OWLClassExpression)superNode.getName()));
                    changes.add(subClassOfAxiom);
                }
            }
            if (taxonomyNode.getEquivalents().size() > 1) {
                AddAxiom equivalentAxiom = new AddAxiom(ontology, (OWLAxiom)OWL.equivalentClasses(taxonomyNode.getEquivalents()));
                changes.add(equivalentAxiom);
            }
            if ((individuals = TaxonomyPersistence.getDatumInstanceAsCollectorOfOWLNamedIndividual(taxonomyNode)) == null || individuals.isEmpty()) continue;
            for (OWLNamedIndividual ind : individuals) {
                AddAxiom classAssertionAxiom = new AddAxiom(ontology, (OWLAxiom)OWL.classAssertion((OWLIndividual)ind, (OWLClassExpression)taxonomyNode.getName()));
                changes.add(classAssertionAxiom);
            }
        }
        OWL._manager.applyChanges(changes);
        return ontology;
    }

    private static Collection<OWLNamedIndividual> getDatumInstanceAsCollectorOfOWLNamedIndividual(TaxonomyNode<OWLClass> taxonomyNode) {
        return (Collection)taxonomyNode.getDatum((Object)TaxonomyUtils.TaxonomyKey.INSTANCES_KEY);
    }

    private static Stream<OWLClass> superClasses(OWLOntology ontology, OWLClass owlClass) {
        return ontology.subClassAxiomsForSubClass(owlClass).map(OWLSubClassOfAxiom::getSuperClass).filter(owlSuperDescription -> owlSuperDescription instanceof OWLClass).map(x -> (OWLClass)x);
    }

    private static Set<OWLClass> getSuperClasses(OWLOntology ontology, OWLClass owlClass) {
        return TaxonomyPersistence.superClasses(ontology, owlClass).collect(Collectors.toSet());
    }

    private static TaxonomyImpl<OWLClass> createTaxonomy(OWLOntology ontology) {
        TaxonomyImpl<OWLClass> taxonomy = new TaxonomyImpl<OWLClass>(null, OWL.Thing, OWL.Nothing);
        HashSet<OWLClass> processedEquivalentClasses = new HashSet<OWLClass>();
        processedEquivalentClasses.add(OWL.Thing);
        processedEquivalentClasses.add(OWL.Nothing);
        ontology.classesInSignature().filter(owlClass -> !processedEquivalentClasses.contains(owlClass)).forEach(owlClass -> {
            HashSet equivalentClasses = new HashSet();
            boolean[] thing_Nothing = new boolean[]{false, false};
            ontology.equivalentClassesAxioms(owlClass).forEach(equivalentAxiom -> {
                equivalentAxiom.namedClasses().forEach(equivalentClasses::add);
                if (equivalentAxiom.containsOWLNothing()) {
                    thing_Nothing[1] = true;
                }
                if (equivalentAxiom.containsOWLThing()) {
                    thing_Nothing[0] = true;
                }
            });
            equivalentClasses.removeAll(processedEquivalentClasses);
            if (thing_Nothing[0]) {
                taxonomy.addEquivalents(OWL.Thing, equivalentClasses);
            } else if (thing_Nothing[1]) {
                taxonomy.addEquivalents(OWL.Nothing, equivalentClasses);
            } else {
                if (equivalentClasses.contains(owlClass)) {
                    equivalentClasses.remove(owlClass);
                }
                taxonomy.addNode((OWLClass)owlClass, false);
                taxonomy.addEquivalents((OWLClass)owlClass, equivalentClasses);
            }
            processedEquivalentClasses.add((OWLClass)owlClass);
            processedEquivalentClasses.addAll(equivalentClasses);
        });
        for (TaxonomyNode<OWLClass> taxonomyNode : taxonomy.getNodes().values()) {
            if (!OWL.Nothing.equals(taxonomyNode.getName()) || taxonomyNode.getSupers().size() <= 1 || !taxonomyNode.getSupers().contains(taxonomy.getTop())) continue;
            taxonomy.getTop().removeSub(taxonomyNode);
        }
        for (TaxonomyNode<OWLClass> taxonomyNode : taxonomy.getNodes().values()) {
            OWLClass owlClass2 = taxonomyNode.getName();
            if (owlClass2 == null || owlClass2.equals(OWL.Nothing)) continue;
            taxonomy.addSupers(owlClass2, TaxonomyPersistence.getSuperClasses(ontology, owlClass2));
        }
        for (TaxonomyNode<OWLClass> taxonomyNode : taxonomy.getNodes().values()) {
            Set individuals = ontology.classAssertionAxioms((OWLClassExpression)taxonomyNode.getName()).map(classAssertionAxiom -> classAssertionAxiom.getIndividual()).filter(individual -> individual.isNamed() && individual instanceof OWLNamedIndividual).map(x -> (OWLNamedIndividual)x).collect(Collectors.toSet());
            if (individuals.isEmpty()) continue;
            taxonomyNode.putDatum((Object)TaxonomyUtils.TaxonomyKey.INSTANCES_KEY, individuals);
        }
        return taxonomy;
    }

    public static TaxonomyImpl<OWLClass> load(InputStream is) throws IOException {
        try {
            OWLOntology ontology = OWL._manager.loadOntologyFromOntologyDocument(is);
            TaxonomyImpl<OWLClass> result = TaxonomyPersistence.createTaxonomy(ontology);
            OWL._manager.removeOntology(ontology);
            return result;
        }
        catch (OWLOntologyCreationException e2) {
            _logger.log(Level.SEVERE, "Unable to create the ontology", e2);
            throw new IOException("Unable to create the ontology");
        }
    }
}

