/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.util.ArrayList;
import java.util.stream.Stream;
import openllet.aterm.ATermAppl;
import openllet.core.utils.ATermUtils;
import openllet.owlapi.OpenlletReasoner;
import openllet.owlapi.facet.FacetReasonerOWL;
import openllet.query.sparqldl.engine.QueryEngine;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryAtomFactory;
import openllet.query.sparqldl.model.QueryImpl;
import openllet.query.sparqldl.model.QueryResult;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class EntailmentQueryVisitor
implements OWLAxiomVisitor,
FacetReasonerOWL {
    private final IndividualTermConverter _indConv;
    private final OpenlletReasoner _reasoner;
    private Query _query;

    @Override
    public OpenlletReasoner getReasoner() {
        return this._reasoner;
    }

    public EntailmentQueryVisitor(OpenlletReasoner reasoner) {
        this._reasoner = reasoner;
        this._indConv = new IndividualTermConverter();
        this.reset();
    }

    public boolean isEntailed() {
        QueryResult results = QueryEngine.exec(this._query);
        return !results.isEmpty();
    }

    public void reset() {
        this._query = new QueryImpl(this._reasoner.getKB(), false);
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        ATermAppl ind = this._indConv.getTerm(axiom.getIndividual());
        ATermAppl cls = this._reasoner.term((OWLObject)axiom.getClassExpression());
        this._query.add(QueryAtomFactory.TypeAtom(ind, cls));
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        ATermAppl subj = this._indConv.getTerm(axiom.getSubject());
        ATermAppl pred = this._reasoner.term((OWLObject)axiom.getProperty());
        ATermAppl obj = this._reasoner.term((OWLObject)axiom.getObject());
        this._query.add(QueryAtomFactory.PropertyValueAtom(subj, pred, obj));
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        ArrayList differents = new ArrayList();
        axiom.individuals().forEach(ind -> {
            ATermAppl term = this._indConv.getTerm((OWLIndividual)ind);
            for (ATermAppl dterm : differents) {
                this._query.add(QueryAtomFactory.DifferentFromAtom(term, dterm));
            }
        });
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        ATermAppl subj = this._indConv.getTerm(axiom.getSubject());
        ATermAppl pred = this._reasoner.term((OWLObject)axiom.getProperty());
        ATermAppl obj = this._reasoner.term((OWLObject)axiom.getObject());
        this._query.add(QueryAtomFactory.NegativePropertyValueAtom(subj, pred, obj));
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        ATermAppl subj = this._indConv.getTerm(axiom.getSubject());
        ATermAppl pred = this._reasoner.term((OWLObject)axiom.getProperty());
        ATermAppl obj = this._indConv.getTerm((OWLIndividual)axiom.getObject());
        this._query.add(QueryAtomFactory.NegativePropertyValueAtom(subj, pred, obj));
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        ATermAppl subj = this._indConv.getTerm(axiom.getSubject());
        ATermAppl pred = this._reasoner.term((OWLObject)axiom.getProperty());
        ATermAppl obj = this._indConv.getTerm((OWLIndividual)axiom.getObject());
        this._query.add(QueryAtomFactory.PropertyValueAtom(subj, pred, obj));
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        ATermAppl head = null;
        for (OWLIndividual ind : OWLAPIStreamUtils.asList((Stream)axiom.individuals())) {
            ATermAppl term = this._indConv.getTerm(ind);
            if (head == null) {
                head = term;
                continue;
            }
            this._query.add(QueryAtomFactory.SameAsAtom(head, term));
        }
    }

    private class IndividualTermConverter
    implements OWLIndividualVisitor {
        private ATermAppl _term;

        private IndividualTermConverter() {
        }

        public ATermAppl getTerm(OWLIndividual individual) {
            this._term = null;
            individual.accept((OWLIndividualVisitor)this);
            return this._term;
        }

        public void visit(OWLNamedIndividual individual) {
            this._term = EntailmentQueryVisitor.this._reasoner.term((OWLObject)individual);
        }

        public void visit(OWLAnonymousIndividual individual) {
            this._term = ATermUtils.makeVar(individual.toStringID());
        }
    }
}

