/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.io.Serializable;
import java.util.Set;
import java.util.stream.Stream;
import openllet.atom.OpenError;
import openllet.core.KBLoader;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.owlapi.LimitedMapIRIMapper;
import openllet.owlapi.OWLGroup;
import openllet.owlapi.OWLHelper;
import openllet.owlapi.OpenlletReasoner;
import openllet.owlapi.OpenlletReasonerFactory;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportEvent;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class OWLAPILoader
extends KBLoader
implements OWLHelper {
    private final OWLOntologyManager _manager = OWLManager.createOWLOntologyManager();
    private final LimitedMapIRIMapper _iriMapper = new LimitedMapIRIMapper();
    private volatile OpenlletReasoner _reasoner;
    private volatile OWLOntology _ontology;
    private boolean _ignoreImports;
    private boolean _loadSingleFile;

    @Override
    public OWLOntologyManager getManager() {
        return this._manager;
    }

    @Override
    public OWLDataFactory getFactory() {
        return this._manager.getOWLDataFactory();
    }

    @Override
    public boolean isVolatile() {
        return true;
    }

    @Override
    public OWLGroup getGroup() {
        return OWLGroup.fromVolatileManager(this._manager);
    }

    @Override
    public OpenlletReasoner getReasoner() {
        return this._reasoner;
    }

    @Override
    public OWLOntology getOntology() {
        return this._ontology;
    }

    @Override
    public KnowledgeBase getKB() {
        return this._reasoner.getKB();
    }

    public OWLAPILoader() {
        this._manager.setOntologyLoaderConfiguration(this._manager.getOntologyLoaderConfiguration().setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT));
        this._manager.addMissingImportListener(new MissingImportListener(){
            private static final long serialVersionUID = -1580704502184270618L;

            public void importMissing(MissingImportEvent event) {
                if (!OWLAPILoader.this._ignoreImports) {
                    IRI importURI = event.getImportedOntologyURI();
                    System.err.println("WARNING: Cannot import " + importURI);
                    event.getCreationException().printStackTrace();
                }
            }
        });
        this.clear();
    }

    @Deprecated
    public Set<OWLOntology> getAllOntologies() {
        return OWLAPIStreamUtils.asSet((Stream)this._manager.ontologies());
    }

    public Stream<OWLOntology> allOntologies() {
        return this._manager.ontologies();
    }

    @Override
    public void load() {
        this._reasoner = new OpenlletReasonerFactory().createReasoner(this._ontology);
        this._reasoner.getKB().setTaxonomyBuilderProgressMonitor(OpenlletOptions.USE_CLASSIFICATION_MONITOR.create());
    }

    @Override
    public void parse(String ... fileNames) {
        this._loadSingleFile = fileNames.length == 1;
        super.parse(fileNames);
    }

    @Override
    protected void parseFile(String file) {
        try {
            IRI fileIRI = IRI.create((String)file);
            this._iriMapper.addAllowedIRI(fileIRI);
            if (this._loadSingleFile) {
                this._ontology = this._manager.loadOntologyFromOntologyDocument(fileIRI);
            } else {
                OWLOntology importOnt = this._manager.loadOntologyFromOntologyDocument(fileIRI);
                OWLImportsDeclaration declaration = this._manager.getOWLDataFactory().getOWLImportsDeclaration((IRI)importOnt.getOntologyID().getOntologyIRI().get());
                this._manager.applyChange((OWLOntologyChange)new AddImport(this._ontology, declaration));
            }
        }
        catch (IllegalArgumentException e2) {
            throw new OpenError(file, e2);
        }
        catch (OWLOntologyCreationException e3) {
            throw new OpenError(file, e3);
        }
        catch (OWLOntologyChangeException e4) {
            throw new OpenError(file, e4);
        }
    }

    @Override
    public void setIgnoreImports(boolean ignoreImports) {
        this._ignoreImports = ignoreImports;
        this._manager.getIRIMappers().clear();
        if (ignoreImports) {
            this._manager.getIRIMappers().add((Serializable)((Object)this._iriMapper));
        }
    }

    @Override
    public void clear() {
        this._iriMapper.clear();
        this._manager.clearOntologies();
        try {
            this._ontology = this._manager.createOntology();
        }
        catch (OWLOntologyCreationException e2) {
            throw new OpenError(e2);
        }
    }

    @Override
    public void dispose() {
        this._reasoner.dispose();
        this._reasoner = null;
        this._ontology = null;
    }
}

