/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Set;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyUtils;
import openllet.core.taxonomy.printer.TreeTaxonomyPrinter;
import openllet.core.utils.QNameProvider;
import openllet.owlapi.OWLException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLNamedIndividual;

public class OWLClassTreePrinter
extends TreeTaxonomyPrinter<OWLClass> {
    private final QNameProvider _qnames = new QNameProvider();

    @Override
    protected void printNode(Set<OWLClass> set) {
        super.printNode(set);
        Set<OWLNamedIndividual> instances = OWLClassTreePrinter.getDirectInstances(this._taxonomyImpl, set.iterator().next());
        if (instances.size() > 0) {
            this._out.print(" - (");
            boolean printed = false;
            for (OWLNamedIndividual x : instances) {
                if (printed) {
                    this._out.print(", ");
                } else {
                    printed = true;
                }
                this.printURI(this._out, x);
            }
            this._out.print(")");
        }
    }

    @Override
    protected void printURI(PrintWriter out, OWLClass c) {
        this.printIRI(out, c.getIRI());
    }

    @Override
    private void printURI(PrintWriter out, OWLNamedIndividual i) {
        this.printIRI(out, i.getIRI());
    }

    private void printIRI(PrintWriter out, IRI iri2) {
        out.print(this._qnames.shortForm(iri2.toString()));
    }

    public static Set<OWLNamedIndividual> getDirectInstances(Taxonomy<OWLClass> t, OWLClass c) {
        Set instances = (Set)t.getDatum(c, TaxonomyUtils.TaxonomyKey.INSTANCES_KEY);
        if (instances == null) {
            if (t.contains(c)) {
                return Collections.emptySet();
            }
            throw new OWLException(c + " is an unknown class!");
        }
        return Collections.unmodifiableSet(instances);
    }
}

