/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.io.File;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.stream.Stream;
import openllet.owlapi.OWLGenericTools;
import openllet.owlapi.OWLHelper;
import openllet.owlapi.OWLManagerGroup;
import openllet.shared.tools.Logging;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public interface OWLGroup
extends AutoCloseable,
Logging {
    public static OWLManagerGroup fromVolatileManager(OWLOntologyManager manager) {
        return new OWLManagerGroup(Optional.of(manager), Optional.empty());
    }

    public static OWLManagerGroup fromPersistentManager(OWLOntologyManager manager) {
        return new OWLManagerGroup(Optional.empty(), Optional.of(manager));
    }

    public boolean setOntologiesDirectory(File var1);

    public Optional<File> getOntologiesDirectory();

    public OWLOntologyManager getVolatileManager();

    public OWLOntologyManager getPersistentManager();

    public boolean havePersistentManager();

    public boolean haveVolatileManager();

    public void loadDirectory(File var1, OWLOntologyManager var2, BiFunction<OWLOntologyManager, File, Optional<OWLOntology>> var3);

    public void loadDirectory(File var1);

    default public Optional<OWLHelper> getOntology(IRI ontology, double version2, boolean isVolatile) {
        return this.getOntology(OWLHelper.getVersion(ontology, version2), isVolatile);
    }

    default public Optional<OWLHelper> getOntology(OWLOntologyID ontologyID, boolean isVolatile) {
        try {
            return Optional.of(new OWLGenericTools(this, ontologyID, isVolatile));
        }
        catch (Exception e2) {
            this.getLogger().log(Level.WARNING, "Can't load " + ontologyID + " in volatile=" + isVolatile + " mode", e2);
            return Optional.empty();
        }
    }

    default public Optional<OWLOntology> getOntology(OWLOntologyID ontologyID) {
        Optional<OWLOntology> ontology = this.getVolatileOntology(ontologyID);
        return ontology.isPresent() ? ontology : this.getPersistentOntology(ontologyID);
    }

    default public Optional<OWLHelper> getHelper(OWLOntologyID ontologyID) {
        Optional<OWLOntology> ontology = this.getVolatileOntology(ontologyID);
        if (ontology.isPresent()) {
            return Optional.of(new OWLGenericTools(this, this.getVolatileManager(), ontology.get()));
        }
        ontology = this.getPersistentOntology(ontologyID);
        if (ontology.isPresent()) {
            return Optional.of(new OWLGenericTools(this, this.getPersistentManager(), ontology.get()));
        }
        return Optional.empty();
    }

    default public Stream<OWLHelper> getVolatilesHelper() {
        if (!this.haveVolatileManager()) {
            return Stream.empty();
        }
        OWLOntologyManager vm = this.getVolatileManager();
        return vm.ontologies().map(ontology -> new OWLGenericTools(this, vm, (OWLOntology)ontology));
    }

    default public Stream<OWLHelper> getPersistentsHelper() {
        if (!this.havePersistentManager()) {
            return Stream.empty();
        }
        OWLOntologyManager vm = this.getPersistentManager();
        return vm.ontologies().map(ontology -> new OWLGenericTools(this, vm, (OWLOntology)ontology));
    }

    public static Optional<OWLOntology> getOntology(OWLOntologyManager manager, OWLOntologyID ontologyID) {
        Optional ontIri = ontologyID.getOntologyIRI();
        if (!ontIri.isPresent()) {
            return Optional.empty();
        }
        Stream<OWLOntology> ontologies = manager.versions((IRI)ontIri.get());
        Optional verIri = ontologyID.getVersionIRI();
        if (verIri.isPresent()) {
            IRI version2 = (IRI)verIri.get();
            ontologies = ontologies.filter(candidat -> candidat.getOntologyID().getVersionIRI().map(arg_0 -> ((IRI)version2).equals(arg_0)).orElse(false));
        }
        return ontologies.findAny();
    }

    default public Optional<OWLOntology> getVolatileOntology(OWLOntologyID ontologyID) {
        if (this.haveVolatileManager()) {
            return OWLGroup.getOntology(this.getVolatileManager(), ontologyID);
        }
        return Optional.empty();
    }

    default public Optional<OWLOntology> getPersistentOntology(OWLOntologyID ontologyID) {
        return OWLGroup.getOntology(this.getPersistentManager(), ontologyID);
    }

    public String ontology2filename(OWLOntologyID var1);

    default public String ontology2filename(OWLOntology ontology) {
        return this.ontology2filename(ontology.getOntologyID());
    }

    public void check(OWLOntologyManager var1);

    default public void remove(OWLHelper helper) {
        helper.dispose();
        helper.getManager().removeOntology(helper.getOntology());
    }
}

