/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import openllet.owlapi.IRIUtils;
import openllet.owlapi.OWL;
import openllet.owlapi.facet.FacetFactoryOWL;
import openllet.owlapi.facet.FacetManagerOWL;
import openllet.owlapi.facet.FacetOntologyOWL;
import openllet.owlapi.facet.FacetReasonerOWL;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;

public interface OWLManagementObject
extends FacetFactoryOWL,
FacetManagerOWL,
FacetOntologyOWL,
FacetReasonerOWL {
    default public ChangeApplied addAxiom(OWLAxiom axiom) {
        return this.getOntology().add(axiom);
    }

    default public ChangeApplied addAxioms(Stream<OWLAxiom> axioms) {
        return this.getOntology().addAxioms(axioms);
    }

    default public ChangeApplied removeAxiom(OWLAxiom axiom) {
        return this.getOntology().remove(axiom);
    }

    default public ChangeApplied removeAxioms(Stream<OWLAxiom> axioms) {
        return this.getOntology().removeAxioms(axioms);
    }

    default public void addObjectPropertyAxiom(OWLObjectPropertyExpression property, OWLIndividual subject, OWLIndividual value) {
        this.addAxiom((OWLAxiom)this.getFactory().getOWLObjectPropertyAssertionAxiom(property, subject, value));
    }

    default public void addDataPropertyAxiom(OWLDataProperty property, OWLIndividual subject, OWLLiteral literal) {
        this.addAxiom((OWLAxiom)this.getFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)property, subject, literal));
    }

    default public void addDataPropertyAxiom(OWLDataProperty property, OWLIndividual subject, String value) {
        this.addDataPropertyAxiom(property, subject, this.getFactory().getOWLLiteral(value));
    }

    default public void addDataPropertyAxiom(OWLDataProperty property, OWLIndividual subject, double value) {
        this.addDataPropertyAxiom(property, subject, this.getFactory().getOWLLiteral(value));
    }

    default public void addDataPropertyAxiom(OWLDataProperty property, OWLIndividual subject, long value) {
        this.addDataPropertyAxiom(property, subject, this.getFactory().getOWLLiteral((double)value));
    }

    default public void addDataPropertyAxiom(OWLDataProperty property, OWLIndividual subject, int value) {
        this.addDataPropertyAxiom(property, subject, this.getFactory().getOWLLiteral(value));
    }

    default public void addClassPropertyAxiom(OWLClassExpression clazz, OWLIndividual subject) {
        this.addAxiom((OWLAxiom)this.getFactory().getOWLClassAssertionAxiom(clazz, subject));
    }

    default public void removeObjectPropertyAxiom(OWLObjectPropertyExpression property, OWLIndividual subject, OWLIndividual value) {
        this.removeAxiom((OWLAxiom)this.getFactory().getOWLObjectPropertyAssertionAxiom(property, subject, value));
    }

    default public void removeDataPropertyAxiom(OWLDataProperty property, OWLIndividual subject, OWLLiteral literal) {
        this.removeAxiom((OWLAxiom)this.getFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)property, subject, literal));
    }

    default public void removeDataPropertyAxiom(OWLDataProperty property, OWLNamedIndividual subject) {
        this.removeAxioms(this.getValues(subject, property).stream().map(value -> this.getFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)property, (OWLIndividual)subject, value)));
    }

    default public void removeDataPropertyAxiom(IRI property, OWLNamedIndividual subject) {
        this.removeDataPropertyAxiom(this.getFactory().getOWLDataProperty(property), subject);
    }

    default public void removeObjectPropertyAxiom(OWLObjectProperty property, OWLNamedIndividual subject) {
        this.removeAxioms(this.getObjects(subject, (OWLObjectPropertyExpression)property).map(object -> this.getFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)property, (OWLIndividual)subject, (OWLIndividual)object)));
    }

    default public void removeObjectPropertyAxiom(IRI property, OWLNamedIndividual subject) {
        this.removeObjectPropertyAxiom(this.getFactory().getOWLObjectProperty(property), subject);
    }

    default public boolean individualHaveFacet(OWLNamedIndividual named, OWLClassExpression facette) {
        return this.getReasoner().isEntailed((OWLAxiom)this.getFactory().getOWLClassAssertionAxiom(facette, (OWLIndividual)named));
    }

    default public boolean isLiteralIncludeInRange(OWLDataProperty property, OWLDataRange range, OWLLiteral literal) {
        return this.getReasoner().isSatisfiable((OWLClassExpression)OWL.and(new OWLClassExpression[]{OWL.some((OWLDataPropertyExpression)property, (OWLDataRange)OWL.oneOf(literal)), OWL.some((OWLDataPropertyExpression)property, range), OWL.max((OWLDataPropertyExpression)property, 1)}));
    }

    default public OWLClass declareClassOfIndividual(Class<?> clazz, OWLNamedIndividual individual) {
        OWLClass owlClazz = this.toClass(IRIUtils.clazz(clazz));
        this.addClass(individual, (OWLClassExpression)owlClazz);
        return owlClazz;
    }

    default public OWLNamedIndividual declareIndividual(IRI iri2) {
        OWLNamedIndividual baby = this.toIndividual(iri2);
        this.addAxiom((OWLAxiom)this.getFactory().getOWLDeclarationAxiom((OWLEntity)baby));
        return baby;
    }

    default public OWLNamedIndividual declareIndividual(OWLClass owlClazz, OWLNamedIndividual individual) {
        this.addAxiom((OWLAxiom)this.getFactory().getOWLDeclarationAxiom((OWLEntity)individual));
        this.addClass(individual, (OWLClassExpression)owlClazz);
        return individual;
    }

    default public OWLNamedIndividual declareIndividual(OWLClass owlClazz, IRI individual) {
        OWLNamedIndividual owlIndividual = this.declareIndividual(individual);
        this.addClass(owlIndividual, (OWLClassExpression)owlClazz);
        return owlIndividual;
    }

    @Deprecated
    default public OWLNamedIndividual declareIndividual(OWLClass owlClazz, String namespace2, String name) {
        return this.declareIndividual(owlClazz, IRI.create((String)(IRIUtils.isIRI(name) ? name : namespace2 + IRIUtils.randId(name))));
    }

    default public OWLAnonymousIndividual declareIndividual() {
        return this.getFactory().getOWLAnonymousIndividual();
    }

    default public OWLObjectProperty declareObjectProperty(IRI iri2) {
        OWLObjectProperty baby = this.toObjectProperty(iri2);
        this.addAxiom((OWLAxiom)this.getFactory().getOWLDeclarationAxiom((OWLEntity)baby));
        return baby;
    }

    default public OWLDataProperty declareDataProperty(IRI iri2) {
        OWLDataProperty baby = this.toDataProperty(iri2);
        this.addAxiom((OWLAxiom)this.getFactory().getOWLDeclarationAxiom((OWLEntity)baby));
        return baby;
    }

    default public OWLClass declareClass(IRI clazz) {
        OWLClass owlClazz = this.toClass(clazz);
        this.addAxiom((OWLAxiom)this.getFactory().getOWLDeclarationAxiom((OWLEntity)owlClazz));
        return owlClazz;
    }

    default public OWLObjectProperty toObjectProperty(IRI iri2) {
        return this.getFactory().getOWLObjectProperty(iri2);
    }

    default public OWLDataProperty toDataProperty(IRI iri2) {
        return this.getFactory().getOWLDataProperty(iri2);
    }

    default public OWLClass toClass(IRI iri2) {
        return this.getFactory().getOWLClass(iri2);
    }

    default public OWLNamedIndividual toIndividual(IRI iri2) {
        return this.getFactory().getOWLNamedIndividual(iri2);
    }

    default public Stream<OWLNamedIndividual> getObjects(OWLNamedIndividual subject, OWLObjectPropertyExpression property) {
        return this.getReasoner().getObjectPropertyValues(subject, property).entities();
    }

    default public Stream<OWLNamedIndividual> getObjects(OWLNamedIndividual subject, IRI property) {
        return this.getObjects(subject, (OWLObjectPropertyExpression)this.toObjectProperty(property));
    }

    default public Set<OWLLiteral> getValues(OWLNamedIndividual subject, OWLDataProperty property) {
        return this.getReasoner().getDataPropertyValues(subject, property);
    }

    default public Set<OWLLiteral> getValues(OWLNamedIndividual subject, IRI property) {
        return this.getValues(subject, this.toDataProperty(property));
    }

    default public Optional<OWLNamedIndividual> getObject(OWLNamedIndividual subject, OWLObjectPropertyExpression property) {
        return this.getObjects(subject, property).findAny();
    }

    default public Optional<OWLNamedIndividual> getObject(OWLNamedIndividual subject, IRI property) {
        return this.getObject(subject, (OWLObjectPropertyExpression)this.toObjectProperty(property));
    }

    default public Optional<OWLLiteral> getValue(OWLNamedIndividual subject, OWLDataProperty property) {
        Set<OWLLiteral> values = this.getValues(subject, property);
        return values.isEmpty() ? Optional.empty() : Optional.of(values.iterator().next());
    }

    default public Optional<OWLLiteral> getValue(OWLNamedIndividual subject, IRI property) {
        return this.getValue(subject, this.toDataProperty(property));
    }

    default public void addObject(OWLNamedIndividual subject, OWLObjectPropertyExpression property, OWLNamedIndividual object) {
        this.addObjectPropertyAxiom(property, (OWLIndividual)subject, (OWLIndividual)object);
    }

    default public void addObject(OWLNamedIndividual subject, IRI property, OWLNamedIndividual object) {
        this.addObject(subject, (OWLObjectPropertyExpression)this.toObjectProperty(property), object);
    }

    default public void addValue(OWLNamedIndividual subject, OWLDataProperty property, OWLLiteral literal) {
        this.addDataPropertyAxiom(property, (OWLIndividual)subject, literal);
    }

    default public void addValue(OWLNamedIndividual subject, IRI property, OWLLiteral literal) {
        this.addValue(subject, this.toDataProperty(property), literal);
    }

    default public void addValue(OWLNamedIndividual subject, OWLDataProperty property, String literal) {
        this.addDataPropertyAxiom(property, (OWLIndividual)subject, literal);
    }

    default public void addValue(OWLNamedIndividual subject, IRI property, String literal) {
        this.addValue(subject, this.toDataProperty(property), literal);
    }

    default public void addValue(OWLNamedIndividual subject, OWLDataProperty property, int literal) {
        this.addDataPropertyAxiom(property, (OWLIndividual)subject, literal);
    }

    default public void addValue(OWLNamedIndividual subject, IRI property, int literal) {
        this.addValue(subject, this.toDataProperty(property), literal);
    }

    default public void addValue(OWLNamedIndividual subject, OWLDataProperty property, double literal) {
        this.addDataPropertyAxiom(property, (OWLIndividual)subject, literal);
    }

    default public void addValue(OWLNamedIndividual subject, IRI property, double literal) {
        this.addValue(subject, this.toDataProperty(property), literal);
    }

    default public void updateObject(OWLNamedIndividual subject, OWLObjectProperty property, OWLNamedIndividual object) {
        this.removeObjectPropertyAxiom(property, subject);
        this.addObjectPropertyAxiom((OWLObjectPropertyExpression)property, (OWLIndividual)subject, (OWLIndividual)object);
    }

    default public void updateObject(OWLNamedIndividual subject, IRI property, OWLNamedIndividual object) {
        this.updateObject(subject, this.toObjectProperty(property), object);
    }

    default public void updateValue(OWLNamedIndividual subject, OWLDataProperty property, OWLLiteral literal) {
        this.removeDataPropertyAxiom(property, subject);
        this.addDataPropertyAxiom(property, (OWLIndividual)subject, literal);
    }

    default public void updateValue(OWLNamedIndividual subject, IRI property, OWLLiteral literal) {
        this.updateValue(subject, this.toDataProperty(property), literal);
    }

    default public void updateValue(OWLNamedIndividual subject, OWLDataProperty property, String literal) {
        this.removeDataPropertyAxiom(property, subject);
        this.addDataPropertyAxiom(property, (OWLIndividual)subject, literal);
    }

    default public void updateValue(OWLNamedIndividual subject, IRI property, String literal) {
        this.updateValue(subject, this.toDataProperty(property), literal);
    }

    default public void updateValue(OWLNamedIndividual subject, OWLDataProperty property, int literal) {
        this.removeDataPropertyAxiom(property, subject);
        this.addDataPropertyAxiom(property, (OWLIndividual)subject, literal);
    }

    default public void updateValue(OWLNamedIndividual subject, IRI property, int literal) {
        this.updateValue(subject, this.toDataProperty(property), literal);
    }

    default public void updateValue(OWLNamedIndividual subject, OWLDataProperty property, double literal) {
        this.removeDataPropertyAxiom(property, subject);
        this.addDataPropertyAxiom(property, (OWLIndividual)subject, literal);
    }

    default public void updateValue(OWLNamedIndividual subject, IRI property, double literal) {
        this.updateValue(subject, this.toDataProperty(property), literal);
    }

    default public void addClass(OWLNamedIndividual subject, OWLClassExpression clazz) {
        this.addAxiom((OWLAxiom)this.getFactory().getOWLClassAssertionAxiom(clazz, (OWLIndividual)subject));
    }

    default public void addClass(OWLNamedIndividual subject, IRI clazz) {
        this.addClass(subject, (OWLClassExpression)this.toClass(clazz));
    }
}

