/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import openllet.atom.OpenError;
import openllet.owlapi.OWL;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;

public class OntologyUtils {
    @Deprecated
    private static final OWLOntologyManager _manager = OWL._manager;

    @Deprecated
    public static void addAxioms(OWLOntology ontology, Collection<? extends OWLAxiom> axioms) {
        OntologyUtils.addAxioms(ontology, axioms.stream());
    }

    @Deprecated
    public static void addAxioms(OWLOntology ontology, Stream<? extends OWLAxiom> axioms) {
        OntologyUtils.updateOntology(ontology, axioms, true);
    }

    @Deprecated
    public static void addAxioms(OWLOntology ontology, OWLAxiom ... axioms) {
        OntologyUtils.addAxioms(ontology, Arrays.asList(axioms));
    }

    @Deprecated
    public static boolean containsClass(Set<Set<OWLClass>> classes, OWLClass cls) {
        for (Set<OWLClass> set : classes) {
            if (!set.contains(cls)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static Set<OWLEntity> getSignature(OWLAxiom axiom) {
        return axiom.getSignature();
    }

    @Deprecated
    public static Stream<OWLEntity> signature(OWLAxiom axiom) {
        return axiom.signature();
    }

    @Deprecated
    public static OWLOntologyManager getOWLOntologyManager() {
        return _manager;
    }

    @Deprecated
    public static void clearOWLOntologyManager() {
        _manager.clearOntologies();
    }

    @Deprecated
    public static OWLOntology loadOntology(String uri) {
        return OntologyUtils.loadOntology(_manager, uri);
    }

    public static OWLOntology loadOntology(OWLOntologyManager manager, String uri) {
        try {
            return manager.loadOntology(IRI.create((String)uri));
        }
        catch (OWLOntologyCreationException e2) {
            throw new OpenError(e2);
        }
    }

    @Deprecated
    public static OWLOntology loadOntology(InputStream inputStream) {
        return OntologyUtils.loadOntology(_manager, inputStream);
    }

    public static OWLOntology loadOntology(OWLOntologyManager manager, InputStream inputStream) {
        try {
            return manager.loadOntologyFromOntologyDocument(inputStream);
        }
        catch (OWLOntologyCreationException e2) {
            throw new OpenError(e2);
        }
    }

    @Deprecated
    public static OWLOntology loadOntology(String uri, boolean withAnnotations) {
        return OntologyUtils.loadOntology(_manager, uri, withAnnotations);
    }

    public static OWLOntology loadOntology(OWLOntologyManager manager, String uri, boolean withAnnotations) {
        OWLOntology ont = OntologyUtils.loadOntology(manager, uri);
        if (!withAnnotations) {
            OntologyUtils.removeAllAnnotations(ont);
        }
        return ont;
    }

    @Deprecated
    public static OWLOntology loadOntology(InputStream inputStream, boolean withAnnotations) {
        return OntologyUtils.loadOntology(_manager, inputStream, withAnnotations);
    }

    public static OWLOntology loadOntology(OWLOntologyManager manager, InputStream inputStream, boolean withAnnotations) {
        OWLOntology ont = OntologyUtils.loadOntology(manager, inputStream);
        if (!withAnnotations) {
            OntologyUtils.removeAllAnnotations(ont);
        }
        return ont;
    }

    @Deprecated
    public static void printAxioms(Collection<? extends OWLAxiom> axioms) {
        for (OWLAxiom oWLAxiom : axioms) {
            System.out.println(oWLAxiom);
        }
    }

    @Deprecated
    public static void printOntology(OWLOntology ont) {
        ont.axioms().map(Object::toString).sorted().forEach(System.out::println);
    }

    public static void removeAxioms(OWLOntology ontology, Collection<? extends OWLAxiom> axioms) {
        OntologyUtils.updateOntology(ontology, axioms, false);
    }

    @Deprecated
    public static void removeAxioms(OWLOntology ontology, OWLAxiom ... axioms) {
        OntologyUtils.removeAxioms(ontology, Arrays.asList(axioms));
    }

    @Deprecated
    public static void save(OWLOntology ont, String path) throws OWLOntologyStorageException {
        _manager.saveOntology(ont, IRI.create((URI)new File(path).toURI()));
    }

    public static void updateOntology(OWLOntology ontology, Stream<? extends OWLAxiom> axioms, boolean add) {
        if (add) {
            ontology.addAxioms(axioms);
        } else {
            ontology.removeAxioms(axioms);
        }
    }

    public static void updateOntology(OWLOntology ontology, Collection<? extends OWLAxiom> axioms, boolean add) {
        OntologyUtils.updateOntology(ontology, axioms.stream(), add);
    }

    public static boolean containsUnreferencedEntity(OWLOntology ontology, OWLClassExpression desc) {
        for (OWLEntity entity : desc.signature().collect(Collectors.toList())) {
            if (ontology.containsEntityInSignature(entity) || entity instanceof OWLClass && (((OWLClass)entity).isOWLThing() || ((OWLClass)entity).isOWLNothing())) continue;
            return true;
        }
        return false;
    }

    public static Set<OWLOntology> removeAxiom(OWLAxiom axiom, Set<OWLOntology> ontologies, OWLOntologyManager manager) {
        HashSet<OWLOntology> modifiedOnts = new HashSet<OWLOntology>();
        for (OWLOntology ont : ontologies) {
            if (!ont.containsAxiom(axiom)) continue;
            modifiedOnts.add(ont);
            manager.applyChange((OWLOntologyChange)new RemoveAxiom(ont, axiom));
        }
        return modifiedOnts;
    }

    public static void addAxiom(OWLAxiom axiom, Set<OWLOntology> ontologies, OWLOntologyManager manager) {
        for (OWLOntology ont : ontologies) {
            manager.applyChange((OWLOntologyChange)new AddAxiom(ont, axiom));
        }
    }

    public static void removeAllAnnotations(OWLOntology ontology) {
        try {
            Set referencedEntities = Stream.concat(Stream.concat(ontology.classesInSignature(), ontology.objectPropertiesInSignature()), Stream.concat(ontology.dataPropertiesInSignature(), ontology.individualsInSignature())).collect(Collectors.toSet());
            ontology.removeAxioms(ontology.axioms().filter(axiom -> !axiom.isLogicalAxiom()));
            OWLDataFactory factory = ontology.getOWLOntologyManager().getOWLDataFactory();
            ontology.addAxioms(referencedEntities.stream().filter(entity -> !ontology.containsEntityInSignature(entity)).map(arg_0 -> ((OWLDataFactory)factory).getOWLDeclarationAxiom(arg_0)));
        }
        catch (OWLOntologyChangeException e2) {
            throw new OWLRuntimeException((Throwable)e2);
        }
    }

    public static OWLEntity findEntity(String name, Stream<OWLOntology> ontologies) {
        return ontologies.map(ontology -> OntologyUtils.findEntity(name, ontology)).filter(entity -> entity != null).findAny().orElse(null);
    }

    @Deprecated
    public static OWLEntity findEntity(String name, Set<OWLOntology> ontologies) {
        OWLOntology ontology;
        OWLEntity entity = null;
        Iterator<OWLOntology> iterator = ontologies.iterator();
        while (iterator.hasNext() && (entity = OntologyUtils.findEntity(name, ontology = iterator.next())) == null) {
        }
        return entity;
    }

    public static OWLEntity findEntity(String name, OWLOntology ontology) {
        OWLClass entity = null;
        if ("owl:Thing".equals(name)) {
            entity = OWL.Thing;
        } else if ("owl:Nothing".equals(name)) {
            entity = OWL.Nothing;
        } else {
            IRI baseIRI;
            IRI iri2 = IRI.create((String)name);
            if (iri2 == null) {
                throw new OpenError("Invalid IRI: " + iri2);
            }
            if (!iri2.isAbsolute() && (baseIRI = (IRI)ontology.getOntologyID().getOntologyIRI().orElse(null)) != null) {
                iri2 = baseIRI.resolve("#" + iri2);
            }
            if (ontology.containsClassInSignature(iri2, Imports.EXCLUDED)) {
                entity = OWL.Class(iri2);
            } else if (ontology.containsObjectPropertyInSignature(iri2, Imports.EXCLUDED)) {
                entity = OWL.ObjectProperty(iri2);
            } else if (ontology.containsDataPropertyInSignature(iri2, Imports.EXCLUDED)) {
                entity = OWL.DataProperty(iri2);
            } else if (ontology.containsIndividualInSignature(iri2, Imports.EXCLUDED)) {
                entity = OWL.Individual(iri2).asOWLNamedIndividual();
            }
        }
        return entity;
    }
}

