/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.KnowledgeBaseImplFullSync;
import openllet.core.OpenlletOptions;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.exceptions.PelletRuntimeException;
import openllet.core.exceptions.TimeoutException;
import openllet.core.exceptions.TimerInterruptedException;
import openllet.core.exceptions.UndefinedEntityException;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.VersionInfo;
import openllet.owlapi.EntailmentChecker;
import openllet.owlapi.OWLManagerGroup;
import openllet.owlapi.OpenlletReasoner;
import openllet.owlapi.OpenlletReasonerFactory;
import openllet.owlapi.PelletVisitor;
import openllet.owlapi.ProgressAdapter;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.NodeFactory;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.util.Version;

public class PelletReasoner
implements OpenlletReasoner {
    public static final Logger _logger = Log.getLogger(PelletReasoner.class);
    private static final Set<InferenceType> PRECOMPUTABLE_INFERENCES = EnumSet.of(InferenceType.CLASS_HIERARCHY, InferenceType.CLASS_ASSERTIONS, InferenceType.OBJECT_PROPERTY_HIERARCHY, InferenceType.DATA_PROPERTY_HIERARCHY);
    private static final Version VERSION = PelletReasoner.createVersion();
    private final OWLOntologyManager _manager;
    private volatile OWLDataFactory _factory;
    private volatile OWLOntology _ontology;
    private volatile KnowledgeBase _kb = new KnowledgeBaseImplFullSync();
    private volatile ReasonerProgressMonitor _monitor;
    private volatile boolean _shouldRefresh;
    private final PelletVisitor _visitor;
    private final BufferingMode _bufferingMode;
    private final List<OWLOntologyChange> _pendingChanges = new ArrayList<OWLOntologyChange>();
    private volatile IndividualNodeSetPolicy _individualNodeSetPolicy;
    private final ChangeVisitor _changeVisitor = new ChangeVisitor();
    private final EntityMapper<OWLNamedIndividual> IND_MAPPER = new NamedIndividualMapper();
    private final EntityMapper<OWLLiteral> LIT_MAPPER = new LiteralMapper();
    private final EntityMapper<OWLObjectPropertyExpression> OP_MAPPER = new ObjectPropertyMapper();
    private final EntityMapper<OWLDataProperty> DP_MAPPER = new DataPropertyMapper();
    private final EntityMapper<OWLDatatype> DT_MAPPER = new DatatypeMapper();
    private final EntityMapper<OWLClass> CLASS_MAPPER = new ClassMapper();

    private static Version createVersion() {
        String versionString = VersionInfo.getInstance().getVersionString();
        String[] versionNumbers = versionString.split("\\.");
        int major = PelletReasoner.parseNumberIfExists(versionNumbers, 0);
        int minor = PelletReasoner.parseNumberIfExists(versionNumbers, 1);
        int patch = PelletReasoner.parseNumberIfExists(versionNumbers, 2);
        int build = PelletReasoner.parseNumberIfExists(versionNumbers, 3);
        return new Version(major, minor, patch, build);
    }

    private static int parseNumberIfExists(String[] numbers, int index) {
        try {
            if (0 <= index && index < numbers.length) {
                return Integer.parseInt(numbers[index]);
            }
        }
        catch (NumberFormatException e2) {
            _logger.log(Level.FINE, "Invalid number in version identifier: " + numbers[index], e2);
        }
        return 0;
    }

    private static IRI iri(ATermAppl term) {
        if (term.getArity() != 0) {
            throw new OWLRuntimeException("Trying to convert an anonymous term " + term);
        }
        return IRI.create((String)term.getName());
    }

    @Override
    public OWLOntologyManager getManager() {
        return this._manager;
    }

    @Override
    public OWLManagerGroup getGroup() {
        return null;
    }

    @Override
    public OWLDataFactory getFactory() {
        return this._factory;
    }

    @Override
    public OWLOntology getOntology() {
        return this._ontology;
    }

    @Override
    public KnowledgeBase getKB() {
        return this._kb;
    }

    public PelletReasoner(OWLOntology ontology, BufferingMode bufferingMode) {
        this(ontology, (OWLReasonerConfiguration)new SimpleConfiguration((ReasonerProgressMonitor)new NullReasonerProgressMonitor(), OpenlletOptions.SILENT_UNDEFINED_ENTITY_HANDLING ? FreshEntityPolicy.ALLOW : FreshEntityPolicy.DISALLOW, 0L, IndividualNodeSetPolicy.BY_SAME_AS), bufferingMode);
    }

    public PelletReasoner(OWLOntology ontology, OWLReasonerConfiguration config, BufferingMode bufferingMode) throws IllegalConfigurationException {
        this._individualNodeSetPolicy = config.getIndividualNodeSetPolicy();
        if (!this.getFreshEntityPolicy().equals((Object)config.getFreshEntityPolicy())) {
            throw new IllegalConfigurationException("OpenlletOptions.SILENT_UNDEFINED_ENTITY_HANDLING conflicts with reasoner configuration", config);
        }
        this._ontology = ontology;
        this._monitor = config.getProgressMonitor();
        this._kb.setTaxonomyBuilderProgressMonitor(new ProgressAdapter(this._monitor));
        if (config.getTimeOut() > 0L) {
            this._kb.getTimers()._mainTimer.setTimeout(config.getTimeOut());
        }
        this._manager = ontology.getOWLOntologyManager();
        this._factory = this._manager.getOWLDataFactory();
        this._visitor = new PelletVisitor(this._kb);
        this._bufferingMode = bufferingMode;
        this._manager.addOntologyChangeListener((OWLOntologyChangeListener)this);
        this._shouldRefresh = true;
        this.refresh();
    }

    private static PelletRuntimeException convert(PelletRuntimeException e2) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException, FreshEntitiesException {
        if (e2 instanceof TimeoutException) {
            throw new TimeOutException();
        }
        if (e2 instanceof TimerInterruptedException) {
            throw new ReasonerInterruptedException((Throwable)e2);
        }
        if (e2 instanceof openllet.core.exceptions.InconsistentOntologyException) {
            throw new InconsistentOntologyException((Throwable)e2);
        }
        if (e2 instanceof UndefinedEntityException) {
            Set unknown = Collections.emptySet();
            throw new FreshEntitiesException(unknown);
        }
        return e2;
    }

    public void dispose() {
        this._manager.removeOntologyChangeListener((OWLOntologyChangeListener)this);
        this._kb = null;
        this._pendingChanges.clear();
        this._factory = null;
        this._ontology = null;
        this._monitor = null;
        this._individualNodeSetPolicy = null;
    }

    public void flush() {
        try {
            this.processChanges(this._pendingChanges);
        }
        catch (Exception e2) {
            Log.error(_logger, e2);
        }
        this._pendingChanges.clear();
        this.refreshCheck();
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.getUnsatisfiableClasses();
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        this.refreshCheck();
        return this.toDataPropertyNode(this._kb.getAllEquivalentProperties(ATermUtils.BOTTOM_DATA_PROPERTY));
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        this.refreshCheck();
        return this.toObjectPropertyNode(this._kb.getAllEquivalentProperties(ATermUtils.BOTTOM_OBJECT_PROPERTY));
    }

    public BufferingMode getBufferingMode() {
        return this._bufferingMode;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            ATermAppl some = ATermUtils.makeSomeValues(this.term((OWLObject)pe), ATermUtils.TOP_LIT);
            Set<ATermAppl> equivalents = this._kb.getEquivalentClasses(some);
            if (direct && !equivalents.isEmpty()) {
                return this.toClassNodeSet(Collections.singleton(equivalents));
            }
            Set<Set<ATermAppl>> result = this._kb.getSuperClasses(some, direct);
            if (!equivalents.isEmpty()) {
                result.add(equivalents);
            }
            return this.toClassNodeSet(result);
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toLiteralSet(this._kb.getDataPropertyValues(this.term((OWLObject)pe), this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    @Override
    public Set<OWLLiteral> getAnnotationPropertyValues(OWLNamedIndividual ind, OWLAnnotationProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toLiteralSet(this._kb.getPropertyValues(this.term((OWLObject)pe), this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.getIndividualNodeSet(this._kb.getDifferents(this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            Set<Set<ATermAppl>> disjoints = this._kb.getDisjointClasses(this.term((OWLObject)ce));
            return this.toClassNodeSet(disjoints);
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLDataProperty>> values = new HashSet<Node<OWLDataProperty>>();
            for (Set<ATermAppl> val : this._kb.getDisjointProperties(this.term((OWLObject)pe))) {
                values.add(this.toDataPropertyNode(val));
            }
            return new OWLDataPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLObjectPropertyExpression>> values = new HashSet<Node<OWLObjectPropertyExpression>>();
            for (Set<ATermAppl> val : this._kb.getDisjointProperties(this.term((OWLObject)pe))) {
                values.add(this.toObjectPropertyNode(val));
            }
            return new OWLObjectPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toClassNode(this._kb.getAllEquivalentClasses(this.term((OWLObject)ce)));
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toDataPropertyNode(this._kb.getAllEquivalentProperties(this.term((OWLObject)pe)));
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toObjectPropertyNode(this._kb.getAllEquivalentProperties(this.term((OWLObject)pe)));
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this._individualNodeSetPolicy;
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSetBySameAs(Collection<ATermAppl> individuals) {
        HashSet<Node<OWLNamedIndividual>> instances = new HashSet<Node<OWLNamedIndividual>>();
        HashSet<ATermAppl> seen = new HashSet<ATermAppl>();
        for (ATermAppl ind : individuals) {
            if (seen.contains(ind)) continue;
            Set<ATermAppl> equiv = this._kb.getAllSames(ind);
            instances.add(this.toIndividualNode(equiv));
            seen.addAll(equiv);
        }
        return new OWLNamedIndividualNodeSet(instances);
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSetByName(Collection<ATermAppl> individuals) {
        HashSet<Node<OWLNamedIndividual>> instances = new HashSet<Node<OWLNamedIndividual>>();
        for (ATermAppl ind : individuals) {
            for (ATermAppl equiv : this._kb.getAllSames(ind)) {
                instances.add(this.toIndividualNode(equiv));
            }
        }
        return new OWLNamedIndividualNodeSet(instances);
    }

    private Stream<OWLNamedIndividual> individualStream(Stream<ATermAppl> individuals) {
        return individuals.map(this._kb::getAllSames).flatMap(set -> set.stream()).distinct().map(this.IND_MAPPER::map);
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSet(Collection<ATermAppl> individuals) {
        switch (this._individualNodeSetPolicy) {
            case BY_SAME_AS: {
                return this.getIndividualNodeSetBySameAs(individuals);
            }
            case BY_NAME: {
                return this.getIndividualNodeSetByName(individuals);
            }
        }
        throw new AssertionError((Object)("Unsupported IndividualNodeSetPolicy : " + this._individualNodeSetPolicy));
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.getIndividualNodeSet(this._kb.getInstances(this.term((OWLObject)ce), direct));
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toObjectPropertyNode(this._kb.getInverses(this.term((OWLObject)pe)));
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            ATermAppl some = ATermUtils.makeSomeValues(this.term((OWLObject)pe), ATermUtils.TOP);
            Set<ATermAppl> equivalents = this._kb.getEquivalentClasses(some);
            if (direct && !equivalents.isEmpty()) {
                return this.toClassNodeSet(Collections.singleton(equivalents));
            }
            Set<Set<ATermAppl>> result = this._kb.getSuperClasses(some, direct);
            if (!equivalents.isEmpty()) {
                result.add(equivalents);
            }
            return this.toClassNodeSet(result);
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            ATermAppl some = ATermUtils.makeSomeValues(ATermUtils.makeInv(this.term((OWLObject)pe)), ATermUtils.TOP);
            Set<ATermAppl> equivalents = this._kb.getEquivalentClasses(some);
            if (direct && !equivalents.isEmpty()) {
                return this.toClassNodeSet(Collections.singleton(equivalents));
            }
            Set<Set<ATermAppl>> result = this._kb.getSuperClasses(some, direct);
            if (!equivalents.isEmpty()) {
                result.add(equivalents);
            }
            return this.toClassNodeSet(result);
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.getIndividualNodeSet(this._kb.getObjectPropertyValues(this.term((OWLObject)pe), this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public Stream<OWLNamedIndividual> objectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.individualStream(this._kb.getObjectPropertyValues(this.term((OWLObject)pe), this.term((OWLObject)ind)).stream());
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        return Collections.emptySet();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        return Collections.emptySet();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return this._pendingChanges;
    }

    public String getReasonerName() {
        return OpenlletReasonerFactory.getInstance().getReasonerName();
    }

    public Version getReasonerVersion() {
        return VERSION;
    }

    public OWLOntology getRootOntology() {
        return this._ontology;
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toIndividualNode(this._kb.getAllSames(this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toClassNodeSet(this._kb.getSubClasses(this.term((OWLObject)ce), direct));
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLDataProperty>> values = new HashSet<Node<OWLDataProperty>>();
            for (Set<ATermAppl> val : this._kb.getSubProperties(this.term((OWLObject)pe), direct)) {
                values.add(this.toDataPropertyNode(val));
            }
            return new OWLDataPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLObjectPropertyExpression>> values = new HashSet<Node<OWLObjectPropertyExpression>>();
            for (Set<ATermAppl> val : this._kb.getSubProperties(this.term((OWLObject)pe), direct)) {
                values.add(this.toObjectPropertyNode(val));
            }
            return new OWLObjectPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toClassNodeSet(this._kb.getSuperClasses(this.term((OWLObject)ce), direct));
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLDataProperty>> values = new HashSet<Node<OWLDataProperty>>();
            for (Set<ATermAppl> val : this._kb.getSuperProperties(this.term((OWLObject)pe), direct)) {
                values.add(this.toDataPropertyNode(val));
            }
            return new OWLDataPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLObjectPropertyExpression>> values = new HashSet<Node<OWLObjectPropertyExpression>>();
            for (Set<ATermAppl> val : this._kb.getSuperProperties(this.term((OWLObject)pe), direct)) {
                values.add(this.toObjectPropertyNode(val));
            }
            return new OWLObjectPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public long getTimeOut() {
        return this._kb.getTimers()._mainTimer.getTimeout();
    }

    public Node<OWLClass> getTopClassNode() {
        this.refreshCheck();
        return this.toClassNode(this._kb.getAllEquivalentClasses(ATermUtils.TOP));
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        this.refreshCheck();
        return this.toDataPropertyNode(this._kb.getAllEquivalentProperties(ATermUtils.TOP_DATA_PROPERTY));
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        this.refreshCheck();
        return this.toObjectPropertyNode(this._kb.getAllEquivalentProperties(ATermUtils.TOP_OBJECT_PROPERTY));
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            Set<Set<ATermAppl>> result = this._kb.getTypes(this.term((OWLObject)ind), direct);
            return this.toClassNodeSet(result);
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return OpenlletOptions.SILENT_UNDEFINED_ENTITY_HANDLING ? FreshEntityPolicy.ALLOW : FreshEntityPolicy.DISALLOW;
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toClassNode(this._kb.getAllUnsatisfiableClasses());
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public void interrupt() {
        this._kb.getTimers().interrupt();
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this._kb.isConsistent();
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public boolean isEntailed(OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.refreshCheck();
        try {
            return this.isEntailed(Collections.singleton(axiom));
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public boolean isEntailed(Stream<? extends OWLAxiom> axioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.refreshCheck();
        try {
            EntailmentChecker entailmentChecker = new EntailmentChecker(this);
            return entailmentChecker.isEntailed(axioms);
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        return this.isEntailed(axioms.stream());
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return !EntailmentChecker.UNSUPPORTED_ENTAILMENT.contains(axiomType);
    }

    public boolean isSatisfiable(OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.refreshCheck();
        try {
            return this._kb.isSatisfiable(this.term((OWLObject)classExpression));
        }
        catch (PelletRuntimeException e2) {
            throw PelletReasoner.convert(e2);
        }
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        switch (this._bufferingMode) {
            case BUFFERING: {
                this._pendingChanges.addAll(changes);
                break;
            }
            case NON_BUFFERING: {
                this.processChanges(changes);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected buffering mode: " + this._bufferingMode));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processChanges(List<? extends OWLOntologyChange> changes) {
        if (this._shouldRefresh) {
            return false;
        }
        Set importsClosure = this._ontology.importsClosure().collect(Collectors.toSet());
        for (OWLOntologyChange oWLOntologyChange : new ArrayList<OWLOntologyChange>(changes)) {
            _logger.fine(() -> "Changed: " + change + " in " + change.getOntology());
            if (null == oWLOntologyChange || !importsClosure.contains(oWLOntologyChange.getOntology())) continue;
            PelletVisitor pelletVisitor = this._visitor;
            synchronized (pelletVisitor) {
                if (!this._changeVisitor.process(oWLOntologyChange)) {
                    _logger.fine(() -> "Reload required by ontology change " + change);
                    this._shouldRefresh = true;
                    break;
                }
            }
        }
        return !this._shouldRefresh;
    }

    @Override
    public void prepareReasoner() throws ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        if (this._kb.isConsistent()) {
            this._kb.realize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        PelletVisitor pelletVisitor = this._visitor;
        synchronized (pelletVisitor) {
            this._visitor.clear();
            this._kb.clear();
            this._visitor.setAddAxiom(true);
            this._ontology.importsClosure().forEach(ont -> ont.accept((OWLObjectVisitor)this._visitor));
            this._visitor.verify();
            this._shouldRefresh = false;
        }
    }

    private void refreshCheck() {
        if (null == this._kb) {
            throw new OWLRuntimeException("Trying to use a disposed reasoner");
        }
        if (this._shouldRefresh) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ATermAppl term(OWLObject d) {
        PelletVisitor pelletVisitor = this._visitor;
        synchronized (pelletVisitor) {
            this.refreshCheck();
            this._visitor.reset();
            this._visitor.setAddAxiom(false);
            d.accept((OWLObjectVisitor)this._visitor);
            ATermAppl a = this._visitor.result();
            if (null == a) {
                throw new InternalReasonerException("Cannot create ATerm from description " + d);
            }
            return a;
        }
    }

    private NodeSet<OWLClass> toClassNodeSet(Set<Set<ATermAppl>> termSets) {
        return new OWLClassNodeSet(termSets.stream().map(this::toClassNode).collect(Collectors.toSet()));
    }

    private Node<OWLClass> toClassNode(Set<ATermAppl> terms) {
        return NodeFactory.getOWLClassNode(this.CLASS_MAPPER.map(terms));
    }

    private Node<OWLDataProperty> toDataPropertyNode(Set<ATermAppl> terms) {
        return NodeFactory.getOWLDataPropertyNode(this.DP_MAPPER.map(terms));
    }

    private Node<OWLNamedIndividual> toIndividualNode(Set<ATermAppl> terms) {
        return NodeFactory.getOWLNamedIndividualNode(this.IND_MAPPER.map(terms));
    }

    private Set<OWLLiteral> toLiteralSet(Collection<ATermAppl> terms) {
        return this.LIT_MAPPER.map(terms);
    }

    private Node<OWLObjectPropertyExpression> toObjectPropertyNode(Set<ATermAppl> terms) {
        return NodeFactory.getOWLObjectPropertyNode(this.OP_MAPPER.map(terms));
    }

    private Node<OWLNamedIndividual> toIndividualNode(ATermAppl term) {
        return NodeFactory.getOWLNamedIndividualNode((OWLNamedIndividual)this.IND_MAPPER.map(term));
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return PRECOMPUTABLE_INFERENCES;
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        switch (inferenceType) {
            case CLASS_HIERARCHY: {
                return this._kb.isClassified();
            }
            case CLASS_ASSERTIONS: {
                return this._kb.isRealized();
            }
            case OBJECT_PROPERTY_HIERARCHY: {
                return this._kb.getRBox().isObjectTaxonomyPrepared();
            }
            case DATA_PROPERTY_HIERARCHY: {
                return this._kb.getRBox().isDataTaxonomyPrepared();
            }
        }
        return false;
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        for (InferenceType inferenceType : inferenceTypes) {
            switch (inferenceType) {
                case CLASS_HIERARCHY: {
                    this._kb.classify();
                }
                case CLASS_ASSERTIONS: {
                    this._kb.realize();
                }
                case OBJECT_PROPERTY_HIERARCHY: {
                    this._kb.getRBox().getObjectTaxonomy();
                }
                case DATA_PROPERTY_HIERARCHY: {
                    this._kb.getRBox().getDataTaxonomy();
                }
            }
        }
    }

    private class ObjectPropertyMapper
    extends EntityMapper<OWLObjectPropertyExpression> {
        private ObjectPropertyMapper() {
        }

        @Override
        public OWLObjectPropertyExpression map(ATermAppl term) {
            if (ATermUtils.TOP_OBJECT_PROPERTY.equals(term)) {
                return PelletReasoner.this._factory.getOWLTopObjectProperty();
            }
            if (ATermUtils.BOTTOM_OBJECT_PROPERTY.equals(term)) {
                return PelletReasoner.this._factory.getOWLBottomObjectProperty();
            }
            if (ATermUtils.isInv(term)) {
                try {
                    IRI iri2 = IRI.create((String)((ATermAppl)term.getArgument(0)).getAFun().getName());
                    return PelletReasoner.this._factory.getOWLObjectProperty(iri2).getInverseProperty();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            return PelletReasoner.this._factory.getOWLObjectProperty(PelletReasoner.iri(term));
        }
    }

    private class NamedIndividualMapper
    extends EntityMapper<OWLNamedIndividual> {
        private NamedIndividualMapper() {
        }

        @Override
        public OWLNamedIndividual map(ATermAppl term) {
            if (ATermUtils.isBnode(term)) {
                return null;
            }
            return PelletReasoner.this._factory.getOWLNamedIndividual(PelletReasoner.iri(term));
        }
    }

    private class LiteralMapper
    extends EntityMapper<OWLLiteral> {
        private LiteralMapper() {
        }

        @Override
        public OWLLiteral map(ATermAppl term) {
            String lexValue = ((ATermAppl)term.getArgument(0)).getName();
            ATermAppl lang = (ATermAppl)term.getArgument(1);
            ATermAppl dtype = (ATermAppl)term.getArgument(2);
            if (dtype.equals(ATermUtils.PLAIN_LITERAL_DATATYPE)) {
                if (lang.equals(ATermUtils.EMPTY)) {
                    return PelletReasoner.this._factory.getOWLLiteral(lexValue);
                }
                return PelletReasoner.this._factory.getOWLLiteral(lexValue, lang.toString());
            }
            OWLDatatype datatype = (OWLDatatype)PelletReasoner.this.DT_MAPPER.map(dtype);
            return PelletReasoner.this._factory.getOWLLiteral(lexValue, datatype);
        }
    }

    private abstract class EntityMapper<T extends OWLObject> {
        private EntityMapper() {
        }

        public abstract T map(ATermAppl var1);

        public final Set<T> map(Collection<ATermAppl> terms) {
            HashSet<T> mappedSet = new HashSet<T>();
            for (ATermAppl term : terms) {
                T mapped = this.map(term);
                if (mapped == null) continue;
                mappedSet.add(mapped);
            }
            return mappedSet;
        }
    }

    private class DatatypeMapper
    extends EntityMapper<OWLDatatype> {
        private DatatypeMapper() {
        }

        @Override
        public OWLDatatype map(ATermAppl term) {
            return PelletReasoner.this._factory.getOWLDatatype(PelletReasoner.iri(term));
        }
    }

    private class DataPropertyMapper
    extends EntityMapper<OWLDataProperty> {
        private DataPropertyMapper() {
        }

        @Override
        public OWLDataProperty map(ATermAppl term) {
            if (ATermUtils.TOP_DATA_PROPERTY.equals(term)) {
                return PelletReasoner.this._factory.getOWLTopDataProperty();
            }
            if (ATermUtils.BOTTOM_DATA_PROPERTY.equals(term)) {
                return PelletReasoner.this._factory.getOWLBottomDataProperty();
            }
            return PelletReasoner.this._factory.getOWLDataProperty(PelletReasoner.iri(term));
        }
    }

    private class ClassMapper
    extends EntityMapper<OWLClass> {
        private ClassMapper() {
        }

        @Override
        public OWLClass map(ATermAppl term) {
            if (term.equals(ATermUtils.TOP)) {
                return PelletReasoner.this._factory.getOWLThing();
            }
            if (term.equals(ATermUtils.BOTTOM)) {
                return PelletReasoner.this._factory.getOWLNothing();
            }
            return PelletReasoner.this._factory.getOWLClass(PelletReasoner.iri(term));
        }
    }

    private class ChangeVisitor
    implements OWLOntologyChangeVisitor {
        private boolean reloadRequired;

        private ChangeVisitor() {
        }

        public boolean isReloadRequired() {
            return this.reloadRequired;
        }

        public boolean process(OWLOntologyChange change) {
            this.reset();
            change.accept((OWLOntologyChangeVisitor)this);
            return !this.isReloadRequired();
        }

        public void reset() {
            PelletReasoner.this._visitor.reset();
            this.reloadRequired = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(AddAxiom change) {
            PelletVisitor pelletVisitor = PelletReasoner.this._visitor;
            synchronized (pelletVisitor) {
                PelletReasoner.this._visitor.setAddAxiom(true);
                change.getAxiom().accept((OWLObjectVisitor)PelletReasoner.this._visitor);
                this.reloadRequired = PelletReasoner.this._visitor.isReloadRequired();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(RemoveAxiom change) {
            PelletVisitor pelletVisitor = PelletReasoner.this._visitor;
            synchronized (pelletVisitor) {
                PelletReasoner.this._visitor.setAddAxiom(false);
                change.getAxiom().accept((OWLObjectVisitor)PelletReasoner.this._visitor);
                this.reloadRequired = PelletReasoner.this._visitor.isReloadRequired();
            }
        }

        public void visit(AddImport change) {
            this.reloadRequired = true;
        }

        public void visit(RemoveImport change) {
            this.reloadRequired = true;
        }
    }
}

