/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi.explanation;

import com.clarkparsia.owlapi.explanation.BlackBoxExplanation;
import com.clarkparsia.owlapi.explanation.HSTExplanationGenerator;
import com.clarkparsia.owlapi.explanation.SatisfiabilityConverter;
import com.clarkparsia.owlapi.explanation.TransactionAwareSingleExpGen;
import java.util.Set;
import openllet.owlapi.OpenlletReasoner;
import openllet.owlapi.OpenlletReasonerFactory;
import openllet.owlapi.explanation.GlassBoxExplanation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class PelletExplanation {
    private final OWLDataFactory _factory;
    private final HSTExplanationGenerator _expGen;
    private final SatisfiabilityConverter _converter;

    public static void setup() {
        GlassBoxExplanation.setup();
    }

    public PelletExplanation(OWLOntology ontology) {
        this(ontology, true);
    }

    public PelletExplanation(OWLOntology ontology, boolean useGlassBox) {
        this(new OpenlletReasonerFactory().createReasoner(ontology), useGlassBox);
    }

    public PelletExplanation(OpenlletReasoner reasoner) {
        this(reasoner, true);
    }

    private PelletExplanation(OpenlletReasoner reasoner, boolean useGlassBox) {
        this._factory = reasoner.getManager().getOWLDataFactory();
        GlassBoxExplanation singleExp = useGlassBox ? new GlassBoxExplanation(reasoner) : new BlackBoxExplanation(reasoner.getRootOntology(), (OWLReasonerFactory)new OpenlletReasonerFactory(), (OWLReasoner)reasoner);
        this._expGen = new HSTExplanationGenerator((TransactionAwareSingleExpGen)singleExp);
        this._converter = new SatisfiabilityConverter(this._factory);
    }

    public Set<OWLAxiom> getEntailmentExplanation(OWLAxiom axiom) {
        OWLClassExpression unsatClass = this._converter.convert(axiom);
        return this.getUnsatisfiableExplanation(unsatClass);
    }

    public Set<Set<OWLAxiom>> getEntailmentExplanations(OWLAxiom axiom) {
        OWLClassExpression unsatClass = this._converter.convert(axiom);
        return this.getUnsatisfiableExplanations(unsatClass);
    }

    public Set<Set<OWLAxiom>> getEntailmentExplanations(OWLAxiom axiom, int maxExplanations) {
        OWLClassExpression unsatClass = this._converter.convert(axiom);
        return this.getUnsatisfiableExplanations(unsatClass, maxExplanations);
    }

    public Set<OWLAxiom> getInconsistencyExplanation() {
        return this.getUnsatisfiableExplanation((OWLClassExpression)this._factory.getOWLThing());
    }

    public Set<Set<OWLAxiom>> getInconsistencyExplanations() {
        return this.getUnsatisfiableExplanations((OWLClassExpression)this._factory.getOWLThing());
    }

    public Set<Set<OWLAxiom>> getInconsistencyExplanations(int maxExplanations) {
        return this.getUnsatisfiableExplanations((OWLClassExpression)this._factory.getOWLThing(), maxExplanations);
    }

    public Set<OWLAxiom> getInstanceExplanation(OWLIndividual ind, OWLClassExpression cls) {
        OWLClassAssertionAxiom classAssertion = this._factory.getOWLClassAssertionAxiom(cls, ind);
        return this.getEntailmentExplanation((OWLAxiom)classAssertion);
    }

    public Set<Set<OWLAxiom>> getInstanceExplanations(OWLIndividual ind, OWLClassExpression cls) {
        OWLClassAssertionAxiom classAssertion = this._factory.getOWLClassAssertionAxiom(cls, ind);
        return this.getEntailmentExplanations((OWLAxiom)classAssertion);
    }

    public Set<Set<OWLAxiom>> getInstanceExplanations(OWLIndividual ind, OWLClassExpression cls, int maxExplanations) {
        OWLClassAssertionAxiom classAssertion = this._factory.getOWLClassAssertionAxiom(cls, ind);
        return this.getEntailmentExplanations((OWLAxiom)classAssertion, maxExplanations);
    }

    public Set<OWLAxiom> getSubClassExplanation(OWLClassExpression subClass, OWLClassExpression superClass) {
        OWLSubClassOfAxiom subClassAxiom = this._factory.getOWLSubClassOfAxiom(subClass, superClass);
        return this.getEntailmentExplanation((OWLAxiom)subClassAxiom);
    }

    public Set<Set<OWLAxiom>> getSubClassExplanations(OWLClassExpression subClass, OWLClassExpression superClass) {
        OWLSubClassOfAxiom subClassAxiom = this._factory.getOWLSubClassOfAxiom(subClass, superClass);
        return this.getEntailmentExplanations((OWLAxiom)subClassAxiom);
    }

    public Set<Set<OWLAxiom>> getSubClassExplanations(OWLClassExpression subClass, OWLClassExpression superClass, int maxExplanations) {
        OWLSubClassOfAxiom subClassAxiom = this._factory.getOWLSubClassOfAxiom(subClass, superClass);
        return this.getEntailmentExplanations((OWLAxiom)subClassAxiom, maxExplanations);
    }

    public Set<OWLAxiom> getUnsatisfiableExplanation(OWLClassExpression unsatClass) {
        return this._expGen.getExplanation(unsatClass);
    }

    public Set<Set<OWLAxiom>> getUnsatisfiableExplanations(OWLClassExpression unsatClass) {
        return this._expGen.getExplanations(unsatClass);
    }

    public Set<Set<OWLAxiom>> getUnsatisfiableExplanations(OWLClassExpression unsatClass, int maxExplanations) {
        return this._expGen.getExplanations(unsatClass, maxExplanations);
    }

    static {
        PelletExplanation.setup();
    }
}

