/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi.explanation.io.manchester;

import com.clarkparsia.owlapi.explanation.io.ExplanationRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import openllet.owlapi.explanation.io.manchester.BlockWriter;
import openllet.owlapi.explanation.io.manchester.ManchesterSyntaxObjectRenderer;
import openllet.owlapi.explanation.io.manchester.TextBlockWriter;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObjectVisitor;

public class ManchesterSyntaxExplanationRenderer
implements ExplanationRenderer {
    protected ManchesterSyntaxObjectRenderer _renderer;
    protected BlockWriter _writer;
    protected OWLAxiom _currentAxiom;
    private boolean _wrapLines = true;
    private boolean _smartIndent = true;
    private int _index;

    public void endRendering() {
        this._writer.flush();
    }

    protected OWLAxiom getCurrentAxiom() {
        return this._currentAxiom;
    }

    public boolean isSmartIndent() {
        return this._smartIndent;
    }

    public boolean isWrapLines() {
        return this._wrapLines;
    }

    public void render(Set<Set<OWLAxiom>> explanations) throws OWLException, IOException, UnsupportedOperationException {
        this.render(null, explanations);
    }

    public void render(OWLAxiom axiom, Set<Set<OWLAxiom>> explanations) throws OWLException, IOException {
        this.setCurrentAxiom(axiom);
        if (this._index == 1) {
            if (axiom != null) {
                this._writer.print("Axiom: ");
                axiom.accept((OWLObjectVisitor)this._renderer);
                this._writer.println();
                this._writer.println();
            }
            if (explanations.isEmpty()) {
                this._writer.println("Explanation: AXIOM IS NOT ENTAILED!");
                return;
            }
            this._writer.println("Explanation(s): ");
        }
        String header = this._index++ + ")";
        this._writer.print(header);
        this.renderSingleExplanation(explanations.iterator().next());
        this._writer.println();
    }

    protected void renderSingleExplanation(Set<OWLAxiom> explanation) {
        this._writer.printSpace();
        this._writer.printSpace();
        this._writer.printSpace();
        this._writer.startBlock();
        for (OWLAxiom a : explanation) {
            a.accept((OWLObjectVisitor)this._renderer);
            this._writer.println();
        }
        this._writer.endBlock();
        this._writer.println();
    }

    protected void setCurrentAxiom(OWLAxiom currentAxiom) {
        this._currentAxiom = currentAxiom;
    }

    public void setSmartIndent(boolean smartIndent) {
        this._smartIndent = smartIndent;
    }

    public void setWrapLines(boolean wrapLines) {
        this._wrapLines = wrapLines;
    }

    public void startRendering(Writer w) {
        this._writer = new TextBlockWriter(w);
        this._renderer = new ManchesterSyntaxObjectRenderer(this._writer);
        this._renderer.setWrapLines(this.isWrapLines());
        this._renderer.setSmartIndent(this.isSmartIndent());
        this._index = 1;
    }
}

